/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.uif.UifDictionaryBeanBase;
import org.kuali.rice.krad.util.KRADUtils;

@BeanTag(name="url", parent="Uif-Url")
public class UrlInfo
extends UifDictionaryBeanBase
implements Serializable {
    private static final long serialVersionUID = 3195177614468120958L;
    private String href;
    private String originalHref;
    private String baseUrl;
    private String controllerMapping;
    private String viewType;
    private String viewId;
    private String pageId;
    private String formKey;
    private String methodToCall;
    private TargetFrame target;
    private Map<String, String> requestParameters;

    public UrlInfo() {
    }

    public UrlInfo(String href) {
        this.href = href;
        this.originalHref = href;
    }

    public UrlInfo(String baseUrl, String controllerMapping, String viewId, String methodToCall) {
        this.baseUrl = baseUrl;
        this.controllerMapping = controllerMapping;
        this.viewId = viewId;
        this.methodToCall = methodToCall;
    }

    public boolean isFullyConfigured() {
        boolean fullyConfigured = false;
        if (StringUtils.isNotBlank((String)this.href)) {
            fullyConfigured = true;
        } else if (StringUtils.isNotBlank((String)this.baseUrl) && StringUtils.isNotBlank((String)this.controllerMapping)) {
            fullyConfigured = true;
        }
        return fullyConfigured;
    }

    protected String generateUrl() {
        Object generatedUrl = "";
        if (StringUtils.isBlank((String)this.baseUrl)) {
            return generatedUrl;
        }
        generatedUrl = this.baseUrl;
        if (StringUtils.isNotBlank((String)this.controllerMapping) && !this.controllerMapping.startsWith("/")) {
            generatedUrl = (String)generatedUrl + "/" + this.controllerMapping;
        } else if (StringUtils.isNotBlank((String)this.controllerMapping)) {
            generatedUrl = (String)generatedUrl + this.controllerMapping;
        }
        HashMap<String, String> allRequestParameters = new HashMap<String, String>();
        if (StringUtils.isNotBlank((String)this.methodToCall)) {
            allRequestParameters.put("methodToCall", this.methodToCall);
        }
        if (StringUtils.isNotBlank((String)this.viewId)) {
            allRequestParameters.put("viewId", this.viewId);
        }
        if (StringUtils.isNotBlank((String)this.pageId)) {
            allRequestParameters.put("pageId", this.pageId);
        }
        if (StringUtils.isNotBlank((String)this.formKey)) {
            allRequestParameters.put("formKey", this.formKey);
        }
        if (this.requestParameters != null) {
            allRequestParameters.putAll(this.requestParameters);
        }
        generatedUrl = (String)generatedUrl + KRADUtils.getRequestStringFromMap(allRequestParameters);
        return generatedUrl;
    }

    @BeanTagAttribute
    public String getHref() {
        if (StringUtils.isBlank((String)this.href)) {
            this.href = this.generateUrl();
        }
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
        this.originalHref = href;
    }

    @BeanTagAttribute
    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @BeanTagAttribute
    public String getControllerMapping() {
        return this.controllerMapping;
    }

    public void setControllerMapping(String controllerMapping) {
        this.controllerMapping = controllerMapping;
    }

    @BeanTagAttribute
    public String getViewType() {
        return this.viewType;
    }

    public void setViewType(String viewType) {
        this.viewType = viewType;
    }

    @BeanTagAttribute
    public String getViewId() {
        return this.viewId;
    }

    public void setViewId(String viewId) {
        this.viewId = viewId;
    }

    @BeanTagAttribute
    public String getPageId() {
        return this.pageId;
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    @BeanTagAttribute
    public String getFormKey() {
        return this.formKey;
    }

    public void setFormKey(String formKey) {
        this.formKey = formKey;
    }

    @BeanTagAttribute
    public String getMethodToCall() {
        return this.methodToCall;
    }

    public void setMethodToCall(String methodToCall) {
        this.methodToCall = methodToCall;
    }

    @BeanTagAttribute
    public Map<String, String> getRequestParameters() {
        return this.requestParameters;
    }

    public void setRequestParameters(Map<String, String> requestParameters) {
        this.requestParameters = requestParameters;
    }

    public String getOriginalHref() {
        return this.originalHref;
    }

    protected void setOriginalHref(String originalHref) {
        this.originalHref = originalHref;
    }

    @BeanTagAttribute
    public TargetFrame getTarget() {
        return this.target;
    }

    public void setTarget(String targetFrame) {
        this.target = Arrays.stream(TargetFrame.values()).filter(t -> t.name().equalsIgnoreCase(targetFrame)).findFirst().orElseThrow(() -> new IllegalArgumentException("Invalid TargetFrame " + targetFrame));
    }

    public String toString() {
        return this.getHref();
    }

    public static enum TargetFrame {
        SELF,
        PARENT,
        TOP,
        BLANK;

    }
}

