/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.function.Function;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.indices.InvalidAliasNameException;

public class AliasValidator {
    public void validateAlias(Alias alias, String index, Metadata metadata) {
        this.validateAlias(alias.name(), index, alias.indexRouting(), metadata::index);
    }

    public void validateAliasMetadata(AliasMetadata aliasMetadata, String index, Metadata metadata) {
        this.validateAlias(aliasMetadata.alias(), index, aliasMetadata.indexRouting(), metadata::index);
    }

    public void validateAliasStandalone(Alias alias) {
        this.validateAliasStandalone(alias.name(), alias.indexRouting());
        if (Strings.hasLength(alias.filter())) {
            try {
                XContentHelper.convertToMap(XContentFactory.xContent((CharSequence)alias.filter()), alias.filter(), false);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("failed to parse filter for alias [" + alias.name() + "]", e);
            }
        }
    }

    public void validateAlias(String alias, String index, @Nullable String indexRouting, Function<String, IndexMetadata> indexLookup) {
        this.validateAliasStandalone(alias, indexRouting);
        if (!Strings.hasText(index)) {
            throw new IllegalArgumentException("index name is required");
        }
        IndexMetadata indexNamedSameAsAlias = indexLookup.apply(alias);
        if (indexNamedSameAsAlias != null) {
            throw new InvalidAliasNameException(indexNamedSameAsAlias.getIndex(), alias, "an index exists with the same name as the alias");
        }
    }

    void validateAliasStandalone(String alias, String indexRouting) {
        if (!Strings.hasText(alias)) {
            throw new IllegalArgumentException("alias name is required");
        }
        MetadataCreateIndexService.validateIndexOrAliasName(alias, InvalidAliasNameException::new);
        if (indexRouting != null && indexRouting.indexOf(44) != -1) {
            throw new IllegalArgumentException("alias [" + alias + "] has several index routing values associated with it");
        }
    }

    public void validateAliasFilter(String alias, String filter, QueryShardContext queryShardContext, NamedXContentRegistry xContentRegistry) {
        assert (queryShardContext != null);
        try (XContentParser parser = XContentFactory.xContent((CharSequence)filter).createParser(xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, filter);){
            AliasValidator.validateAliasFilter(parser, queryShardContext);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("failed to parse filter for alias [" + alias + "]", e);
        }
    }

    public void validateAliasFilter(String alias, byte[] filter, QueryShardContext queryShardContext, NamedXContentRegistry xContentRegistry) {
        assert (queryShardContext != null);
        try (XContentParser parser = XContentFactory.xContent((byte[])filter).createParser(xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, filter);){
            AliasValidator.validateAliasFilter(parser, queryShardContext);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("failed to parse filter for alias [" + alias + "]", e);
        }
    }

    private static void validateAliasFilter(XContentParser parser, QueryShardContext queryShardContext) throws IOException {
        QueryBuilder parseInnerQueryBuilder = AbstractQueryBuilder.parseInnerQueryBuilder(parser);
        QueryBuilder queryBuilder = Rewriteable.rewrite(parseInnerQueryBuilder, queryShardContext, true);
        queryBuilder.toQuery(queryShardContext);
    }
}

