/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.cache;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.cache.AbstractMetaCache;
import org.apache.ojb.broker.cache.ObjectCache;
import org.apache.ojb.broker.cache.ObjectCacheDefaultImpl;

public class ObjectCachePerClassImpl
extends AbstractMetaCache {
    private static Map cachesByClass = Collections.synchronizedMap(new HashMap());

    public ObjectCachePerClassImpl(PersistenceBroker persistenceBroker, Properties properties) {
        this.setClassCache(Object.class, (ObjectCache)new ObjectCacheDefaultImpl(persistenceBroker, null));
    }

    @Override
    public ObjectCache getCache(Identity identity, Object object, int n) {
        if (identity.getObjectsRealClass() == null) {
            return null;
        }
        return this.getCachePerClass(identity.getObjectsRealClass(), n);
    }

    @Override
    public void clear() {
        for (ObjectCache objectCache : cachesByClass.values()) {
            if (objectCache == null) continue;
            objectCache.clear();
        }
    }

    public void setClassCache(Class clazz, ObjectCache objectCache) {
        this.setClassCache(clazz.getName(), objectCache);
    }

    private void setClassCache(String string, ObjectCache objectCache) {
        cachesByClass.put(string, objectCache);
    }

    private ObjectCache getCachePerClass(Class clazz, int n) {
        ObjectCache objectCache = (ObjectCache)cachesByClass.get(clazz.getName());
        if (objectCache == null && 1 == n && !cachesByClass.containsKey(clazz.getName())) {
            objectCache = new ObjectCacheDefaultImpl(null, null);
            this.setClassCache(clazz.getName(), objectCache);
        }
        return objectCache;
    }
}

