/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.util;

import java.beans.PropertyDescriptor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import org.apache.commons.beanutils.PropertyUtils;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class DataTypeUtil {
    private DataTypeUtil() {
    }

    public static String determineFieldDataType(Class<?> type, String attributeName) {
        Class<?> attributeType = DataTypeUtil.thieveAttributeType(type, attributeName);
        return DataTypeUtil.determineDataType(attributeType);
    }

    public static String determineDataType(Class<?> attributeType) {
        if (DataTypeUtil.isStringy(attributeType)) {
            return "string";
        }
        if (DataTypeUtil.isDecimaltastic(attributeType)) {
            return "float";
        }
        if (DataTypeUtil.isDateLike(attributeType)) {
            return "datetime";
        }
        if (DataTypeUtil.isIntsy(attributeType)) {
            return "long";
        }
        if (DataTypeUtil.isBooleanable(attributeType)) {
            return "boolean";
        }
        return "string";
    }

    public static boolean isStringy(Class<?> type) {
        return String.class.isAssignableFrom(type);
    }

    public static boolean isDateLike(Class<?> type) {
        return Date.class.isAssignableFrom(type);
    }

    public static boolean isDecimaltastic(Class<?> type) {
        return Double.class.isAssignableFrom(type) || Float.class.isAssignableFrom(type) || type.equals(Double.TYPE) || type.equals(Float.TYPE) || BigDecimal.class.isAssignableFrom(type) || KualiDecimal.class.isAssignableFrom(type);
    }

    public static boolean isIntsy(Class<?> type) {
        return Integer.class.isAssignableFrom(type) || Long.class.isAssignableFrom(type) || Short.class.isAssignableFrom(type) || Byte.class.isAssignableFrom(type) || BigInteger.class.isAssignableFrom(type) || type.equals(Integer.TYPE) || type.equals(Long.TYPE) || type.equals(Short.TYPE) || type.equals(Byte.TYPE);
    }

    public static boolean isBooleanable(Class<?> type) {
        return Boolean.class.isAssignableFrom(type) || type.equals(Boolean.TYPE);
    }

    private static Class<?> thieveAttributeType(Class<?> boClass, String attributeKey) {
        for (PropertyDescriptor prop : PropertyUtils.getPropertyDescriptors(boClass)) {
            if (!prop.getName().equals(attributeKey)) continue;
            return prop.getPropertyType();
        }
        return null;
    }
}

