/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.BucketCollector;
import org.elasticsearch.search.aggregations.MultiBucketCollector;
import org.elasticsearch.search.aggregations.bucket.BestBucketsDeferringCollector;
import org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import org.elasticsearch.search.aggregations.bucket.DeferringBucketCollector;
import org.elasticsearch.search.aggregations.bucket.global.GlobalAggregator;
import org.elasticsearch.search.internal.SearchContext;

public abstract class DeferableBucketAggregator
extends BucketsAggregator {
    private DeferringBucketCollector recordingWrapper;

    protected DeferableBucketAggregator(String name, AggregatorFactories factories, SearchContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, factories, context, parent, metadata);
    }

    @Override
    protected void doPreCollection() throws IOException {
        ArrayList<BucketCollector> collectors = new ArrayList<BucketCollector>();
        ArrayList<BucketCollector> deferredCollectors = new ArrayList<BucketCollector>();
        for (int i = 0; i < this.subAggregators.length; ++i) {
            if (this.shouldDefer(this.subAggregators[i])) {
                if (this.recordingWrapper == null) {
                    this.recordingWrapper = this.getDeferringCollector();
                }
                deferredCollectors.add(this.subAggregators[i]);
                this.subAggregators[i] = this.recordingWrapper.wrap(this.subAggregators[i]);
                continue;
            }
            collectors.add(this.subAggregators[i]);
        }
        if (this.recordingWrapper != null) {
            this.recordingWrapper.setDeferredCollector(deferredCollectors);
            collectors.add(this.recordingWrapper);
        }
        this.collectableSubAggregators = MultiBucketCollector.wrap(collectors);
    }

    public static boolean descendsFromGlobalAggregator(Aggregator parent) {
        while (parent != null) {
            if (parent.getClass() == GlobalAggregator.class) {
                return true;
            }
            parent = parent.parent();
        }
        return false;
    }

    public DeferringBucketCollector getDeferringCollector() {
        return new BestBucketsDeferringCollector(this.context(), DeferableBucketAggregator.descendsFromGlobalAggregator(this.parent()));
    }

    protected boolean shouldDefer(Aggregator aggregator) {
        return false;
    }

    protected final void runDeferredCollections(long ... bucketOrds) throws IOException {
        if (this.recordingWrapper != null) {
            this.recordingWrapper.replay(bucketOrds);
        }
    }
}

