/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.core.proxy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.ojb.broker.ManageableCollection;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PBFactoryException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.core.PersistenceBrokerThreadMapping;
import org.apache.ojb.broker.core.proxy.CollectionProxy;
import org.apache.ojb.broker.core.proxy.CollectionProxyListener;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.metadata.MetadataManager;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.util.collections.IRemovalAwareCollection;
import org.apache.ojb.broker.util.collections.RemovalAwareCollection;

public class CollectionProxyDefaultImpl
implements Collection,
ManageableCollection,
CollectionProxy {
    private PBKey _brokerKey;
    private boolean _perThreadDescriptorsEnabled;
    private Object _profileKey;
    private Query _query;
    private Collection _data;
    private Class _collectionClass;
    private int _size = -1;
    private boolean _needsClose;
    private transient ArrayList _listeners;

    public CollectionProxyDefaultImpl(PBKey pBKey, Query query) {
        this(pBKey, RemovalAwareCollection.class, query);
    }

    public CollectionProxyDefaultImpl(PBKey pBKey, Class clazz, Query query) {
        MetadataManager metadataManager = MetadataManager.getInstance();
        this._perThreadDescriptorsEnabled = metadataManager.isEnablePerThreadChanges();
        if (this._perThreadDescriptorsEnabled) {
            Object object = metadataManager.getCurrentProfileKey();
            if (object == null) {
                throw new MetadataException("Trying to create a Collection proxy with per-thread metadata changes enabled, but no profile key.");
            }
            this.setProfileKey(object);
        }
        this.setBrokerKey(pBKey);
        this.setCollectionClass(clazz);
        this.setQuery(query);
    }

    protected void loadProfileIfNeeded() {
        MetadataManager metadataManager;
        Object object = this.getProfileKey();
        if (object != null && !object.equals((metadataManager = MetadataManager.getInstance()).getCurrentProfileKey())) {
            metadataManager.loadProfile(object);
        }
    }

    @Override
    public boolean isLoaded() {
        return this._data != null;
    }

    protected synchronized int loadSize() throws PersistenceBrokerException {
        PersistenceBroker persistenceBroker = this.getBroker();
        try {
            int n = persistenceBroker.getCount(this.getQuery());
            return n;
        }
        catch (Exception exception) {
            throw new PersistenceBrokerException(exception);
        }
        finally {
            this.releaseBroker(persistenceBroker);
        }
    }

    protected synchronized void setSize(int n) {
        this._size = n;
    }

    protected Collection loadData() throws PersistenceBrokerException {
        PersistenceBroker persistenceBroker = this.getBroker();
        try {
            Collection collection = this._data != null ? this._data : (this._size != 0 ? (Collection)((Object)persistenceBroker.getCollectionByQuery(this.getCollectionClass(), this.getQuery())) : (Collection)this.getCollectionClass().newInstance());
            Collection collection2 = collection;
            return collection2;
        }
        catch (Exception exception) {
            throw new PersistenceBrokerException(exception);
        }
        finally {
            this.releaseBroker(persistenceBroker);
        }
    }

    protected void beforeLoading() {
        if (this._listeners != null) {
            if (this._perThreadDescriptorsEnabled) {
                this.loadProfileIfNeeded();
            }
            for (int i = this._listeners.size() - 1; i >= 0; --i) {
                CollectionProxyListener collectionProxyListener = (CollectionProxyListener)this._listeners.get(i);
                collectionProxyListener.beforeLoading(this);
            }
        }
    }

    protected void afterLoading() {
        if (this._listeners != null) {
            if (this._perThreadDescriptorsEnabled) {
                this.loadProfileIfNeeded();
            }
            for (int i = this._listeners.size() - 1; i >= 0; --i) {
                CollectionProxyListener collectionProxyListener = (CollectionProxyListener)this._listeners.get(i);
                collectionProxyListener.afterLoading(this);
            }
        }
    }

    @Override
    public int size() {
        if (this.isLoaded()) {
            return this.getData().size();
        }
        if (this._size < 0) {
            this._size = this.loadSize();
        }
        return this._size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object object) {
        return this.getData().contains(object);
    }

    @Override
    public Iterator iterator() {
        return this.getData().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.getData().toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this.getData().toArray(objectArray);
    }

    public boolean add(Object object) {
        return this.getData().add(object);
    }

    @Override
    public boolean remove(Object object) {
        return this.getData().remove(object);
    }

    public boolean containsAll(Collection collection) {
        return this.getData().containsAll(collection);
    }

    public boolean addAll(Collection collection) {
        return this.getData().addAll(collection);
    }

    public boolean removeAll(Collection collection) {
        return this.getData().removeAll(collection);
    }

    public boolean retainAll(Collection collection) {
        return this.getData().retainAll(collection);
    }

    @Override
    public void clear() {
        Class clazz = this.getCollectionClass();
        if (IRemovalAwareCollection.class.isAssignableFrom(clazz)) {
            this.getData().clear();
        } else {
            ArrayList arrayList;
            try {
                arrayList = (ArrayList)clazz.newInstance();
            }
            catch (Exception exception) {
                arrayList = new ArrayList();
            }
            this.setData(arrayList);
        }
        this._size = 0;
    }

    public Query getQuery() {
        return this._query;
    }

    protected void setQuery(Query query) {
        this._query = query;
    }

    protected synchronized void releaseBroker(PersistenceBroker persistenceBroker) {
        if (persistenceBroker != null && this._needsClose) {
            this._needsClose = false;
            persistenceBroker.close();
        }
    }

    protected synchronized PersistenceBroker getBroker() throws PBFactoryException {
        if (this._perThreadDescriptorsEnabled) {
            this.loadProfileIfNeeded();
        }
        if (this.getBrokerKey() == null) {
            throw new OJBRuntimeException("Can't find associated PBKey. Need PBKey to obtain a validPersistenceBroker instance from intern resources.");
        }
        PersistenceBroker persistenceBroker = PersistenceBrokerThreadMapping.currentPersistenceBroker(this.getBrokerKey());
        if (persistenceBroker == null || persistenceBroker.isClosed()) {
            persistenceBroker = PersistenceBrokerFactory.createPersistenceBroker(this.getBrokerKey());
            this._needsClose = true;
        }
        return persistenceBroker;
    }

    public synchronized Collection getData() {
        if (!this.isLoaded()) {
            this.beforeLoading();
            this.setData(this.loadData());
            this.afterLoading();
        }
        return this._data;
    }

    public void setData(Collection collection) {
        this._data = collection;
    }

    public Class getCollectionClass() {
        return this._collectionClass;
    }

    protected void setCollectionClass(Class clazz) {
        this._collectionClass = clazz;
    }

    @Override
    public void ojbAdd(Object object) {
        this.add(object);
    }

    @Override
    public void ojbAddAll(ManageableCollection manageableCollection) {
        this.addAll((Collection)((CollectionProxyDefaultImpl)manageableCollection));
    }

    @Override
    public Iterator ojbIterator() {
        return this.iterator();
    }

    @Override
    public void afterStore(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
        Collection collection = this.getData();
        if (collection instanceof ManageableCollection) {
            ((ManageableCollection)((Object)collection)).afterStore(persistenceBroker);
        }
    }

    public PBKey getBrokerKey() {
        return this._brokerKey;
    }

    protected void setBrokerKey(PBKey pBKey) {
        this._brokerKey = pBKey;
    }

    protected Object getProfileKey() {
        return this._profileKey;
    }

    public void setProfileKey(Object object) {
        this._profileKey = object;
    }

    @Override
    public synchronized void addListener(CollectionProxyListener collectionProxyListener) {
        if (this._listeners == null) {
            this._listeners = new ArrayList();
        }
        if (!this._listeners.contains(collectionProxyListener)) {
            this._listeners.add(collectionProxyListener);
        }
    }

    @Override
    public synchronized void removeListener(CollectionProxyListener collectionProxyListener) {
        if (this._listeners != null) {
            this._listeners.remove(collectionProxyListener);
        }
    }
}

