/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.questionnaire.impl.question;

import java.util.HashMap;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.common.framework.version.VersionException;
import org.kuali.coeus.common.impl.version.VersioningServiceImpl;
import org.kuali.coeus.common.questionnaire.framework.question.Question;
import org.kuali.coeus.common.questionnaire.impl.question.QuestionAuthorizationService;
import org.kuali.coeus.common.questionnaire.impl.question.QuestionMaintainableImpl;
import org.kuali.coeus.common.questionnaire.impl.question.QuestionMaintenanceForm;
import org.kuali.coeus.common.questionnaire.impl.question.QuestionService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.kns.document.MaintenanceDocumentBase;
import org.kuali.rice.kns.web.struts.action.KualiMaintenanceDocumentAction;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.kns.web.struts.form.KualiMaintenanceForm;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.SequenceAccessorService;

public class QuestionMaintenanceDocumentAction
extends KualiMaintenanceDocumentAction {
    private static final String EDIT_QUESTION_OF_ACTIVE_QUESTIONNAIRE_QUESTION = "EditQuestionOfActiveQuestionnaire";

    public ActionForward loadQuestionResponse(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        KualiMaintenanceForm maintenanceForm = (KualiMaintenanceForm)form;
        MaintenanceDocumentBase maintenanceDocument = (MaintenanceDocumentBase)maintenanceForm.getDocument();
        Question question = (Question)maintenanceDocument.getNewMaintainableObject().getDataObject();
        question.refreshReferenceObject("questionType");
        return mapping.findForward("basic");
    }

    public ActionForward refreshPulldownOptions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("basic");
    }

    private void specialHandlingOfQuestion(QuestionMaintenanceForm questionMaintenanceForm, HttpServletRequest request) throws VersionException {
        boolean readOnly;
        MaintenanceDocumentBase maintenanceDocumentBase = (MaintenanceDocumentBase)questionMaintenanceForm.getDocument();
        boolean bl = readOnly = !KcServiceLocator.getService(QuestionAuthorizationService.class).hasPermission("Modify Question") || Objects.equals(request.getParameter("readOnly"), "true");
        if (StringUtils.equals((CharSequence)questionMaintenanceForm.getMethodToCall(), (CharSequence)"edit")) {
            if (readOnly) {
                questionMaintenanceForm.setReadOnly(true);
            } else {
                this.createNewQuestionVersion(maintenanceDocumentBase, Long.parseLong(request.getParameter("id")));
            }
        } else if (StringUtils.equals((CharSequence)questionMaintenanceForm.getMethodToCall(), (CharSequence)"copy")) {
            this.initCopiedQuestion(maintenanceDocumentBase);
        }
    }

    private void createNewQuestionVersion(MaintenanceDocumentBase maintenanceDocumentBase, Long oldQuestionId) throws VersionException {
        Question approvedQuestion = this.getQuestionService().getQuestionByQuestionId(oldQuestionId);
        VersioningServiceImpl versioningService = new VersioningServiceImpl();
        Question versionedQuestion = versioningService.createNewVersion(approvedQuestion);
        Long newQuestionRefId = KcServiceLocator.getService(SequenceAccessorService.class).getNextAvailableSequenceNumber("SEQ_QUESTIONNAIRE_REF_ID", versionedQuestion.getClass());
        QuestionMaintainableImpl oldMaintainableObject = (QuestionMaintainableImpl)maintenanceDocumentBase.getOldMaintainableObject();
        Question oldQuestion = (Question)oldMaintainableObject.getBusinessObject();
        oldQuestion.setId(newQuestionRefId);
        QuestionMaintainableImpl newMaintainableObject = (QuestionMaintainableImpl)maintenanceDocumentBase.getNewMaintainableObject();
        versionedQuestion.setId(newQuestionRefId);
        versionedQuestion.setVersionNumber(oldQuestion.getVersionNumber());
        newMaintainableObject.setBusinessObject((PersistableBusinessObject)versionedQuestion);
    }

    private QuestionService getQuestionService() {
        return KcServiceLocator.getService(QuestionService.class);
    }

    private void initCopiedQuestion(MaintenanceDocumentBase maintenanceDocumentBase) {
        QuestionMaintainableImpl oldMaintainableObject = (QuestionMaintainableImpl)maintenanceDocumentBase.getOldMaintainableObject();
        Question oldQuestion = (Question)oldMaintainableObject.getBusinessObject();
        oldQuestion.setQuestionSeqId(null);
        oldQuestion.setSequenceNumber(null);
        QuestionMaintainableImpl newMaintainableObject = (QuestionMaintainableImpl)maintenanceDocumentBase.getNewMaintainableObject();
        Question newQuestion = (Question)newMaintainableObject.getBusinessObject();
        newQuestion.setQuestionSeqId(null);
        newQuestion.setSequenceNumber(null);
    }

    public ActionForward edit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward;
        Long questionRefId;
        QuestionService questionService = KcServiceLocator.getService(QuestionService.class);
        QuestionMaintenanceForm questionMaintenanceForm = (QuestionMaintenanceForm)form;
        String question = request.getParameter("questionIndex");
        String questionRefIdString = request.getParameter("id");
        Long l = questionRefId = questionRefIdString == null ? null : Long.valueOf(Long.parseLong(request.getParameter("id")));
        if (!questionMaintenanceForm.isReadOnly() && (question != null || questionService.isQuestionUsed(questionService.getQuestionByQuestionId(questionRefId).getQuestionSeqId()))) {
            if (question == null) {
                super.edit(mapping, form, request, response);
                this.specialHandlingOfQuestion(questionMaintenanceForm, request);
                ConfigurationService kualiConfiguration = CoreApiServiceLocator.getKualiConfigurationService();
                forward = this.performQuestionWithoutInput(mapping, form, request, response, EDIT_QUESTION_OF_ACTIVE_QUESTIONNAIRE_QUESTION, kualiConfiguration.getPropertyValueAsString("document.question.editQuestionOfActiveQuestionnaire.text"), "confirmationQuestion", "close", "");
            } else {
                String buttonClicked = request.getParameter("buttonClicked");
                forward = EDIT_QUESTION_OF_ACTIVE_QUESTIONNAIRE_QUESTION.equals(question) && "1".equals(buttonClicked) ? this.returnToSender(request, mapping, (KualiDocumentFormBase)questionMaintenanceForm) : mapping.findForward("basic");
            }
        } else {
            forward = super.edit(mapping, form, request, response);
            questionMaintenanceForm.getDocument().getDocumentHeader().setDocumentDescription("question - bootstrap data");
            this.specialHandlingOfQuestion(questionMaintenanceForm, request);
        }
        return forward;
    }

    protected void populateAuthorizationFields(KualiDocumentFormBase formBase) {
        QuestionMaintenanceForm questionMaintenanceForm = (QuestionMaintenanceForm)formBase;
        boolean isReadOnly = questionMaintenanceForm.isReadOnly();
        super.populateAuthorizationFields(formBase);
        if (isReadOnly && StringUtils.equals((CharSequence)questionMaintenanceForm.getMethodToCall(), (CharSequence)"edit")) {
            questionMaintenanceForm.setReadOnly(isReadOnly);
        }
        if (questionMaintenanceForm.isReadOnly() && formBase.getDocumentActions().containsKey("canClose")) {
            HashMap<String, String> documentActions = new HashMap<String, String>();
            documentActions.put("canClose", "TRUE");
            questionMaintenanceForm.setDocumentActions(documentActions);
        }
    }
}

