/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.api.identity;

import java.io.Serializable;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.kim.api.identity.CodedAttributeContract;
import org.w3c.dom.Element;

@XmlRootElement(name="codedAttribute")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="CodedAttributeType", propOrder={"code", "name", "sortCode", "active", "versionNumber", "objectId", "_futureElements"})
public final class CodedAttribute
extends AbstractDataTransferObject
implements CodedAttributeContract {
    @XmlElement(name="code", required=true)
    private final String code;
    @XmlElement(name="name", required=false)
    private final String name;
    @XmlElement(name="sortCode", required=false)
    private final String sortCode;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlElement(name="objectId", required=false)
    private final String objectId;
    @XmlElement(name="active", required=false)
    private final boolean active;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private CodedAttribute() {
        this.name = null;
        this.code = null;
        this.sortCode = null;
        this.versionNumber = null;
        this.objectId = null;
        this.active = false;
    }

    private CodedAttribute(Builder builder) {
        this.name = builder.getName();
        this.code = builder.getCode();
        this.sortCode = builder.getSortCode();
        this.versionNumber = builder.getVersionNumber();
        this.objectId = builder.getObjectId();
        this.active = builder.isActive();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    @Override
    public String getSortCode() {
        return this.sortCode;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public boolean isActive() {
        return this.active;
    }

    public static class Cache {
        public static final String NAME = "http://rice.kuali.org/kim/v2_0/CodedAttributeType";
    }

    static class Elements {
        static final String NAME = "name";
        static final String CODE = "code";
        static final String SORT_CODE = "sortCode";
        static final String ACTIVE = "active";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "codedAttribute";
        static final String TYPE_NAME = "CodedAttributeType";

        Constants() {
        }
    }

    public static final class Builder
    implements Serializable,
    ModelBuilder,
    CodedAttributeContract {
        private String name;
        private String code;
        private String sortCode;
        private Long versionNumber;
        private String objectId;
        private boolean active;

        private Builder(String code) {
            this.setCode(code);
        }

        public static Builder create(String code) {
            return new Builder(code);
        }

        public static Builder create(CodedAttributeContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract was null");
            }
            Builder builder = Builder.create(contract.getCode());
            builder.setName(contract.getName());
            builder.setSortCode(contract.getSortCode());
            builder.setVersionNumber(contract.getVersionNumber());
            builder.setObjectId(contract.getObjectId());
            builder.setActive(contract.isActive());
            return builder;
        }

        public CodedAttribute build() {
            return new CodedAttribute(this);
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String getCode() {
            return this.code;
        }

        @Override
        public String getSortCode() {
            return this.sortCode;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public String getObjectId() {
            return this.objectId;
        }

        public boolean isActive() {
            return this.active;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setCode(String code) {
            if (StringUtils.isWhitespace((String)code)) {
                throw new IllegalArgumentException("code is empty");
            }
            this.code = code;
        }

        public void setSortCode(String sortCode) {
            this.sortCode = sortCode;
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public void setObjectId(String objectId) {
            this.objectId = objectId;
        }

        public void setActive(boolean active) {
            this.active = active;
        }
    }
}

