/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer.sql;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import org.apache.commons.collections.map.ReferenceIdentityMap;
import org.apache.ojb.broker.accesslayer.sql.SelectStatement;
import org.apache.ojb.broker.accesslayer.sql.SqlDeleteByPkStatement;
import org.apache.ojb.broker.accesslayer.sql.SqlDeleteByQuery;
import org.apache.ojb.broker.accesslayer.sql.SqlDeleteMNStatement;
import org.apache.ojb.broker.accesslayer.sql.SqlExistStatement;
import org.apache.ojb.broker.accesslayer.sql.SqlGenerator;
import org.apache.ojb.broker.accesslayer.sql.SqlInsertMNStatement;
import org.apache.ojb.broker.accesslayer.sql.SqlInsertStatement;
import org.apache.ojb.broker.accesslayer.sql.SqlProcedureStatement;
import org.apache.ojb.broker.accesslayer.sql.SqlSelectByPkStatement;
import org.apache.ojb.broker.accesslayer.sql.SqlSelectMNStatement;
import org.apache.ojb.broker.accesslayer.sql.SqlSelectStatement;
import org.apache.ojb.broker.accesslayer.sql.SqlStatement;
import org.apache.ojb.broker.accesslayer.sql.SqlUpdateStatement;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.DeleteProcedureDescriptor;
import org.apache.ojb.broker.metadata.InsertProcedureDescriptor;
import org.apache.ojb.broker.metadata.UpdateProcedureDescriptor;
import org.apache.ojb.broker.platforms.Platform;
import org.apache.ojb.broker.query.BetweenCriteria;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.ExistsCriteria;
import org.apache.ojb.broker.query.FieldCriteria;
import org.apache.ojb.broker.query.InCriteria;
import org.apache.ojb.broker.query.NullCriteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.SelectionCriteria;
import org.apache.ojb.broker.query.SqlCriteria;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class SqlGeneratorDefaultImpl
implements SqlGenerator {
    private Logger logger = LoggerFactory.getLogger(SqlGeneratorDefaultImpl.class);
    private Platform m_platform;
    private Map sqlForClass = new ReferenceIdentityMap(2, 0);

    public SqlGeneratorDefaultImpl(Platform platform) {
        this.m_platform = platform;
    }

    @Override
    public SqlStatement getPreparedDeleteStatement(ClassDescriptor classDescriptor) {
        SqlForClass sqlForClass = this.getSqlForClass(classDescriptor);
        SqlStatement sqlStatement = sqlForClass.getDeleteSql();
        if (sqlStatement == null) {
            DeleteProcedureDescriptor deleteProcedureDescriptor = classDescriptor.getDeleteProcedure();
            sqlStatement = deleteProcedureDescriptor == null ? new SqlDeleteByPkStatement(classDescriptor, this.logger) : new SqlProcedureStatement(deleteProcedureDescriptor, this.logger);
            sqlForClass.setDeleteSql(sqlStatement);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("SQL:" + sqlStatement.getStatement());
            }
        }
        return sqlStatement;
    }

    @Override
    public SqlStatement getPreparedInsertStatement(ClassDescriptor classDescriptor) {
        SqlForClass sqlForClass = this.getSqlForClass(classDescriptor);
        SqlStatement sqlStatement = sqlForClass.getInsertSql();
        if (sqlStatement == null) {
            InsertProcedureDescriptor insertProcedureDescriptor = classDescriptor.getInsertProcedure();
            sqlStatement = insertProcedureDescriptor == null ? new SqlInsertStatement(classDescriptor, this.logger) : new SqlProcedureStatement(insertProcedureDescriptor, this.logger);
            sqlForClass.setInsertSql(sqlStatement);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("SQL:" + sqlStatement.getStatement());
            }
        }
        return sqlStatement;
    }

    @Override
    public SelectStatement getPreparedSelectByPkStatement(ClassDescriptor classDescriptor) {
        SqlForClass sqlForClass = this.getSqlForClass(classDescriptor);
        SelectStatement selectStatement = sqlForClass.getSelectByPKSql();
        if (selectStatement == null) {
            selectStatement = new SqlSelectByPkStatement(this.m_platform, classDescriptor, this.logger);
            sqlForClass.setSelectByPKSql(selectStatement);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("SQL:" + selectStatement.getStatement());
            }
        }
        return selectStatement;
    }

    public SqlStatement getPreparedExistsStatement(ClassDescriptor classDescriptor) {
        SqlForClass sqlForClass = this.getSqlForClass(classDescriptor);
        SqlStatement sqlStatement = sqlForClass.getSelectExists();
        if (sqlStatement == null) {
            sqlStatement = new SqlExistStatement(classDescriptor, this.logger);
            sqlForClass.setSelectExists(sqlStatement);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("SQL:" + sqlStatement.getStatement());
            }
        }
        return sqlStatement;
    }

    @Override
    public SelectStatement getPreparedSelectStatement(Query query, ClassDescriptor classDescriptor) {
        SqlSelectStatement sqlSelectStatement = new SqlSelectStatement(this.m_platform, classDescriptor, query, this.logger);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SQL:" + sqlSelectStatement.getStatement());
        }
        return sqlSelectStatement;
    }

    @Override
    public SqlStatement getPreparedUpdateStatement(ClassDescriptor classDescriptor) {
        SqlForClass sqlForClass = this.getSqlForClass(classDescriptor);
        SqlStatement sqlStatement = sqlForClass.getUpdateSql();
        if (sqlStatement == null) {
            UpdateProcedureDescriptor updateProcedureDescriptor = classDescriptor.getUpdateProcedure();
            sqlStatement = updateProcedureDescriptor == null ? new SqlUpdateStatement(classDescriptor, this.logger) : new SqlProcedureStatement(updateProcedureDescriptor, this.logger);
            sqlForClass.setUpdateSql(sqlStatement);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("SQL:" + sqlStatement.getStatement());
            }
        }
        return sqlStatement;
    }

    @Override
    public String getInsertMNStatement(String string, String[] stringArray, String[] stringArray2) {
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        SqlInsertMNStatement sqlInsertMNStatement = new SqlInsertMNStatement(string, stringArray3, this.logger);
        String string2 = sqlInsertMNStatement.getStatement();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SQL:" + string2);
        }
        return string2;
    }

    @Override
    public String getSelectMNStatement(String string, String[] stringArray, String[] stringArray2) {
        SqlSelectMNStatement sqlSelectMNStatement = new SqlSelectMNStatement(string, stringArray, stringArray2, this.logger);
        String string2 = sqlSelectMNStatement.getStatement();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SQL:" + string2);
        }
        return string2;
    }

    @Override
    public String getDeleteMNStatement(String string, String[] stringArray, String[] stringArray2) {
        String[] stringArray3;
        if (stringArray2 == null) {
            stringArray3 = stringArray;
        } else {
            stringArray3 = new String[stringArray.length + stringArray2.length];
            System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
            System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        }
        SqlDeleteMNStatement sqlDeleteMNStatement = new SqlDeleteMNStatement(string, stringArray3, this.logger);
        String string2 = sqlDeleteMNStatement.getStatement();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SQL:" + string2);
        }
        return string2;
    }

    @Override
    public SelectStatement getSelectStatementDep(Query query, ClassDescriptor classDescriptor) {
        return this.getPreparedSelectStatement(query, classDescriptor);
    }

    public String asSQLStatement(Criteria criteria, ClassDescriptor classDescriptor) {
        Enumeration enumeration = criteria.getElements();
        StringBuffer stringBuffer = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            Object object;
            Object e = enumeration.nextElement();
            if (e instanceof Criteria) {
                String string;
                Criteria criteria2 = (Criteria)e;
                if (criteria2.isEmbraced()) {
                    object = " (";
                    string = ") ";
                } else {
                    object = "";
                    string = "";
                }
                switch (criteria2.getType()) {
                    case 0: {
                        stringBuffer.append(" OR ").append((String)object);
                        stringBuffer.append(this.asSQLStatement(criteria2, classDescriptor));
                        stringBuffer.append(string);
                        break;
                    }
                    case 1: {
                        stringBuffer.insert(0, "( ");
                        stringBuffer.append(") ");
                        stringBuffer.append(" AND ").append((String)object);
                        stringBuffer.append(this.asSQLStatement(criteria2, classDescriptor));
                        stringBuffer.append(string);
                    }
                }
                continue;
            }
            object = (SelectionCriteria)e;
            if (stringBuffer.length() == 0) {
                stringBuffer.append(this.asSQLClause((SelectionCriteria)object, classDescriptor));
                continue;
            }
            stringBuffer.insert(0, "(");
            stringBuffer.append(") ");
            stringBuffer.append(" AND ");
            stringBuffer.append(this.asSQLClause((SelectionCriteria)object, classDescriptor));
        }
        if (stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    protected String asSQLClause(SelectionCriteria selectionCriteria, ClassDescriptor classDescriptor) {
        if (selectionCriteria instanceof FieldCriteria) {
            return this.toSQLClause((FieldCriteria)selectionCriteria, classDescriptor);
        }
        if (selectionCriteria instanceof NullCriteria) {
            return this.toSQLClause((NullCriteria)selectionCriteria);
        }
        if (selectionCriteria instanceof BetweenCriteria) {
            return this.toSQLClause((BetweenCriteria)selectionCriteria, classDescriptor);
        }
        if (selectionCriteria instanceof InCriteria) {
            return this.toSQLClause((InCriteria)selectionCriteria);
        }
        if (selectionCriteria instanceof SqlCriteria) {
            return this.toSQLClause((SqlCriteria)selectionCriteria);
        }
        if (selectionCriteria instanceof ExistsCriteria) {
            return this.toSQLClause((ExistsCriteria)selectionCriteria, classDescriptor);
        }
        return this.toSQLClause(selectionCriteria, classDescriptor);
    }

    private String toSqlClause(Object object, ClassDescriptor classDescriptor) {
        String string;
        if (object instanceof Query) {
            Query query = (Query)object;
            string = this.getPreparedSelectStatement(query, classDescriptor.getRepository().getDescriptorFor(query.getSearchClass())).getStatement();
        } else {
            string = (String)object;
        }
        return string;
    }

    private String toSQLClause(NullCriteria nullCriteria) {
        String string = (String)nullCriteria.getAttribute();
        return string + nullCriteria.getClause();
    }

    private String toSQLClause(FieldCriteria fieldCriteria, ClassDescriptor classDescriptor) {
        String string = this.toSqlClause(fieldCriteria.getAttribute(), classDescriptor);
        return string + fieldCriteria.getClause() + fieldCriteria.getValue();
    }

    private String toSQLClause(BetweenCriteria betweenCriteria, ClassDescriptor classDescriptor) {
        String string = this.toSqlClause(betweenCriteria.getAttribute(), classDescriptor);
        return string + betweenCriteria.getClause() + " ? AND ? ";
    }

    private String toSQLClause(InCriteria inCriteria) {
        StringBuffer stringBuffer = new StringBuffer();
        Collection collection = (Collection)inCriteria.getValue();
        int n = collection.size();
        stringBuffer.append(inCriteria.getAttribute());
        stringBuffer.append(inCriteria.getClause());
        stringBuffer.append("(");
        for (int i = 0; i < n - 1; ++i) {
            stringBuffer.append("?,");
        }
        stringBuffer.append("?)");
        return stringBuffer.toString();
    }

    private String toSQLClause(SelectionCriteria selectionCriteria, ClassDescriptor classDescriptor) {
        String string = this.toSqlClause(selectionCriteria.getAttribute(), classDescriptor);
        return string + selectionCriteria.getClause() + " ? ";
    }

    private String toSQLClause(SqlCriteria sqlCriteria) {
        return sqlCriteria.getClause();
    }

    private String toSQLClause(ExistsCriteria existsCriteria, ClassDescriptor classDescriptor) {
        StringBuffer stringBuffer = new StringBuffer();
        Query query = (Query)existsCriteria.getValue();
        stringBuffer.append(existsCriteria.getClause());
        stringBuffer.append(" (");
        if (classDescriptor != null) {
            stringBuffer.append(this.getPreparedSelectStatement(query, classDescriptor.getRepository().getDescriptorFor(query.getSearchClass())));
        } else {
            stringBuffer.append(query);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    @Override
    public SqlStatement getPreparedDeleteStatement(Query query, ClassDescriptor classDescriptor) {
        return new SqlDeleteByQuery(this.m_platform, classDescriptor, query, this.logger);
    }

    @Override
    public Platform getPlatform() {
        return this.m_platform;
    }

    protected SqlForClass getSqlForClass(ClassDescriptor classDescriptor) {
        SqlForClass sqlForClass = (SqlForClass)this.sqlForClass.get(classDescriptor);
        if (sqlForClass == null) {
            sqlForClass = this.newInstanceSqlForClass();
            this.sqlForClass.put(classDescriptor, sqlForClass);
        }
        return sqlForClass;
    }

    protected SqlForClass newInstanceSqlForClass() {
        return new SqlForClass();
    }

    public static class SqlForClass {
        private SqlStatement deleteSql;
        private SqlStatement insertSql;
        private SqlStatement updateSql;
        private SelectStatement selectByPKSql;
        private SqlStatement selectExists;

        public SqlStatement getDeleteSql() {
            return this.deleteSql;
        }

        public void setDeleteSql(SqlStatement sqlStatement) {
            this.deleteSql = sqlStatement;
        }

        public SqlStatement getInsertSql() {
            return this.insertSql;
        }

        public void setInsertSql(SqlStatement sqlStatement) {
            this.insertSql = sqlStatement;
        }

        public SqlStatement getUpdateSql() {
            return this.updateSql;
        }

        public void setUpdateSql(SqlStatement sqlStatement) {
            this.updateSql = sqlStatement;
        }

        public SelectStatement getSelectByPKSql() {
            return this.selectByPKSql;
        }

        public void setSelectByPKSql(SelectStatement selectStatement) {
            this.selectByPKSql = selectStatement;
        }

        public SqlStatement getSelectExists() {
            return this.selectExists;
        }

        public void setSelectExists(SqlStatement sqlStatement) {
            this.selectExists = sqlStatement;
        }
    }
}

