/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.documentlink.dao.impl;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;
import org.kuali.rice.kew.documentlink.DocumentLink;
import org.kuali.rice.kew.documentlink.dao.DocumentLinkDAO;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.springframework.beans.factory.annotation.Required;

public class DocumentLinkDAOJpa
implements DocumentLinkDAO {
    private EntityManager entityManager;
    private DataObjectService dataObjectService;

    @Override
    public void deleteDocumentLink(DocumentLink link) {
        this.getDataObjectService().delete((Object)link);
        DocumentLink reverseLink = this.getLinkedDocument(link.getDestDocId(), link.getOrgnDocId());
        if (reverseLink != null) {
            this.getDataObjectService().delete((Object)reverseLink);
        }
    }

    @Override
    public List<DocumentLink> getLinkedDocumentsByDocId(String docId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("DocumentLink.GetLinkedDocumentsByDocId", DocumentLink.class);
        query.setParameter("orgnDocId", (Object)docId);
        return query.getResultList();
    }

    @Override
    public List<DocumentLink> getOutgoingLinkedDocumentsByDocId(String docId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("DocumentLink.GetOutgoingLinkedDocumentsByDocId", DocumentLink.class);
        query.setParameter("destDocId", (Object)docId);
        return query.getResultList();
    }

    @Override
    public DocumentLink saveDocumentLink(DocumentLink link) {
        link = this.saveIfNotExists(link);
        this.saveIfNotExists(this.createReverseLink(link));
        this.getDataObjectService().flush(DocumentLink.class);
        return link;
    }

    protected DocumentLink saveIfNotExists(DocumentLink link) {
        DocumentLink existingLink = this.getLinkedDocument(link.getOrgnDocId(), link.getDestDocId());
        link = existingLink == null ? (DocumentLink)this.getDataObjectService().save((Object)link, new PersistenceOption[0]) : existingLink;
        return link;
    }

    protected DocumentLink getLinkedDocument(String orgnDocId, String destDocId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("DocumentLink.GetLinkedDocument", DocumentLink.class);
        query.setParameter("orgnDocId", (Object)orgnDocId);
        query.setParameter("destDocId", (Object)destDocId);
        try {
            return (DocumentLink)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    private DocumentLink createReverseLink(DocumentLink link) {
        DocumentLink reverseLink = new DocumentLink();
        reverseLink.setOrgnDocId(link.getDestDocId());
        reverseLink.setDestDocId(link.getOrgnDocId());
        return reverseLink;
    }

    @Override
    public DocumentLink getDocumentLink(String documentLinkId) {
        return (DocumentLink)this.getDataObjectService().find(DocumentLink.class, (Object)documentLinkId);
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    @Required
    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }
}

