/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.locking;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.commons.lang.SystemUtils;
import org.apache.ojb.broker.locking.LockIsolation;
import org.apache.ojb.broker.locking.LockIsolationManager;
import org.apache.ojb.broker.locking.LockManager;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class LockManagerInMemoryImpl
implements LockManager {
    private Logger log = LoggerFactory.getLogger(LockManagerInMemoryImpl.class);
    private static long CLEANUP_FREQUENCY = 1000L;
    private static int MAX_LOCKS_TO_CLEAN = 300;
    private HashMap locktable = new HashMap();
    private LockIsolationManager lockStrategyManager = new LockIsolationManager();
    private long m_lastCleanupAt = System.currentTimeMillis();
    private long lockTimeout = 60000L;
    private long timeoutCounterRead;
    private long timeoutCounterWrite;

    @Override
    public long getLockTimeout() {
        return this.lockTimeout;
    }

    @Override
    public void setLockTimeout(long l) {
        this.lockTimeout = l;
    }

    @Override
    public long getBlockTimeout() {
        return 0L;
    }

    @Override
    public void setBlockTimeout(long l) {
    }

    @Override
    public String getLockInfo() {
        String string = SystemUtils.LINE_SEPARATOR;
        StringBuffer stringBuffer = new StringBuffer("Class: " + LockManagerInMemoryImpl.class.getName() + string);
        stringBuffer.append("lock timeout: " + this.getLockTimeout() + " [ms]" + string);
        stringBuffer.append("concurrent lock owners: " + this.locktable.size() + string);
        stringBuffer.append("timed out write locks: " + this.timeoutCounterWrite + string);
        stringBuffer.append("timed out read locks: " + this.timeoutCounterRead + string);
        return stringBuffer.toString();
    }

    @Override
    public boolean readLock(Object object, Object object2, int n) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("LM.readLock(tx-" + object + ", " + object2 + ")");
        }
        this.checkTimedOutLocks();
        LockEntry lockEntry = new LockEntry(object2, object, System.currentTimeMillis(), n, 0);
        LockIsolation lockIsolation = this.lockStrategyManager.getStrategyFor(n);
        return this.addReaderIfPossibleInternal(lockEntry, lockIsolation.allowMultipleRead(), lockIsolation.allowReadWhenWrite());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addReaderIfPossibleInternal(LockEntry lockEntry, boolean bl, boolean bl2) {
        boolean bl3 = false;
        ObjectLocks objectLocks = null;
        Object object = lockEntry.getResourceId();
        HashMap hashMap = this.locktable;
        synchronized (hashMap) {
            objectLocks = (ObjectLocks)this.locktable.get(object);
            if (objectLocks == null) {
                objectLocks = new ObjectLocks();
                this.locktable.put(object, objectLocks);
                objectLocks.addReader(lockEntry);
                bl3 = true;
            } else {
                LockEntry lockEntry2 = objectLocks.getWriter();
                if (lockEntry2 != null) {
                    if (lockEntry2.isOwnedBy(lockEntry.getKey())) {
                        bl3 = true;
                    } else if (bl2 && bl) {
                        objectLocks.addReader(lockEntry);
                        bl3 = true;
                    } else {
                        bl3 = false;
                    }
                } else if (objectLocks.getReaders().size() > 0) {
                    if (objectLocks.getReader(lockEntry.getKey()) != null) {
                        bl3 = true;
                    } else if (bl) {
                        objectLocks.addReader(lockEntry);
                        bl3 = true;
                    }
                } else {
                    objectLocks.addReader(lockEntry);
                    bl3 = true;
                }
            }
        }
        return bl3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeReader(Object object, Object object2) {
        boolean bl = false;
        ObjectLocks objectLocks = null;
        HashMap hashMap = this.locktable;
        synchronized (hashMap) {
            objectLocks = (ObjectLocks)this.locktable.get(object2);
            if (objectLocks != null) {
                Hashtable hashtable = objectLocks.getReaders();
                boolean bl2 = bl = hashtable.remove(object) != null;
                if (objectLocks.getWriter() == null && hashtable.size() == 0) {
                    this.locktable.remove(object2);
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeWriter(Object object, Object object2) {
        boolean bl = false;
        ObjectLocks objectLocks = null;
        HashMap hashMap = this.locktable;
        synchronized (hashMap) {
            LockEntry lockEntry;
            objectLocks = (ObjectLocks)this.locktable.get(object2);
            if (objectLocks != null && (lockEntry = objectLocks.getWriter()) != null && lockEntry.isOwnedBy(object)) {
                objectLocks.setWriter(null);
                bl = true;
                if (objectLocks.getReaders().size() == 0) {
                    this.locktable.remove(object2);
                }
            }
        }
        return bl;
    }

    @Override
    public boolean releaseLock(Object object, Object object2) {
        boolean bl;
        if (this.log.isDebugEnabled()) {
            this.log.debug("LM.releaseLock(tx-" + object + ", " + object2 + ")");
        }
        if (!(bl = this.removeReader(object, object2))) {
            bl = this.removeWriter(object, object2);
        }
        return bl;
    }

    @Override
    public void releaseLocks(Object object) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("LM.releaseLocks(tx-" + object + ")");
        }
        this.checkTimedOutLocks();
        this.releaseLocksInternal(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseLocksInternal(Object object) {
        HashMap hashMap = this.locktable;
        synchronized (hashMap) {
            Collection collection = this.locktable.values();
            for (ObjectLocks objectLocks : collection) {
                objectLocks.removeReader(object);
                if (objectLocks.getWriter() == null || !objectLocks.getWriter().isOwnedBy(object)) continue;
                objectLocks.setWriter(null);
            }
        }
    }

    @Override
    public boolean writeLock(Object object, Object object2, int n) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("LM.writeLock(tx-" + object + ", " + object2 + ")");
        }
        this.checkTimedOutLocks();
        LockEntry lockEntry = new LockEntry(object2, object, System.currentTimeMillis(), n, 1);
        LockIsolation lockIsolation = this.lockStrategyManager.getStrategyFor(n);
        return this.setWriterIfPossibleInternal(lockEntry, lockIsolation.allowWriteWhenRead());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setWriterIfPossibleInternal(LockEntry lockEntry, boolean bl) {
        boolean bl2 = false;
        ObjectLocks objectLocks = null;
        HashMap hashMap = this.locktable;
        synchronized (hashMap) {
            objectLocks = (ObjectLocks)this.locktable.get(lockEntry.getResourceId());
            if (objectLocks == null) {
                objectLocks = new ObjectLocks();
                objectLocks.setWriter(lockEntry);
                this.locktable.put(lockEntry.getResourceId(), objectLocks);
                bl2 = true;
            } else {
                LockEntry lockEntry2 = objectLocks.getWriter();
                if (lockEntry2 != null) {
                    if (lockEntry2.isOwnedBy(lockEntry.getKey())) {
                        bl2 = true;
                    }
                } else {
                    int n = objectLocks.getReaders().size();
                    if (n > 0) {
                        if (objectLocks.getReader(lockEntry.getKey()) != null) {
                            if (n == 1) {
                                objectLocks.readers.remove(lockEntry.getKey());
                                objectLocks.setWriter(lockEntry);
                                bl2 = true;
                            } else if (bl) {
                                objectLocks.readers.remove(lockEntry.getKey());
                                objectLocks.setWriter(lockEntry);
                                bl2 = true;
                            }
                        } else if (bl) {
                            objectLocks.setWriter(lockEntry);
                            bl2 = true;
                        }
                    } else {
                        objectLocks.setWriter(lockEntry);
                        bl2 = true;
                    }
                }
            }
        }
        return bl2;
    }

    @Override
    public boolean upgradeLock(Object object, Object object2, int n) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("LM.upgradeLock(tx-" + object + ", " + object2 + ")");
        }
        return this.writeLock(object, object2, n);
    }

    @Override
    public boolean hasWrite(Object object, Object object2) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("LM.hasWrite(tx-" + object + ", " + object2 + ")");
        }
        this.checkTimedOutLocks();
        return this.hasWriteLockInternal(object2, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasWriteLockInternal(Object object, Object object2) {
        boolean bl = false;
        ObjectLocks objectLocks = null;
        HashMap hashMap = this.locktable;
        synchronized (hashMap) {
            LockEntry lockEntry;
            objectLocks = (ObjectLocks)this.locktable.get(object);
            if (objectLocks != null && (lockEntry = objectLocks.getWriter()) != null) {
                bl = lockEntry.isOwnedBy(object2);
            }
        }
        return bl;
    }

    @Override
    public boolean hasUpgrade(Object object, Object object2) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("LM.hasUpgrade(tx-" + object + ", " + object2 + ")");
        }
        return this.hasWrite(object, object2);
    }

    @Override
    public boolean hasRead(Object object, Object object2) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("LM.hasRead(tx-" + object + ", " + object2 + ')');
        }
        this.checkTimedOutLocks();
        return this.hasReadLockInternal(object2, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasReadLockInternal(Object object, Object object2) {
        boolean bl = false;
        ObjectLocks objectLocks = null;
        HashMap hashMap = this.locktable;
        synchronized (hashMap) {
            LockEntry lockEntry;
            objectLocks = (ObjectLocks)this.locktable.get(object);
            if (objectLocks != null && ((lockEntry = objectLocks.getReader(object2)) != null || objectLocks.getWriter() != null && objectLocks.getWriter().isOwnedBy(object2))) {
                bl = true;
            }
        }
        return bl;
    }

    public int lockedObjects() {
        return this.locktable.size();
    }

    private void checkTimedOutLocks() {
        if (System.currentTimeMillis() - this.m_lastCleanupAt > CLEANUP_FREQUENCY) {
            this.removeTimedOutLocks(this.getLockTimeout());
            this.m_lastCleanupAt = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTimedOutLocks(long l) {
        long l2 = System.currentTimeMillis() - l;
        boolean bl = false;
        ObjectLocks objectLocks = null;
        HashMap hashMap = this.locktable;
        synchronized (hashMap) {
            Iterator iterator = this.locktable.values().iterator();
            for (int i = 0; iterator.hasNext() && !bl && i <= MAX_LOCKS_TO_CLEAN; ++i) {
                objectLocks = (ObjectLocks)iterator.next();
                if (objectLocks.getWriter() != null && objectLocks.getWriter().getTimestamp() < l2) {
                    objectLocks.setWriter(null);
                    ++this.timeoutCounterWrite;
                }
                if (objectLocks.getYoungestReader() < l2) {
                    objectLocks.getReaders().clear();
                    ++this.timeoutCounterRead;
                    if (objectLocks.getWriter() != null) continue;
                    iterator.remove();
                    continue;
                }
                Iterator iterator2 = objectLocks.getReaders().values().iterator();
                LockEntry lockEntry = null;
                while (iterator2.hasNext()) {
                    lockEntry = (LockEntry)iterator2.next();
                    if (lockEntry.getTimestamp() >= l2) continue;
                    iterator2.remove();
                }
            }
        }
    }

    final class LockEntry
    implements Serializable {
        static final int LOCK_READ = 0;
        static final int LOCK_WRITE = 1;
        private Object resourceId;
        private Object key;
        private long timestamp;
        private int isolationLevel;
        private int lockType;

        public LockEntry(Object object, Object object2, long l, int n, int n2) {
            this.resourceId = object;
            this.key = object2;
            this.timestamp = l;
            this.isolationLevel = n;
            this.lockType = n2;
        }

        public Object getResourceId() {
            return this.resourceId;
        }

        public Object getKey() {
            return this.key;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public int getIsolationLevel() {
            return this.isolationLevel;
        }

        public int getLockType() {
            return this.lockType;
        }

        public void setLockType(int n) {
            this.lockType = n;
        }

        public boolean isOwnedBy(Object object) {
            return this.getKey().equals(object);
        }

        public void setIsolationLevel(int n) {
            this.isolationLevel = n;
        }

        public void setresourceId(String string) {
            this.resourceId = string;
        }

        public void setTimestamp(long l) {
            this.timestamp = l;
        }

        public void setKey(Object object) {
            this.key = object;
        }
    }

    static final class ObjectLocks {
        private LockEntry writer;
        private Hashtable readers;
        private long m_youngestReader = 0L;

        ObjectLocks() {
            this(null);
        }

        ObjectLocks(LockEntry lockEntry) {
            this.writer = lockEntry;
            this.readers = new Hashtable();
        }

        LockEntry getWriter() {
            return this.writer;
        }

        void setWriter(LockEntry lockEntry) {
            this.writer = lockEntry;
        }

        Hashtable getReaders() {
            return this.readers;
        }

        void addReader(LockEntry lockEntry) {
            if (lockEntry.getTimestamp() < this.m_youngestReader || this.m_youngestReader == 0L) {
                this.m_youngestReader = lockEntry.getTimestamp();
            }
            this.readers.put(lockEntry.getKey(), lockEntry);
        }

        long getYoungestReader() {
            return this.m_youngestReader;
        }

        LockEntry getReader(Object object) {
            return (LockEntry)this.readers.get(object);
        }

        LockEntry removeReader(Object object) {
            return (LockEntry)this.readers.remove(object);
        }
    }
}

