/*
 * Decompiled with CFR 0.152.
 */
package com.codiform.moo.property;

import com.codiform.moo.annotation.Optionality;
import com.codiform.moo.property.AbstractProperty;
import com.codiform.moo.property.CollectionProperty;
import com.codiform.moo.translator.CollectionMatcher;
import com.codiform.moo.translator.DefaultCollectionTargetFactory;
import com.codiform.moo.translator.DefaultObjectTargetFactory;
import com.codiform.moo.translator.IndexMatcher;
import com.codiform.moo.translator.TranslationTargetFactory;

public abstract class AbstractCollectionProperty
extends AbstractProperty
implements CollectionProperty {
    private final Class<?> itemClass;
    private final Class<CollectionMatcher<Object, Object>> matcher;
    private final Optionality optionality;
    private final boolean removeOrphans;
    private final boolean update;
    private String itemSource;
    private Class<? extends TranslationTargetFactory> factory;
    private Class<? extends TranslationTargetFactory> itemFactory;

    public AbstractCollectionProperty(com.codiform.moo.annotation.CollectionProperty annotation) {
        if (annotation != null) {
            this.itemClass = annotation.itemClass() == Object.class ? null : annotation.itemClass();
            this.matcher = annotation.matcher() == IndexMatcher.class ? null : annotation.matcher();
            this.optionality = annotation.optionality();
            this.removeOrphans = annotation.removeOrphans();
            this.update = annotation.update();
            this.itemSource = annotation.itemSource().trim();
            this.factory = annotation.factory();
            this.itemFactory = annotation.itemFactory();
            if (this.itemSource.length() == 0) {
                this.itemSource = null;
            }
        } else {
            this.itemClass = null;
            this.matcher = null;
            this.optionality = null;
            this.removeOrphans = true;
            this.update = false;
            this.itemSource = null;
            this.factory = DefaultCollectionTargetFactory.class;
            this.itemFactory = DefaultObjectTargetFactory.class;
        }
    }

    @Override
    public Class<?> getItemClass() {
        return this.itemClass;
    }

    @Override
    public boolean hasMatcher() {
        return this.matcher != null;
    }

    @Override
    public boolean shouldItemsBeTranslated() {
        return this.itemClass != null || this.getItemFactory() != DefaultObjectTargetFactory.class;
    }

    @Override
    public Class<CollectionMatcher<Object, Object>> getMatcherType() {
        return this.matcher;
    }

    @Override
    public boolean shouldUpdate() {
        return this.update;
    }

    @Override
    public boolean isSourceRequired(boolean defaultSetting) {
        return this.isSourceRequired(defaultSetting, this.optionality);
    }

    @Override
    public boolean shouldRemoveOrphans() {
        return this.removeOrphans;
    }

    @Override
    public boolean shouldBeTranslated() {
        return false;
    }

    @Override
    public String getItemSource() {
        return this.itemSource;
    }

    @Override
    public Class<? extends TranslationTargetFactory> getFactory() {
        return this.factory;
    }

    @Override
    public Class<? extends TranslationTargetFactory> getItemFactory() {
        return this.itemFactory;
    }
}

