/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.element;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;
import org.kuali.rice.krad.datadictionary.validator.Validator;
import org.kuali.rice.krad.messages.MessageService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.element.ContentElementBase;
import org.kuali.rice.krad.uif.util.LifecycleElement;

@BeanTag(name="link", parent="Uif-Link")
public class Link
extends ContentElementBase {
    private static final long serialVersionUID = 8989868231938336068L;
    private String linkText;
    private String target;
    private String href;
    private String iconClass;
    private String linkIconPlacement = UifConstants.Position.LEFT.name();
    private String linkDialogId = "";
    private boolean openInDialog;

    @Override
    public void performApplyModel(Object model, LifecycleElement parent) {
        super.performApplyModel(model, parent);
    }

    @Override
    public void performFinalize(Object model, LifecycleElement parent) {
        super.performFinalize(model, parent);
        MessageService messageService = KRADServiceLocatorWeb.getMessageService();
        if (this.openInDialog) {
            this.addDataAttribute("onClick", "e.preventDefault(); openLinkInDialog(jQuery(this), \"" + this.linkDialogId + "\");");
            this.addDataAttribute("role", "Action");
        }
        if (StringUtils.isNotBlank((String)this.iconClass) && ("ICON_ONLY".equals(this.linkIconPlacement) || StringUtils.isBlank((String)this.linkText))) {
            this.getCssClasses().add(this.iconClass);
            this.linkIconPlacement = "ICON_ONLY";
        }
        if (this.target.equals("_blank")) {
            String title = this.getTitle();
            if (StringUtils.isNotBlank((String)title)) {
                this.setTitle(title + " - " + messageService.getMessageText("accessibility.link.opensTab"));
            } else {
                this.setTitle(messageService.getMessageText("accessibility.link.opensTab"));
            }
        }
    }

    @BeanTagAttribute
    public String getLinkText() {
        return this.linkText;
    }

    public void setLinkText(String linkText) {
        this.linkText = linkText;
    }

    @BeanTagAttribute
    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    @BeanTagAttribute
    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    @BeanTagAttribute
    public String getLinkDialogId() {
        return this.linkDialogId;
    }

    public void setLinkDialogId(String linkDialogId) {
        this.linkDialogId = linkDialogId;
    }

    @BeanTagAttribute
    public boolean isOpenInDialog() {
        return this.openInDialog;
    }

    public void setOpenInDialog(boolean openInDialog) {
        this.openInDialog = openInDialog;
    }

    @BeanTagAttribute
    public String getIconClass() {
        return this.iconClass;
    }

    public void setIconClass(String iconClass) {
        this.iconClass = iconClass;
    }

    @BeanTagAttribute
    public String getLinkIconPlacement() {
        return this.linkIconPlacement;
    }

    public void setLinkIconPlacement(String linkIconPlacement) {
        this.linkIconPlacement = linkIconPlacement;
    }

    @Override
    public void completeValidation(ValidationTrace tracer) {
        ArrayList reports = new ArrayList();
        tracer.addBean(this);
        if (tracer.getValidationStage() == 1) {
            String[] currentValues;
            if (this.getHref() == null && !Validator.checkExpressions(this, "href")) {
                currentValues = new String[]{"href =" + this.getHref()};
                tracer.createError("Href must be set", currentValues);
            }
            if (this.getLinkText() == null && !Validator.checkExpressions(this, "linkText")) {
                currentValues = new String[]{"linkText = " + this.getLinkText()};
                tracer.createError("LinkText must be set", currentValues);
            }
        }
        super.completeValidation(tracer.getCopy());
    }
}

