/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.budget.person;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.Interval;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.BudgetConstants;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItem;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.common.budget.framework.personnel.BudgetAddPersonnelPeriodEvent;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPerson;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonSalaryDetails;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonService;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelBudgetService;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelDetails;
import org.kuali.coeus.common.budget.framework.personnel.BudgetSavePersonnelPeriodEvent;
import org.kuali.coeus.common.budget.framework.personnel.BudgetSaveProjectPersonnelEvent;
import org.kuali.coeus.common.budget.framework.personnel.DeleteBudgetPersonEvent;
import org.kuali.coeus.common.budget.framework.personnel.PersonnelApplyToPeriodsBudgetEvent;
import org.kuali.coeus.common.budget.framework.personnel.TbnPerson;
import org.kuali.coeus.common.budget.impl.nonpersonnel.BudgetExpensesRuleEvent;
import org.kuali.coeus.common.framework.person.PersonTypeConstants;
import org.kuali.coeus.common.view.wizard.framework.WizardControllerService;
import org.kuali.coeus.common.view.wizard.framework.WizardResultsDto;
import org.kuali.coeus.propdev.impl.budget.ProposalDevelopmentBudgetExt;
import org.kuali.coeus.propdev.impl.budget.core.ProposalBudgetControllerBase;
import org.kuali.coeus.propdev.impl.budget.core.ProposalBudgetForm;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.data.CopyOption;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.web.form.DialogResponse;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/proposalBudget"})
public class ProposalBudgetProjectPersonnelController
extends ProposalBudgetControllerBase {
    private static final String ADD_PERSONNEL_HELPER_ERROR_PATH = "addProjectPersonnelHelper.editBudgetPersonnelDetail.";
    private static final String TBN_REGEX = "\\s*-\\s*[0-9]+$";
    @Autowired
    @Qualifier(value="wizardControllerService")
    private WizardControllerService wizardControllerService;
    @Autowired
    @Qualifier(value="budgetPersonService")
    private BudgetPersonService budgetPersonService;
    @Autowired
    @Qualifier(value="budgetPersonnelBudgetService")
    BudgetPersonnelBudgetService budgetPersonnelBudgetService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;
    private static final String EDIT_PROJECT_PERSONNEL_DIALOG_ID = "PropBudget-EditPersonnel-Section";
    private static final String EDIT_PERSONNEL_PERIOD_DIALOG_ID = "PropBudget-EditPersonnelPeriod-Section";
    private static final String EDIT_LINE_ITEM_DETAILS_DIALOG_ID = "PropBudget-AssignPersonnelToPeriodsPage-DetailsAndRates";
    private static final String CONFIRM_PERSONNEL_PERIOD_CHANGES_DIALOG_ID = "PropBudget-ConfirmPeriodChangesDialog";
    private static final String ADD_PERSONNEL_PERIOD_DIALOG_ID = "PropBudget-AssignPersonnelToPeriodsPage-AddPersonnel";
    private static final String ADD_PROJECT_PERSONNEL_DIALOG_ID = "PropBudget-ProjectPersonnelPage-Wizard";

    @Transactional
    @RequestMapping(params={"methodToCall=searchProjectPersonnel"})
    public ModelAndView searchProjectPersonnel(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        if (!StringUtils.isEmpty((CharSequence)form.getAddProjectPersonnelHelper().getLineType())) {
            form.getAddProjectPersonnelHelper().getResults().clear();
            form.getAddProjectPersonnelHelper().setResults(this.getWizardControllerService().performWizardSearch(form.getAddProjectPersonnelHelper().getLookupFieldValues(), form.getAddProjectPersonnelHelper().getLineType()));
        }
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=addProjectPersonnel"})
    public ModelAndView addProjectPersonnel(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        if (StringUtils.equals((CharSequence)form.getAddProjectPersonnelHelper().getLineType(), (CharSequence)PersonTypeConstants.TBN.getCode())) {
            for (TbnPerson person : form.getAddProjectPersonnelHelper().getTbnPersons()) {
                for (int index = 0; index < person.getQuantity(); ++index) {
                    BudgetPerson newPerson = new BudgetPerson(person);
                    newPerson.setPersonName(this.getNextTbnName(form.getBudget().getBudgetPersons(), newPerson));
                    this.getBudgetPersonService().addBudgetPerson(form.getBudget(), newPerson);
                }
            }
        } else {
            for (Object object : form.getAddProjectPersonnelHelper().getResults()) {
                WizardResultsDto wizardResult = (WizardResultsDto)object;
                BudgetPerson newBudgetPerson = new BudgetPerson();
                if (!wizardResult.isSelected() || !wizardResult.isSelected()) continue;
                if (wizardResult.getKcPerson() != null) {
                    newBudgetPerson.setPersonId(wizardResult.getKcPerson().getPersonId());
                    newBudgetPerson.setPersonName(wizardResult.getKcPerson().getFullName());
                    newBudgetPerson.setUserName(wizardResult.getKcPerson().getUserName());
                    newBudgetPerson.setNonEmployeeFlag(false);
                } else if (wizardResult.getRolodex() != null) {
                    newBudgetPerson.setRolodexId(wizardResult.getRolodex().getRolodexId());
                    newBudgetPerson.setPersonName(wizardResult.getRolodex().getFullName());
                    newBudgetPerson.setNonEmployeeFlag(true);
                }
                this.getBudgetPersonService().addBudgetPerson(form.getBudget(), newBudgetPerson);
            }
        }
        form.getAddProjectPersonnelHelper().reset();
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    protected String getNextTbnName(List<BudgetPerson> current, BudgetPerson newPerson) {
        String tbnPrefix = newPerson.getPersonName() + " - ";
        List sequences = current.stream().filter(person -> StringUtils.isNotBlank((CharSequence)person.getTbnId())).map(BudgetPerson::getPersonName).filter(StringUtils::isNotBlank).filter(personName -> this.doesCategoryExist(newPerson, (String)personName)).map(personName -> personName.replace(tbnPrefix, "")).map(Integer::valueOf).sorted().collect(Collectors.toList());
        if (sequences.isEmpty() || !Integer.valueOf(1).equals(sequences.get(0))) {
            return this.tbnName(tbnPrefix, 1);
        }
        for (Integer i : IntStream.range(1, sequences.size()).boxed().collect(Collectors.toList())) {
            int next = 1 + (Integer)sequences.get(i - 1);
            if (next >= (Integer)sequences.get(i)) continue;
            return this.tbnName(tbnPrefix, next);
        }
        return this.tbnName(tbnPrefix, (Integer)sequences.get(sequences.size() - 1) + 1);
    }

    private boolean doesCategoryExist(BudgetPerson newPerson, String personName) {
        String actualNamePerson = personName.split(TBN_REGEX)[0];
        String actualNameNewPerson = newPerson.getPersonName().split(TBN_REGEX)[0];
        return actualNamePerson.equalsIgnoreCase(actualNameNewPerson);
    }

    private String tbnName(String prefix, int sequence) {
        return prefix + sequence;
    }

    @Transactional
    @RequestMapping(params={"methodToCall=editPersonDetails"})
    public ModelAndView editPersonDetails(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        String selectedLine = form.getActionParamaterValue("selectedLineIndex");
        if (StringUtils.isNotEmpty((CharSequence)selectedLine)) {
            BudgetPerson editBudgetPerson = (BudgetPerson)this.getDataObjectService().copyInstance((Object)form.getBudget().getBudgetPerson(Integer.parseInt(selectedLine)), new CopyOption[0]);
            form.getAddProjectPersonnelHelper().setEditBudgetPerson(editBudgetPerson);
            form.getAddProjectPersonnelHelper().setEditLineIndex(selectedLine);
        }
        return this.getModelAndViewService().showDialog(EDIT_PROJECT_PERSONNEL_DIALOG_ID, true, (UifFormBase)form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=deleteProjectPersonnel"})
    public ModelAndView deleteProjectPersonnel(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        BudgetPerson deleteBudgetPerson;
        ProposalDevelopmentBudgetExt budget;
        String selectedLine = form.getActionParamaterValue("selectedLineIndex");
        if (StringUtils.isNotEmpty((CharSequence)selectedLine) && this.isProjectPersonnelDeleteRulePassed(budget = form.getBudget(), deleteBudgetPerson = budget.getBudgetPersons().get(Integer.parseInt(selectedLine)))) {
            budget.getBudgetPersons().remove(deleteBudgetPerson);
        }
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=prepareAddProjectPersonnel"})
    public ModelAndView prepareAddProjectPersonnel(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        form.getAddProjectPersonnelHelper().setLineType(PersonTypeConstants.EMPLOYEE.getCode());
        return this.getModelAndViewService().showDialog(ADD_PROJECT_PERSONNEL_DIALOG_ID, true, (UifFormBase)form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=updatePersonDetails"})
    public ModelAndView updatePersonDetails(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        int selectedLine = Integer.parseInt(form.getAddProjectPersonnelHelper().getEditLineIndex());
        BudgetPerson editedBudgetPerson = form.getAddProjectPersonnelHelper().getEditBudgetPerson();
        this.getBudgetPersonService().refreshBudgetPerson(editedBudgetPerson);
        boolean rulePassed = this.getKcBusinessRulesEngine().applyRules(new BudgetSaveProjectPersonnelEvent(form.getBudget(), editedBudgetPerson, "addProjectPersonnelHelper.editBudgetPerson."));
        if (rulePassed) {
            form.getBudget().getBudgetPersons().set(selectedLine, form.getAddProjectPersonnelHelper().getEditBudgetPerson());
            super.save(form);
        }
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=calculatePersonSalaryDetails"})
    public ModelAndView calculatePersonSalaryDetails(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        this.calculatePersonSalary(form);
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=syncFromProposal"})
    public ModelAndView syncFromProposal(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        this.getBudgetPersonService().synchBudgetPersonsToProposal(form.getBudget());
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=assignPersonnelToPeriod"})
    public ModelAndView assignPersonnelToPeriod(@RequestParam(value="budgetPeriodId") String budgetPeriodId, @ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        ModelAndView modelAndView = this.getModelAndViewService().getModelAndView((UifFormBase)form);
        ProposalDevelopmentBudgetExt budget = form.getBudget();
        Long currentTabBudgetPeriodId = Long.parseLong(budgetPeriodId);
        BudgetPeriod budgetPeriod = this.getBudgetPeriod(currentTabBudgetPeriodId, budget);
        DialogResponse dialogResponse = form.getDialogResponse(CONFIRM_PERSONNEL_PERIOD_CHANGES_DIALOG_ID);
        if (dialogResponse == null && budgetPeriod.getBudgetPeriod() > 1 && !this.isPersonnelBudgetExists(budget)) {
            modelAndView = this.getModelAndViewService().showDialog(CONFIRM_PERSONNEL_PERIOD_CHANGES_DIALOG_ID, true, (UifFormBase)form);
        } else {
            boolean confirmResetDefault;
            boolean bl = confirmResetDefault = dialogResponse == null || dialogResponse.getResponseAsBoolean();
            if (confirmResetDefault) {
                form.getAddProjectPersonnelHelper().reset();
                form.getAddProjectPersonnelHelper().setCurrentTabBudgetPeriod(budgetPeriod);
                this.setBudgetPeriodStartDateAndEndDateOnLineItems(form, budgetPeriod);
                form.getAddProjectPersonnelHelper().getBudgetLineItem().setBudget(budget);
                form.getAddProjectPersonnelHelper().getBudgetPersonnelDetail().setBudget(budget);
                form.getAddProjectPersonnelHelper().getBudgetPersonnelDetail().setPeriodTypeCode(this.getDefualtPeriodTypeCode());
                modelAndView = this.getModelAndViewService().showDialog(ADD_PERSONNEL_PERIOD_DIALOG_ID, true, (UifFormBase)form);
            }
        }
        return modelAndView;
    }

    protected String getDefualtPeriodTypeCode() {
        return this.getParameterService().getParameterValueAsString("KC-B", "Document", "budgetPersonDetailsDefaultPeriodType");
    }

    private void setBudgetPeriodStartDateAndEndDateOnLineItems(ProposalBudgetForm form, BudgetPeriod budgetPeriod) {
        form.getAddProjectPersonnelHelper().getBudgetLineItem().setStartDate(budgetPeriod.getStartDate());
        form.getAddProjectPersonnelHelper().getBudgetLineItem().setEndDate(budgetPeriod.getEndDate());
        form.getAddProjectPersonnelHelper().getBudgetPersonnelDetail().setStartDate(budgetPeriod.getStartDate());
        form.getAddProjectPersonnelHelper().getBudgetPersonnelDetail().setEndDate(budgetPeriod.getEndDate());
    }

    private boolean isPersonnelBudgetExists(Budget budget) {
        boolean lineItemExists = false;
        block0: for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            if (budgetPeriod.getBudgetPeriod() <= 1) continue;
            for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                if (budgetLineItem.getBudgetPersonnelDetailsList().size() <= 0) continue;
                lineItemExists = true;
                continue block0;
            }
        }
        return lineItemExists;
    }

    private BudgetPeriod getBudgetPeriod(Long currentTabBudgetPeriodId, Budget budget) {
        for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            if (!budgetPeriod.getBudgetPeriodId().equals(currentTabBudgetPeriodId)) continue;
            return budgetPeriod;
        }
        return null;
    }

    @Transactional
    @RequestMapping(params={"methodToCall=addPersonnelToPeriod"})
    public ModelAndView addPersonnelToPeriod(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        ProposalDevelopmentBudgetExt budget = form.getBudget();
        BudgetPeriod currentTabBudgetPeriod = form.getAddProjectPersonnelHelper().getCurrentTabBudgetPeriod();
        List<BudgetPersonnelDetails> newBudgetPersonnelDetails = form.getAddProjectPersonnelHelper().getCalculatedDetails();
        BudgetLineItem newBudgetLineItem = form.getAddProjectPersonnelHelper().getBudgetLineItem();
        boolean success = this.addNewPersonnelLineItemToPeriod(form, budget, currentTabBudgetPeriod, newBudgetLineItem, newBudgetPersonnelDetails, "addProjectPersonnelHelper.budgetPersonnelDetail.");
        if (success) {
            form.getAddProjectPersonnelHelper().reset();
        }
        return this.refreshPageWithBudgetExpenseRules(form);
    }

    protected boolean addNewPersonnelLineItemToPeriod(ProposalBudgetForm form, Budget budget, BudgetPeriod currentTabBudgetPeriod, BudgetLineItem newBudgetLineItem, List<BudgetPersonnelDetails> newBudgetPersonnelDetails, String errorPath) {
        boolean rulePassed = true;
        for (BudgetPersonnelDetails newBudgetPersonnelDetail : newBudgetPersonnelDetails) {
            this.syncLineItemDates(newBudgetLineItem, newBudgetPersonnelDetail);
            this.refreshBudgetLineItemReferences(newBudgetLineItem);
            this.setBudgetLineItemGroupName(form, newBudgetLineItem);
            if (!this.isSummaryPersonnel(newBudgetPersonnelDetail)) {
                this.getBudgetPersonnelBudgetService().refreshBudgetPersonnelLineItemReferences(newBudgetPersonnelDetail);
            }
            rulePassed &= this.isAddBudgetPersonnelRulePassed(budget, currentTabBudgetPeriod, newBudgetLineItem, newBudgetPersonnelDetail, errorPath);
        }
        if (rulePassed) {
            for (BudgetPersonnelDetails newBudgetPersonnelDetail : newBudgetPersonnelDetails) {
                if (this.isSummaryPersonnel(newBudgetPersonnelDetail)) {
                    newBudgetLineItem.setLineItemCost(newBudgetPersonnelDetail.getSalaryRequested());
                    newBudgetLineItem.setStartDate(newBudgetPersonnelDetail.getStartDate());
                    newBudgetLineItem.setEndDate(newBudgetPersonnelDetail.getEndDate());
                }
                this.getBudgetPersonnelBudgetService().addBudgetPersonnelToPeriod(currentTabBudgetPeriod, newBudgetLineItem, newBudgetPersonnelDetail);
            }
            this.getBudgetCalculationService().calculateBudgetPeriod(budget, currentTabBudgetPeriod);
            this.getDataObjectService().save((Object)budget, new PersistenceOption[0]);
            return true;
        }
        return false;
    }

    protected boolean isAddBudgetPersonnelRulePassed(Budget budget, BudgetPeriod budgetPeriod, BudgetLineItem newBudgetLineItem, BudgetPersonnelDetails newBudgetPersonnelDetail, String errorPath) {
        return this.getKcBusinessRulesEngine().applyRules(new BudgetAddPersonnelPeriodEvent(budget, budgetPeriod, newBudgetLineItem, newBudgetPersonnelDetail, errorPath));
    }

    public ModelAndView refreshPageWithBudgetExpenseRules(ProposalBudgetForm form) throws Exception {
        String errorPath = BudgetConstants.BudgetAuditRules.PERSONNEL_COSTS.getPageId();
        this.getKcBusinessRulesEngine().applyRules(new BudgetExpensesRuleEvent(form.getBudget(), errorPath));
        form.setAjaxReturnType("update-page");
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    private void setBudgetLineItemGroupName(ProposalBudgetForm form, BudgetLineItem newBudgetLineItem) {
        String groupName = form.getAddProjectPersonnelHelper().getBudgetPersonGroupName();
        if (!StringUtils.equals((CharSequence)groupName, (CharSequence)"Create New Group")) {
            newBudgetLineItem.setGroupName(groupName);
        }
    }

    private void refreshBudgetLineItemReferences(BudgetLineItem newBudgetLineItem) {
        if (StringUtils.isNotEmpty((CharSequence)newBudgetLineItem.getCostElement())) {
            this.getDataObjectService().wrap((Object)newBudgetLineItem).fetchRelationship("costElementBO");
        }
        newBudgetLineItem.setBudgetCategoryCode(newBudgetLineItem.getCostElementBO().getBudgetCategoryCode());
        if (StringUtils.isNotEmpty((CharSequence)newBudgetLineItem.getBudgetCategoryCode())) {
            this.getDataObjectService().wrap((Object)newBudgetLineItem).fetchRelationship("budgetCategory");
        }
    }

    private void syncLineItemDates(BudgetLineItem budgetLineItem, BudgetPersonnelDetails budgetPersonnelDetails) {
        long longestDuration = 0L;
        for (BudgetPersonnelDetails detail : budgetLineItem.getBudgetPersonnelDetailsList()) {
            BudgetPersonnelDetails updatedDetails = Objects.equals(detail.getBudgetPersonnelLineItemId(), budgetPersonnelDetails.getBudgetPersonnelLineItemId()) ? budgetPersonnelDetails : detail;
            Interval interval = new Interval(updatedDetails.getStartDate().getTime(), updatedDetails.getEndDate().getTime());
            if (interval.toDurationMillis() < longestDuration) continue;
            longestDuration = interval.toDurationMillis();
            budgetLineItem.setStartDate(updatedDetails.getStartDate());
            budgetLineItem.setEndDate(updatedDetails.getEndDate());
        }
    }

    private boolean isSaveRulePassed(Budget budget, BudgetPeriod budgetPeriod, BudgetLineItem newBudgetLineItem, BudgetPersonnelDetails newBudgetPersonnelDetail, int editLineIndex) {
        return this.getKcBusinessRulesEngine().applyRules(new BudgetSavePersonnelPeriodEvent(budget, budgetPeriod, newBudgetLineItem, newBudgetPersonnelDetail, editLineIndex, ADD_PERSONNEL_HELPER_ERROR_PATH));
    }

    private boolean isProjectPersonnelDeleteRulePassed(Budget budget, BudgetPerson budgetPerson) {
        return this.getKcBusinessRulesEngine().applyRules(new DeleteBudgetPersonEvent(budget, budgetPerson, "PropBudget-ProjectPersonnelPage-CollectionGroup"));
    }

    @Transactional
    @RequestMapping(params={"methodToCall=editPersonPeriodDetails"})
    public ModelAndView editPersonPeriodDetails(@RequestParam(value="budgetPeriodId") String budgetPeriodId, @ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        ProposalDevelopmentBudgetExt budget = form.getBudget();
        String selectedLine = form.getActionParamaterValue("selectedLineIndex");
        if (StringUtils.isNotEmpty((CharSequence)selectedLine)) {
            form.getAddProjectPersonnelHelper().reset();
            BudgetPersonnelDetails budgetPersonnelDetails = form.getBudget().getBudgetPersonnelDetails().get(Integer.parseInt(selectedLine));
            BudgetLineItem budgetLineItem = budgetPersonnelDetails.getBudgetLineItem();
            form.getAddProjectPersonnelHelper().setEditLineIndex(selectedLine);
            form.getAddProjectPersonnelHelper().setBudgetLineItem((BudgetLineItem)this.getDataObjectService().copyInstance((Object)budgetLineItem, new CopyOption[0]));
            form.getAddProjectPersonnelHelper().setEditBudgetPersonnelDetail((BudgetPersonnelDetails)this.getDataObjectService().copyInstance((Object)budgetPersonnelDetails, new CopyOption[0]));
            Long currentTabBudgetPeriodId = Long.parseLong(budgetPeriodId);
            BudgetPeriod budgetPeriod = this.getBudgetPeriod(currentTabBudgetPeriodId, budget);
            form.getAddProjectPersonnelHelper().setCurrentTabBudgetPeriod(budgetPeriod);
        }
        return this.getModelAndViewService().showDialog(EDIT_PERSONNEL_PERIOD_DIALOG_ID, true, (UifFormBase)form);
    }

    protected boolean isSummaryPersonChanged(BudgetLineItem budgetLineItem, BudgetPersonnelDetails editedBudgetPersonnelDetails) {
        return !this.isSummaryPersonnel(editedBudgetPersonnelDetails) && !budgetLineItem.isPersonnelLineItem();
    }

    protected boolean isPersonnelChangeToSummaryPerson(BudgetLineItem budgetLineItem, BudgetPersonnelDetails editedBudgetPersonnelDetails) {
        return this.isSummaryPersonnel(editedBudgetPersonnelDetails) && budgetLineItem.isPersonnelLineItem();
    }

    @Transactional
    @RequestMapping(params={"methodToCall=refreshEditBudgetLineItem"})
    public ModelAndView refreshEditBudgetLineItem(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        BudgetPersonnelDetails editBudgetPersonnel = form.getAddProjectPersonnelHelper().getEditBudgetPersonnelDetail();
        this.getDataObjectService().wrap((Object)editBudgetPersonnel).fetchRelationship("budgetPerson");
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=savePersonPeriodDetails"})
    public ModelAndView savePersonPeriodDetails(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        ProposalDevelopmentBudgetExt budget = form.getBudget();
        int selectedLine = Integer.parseInt(form.getAddProjectPersonnelHelper().getEditLineIndex());
        BudgetPersonnelDetails budgetPersonnelDetails = form.getBudget().getBudgetPersonnelDetails().get(selectedLine);
        BudgetLineItem budgetLineItem = budgetPersonnelDetails.getBudgetLineItem();
        int editLineIndex = budgetLineItem.getBudgetPersonnelDetailsList().indexOf(budgetPersonnelDetails);
        BudgetPeriod budgetPeriod = form.getAddProjectPersonnelHelper().getCurrentTabBudgetPeriod();
        BudgetPersonnelDetails editBudgetPersonnel = form.getAddProjectPersonnelHelper().getEditBudgetPersonnelDetail();
        BudgetLineItem editBudgetLineItem = form.getAddProjectPersonnelHelper().getBudgetLineItem();
        int budgetLineItemIndex = budgetPeriod.getBudgetLineItems().indexOf(budgetLineItem);
        if (this.isSummaryPersonChanged(editBudgetLineItem, editBudgetPersonnel)) {
            this.addNewPersonnelLineItemToPeriod(form, budget, budgetPeriod, editBudgetLineItem, List.of(editBudgetPersonnel), ADD_PERSONNEL_HELPER_ERROR_PATH);
        } else {
            boolean rulePassed;
            this.syncLineItemDates(editBudgetLineItem, editBudgetPersonnel);
            if (!this.isSummaryPersonnel(editBudgetPersonnel)) {
                this.getDataObjectService().wrap((Object)editBudgetPersonnel).fetchRelationship("budgetPeriodType");
            }
            if (rulePassed = this.isSaveRulePassed(budget, budgetPeriod, editBudgetLineItem, editBudgetPersonnel, editLineIndex)) {
                this.calculatePersonnelLineItem(form, true);
                if (this.isSummaryPersonnel(editBudgetPersonnel)) {
                    editBudgetLineItem.setLineItemCost(editBudgetPersonnel.getSalaryRequested());
                    editBudgetLineItem.setStartDate(editBudgetPersonnel.getStartDate());
                    editBudgetLineItem.setEndDate(editBudgetPersonnel.getEndDate());
                } else {
                    editBudgetLineItem.getBudgetPersonnelDetailsList().set(editLineIndex, editBudgetPersonnel);
                }
                if (this.isPersonnelChangeToSummaryPerson(editBudgetLineItem, editBudgetPersonnel)) {
                    editBudgetLineItem.getBudgetPersonnelDetailsList().clear();
                }
                BudgetLineItem newBudgetLineItem = (BudgetLineItem)this.getDataObjectService().save((Object)editBudgetLineItem, new PersistenceOption[0]);
                budgetPeriod.getBudgetLineItems().set(budgetLineItemIndex, newBudgetLineItem);
                this.getBudgetCalculationService().calculateBudgetPeriod(budget, budgetPeriod);
            }
        }
        return this.refreshPageWithBudgetExpenseRules(form);
    }

    protected boolean isSummaryPersonnel(BudgetPersonnelDetails budgetPersonnelDetails) {
        return budgetPersonnelDetails.getPersonSequenceNumber().equals(BudgetConstants.BudgetPerson.SUMMARYPERSON.getPersonSequenceNumber());
    }

    @Transactional
    @RequestMapping(params={"methodToCall=calculatePersonnelPeriodLineItem"})
    public ModelAndView calculatePersonnelPeriodLineItem(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        BudgetPersonnelDetails editBudgetPersonnelDetail = form.getAddProjectPersonnelHelper().getEditBudgetPersonnelDetail();
        BudgetLineItem budgetLineItem = form.getAddProjectPersonnelHelper().getBudgetLineItem();
        if (this.isSummaryPersonnel(editBudgetPersonnelDetail)) {
            budgetLineItem.setLineItemCost(editBudgetPersonnelDetail.getSalaryRequested());
            editBudgetPersonnelDetail.setBudgetLineItem(budgetLineItem);
        }
        this.calculatePersonnelLineItem(form, false);
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    protected void calculatePersonnelLineItem(ProposalBudgetForm form, boolean ruleChecked) {
        boolean rulePassed;
        ProposalDevelopmentBudgetExt budget = form.getBudget();
        BudgetPeriod budgetPeriod = form.getAddProjectPersonnelHelper().getCurrentTabBudgetPeriod();
        int selectedLine = Integer.parseInt(form.getAddProjectPersonnelHelper().getEditLineIndex());
        BudgetPersonnelDetails budgetPersonnelDetails = form.getBudget().getBudgetPersonnelDetails().get(selectedLine);
        BudgetLineItem budgetLineItem = budgetPersonnelDetails.getBudgetLineItem();
        int editLineIndex = budgetLineItem.getBudgetPersonnelDetailsList().indexOf(budgetPersonnelDetails);
        BudgetPersonnelDetails editBudgetPersonnel = form.getAddProjectPersonnelHelper().getEditBudgetPersonnelDetail();
        BudgetLineItem editBudgetLineItem = form.getAddProjectPersonnelHelper().getBudgetLineItem();
        this.syncLineItemDates(editBudgetLineItem, editBudgetPersonnel);
        boolean bl = rulePassed = ruleChecked || this.isSaveRulePassed(budget, budgetPeriod, editBudgetLineItem, editBudgetPersonnel, editLineIndex);
        if (rulePassed) {
            this.getBudgetPersonnelBudgetService().calculateBudgetPersonnelLineItem(budget, editBudgetLineItem, editBudgetPersonnel, editLineIndex);
        }
    }

    protected void calculatePersonSalary(ProposalBudgetForm form) {
        ProposalDevelopmentBudgetExt budget = form.getBudget();
        int selectedLine = Integer.parseInt(form.getAddProjectPersonnelHelper().getEditLineIndex());
        BudgetPerson budgetPerson = form.getAddProjectPersonnelHelper().getEditBudgetPerson();
        List<BudgetPersonSalaryDetails> budgetPersonSalaryDetails = this.getBudgetPersonnelBudgetService().calculatePersonSalary(budget, selectedLine);
        budgetPerson.setBudgetPersonSalaryDetails(budgetPersonSalaryDetails);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=calculateCurrentPeriod"})
    public ModelAndView calculateCurrentPeriod(@RequestParam(value="budgetPeriodId") String budgetPeriodId, @ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        ProposalDevelopmentBudgetExt budget = form.getBudget();
        Long currentTabBudgetPeriodId = Long.parseLong(budgetPeriodId);
        BudgetPeriod currentTabBudgetPeriod = this.getBudgetPeriod(currentTabBudgetPeriodId, budget);
        form.getAddProjectPersonnelHelper().setCurrentTabBudgetPeriod(currentTabBudgetPeriod);
        this.getBudgetPersonnelBudgetService().calculateCurrentBudgetPeriod(currentTabBudgetPeriod);
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=editBudgetDetailsAndRates"})
    public ModelAndView editBudgetDetailsAndRates(@RequestParam(value="budgetPeriodId") String budgetPeriodId, @RequestParam(value="lineItemGroupKey") String lineItemGroupKey, @ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        ProposalDevelopmentBudgetExt budget = form.getBudget();
        Long currentTabBudgetPeriodId = Long.parseLong(budgetPeriodId);
        BudgetPeriod currentTabBudgetPeriod = this.getBudgetPeriod(currentTabBudgetPeriodId, budget);
        BudgetLineItem budgetLineItem = this.getSelectedBudgetLineItem(lineItemGroupKey, currentTabBudgetPeriod);
        form.getAddProjectPersonnelHelper().setBudgetLineItem(budgetLineItem);
        form.getAddProjectPersonnelHelper().setCurrentTabBudgetPeriod(currentTabBudgetPeriod);
        return this.getModelAndViewService().showDialog(EDIT_LINE_ITEM_DETAILS_DIALOG_ID, true, (UifFormBase)form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=refresh", "refreshCaller=PropBudget-AssignPersonnelToPeriodsPage-DetailsAndRates"})
    public ModelAndView refreshBudgetDetailsAndRates(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        form.setAjaxReturnType(UifConstants.AjaxReturnTypes.UPDATECOMPONENT.getKey());
        form.setUpdateComponentId(EDIT_LINE_ITEM_DETAILS_DIALOG_ID);
        this.getDataObjectService().wrap((Object)form.getAddProjectBudgetLineItemHelper().getBudgetLineItem()).fetchRelationship("costElementBO");
        return this.getRefreshControllerService().refresh((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=applyToLaterPeriods"})
    public ModelAndView applyToLaterPeriods(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        ProposalDevelopmentBudgetExt budget = form.getBudget();
        BudgetPeriod currentTabBudgetPeriod = form.getAddProjectPersonnelHelper().getCurrentTabBudgetPeriod();
        BudgetLineItem budgetLineItem = form.getAddProjectPersonnelHelper().getBudgetLineItem();
        if (this.getKcBusinessRulesEngine().applyRules(new PersonnelApplyToPeriodsBudgetEvent(budget, ADD_PERSONNEL_HELPER_ERROR_PATH, budgetLineItem, currentTabBudgetPeriod)).booleanValue()) {
            this.getBudgetCalculationService().applyToLaterPeriods(budget, currentTabBudgetPeriod, budgetLineItem);
            return super.save(form);
        }
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=deletePersonnelLineItem"})
    public ModelAndView deletePersonnelLineItem(@RequestParam(value="budgetPeriodId") String budgetPeriodId, @ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        ProposalDevelopmentBudgetExt budget = form.getBudget();
        String selectedLine = form.getActionParamaterValue("selectedLineIndex");
        if (StringUtils.isNotEmpty((CharSequence)selectedLine)) {
            BudgetPersonnelDetails deletedPersonnelLineItem = form.getBudget().getBudgetPersonnelDetails().get(Integer.parseInt(selectedLine));
            Long currentTabBudgetPeriodId = Long.parseLong(budgetPeriodId);
            BudgetPeriod budgetPeriod = this.getBudgetPeriod(currentTabBudgetPeriodId, budget);
            BudgetLineItem budgetLineItem = deletedPersonnelLineItem.getBudgetLineItem();
            if (!this.isSummaryPersonnel(deletedPersonnelLineItem)) {
                budgetLineItem.getBudgetPersonnelDetailsList().remove(deletedPersonnelLineItem);
            }
            if (budgetLineItem.getBudgetPersonnelDetailsList().size() == 0) {
                budgetPeriod.getBudgetLineItems().remove(budgetLineItem);
            }
            this.getBudgetCalculationService().calculateBudgetPeriod(budget, budgetPeriod);
            return this.refreshPageWithBudgetExpenseRules(form);
        }
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    private BudgetLineItem getSelectedBudgetLineItem(String lineItemGroupKey, BudgetPeriod budgetPeriod) {
        for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
            if (!budgetLineItem.getLineItemGroupDescription().equals(lineItemGroupKey)) continue;
            return budgetLineItem;
        }
        return null;
    }

    public WizardControllerService getWizardControllerService() {
        return this.wizardControllerService;
    }

    public void setWizardControllerService(WizardControllerService wizardControllerService) {
        this.wizardControllerService = wizardControllerService;
    }

    public BudgetPersonService getBudgetPersonService() {
        return this.budgetPersonService;
    }

    public void setBudgetPersonService(BudgetPersonService budgetPersonService) {
        this.budgetPersonService = budgetPersonService;
    }

    public BudgetPersonnelBudgetService getBudgetPersonnelBudgetService() {
        return this.budgetPersonnelBudgetService;
    }

    public void setBudgetPersonnelBudgetService(BudgetPersonnelBudgetService budgetPersonnelBudgetService) {
        this.budgetPersonnelBudgetService = budgetPersonnelBudgetService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

