/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.location;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.kuali.coeus.common.framework.org.Organization;
import org.kuali.coeus.common.framework.rolodex.Rolodex;
import org.kuali.coeus.propdev.api.location.ProposalSiteContract;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.location.CongressionalDistrict;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;

@Entity
@Table(name="EPS_PROP_SITES")
@IdClass(value=ProposalSiteId.class)
public class ProposalSite
extends KcPersistableBusinessObjectBase
implements ProposalSiteContract {
    private static final long serialVersionUID = -1657749549230077805L;
    public static final int PROPOSAL_SITE_APPLICANT_ORGANIZATION = 1;
    public static final int PROPOSAL_SITE_PERFORMING_ORGANIZATION = 2;
    public static final int PROPOSAL_SITE_OTHER_ORGANIZATION = 3;
    public static final int PROPOSAL_SITE_PERFORMANCE_SITE = 4;
    private static final String ORGANIZATION = "organization";
    private static final String ROLODEX = "rolodex";
    @Id
    @ManyToOne(cascade={CascadeType.REFRESH})
    @JoinColumn(name="PROPOSAL_NUMBER")
    private DevelopmentProposal developmentProposal;
    @Id
    @Column(name="SITE_NUMBER")
    private Integer siteNumber;
    @Column(name="LOCATION_NAME", nullable=false)
    private String locationName;
    @Column(name="LOCATION_TYPE_CODE", nullable=false)
    private Integer locationTypeCode;
    @Column(name="ORGANIZATION_ID")
    private String organizationId;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.REFRESH})
    @JoinColumn(name="ORGANIZATION_ID", referencedColumnName="ORGANIZATION_ID", insertable=false, updatable=false)
    private Organization organization;
    @Column(name="ROLODEX_ID")
    private Integer rolodexId;
    @ManyToOne(cascade={CascadeType.REFRESH})
    @JoinColumn(name="ROLODEX_ID", referencedColumnName="ROLODEX_ID", insertable=false, updatable=false)
    private Rolodex rolodex;
    @Column(name="ADDRESS_LINE_1")
    private String addressLine1;
    @Column(name="ADDRESS_LINE_2")
    private String addressLine2;
    @Column(name="ADDRESS_LINE_3")
    private String addressLine3;
    @Column(name="CITY")
    private String city;
    @Column(name="COUNTY")
    private String county;
    @Column(name="STATE")
    private String state;
    @Column(name="POSTAL_CODE")
    private String postalCode;
    @Column(name="COUNTRY_CODE")
    private String countryCode;
    @OneToMany(mappedBy="proposalSite", orphanRemoval=true, cascade={CascadeType.ALL})
    @OrderBy(value="proposalSite")
    private List<CongressionalDistrict> congressionalDistricts = new ArrayList<CongressionalDistrict>();

    public void setLocationName(String locationName) {
        this.locationName = locationName;
    }

    public String getLocationName() {
        return this.locationName;
    }

    public void setLocationTypeCode(Integer locationTypeCode) {
        this.locationTypeCode = locationTypeCode;
    }

    public Integer getLocationTypeCode() {
        return this.locationTypeCode;
    }

    public void setOrganizationId(String organizationId) {
        Boolean organizationIdHasChanged = !Objects.equals(this.getOrganizationId(), organizationId);
        if (organizationIdHasChanged.booleanValue() || this.shouldDataBeAlwaysCopied().booleanValue()) {
            if (organizationIdHasChanged.booleanValue()) {
                this.getCongressionalDistricts().clear();
            }
            this.organizationId = organizationId;
            if (this.getOrganizationId() != null) {
                this.refreshReferenceObject(ORGANIZATION);
            }
            this.initializeOrganizationRelatedFields();
            if (organizationIdHasChanged.booleanValue()) {
                this.initializeDefaultCongressionalDistrict();
            }
        }
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public void setOrganization(Organization organization) {
        this.organization = organization;
    }

    private void initializeOrganizationRelatedFields() {
        this.setLocationName(this.getOrganization() == null ? null : this.getOrganization().getOrganizationName());
        this.setRolodexId(this.getOrganization() == null ? null : this.getOrganization().getContactAddressId());
    }

    public Organization getOrganization() {
        return this.organization;
    }

    public void setRolodexId(Integer rolodexId) {
        Boolean rolodexIdHasChanged = !Objects.equals(this.getRolodexId(), rolodexId);
        if (rolodexIdHasChanged.booleanValue() || this.shouldDataBeAlwaysCopied().booleanValue()) {
            this.rolodexId = rolodexId;
            if (this.getRolodexId() != null) {
                this.refreshReferenceObject(ROLODEX);
            }
            this.initializeRolodexRelatedFields();
        }
    }

    public Integer getRolodexId() {
        return this.rolodexId;
    }

    public void setRolodex(Rolodex rolodex) {
        this.rolodex = rolodex;
    }

    public Rolodex getRolodex() {
        return this.rolodex;
    }

    private void initializeRolodexRelatedFields() {
        if (this.getOrganizationId() == null) {
            this.setLocationName(this.getRolodex() == null ? null : this.getRolodex().getOrganization());
        }
        this.setAddressLine1(this.getRolodex() == null ? null : this.getRolodex().getAddressLine1());
        this.setAddressLine2(this.getRolodex() == null ? null : this.getRolodex().getAddressLine2());
        this.setAddressLine3(this.getRolodex() == null ? null : this.getRolodex().getAddressLine3());
        this.setCity(this.getRolodex() == null ? null : this.getRolodex().getCity());
        this.setCounty(this.getRolodex() == null ? null : this.getRolodex().getCounty());
        this.setState(this.getRolodex() == null ? null : this.getRolodex().getState());
        this.setPostalCode(this.getRolodex() == null ? null : this.getRolodex().getPostalCode());
        this.setCountryCode(this.getRolodex() == null ? null : this.getRolodex().getCountryCode());
    }

    public void setCongressionalDistricts(List<CongressionalDistrict> congressionalDistricts) {
        this.congressionalDistricts = congressionalDistricts;
    }

    public String getAddressLine1() {
        return this.addressLine1;
    }

    public void setAddressLine1(String addressLine1) {
        this.addressLine1 = addressLine1;
    }

    public String getAddressLine2() {
        return this.addressLine2;
    }

    public void setAddressLine2(String addressLine2) {
        this.addressLine2 = addressLine2;
    }

    public String getAddressLine3() {
        return this.addressLine3;
    }

    public void setAddressLine3(String addressLine3) {
        this.addressLine3 = addressLine3;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getCounty() {
        return this.county;
    }

    public void setCounty(String county) {
        this.county = county;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public List<CongressionalDistrict> getCongressionalDistricts() {
        return this.congressionalDistricts;
    }

    public void addCongressionalDistrict(CongressionalDistrict congressionalDistrict) {
        this.congressionalDistricts.add(congressionalDistrict);
    }

    public void deleteCongressionalDistrict(int districtIndex) {
        this.congressionalDistricts.remove(districtIndex);
    }

    public void setDefaultCongressionalDistrict(CongressionalDistrict congressionalDistrict) {
        if (!this.contains(congressionalDistrict.getCongressionalDistrict())) {
            this.congressionalDistricts.add(0, congressionalDistrict);
        }
    }

    private boolean contains(String congressionalDistrictIdentifier) {
        for (CongressionalDistrict district : this.congressionalDistricts) {
            if (!StringUtils.equals((CharSequence)district.getCongressionalDistrict(), (CharSequence)congressionalDistrictIdentifier)) continue;
            return true;
        }
        return false;
    }

    public CongressionalDistrict getDefaultCongressionalDistrict() {
        if (this.congressionalDistricts == null || this.congressionalDistricts.isEmpty()) {
            return null;
        }
        return this.congressionalDistricts.get(0);
    }

    public String getFirstCongressionalDistrictName() {
        CongressionalDistrict firstDistrict = this.getDefaultCongressionalDistrict();
        if (firstDistrict == null) {
            return "";
        }
        return firstDistrict.getCongressionalDistrict();
    }

    public void setDefaultCongressionalDistrictIdentifier(String districtIdentifier) {
        if (!StringUtils.isEmpty((CharSequence)districtIdentifier) && !this.contains(districtIdentifier)) {
            this.getCongressionalDistricts().clear();
            CongressionalDistrict defaultDistrict = new CongressionalDistrict();
            defaultDistrict.setCongressionalDistrict(districtIdentifier);
            defaultDistrict.setProposalSite(this);
            this.setDefaultCongressionalDistrict(defaultDistrict);
        }
    }

    public void initializeDefaultCongressionalDistrict() {
        Organization organization = this.getOrganization();
        if (organization != null) {
            String defaultDistrict = organization.getCongressionalDistrict();
            if (!StringUtils.isEmpty((CharSequence)defaultDistrict)) {
                this.setDefaultCongressionalDistrictIdentifier(defaultDistrict);
            } else {
                this.getCongressionalDistricts().clear();
            }
        }
    }

    public DevelopmentProposal getDevelopmentProposal() {
        return this.developmentProposal;
    }

    public void setDevelopmentProposal(DevelopmentProposal developmentProposal) {
        this.developmentProposal = developmentProposal;
    }

    public Integer getSiteNumber() {
        return this.siteNumber;
    }

    public void setSiteNumber(Integer siteNumber) {
        this.siteNumber = siteNumber;
    }

    public String getProposalNumber() {
        if (this.getDevelopmentProposal() != null) {
            return this.getDevelopmentProposal().getProposalNumber();
        }
        return null;
    }

    public Boolean shouldDataBeAlwaysCopied() {
        String proposalStateTypeCode = this.getDevelopmentProposal().getProposalStateTypeCode();
        return proposalStateTypeCode.equals("1") || proposalStateTypeCode.equals("12");
    }

    @Embeddable
    public static final class ProposalSiteId
    implements Serializable,
    Comparable<ProposalSiteId> {
        private String developmentProposal;
        private Integer siteNumber;

        public Integer getSiteNumber() {
            return this.siteNumber;
        }

        public void setSiteNumber(Integer siteNumber) {
            this.siteNumber = siteNumber;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("developmentProposal", (Object)this.developmentProposal).append("siteNumber", (Object)this.siteNumber).toString();
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (other.getClass() != this.getClass()) {
                return false;
            }
            ProposalSiteId rhs = (ProposalSiteId)other;
            return new EqualsBuilder().append((Object)this.developmentProposal, (Object)rhs.developmentProposal).append((Object)this.siteNumber, (Object)rhs.siteNumber).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.developmentProposal).append((Object)this.siteNumber).toHashCode();
        }

        @Override
        public int compareTo(ProposalSiteId other) {
            return new CompareToBuilder().append((Object)this.developmentProposal, (Object)other.developmentProposal).append((Object)this.siteNumber, (Object)other.siteNumber).toComparison();
        }

        public String getDevelopmentProposal() {
            return this.developmentProposal;
        }

        public void setDevelopmentProposal(String developmentProposal) {
            this.developmentProposal = developmentProposal;
        }
    }
}

