/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.internal.SearchContext;

public abstract class ValuesSourceAggregatorFactory
extends AggregatorFactory {
    protected ValuesSourceConfig config;

    public ValuesSourceAggregatorFactory(String name, ValuesSourceConfig config, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, queryShardContext, parent, subFactoriesBuilder, metadata);
        this.config = config;
    }

    @Override
    public Aggregator createInternal(SearchContext searchContext, Aggregator parent, boolean collectsFromSingleBucket, Map<String, Object> metadata) throws IOException {
        ValuesSource vs = this.config.toValuesSource();
        if (vs == null) {
            return this.createUnmapped(searchContext, parent, metadata);
        }
        return this.doCreateInternal(vs, searchContext, parent, collectsFromSingleBucket, metadata);
    }

    protected abstract Aggregator createUnmapped(SearchContext var1, Aggregator var2, Map<String, Object> var3) throws IOException;

    protected abstract Aggregator doCreateInternal(ValuesSource var1, SearchContext var2, Aggregator var3, boolean var4, Map<String, Object> var5) throws IOException;

    @Override
    public String getStatsSubtype() {
        return this.config.valueSourceType().typeName();
    }
}

