/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.coreservice.impl.style;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.impex.ExportDataSet;
import org.kuali.rice.coreservice.impl.style.StyleBo;
import org.kuali.rice.coreservice.impl.style.StyleExportDataSet;
import org.kuali.rice.krad.bo.Exporter;
import org.kuali.rice.krad.exception.ExportNotSupportedException;

public class StyleDataExporter
implements Exporter {
    private List<String> supportedFormats = new ArrayList<String>();

    public StyleDataExporter() {
        this.supportedFormats.add("xml");
    }

    public void export(Class<?> dataObjectClass, List<? extends Object> dataObjects, String exportFormat, OutputStream outputStream) throws IOException {
        if (!"xml".equals(exportFormat)) {
            throw new ExportNotSupportedException("The given export format of " + exportFormat + " is not supported by the KEW XML Exporter!");
        }
        ExportDataSet dataSet = this.buildExportDataSet(dataObjectClass, dataObjects);
        outputStream.write(CoreApiServiceLocator.getXmlExporterService().export(dataSet));
        outputStream.flush();
    }

    public List<String> getSupportedFormats(Class<?> dataObjectClass) {
        return this.supportedFormats;
    }

    protected ExportDataSet buildExportDataSet(Class<?> dataObjectClass, List<? extends Object> dataObjects) {
        StyleExportDataSet dataSet = new StyleExportDataSet();
        for (Object object : dataObjects) {
            if (!dataObjectClass.equals(StyleBo.class)) continue;
            dataSet.getStyles().add((StyleBo)((Object)object));
        }
        return dataSet.createExportDataSet();
    }
}

