/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.api.common.delegate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.kuali.rice.core.api.delegation.DelegationType;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.core.api.mo.ModelObjectComplete;
import org.kuali.rice.kim.api.common.delegate.DelegateMember;
import org.kuali.rice.kim.api.common.delegate.DelegateMemberContract;
import org.kuali.rice.kim.api.common.delegate.DelegateTypeContract;
import org.w3c.dom.Element;

@XmlRootElement(name="delegateType")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="DelegateTypeType", propOrder={"roleId", "delegationId", "delegationTypeCode", "kimTypeId", "members", "active", "_futureElements"})
public final class DelegateType
extends AbstractDataTransferObject
implements DelegateTypeContract {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="roleId")
    private final String roleId;
    @XmlElement(name="delegationId", required=false)
    private final String delegationId;
    @XmlElement(name="delegationTypeCode")
    private final String delegationTypeCode;
    @XmlElement(name="kimTypeId")
    private final String kimTypeId;
    @XmlElementWrapper(name="members", required=false)
    @XmlElement(name="member")
    private final List<DelegateMember> members;
    @XmlElement(name="active")
    private final boolean active;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private DelegateType() {
        this.roleId = null;
        this.delegationId = null;
        this.delegationTypeCode = null;
        this.kimTypeId = null;
        this.members = null;
        this.active = false;
    }

    private DelegateType(Builder b) {
        this.roleId = b.getRoleId();
        this.delegationId = b.getDelegationId();
        this.delegationTypeCode = b.getDelegationType() != null ? b.getDelegationType().getCode() : null;
        this.kimTypeId = b.getKimTypeId();
        this.active = b.isActive();
        ArrayList<DelegateMember> delegateMembers = new ArrayList<DelegateMember>();
        if (!CollectionUtils.isEmpty(b.getMembers())) {
            for (DelegateMember.Builder delgateBuilder : b.getMembers()) {
                delegateMembers.add(delgateBuilder.build());
            }
        }
        this.members = delegateMembers;
    }

    @Override
    public String getKimTypeId() {
        return this.kimTypeId;
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public DelegationType getDelegationType() {
        return DelegationType.fromCode((String)this.delegationTypeCode);
    }

    @Override
    public String getDelegationId() {
        return this.delegationId;
    }

    @Override
    public String getRoleId() {
        return this.roleId;
    }

    public List<DelegateMember> getMembers() {
        return Collections.unmodifiableList(this.members);
    }

    public static class Cache {
        public static final String NAME = "http://rice.kuali.org/kim/v2_0/DelegateTypeType";
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "delegateType";
        static final String TYPE_NAME = "DelegateTypeType";

        Constants() {
        }
    }

    static class Elements {
        static final String ROLE_ID = "roleId";
        static final String DELEGATION_ID = "delegationId";
        static final String DELEGATION_TYPE_CODE = "delegationTypeCode";
        static final String KIM_TYPE_ID = "kimTypeId";
        static final String MEMBERS = "members";
        static final String MEMBER = "member";
        static final String ACTIVE = "active";

        Elements() {
        }
    }

    public static final class Builder
    implements DelegateTypeContract,
    ModelBuilder,
    ModelObjectComplete {
        private String roleId;
        private String delegationId;
        private DelegationType delegationType;
        private String kimTypeId;
        private List<DelegateMember.Builder> members;
        private boolean active;

        public static Builder create(DelegateTypeContract dtc) {
            Builder b = new Builder();
            b.setRoleId(dtc.getRoleId());
            b.setDelegationId(dtc.getDelegationId());
            b.setDelegationType(dtc.getDelegationType());
            b.setActive(dtc.isActive());
            b.setKimTypeId(dtc.getKimTypeId());
            ArrayList<DelegateMember.Builder> delegateBuilders = new ArrayList<DelegateMember.Builder>();
            for (DelegateMemberContract delegateMemberContract : dtc.getMembers()) {
                delegateBuilders.add(DelegateMember.Builder.create(delegateMemberContract));
            }
            b.setMembers(delegateBuilders);
            return b;
        }

        public static Builder create(String roleId, DelegationType delegationType, List<DelegateMember.Builder> members) {
            Builder b = new Builder();
            b.setRoleId(roleId);
            b.setDelegationType(delegationType);
            b.setMembers(members);
            b.setActive(true);
            return b;
        }

        public DelegateType build() {
            return new DelegateType(this);
        }

        @Override
        public String getRoleId() {
            return this.roleId;
        }

        public void setRoleId(String roleId) {
            if (StringUtils.isBlank((String)roleId)) {
                throw new IllegalArgumentException("roleId cannot be null or blank");
            }
            this.roleId = roleId;
        }

        @Override
        public String getDelegationId() {
            return this.delegationId;
        }

        public void setDelegationId(String delegationId) {
            this.delegationId = delegationId;
        }

        @Override
        public DelegationType getDelegationType() {
            return this.delegationType;
        }

        public void setDelegationType(DelegationType delegationType) {
            if (delegationType == null) {
                throw new IllegalArgumentException("delegationTypeCode cannot be null");
            }
            this.delegationType = delegationType;
        }

        @Override
        public String getKimTypeId() {
            return this.kimTypeId;
        }

        public void setKimTypeId(String kimTypeId) {
            this.kimTypeId = kimTypeId;
        }

        public List<DelegateMember.Builder> getMembers() {
            return this.members;
        }

        public void setMembers(List<DelegateMember.Builder> members) {
            this.members = members;
        }

        public boolean isActive() {
            return this.active;
        }

        public void setActive(Boolean active) {
            this.active = active;
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this);
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)obj, (Object)this);
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }
    }
}

