/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.api.model;

import java.math.BigDecimal;
import java.math.RoundingMode;

public abstract class AbstractDecimal<T extends AbstractDecimal>
extends Number
implements Comparable<T> {
    public static final RoundingMode ROUND_BEHAVIOR = RoundingMode.HALF_UP;
    protected final BigDecimal value;

    protected AbstractDecimal() {
        this.value = null;
    }

    protected AbstractDecimal(String value, int scale) {
        this.value = value == null || value.trim().equals("") ? BigDecimal.ZERO.setScale(scale, ROUND_BEHAVIOR) : new BigDecimal(value).setScale(scale, ROUND_BEHAVIOR);
    }

    protected AbstractDecimal(int value, int scale) {
        this.value = BigDecimal.valueOf(value).setScale(scale, ROUND_BEHAVIOR);
    }

    protected AbstractDecimal(double value, int scale) {
        this.value = BigDecimal.valueOf(value).setScale(scale, ROUND_BEHAVIOR);
    }

    protected AbstractDecimal(BigDecimal value, int scale) {
        this.value = value.setScale(scale, ROUND_BEHAVIOR);
    }

    public boolean isLessThan(T operand) {
        if (operand == null) {
            throw new IllegalArgumentException("invalid (null) operand");
        }
        return this.compareTo(operand) == -1;
    }

    public boolean isGreaterThan(T operand) {
        if (operand == null) {
            throw new IllegalArgumentException("invalid (null) operand");
        }
        return this.compareTo(operand) == 1;
    }

    public boolean isLessEqual(T operand) {
        if (operand == null) {
            throw new IllegalArgumentException("invalid (null) operand");
        }
        return !this.isGreaterThan(operand);
    }

    public boolean isGreaterEqual(T operand) {
        if (operand == null) {
            throw new IllegalArgumentException("invalid (null) operand");
        }
        return !this.isLessThan(operand);
    }

    public static boolean isNumeric(String s) {
        boolean isValid = false;
        if (s != null && !s.trim().equals("")) {
            try {
                new BigDecimal(s);
                isValid = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return isValid;
    }

    @Override
    public double doubleValue() {
        return this.value.doubleValue();
    }

    @Override
    public float floatValue() {
        return this.value.floatValue();
    }

    @Override
    public int intValue() {
        return this.value.intValue();
    }

    @Override
    public long longValue() {
        return this.value.longValue();
    }

    public BigDecimal bigDecimalValue() {
        return this.value;
    }

    @Override
    public int compareTo(T k) {
        return this.value.compareTo(((AbstractDecimal)k).value);
    }

    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj instanceof AbstractDecimal) {
            AbstractDecimal k = (AbstractDecimal)obj;
            equals = this.compareTo((T)k) == 0;
        }
        return equals;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.value.toString();
    }

    public boolean isNegative() {
        return this.compareTo(this.zero()) == -1;
    }

    public boolean isPositive() {
        return this.compareTo(this.zero()) == 1;
    }

    public boolean isZero() {
        return this.compareTo(this.zero()) == 0;
    }

    public T abs() {
        T absolute = this.isNegative() ? this.negated() : this.newInstance(this.value, this.value.scale());
        return absolute;
    }

    public boolean isNonZero() {
        return !this.isZero();
    }

    public T add(T addend) {
        if (addend == null) {
            throw new IllegalArgumentException("invalid (null) addend");
        }
        BigDecimal sum = this.value.add(((AbstractDecimal)addend).value);
        return this.newInstance(sum, sum.scale());
    }

    public T subtract(T subtrahend) {
        if (subtrahend == null) {
            throw new IllegalArgumentException("invalid (null) subtrahend");
        }
        BigDecimal difference = this.value.subtract(((AbstractDecimal)subtrahend).value);
        return this.newInstance(difference, difference.scale());
    }

    public T multiply(T multiplier) {
        if (multiplier == null) {
            throw new IllegalArgumentException("invalid (null) multiplier");
        }
        BigDecimal product = this.value.multiply(((AbstractDecimal)multiplier).value);
        return this.newInstance(product, this.value.scale());
    }

    public T mod(T modulus) {
        if (modulus == null) {
            throw new IllegalArgumentException("invalid (null) modulus");
        }
        double difference = this.value.doubleValue() % ((AbstractDecimal)modulus).doubleValue();
        return this.newInstance(BigDecimal.valueOf(difference), this.value.scale());
    }

    public T divide(T divisor) {
        if (divisor == null) {
            throw new IllegalArgumentException("invalid (null) divisor");
        }
        BigDecimal quotient = this.value.divide(((AbstractDecimal)divisor).value, ROUND_BEHAVIOR);
        return this.newInstance(quotient, this.value.scale());
    }

    public T negated() {
        return this.multiply(this.newInstance(-1));
    }

    public T percentage(T rate) {
        return ((AbstractDecimal)this.multiply(rate)).divide(this.oneHundred());
    }

    protected abstract T newInstance(int var1);

    protected abstract T newInstance(BigDecimal var1, int var2);

    protected abstract T zero();

    protected abstract T oneHundred();
}

