/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.offheapstore.disk.storage;

import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.offheapstore.disk.paging.MappedPageSource;
import org.terracotta.offheapstore.disk.persistent.Persistent;
import org.terracotta.offheapstore.disk.persistent.PersistentStorageEngine;
import org.terracotta.offheapstore.disk.storage.AATreeFileAllocator;
import org.terracotta.offheapstore.storage.PortabilityBasedStorageEngine;
import org.terracotta.offheapstore.storage.StorageEngine;
import org.terracotta.offheapstore.storage.portability.Portability;
import org.terracotta.offheapstore.storage.portability.WriteContext;
import org.terracotta.offheapstore.util.Factory;
import org.terracotta.offheapstore.util.MemoryUnit;

public class FileBackedStorageEngine<K, V>
extends PortabilityBasedStorageEngine<K, V>
implements PersistentStorageEngine<K, V> {
    private static final int MAGIC = 1095582789;
    private static final int MAGIC_CHUNK = 1313753427;
    private static final Logger LOGGER = LoggerFactory.getLogger(FileBackedStorageEngine.class);
    private static final int KEY_HASH_OFFSET = 0;
    private static final int KEY_LENGTH_OFFSET = 4;
    private static final int VALUE_LENGTH_OFFSET = 8;
    private static final int KEY_DATA_OFFSET = 12;
    private final ConcurrentHashMap<Long, FileWriteTask> pendingWrites = new ConcurrentHashMap();
    private final ExecutorService writeExecutor;
    private final MappedPageSource source;
    private final FileChannel writeChannel;
    private final AtomicReference<FileChannel> readChannelReference;
    private final TreeMap<Long, FileChunk> chunks = new TreeMap();
    private final long maxChunkSize;
    private volatile StorageEngine.Owner owner;

    public static <K, V> Factory<FileBackedStorageEngine<K, V>> createFactory(MappedPageSource source, long maxChunkSize, MemoryUnit maxChunkUnit, Portability<? super K> keyPortability, Portability<? super V> valuePortability) {
        return FileBackedStorageEngine.createFactory(source, maxChunkSize, maxChunkUnit, keyPortability, valuePortability, true);
    }

    public static <K, V> Factory<FileBackedStorageEngine<K, V>> createFactory(MappedPageSource source, long maxChunkSize, MemoryUnit maxChunkUnit, Portability<? super K> keyPortability, Portability<? super V> valuePortability, boolean bootstrap) {
        Factory<ExecutorService> executorFactory = () -> new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        return FileBackedStorageEngine.createFactory(source, maxChunkSize, maxChunkUnit, keyPortability, valuePortability, executorFactory, bootstrap);
    }

    public static <K, V> Factory<FileBackedStorageEngine<K, V>> createFactory(MappedPageSource source, long maxChunkSize, MemoryUnit maxChunkUnit, Portability<? super K> keyPortability, Portability<? super V> valuePortability, Factory<ExecutorService> executorFactory, boolean bootstrap) {
        return () -> new FileBackedStorageEngine(source, maxChunkSize, maxChunkUnit, keyPortability, valuePortability, (ExecutorService)executorFactory.newInstance(), bootstrap);
    }

    public FileBackedStorageEngine(MappedPageSource source, long maxChunkSize, MemoryUnit maxChunkUnit, Portability<? super K> keyPortability, Portability<? super V> valuePortability) {
        this(source, maxChunkSize, maxChunkUnit, keyPortability, valuePortability, true);
    }

    public FileBackedStorageEngine(MappedPageSource source, long maxChunkSize, MemoryUnit maxChunkUnit, Portability<? super K> keyPortability, Portability<? super V> valuePortability, ExecutorService writer) {
        this(source, maxChunkSize, maxChunkUnit, keyPortability, valuePortability, writer, true);
    }

    public FileBackedStorageEngine(MappedPageSource source, long maxChunkSize, MemoryUnit maxChunkUnit, Portability<? super K> keyPortability, Portability<? super V> valuePortability, boolean bootstrap) {
        this(source, maxChunkSize, maxChunkUnit, keyPortability, valuePortability, new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>()), bootstrap);
    }

    public FileBackedStorageEngine(MappedPageSource source, long maxChunkSize, MemoryUnit maxChunkUnit, Portability<? super K> keyPortability, Portability<? super V> valuePortability, ExecutorService writer, boolean bootstrap) {
        super(keyPortability, valuePortability);
        this.writeExecutor = writer;
        this.writeChannel = source.getWritableChannel();
        this.readChannelReference = new AtomicReference<FileChannel>(source.getReadableChannel());
        this.source = source;
        this.maxChunkSize = Long.highestOneBit(maxChunkUnit.toBytes(maxChunkSize));
    }

    @Override
    protected void clearInternal() {
        Iterator<Map.Entry<Long, FileChunk>> it = this.chunks.entrySet().iterator();
        while (it.hasNext()) {
            it.next().getValue().clear();
            it.remove();
        }
        if (!this.chunks.isEmpty()) {
            throw new AssertionError((Object)"Concurrent modification while clearing!");
        }
    }

    @Override
    public void destroy() {
        try {
            this.close();
        }
        catch (IOException e) {
            LOGGER.warn("Exception while trying to close file backed storage engine", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Future<Void> flush = this.writeExecutor.submit(() -> {
            this.writeChannel.force(true);
            return null;
        });
        boolean interrupted = Thread.interrupted();
        try {
            while (true) {
                try {
                    flush.get();
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                    continue;
                }
                catch (ExecutionException ex) {
                    Throwable cause = ex.getCause();
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    if (cause instanceof IOException) {
                        throw (IOException)cause;
                    }
                    throw new RuntimeException(cause);
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.writeExecutor.shutdownNow();
            if (this.writeExecutor.awaitTermination(60L, TimeUnit.SECONDS)) {
                LOGGER.debug("FileBackedStorageEngine for " + this.source.getFile().getName() + " terminated successfully");
            } else {
                LOGGER.warn("FileBackedStorageEngine for " + this.source.getFile().getName() + " timed-out during termination");
            }
        }
        catch (InterruptedException e) {
            LOGGER.warn("FileBackedStorageEngine for " + this.source.getFile().getName() + " interrupted during termination");
            Thread.currentThread().interrupt();
        }
        finally {
            try {
                this.writeChannel.close();
            }
            finally {
                ((FileChannel)this.readChannelReference.getAndSet(null)).close();
            }
        }
    }

    @Override
    public void persist(ObjectOutput output) throws IOException {
        output.writeInt(1095582789);
        ((Persistent)((Object)this.keyPortability)).persist(output);
        ((Persistent)((Object)this.valuePortability)).persist(output);
        output.writeInt(this.chunks.size());
        for (FileChunk c : this.chunks.values()) {
            c.persist(output);
        }
    }

    @Override
    public void bootstrap(ObjectInput input) throws IOException {
        if (!this.chunks.isEmpty()) {
            throw new IllegalStateException();
        }
        if (input.readInt() != 1095582789) {
            throw new IOException("Wrong magic number");
        }
        ((Persistent)((Object)this.keyPortability)).bootstrap(input);
        ((Persistent)((Object)this.valuePortability)).bootstrap(input);
        int n = input.readInt();
        for (int i = 0; i < n; ++i) {
            FileChunk chunk = new FileChunk(input);
            this.chunks.put(chunk.baseAddress(), chunk);
        }
        if (this.hasRecoveryListeners()) {
            for (Long encoding : this.owner.encodingSet()) {
                ByteBuffer binaryKey = this.readBinaryKey(encoding);
                ByteBuffer binaryValue = this.readBinaryValue(encoding);
                int hash = this.readKeyHash(encoding);
                ByteBuffer binaryKeyForDecode = binaryKey.duplicate();
                ByteBuffer binaryValueForDecode = binaryValue.duplicate();
                Thread caller = Thread.currentThread();
                this.fireRecovered(() -> {
                    if (caller == Thread.currentThread()) {
                        Object result = this.keyPortability.decode(binaryKeyForDecode.duplicate());
                        return result;
                    }
                    throw new IllegalStateException();
                }, () -> {
                    if (caller == Thread.currentThread()) {
                        Object result = this.valuePortability.decode(binaryValueForDecode.duplicate());
                        return result;
                    }
                    throw new IllegalStateException();
                }, binaryKey, binaryValue, hash, 0, encoding);
            }
        }
    }

    @Override
    protected void free(long address) {
        FileChunk chunk = this.findChunk(address);
        chunk.free(address - chunk.baseAddress());
    }

    @Override
    protected ByteBuffer readKeyBuffer(long address) {
        FileChunk chunk = this.findChunk(address);
        return chunk.readKeyBuffer(address - chunk.baseAddress());
    }

    @Override
    protected WriteContext getKeyWriteContext(long address) {
        FileChunk chunk = this.findChunk(address);
        return chunk.getKeyWriteContext(address - chunk.baseAddress());
    }

    @Override
    protected ByteBuffer readValueBuffer(long address) {
        FileChunk chunk = this.findChunk(address);
        return chunk.readValueBuffer(address - chunk.baseAddress());
    }

    @Override
    protected WriteContext getValueWriteContext(long address) {
        FileChunk chunk = this.findChunk(address);
        return chunk.getValueWriteContext(address - chunk.baseAddress());
    }

    @Override
    protected Long writeMappingBuffers(ByteBuffer keyBuffer, ByteBuffer valueBuffer, int hash) {
        FileChunk c;
        Long address;
        for (FileChunk c2 : this.chunks.values()) {
            Long address2 = c2.writeMappingBuffers(keyBuffer, valueBuffer, hash);
            if (address2 == null) continue;
            return address2 + c2.baseAddress();
        }
        do {
            long nextChunkBaseAddress;
            long nextChunkSize;
            long requiredSize;
            if (Long.bitCount(requiredSize = (long)(keyBuffer.remaining() + valueBuffer.remaining() + 12)) != 1) {
                requiredSize = Long.highestOneBit(requiredSize) << 1;
            }
            if (this.chunks.isEmpty()) {
                nextChunkSize = requiredSize;
                nextChunkBaseAddress = 0L;
            } else {
                FileChunk last = this.chunks.lastEntry().getValue();
                nextChunkSize = Math.max(Math.min(last.capacity() << 1, this.maxChunkSize), requiredSize);
                nextChunkBaseAddress = last.baseAddress() + last.capacity();
                if (nextChunkSize < 0L) {
                    return null;
                }
            }
            try {
                c = new FileChunk(nextChunkSize, nextChunkBaseAddress);
            }
            catch (OutOfMemoryError e) {
                return null;
            }
            this.chunks.put(c.baseAddress(), c);
        } while ((address = c.writeMappingBuffers(keyBuffer, valueBuffer, hash)) == null);
        return address + c.baseAddress();
    }

    @Override
    public long getAllocatedMemory() {
        long sum = 0L;
        for (FileChunk c : this.chunks.values()) {
            sum += c.capacity();
        }
        return sum;
    }

    @Override
    public long getOccupiedMemory() {
        long sum = 0L;
        for (FileChunk c : this.chunks.values()) {
            sum += c.occupied();
        }
        return sum;
    }

    @Override
    public long getVitalMemory() {
        return this.getAllocatedMemory();
    }

    @Override
    public long getDataSize() {
        long sum = 0L;
        for (FileChunk c : this.chunks.values()) {
            sum += c.occupied();
        }
        return sum;
    }

    private FileChunk findChunk(long address) {
        return this.chunks.floorEntry(address).getValue();
    }

    private int readIntFromChannel(long position) throws IOException {
        ByteBuffer lengthBuffer = ByteBuffer.allocate(4);
        int i = 0;
        while (lengthBuffer.hasRemaining()) {
            int read = this.readFromChannel(lengthBuffer, position + (long)i);
            if (read < 0) {
                throw new EOFException();
            }
            i += read;
        }
        return ((ByteBuffer)lengthBuffer.flip()).getInt();
    }

    private void writeIntToChannel(long position, int data) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putInt(data).flip();
        this.writeBufferToChannel(position, buffer);
    }

    private void writeLongToChannel(long position, long data) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(data).flip();
        this.writeBufferToChannel(position, buffer);
    }

    private void writeBufferToChannel(long position, ByteBuffer buffer) throws IOException {
        int i = 0;
        while (buffer.hasRemaining()) {
            int written = this.writeChannel.write(buffer, position + (long)i);
            if (written < 0) {
                throw new EOFException();
            }
            i += written;
        }
    }

    private int readFromChannel(ByteBuffer buffer, long position) throws IOException {
        boolean interrupted = Thread.interrupted();
        while (true) {
            FileChannel current = this.getReadableChannel();
            try {
                int n = this.readFromChannel(current, buffer, position);
                return n;
            }
            catch (ClosedChannelException e) {
                interrupted |= Thread.interrupted();
                FileChannel newChannel = this.source.getReadableChannel();
                if (!this.readChannelReference.compareAndSet(current, newChannel)) {
                    newChannel.close();
                    continue;
                }
                LOGGER.info("Creating new read-channel for " + this.source.getFile().getName() + " as previous one was closed (likely due to interrupt)");
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private FileChannel getReadableChannel() throws IOException {
        FileChannel current = this.readChannelReference.get();
        if (current == null) {
            throw new IOException("Storage engine is closed");
        }
        return current;
    }

    private int readFromChannel(FileChannel channel, ByteBuffer buffer, long position) throws IOException {
        int ret = channel.read(buffer, position);
        if (ret < 0) {
            ret = channel.read(buffer, position);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shrink() {
        Lock ownerLock = this.owner.writeLock();
        ownerLock.lock();
        try {
            if (this.chunks.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            FileChunk candidate = this.chunks.lastEntry().getValue();
            for (FileChunk c : this.chunks.descendingMap().values()) {
                c.evictAll();
                this.compress(c);
                this.compress(candidate);
                if (candidate.occupied() != 0L) continue;
                this.chunks.remove(candidate.baseAddress()).clear();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            ownerLock.unlock();
        }
    }

    private void compress(FileChunk from) {
        block0: for (Long encoding : from.encodings()) {
            ByteBuffer keyBuffer = this.readKeyBuffer(encoding);
            int keyHash = this.readKeyHash(encoding);
            ByteBuffer valueBuffer = this.readValueBuffer(encoding);
            for (FileChunk to : this.chunks.headMap(from.baseAddress(), true).values()) {
                Long address = to.writeMappingBuffers(keyBuffer, valueBuffer, keyHash);
                if (address == null) continue;
                long compressed = address + to.baseAddress();
                if (compressed < encoding && this.owner.updateEncoding(keyHash, encoding, compressed, -1L)) {
                    this.free(encoding);
                    continue block0;
                }
                this.free(compressed);
                continue block0;
            }
        }
    }

    @Override
    public void bind(StorageEngine.Owner m) {
        if (this.owner != null) {
            throw new AssertionError();
        }
        this.owner = m;
    }

    @Override
    public int readKeyHash(long address) {
        FileChunk chunk = this.findChunk(address);
        return chunk.readPojoHash(address - chunk.baseAddress());
    }

    class FileWriteTask
    implements Runnable {
        private final FileChunk chunk;
        private final ByteBuffer keyBuffer;
        private final ByteBuffer valueBuffer;
        private final int pojoHash;
        private final long position;

        FileWriteTask(FileChunk chunk, long position, ByteBuffer keyBuffer, ByteBuffer valueBuffer, int pojoHash) {
            this.chunk = chunk;
            this.position = position;
            this.keyBuffer = keyBuffer;
            this.valueBuffer = valueBuffer;
            this.pojoHash = pojoHash;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (FileBackedStorageEngine.this.pendingWrites.get(this.position) == this) {
                try {
                    FileChunk fileChunk = this.chunk;
                    synchronized (fileChunk) {
                        if (this.chunk.isValid()) {
                            try {
                                try {
                                    this.write();
                                }
                                catch (IOException e) {
                                    LOGGER.warn("Received IOException '{}' while trying to write @ {} : trying again", (Object)e.getMessage(), (Object)this.position);
                                    this.write();
                                }
                            }
                            catch (ClosedChannelException e) {
                                LOGGER.debug("DiskWriteTask terminated due to closed channel - we must be shutting down", (Throwable)e);
                            }
                            catch (IOException e) {
                                LOGGER.warn("Received IOException '{}' during write @ {} : giving up", (Object)e.getMessage(), (Object)this.position);
                            }
                            catch (OutOfMemoryError e) {
                                LOGGER.error("Failed to allocate a direct buffer for a FileChannel write.  Consider increasing the -XX:MaxDirectMemorySize property to allow enough space for the FileChannel transfer buffers");
                                throw e;
                            }
                        }
                    }
                }
                finally {
                    FileBackedStorageEngine.this.pendingWrites.remove(this.position, this);
                }
            }
        }

        private void write() throws IOException {
            ByteBuffer key = this.getKeyBuffer();
            ByteBuffer value = this.getValueBuffer();
            int keyLength = key.remaining();
            int valueLength = value.remaining();
            FileBackedStorageEngine.this.writeIntToChannel(this.position + 0L, this.pojoHash);
            FileBackedStorageEngine.this.writeIntToChannel(this.position + 4L, keyLength);
            FileBackedStorageEngine.this.writeIntToChannel(this.position + 8L, valueLength);
            FileBackedStorageEngine.this.writeBufferToChannel(this.position + 12L, key);
            FileBackedStorageEngine.this.writeBufferToChannel(this.position + 12L + (long)keyLength, value);
            long size = FileBackedStorageEngine.this.writeChannel.size();
            long expected = this.position + (long)keyLength + (long)valueLength + 12L;
            if (size < expected) {
                throw new IOException("File size does not encompass last write [size:" + size + " end-of-write:" + expected);
            }
        }

        ByteBuffer getKeyBuffer() {
            return this.keyBuffer.duplicate();
        }

        ByteBuffer getValueBuffer() {
            return this.valueBuffer.duplicate();
        }
    }

    class FileChunk {
        private final AATreeFileAllocator allocator;
        private final long filePosition;
        private final long baseAddress;
        private boolean valid = true;

        FileChunk(long size, long baseAddress) {
            Long newOffset = FileBackedStorageEngine.this.source.allocateRegion(size);
            if (newOffset == null) {
                throw new OutOfMemoryError("Storage engine file data area allocation failed:\nAllocator: " + FileBackedStorageEngine.this.source);
            }
            this.filePosition = newOffset;
            this.allocator = new AATreeFileAllocator(size);
            this.baseAddress = baseAddress;
        }

        FileChunk(ObjectInput input) throws IOException {
            if (input.readInt() != 1313753427) {
                throw new IOException("Wrong magic number");
            }
            this.filePosition = input.readLong();
            this.baseAddress = input.readLong();
            long size = input.readLong();
            FileBackedStorageEngine.this.source.claimRegion(this.filePosition, size);
            this.allocator = new AATreeFileAllocator(size, input);
        }

        ByteBuffer readKeyBuffer(long address) {
            try {
                long position = this.filePosition + address;
                FileWriteTask pending = (FileWriteTask)FileBackedStorageEngine.this.pendingWrites.get(position);
                if (pending == null) {
                    int keyLength = FileBackedStorageEngine.this.readIntFromChannel(position + 4L);
                    return this.readBuffer(position + 12L, keyLength);
                }
                return pending.getKeyBuffer();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (OutOfMemoryError e) {
                LOGGER.error("Failed to allocate direct buffer for FileChannel read.  Consider increasing the -XX:MaxDirectMemorySize property to allow enough space for the FileChannel transfer buffers");
                throw e;
            }
        }

        protected int readPojoHash(long address) {
            try {
                long position = this.filePosition + address;
                FileWriteTask pending = (FileWriteTask)FileBackedStorageEngine.this.pendingWrites.get(position);
                if (pending == null) {
                    return FileBackedStorageEngine.this.readIntFromChannel(position + 0L);
                }
                return pending.pojoHash;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (OutOfMemoryError e) {
                LOGGER.error("Failed to allocate direct buffer for FileChannel read.  Consider increasing the -XX:MaxDirectMemorySize property to allow enough space for the FileChannel transfer buffers");
                throw e;
            }
        }

        ByteBuffer readValueBuffer(long address) {
            try {
                long position = this.filePosition + address;
                FileWriteTask pending = (FileWriteTask)FileBackedStorageEngine.this.pendingWrites.get(position);
                if (pending == null) {
                    int keyLength = FileBackedStorageEngine.this.readIntFromChannel(position + 4L);
                    int valueLength = FileBackedStorageEngine.this.readIntFromChannel(position + 8L);
                    return this.readBuffer(position + (long)keyLength + 12L, valueLength);
                }
                return pending.getValueBuffer();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (OutOfMemoryError e) {
                LOGGER.error("Failed to allocate direct buffer for FileChannel read.  Consider increasing the -XX:MaxDirectMemorySize property to allow enough space for the FileChannel transfer buffers");
                throw e;
            }
        }

        ByteBuffer readBuffer(long position, int length) {
            try {
                ByteBuffer data = ByteBuffer.allocate(length);
                int i = 0;
                while (data.hasRemaining()) {
                    int read = FileBackedStorageEngine.this.readFromChannel(data, position + (long)i);
                    if (read < 0) {
                        throw new EOFException();
                    }
                    i += read;
                }
                return (ByteBuffer)data.rewind();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (OutOfMemoryError e) {
                LOGGER.error("Failed to allocate direct buffer for FileChannel read.  Consider increasing the -XX:MaxDirectMemorySize property to allow enough space for the FileChannel transfer buffers");
                throw e;
            }
        }

        Long writeMappingBuffers(ByteBuffer keyBuffer, ByteBuffer valueBuffer, int pojoHash) {
            int valueLength;
            int keyLength = keyBuffer.remaining();
            long address = this.allocator.allocate(keyLength + (valueLength = valueBuffer.remaining()) + 12);
            if (address >= 0L) {
                long position = this.filePosition + address;
                FileWriteTask task = new FileWriteTask(this, position, keyBuffer, valueBuffer, pojoHash);
                FileBackedStorageEngine.this.pendingWrites.put(position, task);
                FileBackedStorageEngine.this.writeExecutor.execute(task);
                return address;
            }
            return null;
        }

        WriteContext getKeyWriteContext(long address) {
            try {
                long position = this.filePosition + address;
                FileWriteTask pending = (FileWriteTask)FileBackedStorageEngine.this.pendingWrites.get(position);
                if (pending == null) {
                    int keyLength = FileBackedStorageEngine.this.readIntFromChannel(position + 4L);
                    return this.getDiskWriteContext(position + 12L, keyLength);
                }
                if (FileBackedStorageEngine.this.pendingWrites.get(position) != pending) {
                    return this.getKeyWriteContext(address);
                }
                return this.getQueuedWriteContext(pending, pending.getKeyBuffer());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        WriteContext getValueWriteContext(long address) {
            try {
                long position = this.filePosition + address;
                FileWriteTask pending = (FileWriteTask)FileBackedStorageEngine.this.pendingWrites.get(position);
                if (pending == null) {
                    int keyLength = FileBackedStorageEngine.this.readIntFromChannel(position + 4L);
                    int valueLength = FileBackedStorageEngine.this.readIntFromChannel(position + 8L);
                    return this.getDiskWriteContext(position + (long)keyLength + 12L, valueLength);
                }
                if (FileBackedStorageEngine.this.pendingWrites.get(position) != pending) {
                    return this.getValueWriteContext(address);
                }
                return this.getQueuedWriteContext(pending, pending.getValueBuffer());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private WriteContext getDiskWriteContext(final long address, final int max) {
            return new WriteContext(){

                @Override
                public void setLong(int offset, long value) {
                    if (offset < 0 || offset >= max) {
                        throw new IllegalArgumentException();
                    }
                    try {
                        FileBackedStorageEngine.this.writeLongToChannel(address + (long)offset, value);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void flush() {
                }
            };
        }

        private WriteContext getQueuedWriteContext(final FileWriteTask current, final ByteBuffer queuedBuffer) {
            return new WriteContext(){

                @Override
                public void setLong(int offset, long value) {
                    queuedBuffer.putLong(offset, value);
                }

                @Override
                public void flush() {
                    FileWriteTask flush = new FileWriteTask(current.chunk, current.position, current.keyBuffer, current.valueBuffer, current.pojoHash);
                    FileBackedStorageEngine.this.pendingWrites.put(flush.position, flush);
                    FileBackedStorageEngine.this.writeExecutor.execute(flush);
                }
            };
        }

        void free(long address) {
            try {
                int valueLength;
                int keyLength;
                long position = this.filePosition + address;
                FileWriteTask pending = (FileWriteTask)FileBackedStorageEngine.this.pendingWrites.remove(position);
                if (pending == null) {
                    keyLength = FileBackedStorageEngine.this.readIntFromChannel(position + 4L);
                    valueLength = FileBackedStorageEngine.this.readIntFromChannel(position + 8L);
                } else {
                    keyLength = pending.getKeyBuffer().remaining();
                    valueLength = pending.getValueBuffer().remaining();
                }
                this.allocator.free(address, keyLength + valueLength + 12);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        synchronized void clear() {
            FileBackedStorageEngine.this.source.freeRegion(this.filePosition);
            this.valid = false;
        }

        long capacity() {
            return this.allocator.capacity();
        }

        long occupied() {
            return this.allocator.occupied();
        }

        long baseAddress() {
            return this.baseAddress;
        }

        void persist(ObjectOutput output) throws IOException {
            output.writeInt(1313753427);
            output.writeLong(this.filePosition);
            output.writeLong(this.baseAddress);
            output.writeLong(this.allocator.capacity());
            this.allocator.persist(output);
        }

        synchronized boolean isValid() {
            return this.valid;
        }

        Set<Long> encodings() {
            HashSet<Long> encodings = new HashSet<Long>();
            for (Long encoding : FileBackedStorageEngine.this.owner.encodingSet()) {
                long relative = encoding - this.baseAddress();
                if (relative < 0L || relative >= this.capacity()) continue;
                encodings.add(encoding);
            }
            return encodings;
        }

        void evictAll() {
            for (long encoding : this.encodings()) {
                int slot = FileBackedStorageEngine.this.owner.getSlotForHashAndEncoding(this.readPojoHash(encoding - this.baseAddress()), encoding, -1L);
                FileBackedStorageEngine.this.owner.evict(slot, true);
            }
        }
    }
}

