/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.uif;

import com.google.common.base.Joiner;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.core.api.uif.RemotableAttributeErrorContract;
import org.w3c.dom.Element;

@XmlRootElement(name="attributeError")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="attributeErrorType", propOrder={"attributeName", "errors", "_futureElements"})
public final class RemotableAttributeError
extends AbstractDataTransferObject
implements RemotableAttributeErrorContract {
    @XmlElement(name="attributeName", required=false)
    private final String attributeName;
    @XmlElementWrapper(name="errors", required=true)
    @XmlElement(name="error", required=false)
    private final List<String> errors;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private RemotableAttributeError() {
        this.attributeName = null;
        this.errors = null;
    }

    private RemotableAttributeError(Builder builder) {
        this.attributeName = builder.getAttributeName();
        this.errors = builder.getErrors();
    }

    @Override
    public String getAttributeName() {
        return this.attributeName;
    }

    @Override
    public List<String> getErrors() {
        return this.errors;
    }

    @Override
    public String getMessage() {
        return Joiner.on((String)", ").skipNulls().join(this.getErrors());
    }

    @Override
    public String toString() {
        return this.getAttributeName() + ": " + this.getMessage();
    }

    public static boolean containsAttribute(String attributeName, Collection<RemotableAttributeError> errors) {
        if (StringUtils.isBlank((String)attributeName)) {
            throw new IllegalArgumentException("attributeName is blank");
        }
        if (errors == null) {
            throw new IllegalArgumentException("errors is null");
        }
        for (RemotableAttributeErrorContract remotableAttributeErrorContract : errors) {
            if (!attributeName.equals(remotableAttributeErrorContract.getAttributeName())) continue;
            return true;
        }
        return false;
    }

    public static List<RemotableAttributeError> normalizeRemotableAttributes(List<RemotableAttributeError> errors) {
        if (errors == null) {
            throw new IllegalArgumentException("errors is null");
        }
        ArrayList<RemotableAttributeError> normalized = new ArrayList<RemotableAttributeError>();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (RemotableAttributeError error : errors) {
            Integer prevIndex = (Integer)map.get(error.getAttributeName());
            if (prevIndex == null) {
                int insertIdx = normalized.size();
                map.put(error.getAttributeName(), insertIdx);
                normalized.add(insertIdx, error);
                continue;
            }
            RemotableAttributeError prevError = (RemotableAttributeError)normalized.get(prevIndex);
            Builder b = Builder.create(error.getAttributeName(), error.getErrors());
            b.addErrors(prevError.getErrors());
            normalized.set(prevIndex, b.build());
        }
        return normalized;
    }

    static class Elements {
        static final String ATTRIBUTE_NAME = "attributeName";
        static final String ERROR = "error";
        static final String ERRORS = "errors";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "attributeError";
        static final String TYPE_NAME = "attributeErrorType";

        Constants() {
        }
    }

    public static final class Builder
    implements Serializable,
    ModelBuilder,
    RemotableAttributeErrorContract {
        private String attributeName;
        private List<String> errors = new ArrayList<String>();

        private Builder(String attributeName) {
            if (StringUtils.isBlank((String)attributeName)) {
                throw new IllegalArgumentException("attributeName was null");
            }
            this.attributeName = attributeName;
        }

        public static Builder create(String attributeName) {
            return new Builder(attributeName);
        }

        public static Builder create(String attributeName, List<String> errors) {
            Builder b = new Builder(attributeName);
            b.setErrors(errors);
            return b;
        }

        public static Builder create(String attributeName, String ... errors) {
            Builder b = new Builder(attributeName);
            b.addErrors(errors);
            return b;
        }

        public static Builder create(RemotableAttributeErrorContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract was null");
            }
            Builder builder = Builder.create(contract.getAttributeName());
            builder.setErrors(contract.getErrors());
            return builder;
        }

        @Override
        public RemotableAttributeError build() {
            if (this.errors.isEmpty()) {
                throw new IllegalStateException("must contain at least one error");
            }
            for (String err : this.errors) {
                if (!StringUtils.isBlank((String)err)) continue;
                throw new IllegalStateException("contains a blank error");
            }
            return new RemotableAttributeError(this);
        }

        @Override
        public String getAttributeName() {
            return this.attributeName;
        }

        @Override
        public List<String> getErrors() {
            return Collections.unmodifiableList(this.errors);
        }

        @Override
        public String getMessage() {
            return Joiner.on((String)", ").skipNulls().join(this.getErrors());
        }

        public String toString() {
            return this.getAttributeName() + ": " + this.getMessage();
        }

        public void setAttributeName(String attributeName) {
            if (StringUtils.isBlank((String)attributeName)) {
                throw new IllegalArgumentException("attributeName is blank");
            }
            this.attributeName = attributeName;
        }

        public void setErrors(List<String> errors) {
            if (errors == null) {
                throw new IllegalArgumentException("errors is null");
            }
            this.errors = new ArrayList<String>(errors);
        }

        public void addErrors(String ... errors) {
            if (errors == null) {
                throw new IllegalArgumentException("errors is null");
            }
            this.errors.addAll(Arrays.asList(errors));
        }

        public void addErrors(List<String> errors) {
            if (errors == null) {
                throw new IllegalArgumentException("errors is null");
            }
            this.errors.addAll(errors);
        }
    }
}

