/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.api.identity.affiliation;

import java.io.Serializable;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.kim.api.identity.affiliation.EntityAffiliationContract;
import org.kuali.rice.kim.api.identity.affiliation.EntityAffiliationType;
import org.w3c.dom.Element;

@XmlRootElement(name="entityAffiliation")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="EntityAffiliationType", propOrder={"id", "entityId", "affiliationType", "campusCode", "defaultValue", "active", "versionNumber", "objectId", "_futureElements"})
public final class EntityAffiliation
extends AbstractDataTransferObject
implements EntityAffiliationContract {
    @XmlElement(name="entityId", required=false)
    private final String entityId;
    @XmlElement(name="affiliationType", required=false)
    private final EntityAffiliationType affiliationType;
    @XmlElement(name="campusCode", required=false)
    private final String campusCode;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlElement(name="objectId", required=false)
    private final String objectId;
    @XmlElement(name="defaultValue", required=false)
    private final boolean defaultValue;
    @XmlElement(name="active", required=false)
    private final boolean active;
    @XmlElement(name="id", required=false)
    private final String id;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private EntityAffiliation() {
        this.entityId = null;
        this.affiliationType = null;
        this.campusCode = null;
        this.versionNumber = null;
        this.objectId = null;
        this.defaultValue = false;
        this.active = false;
        this.id = null;
    }

    private EntityAffiliation(Builder builder) {
        this.entityId = builder.getEntityId();
        this.affiliationType = builder.getAffiliationType() != null ? builder.getAffiliationType().build() : null;
        this.campusCode = builder.getCampusCode();
        this.versionNumber = builder.getVersionNumber();
        this.objectId = builder.getObjectId();
        this.defaultValue = builder.isDefaultValue();
        this.active = builder.isActive();
        this.id = builder.getId();
    }

    @Override
    public String getEntityId() {
        return this.entityId;
    }

    @Override
    public EntityAffiliationType getAffiliationType() {
        return this.affiliationType;
    }

    @Override
    public String getCampusCode() {
        return this.campusCode;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public boolean isDefaultValue() {
        return this.defaultValue;
    }

    public boolean isActive() {
        return this.active;
    }

    public String getId() {
        return this.id;
    }

    static class Elements {
        static final String ENTITY_ID = "entityId";
        static final String AFFILIATION_TYPE = "affiliationType";
        static final String CAMPUS_CODE = "campusCode";
        static final String DEFAULT_VALUE = "defaultValue";
        static final String ACTIVE = "active";
        static final String ID = "id";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "entityAffiliation";
        static final String TYPE_NAME = "EntityAffiliationType";

        Constants() {
        }
    }

    public static final class Builder
    implements Serializable,
    ModelBuilder,
    EntityAffiliationContract {
        private String entityId;
        private EntityAffiliationType.Builder affiliationType;
        private String campusCode;
        private Long versionNumber;
        private String objectId;
        private boolean defaultValue;
        private boolean active;
        private String id;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public static Builder create(EntityAffiliationContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract was null");
            }
            Builder builder = Builder.create();
            builder.setEntityId(contract.getEntityId());
            if (contract.getAffiliationType() != null) {
                builder.setAffiliationType(EntityAffiliationType.Builder.create(contract.getAffiliationType()));
            }
            builder.setCampusCode(contract.getCampusCode());
            builder.setVersionNumber(contract.getVersionNumber());
            builder.setObjectId(contract.getObjectId());
            builder.setDefaultValue(contract.isDefaultValue());
            builder.setActive(contract.isActive());
            builder.setId(contract.getId());
            return builder;
        }

        public EntityAffiliation build() {
            return new EntityAffiliation(this);
        }

        @Override
        public String getEntityId() {
            return this.entityId;
        }

        @Override
        public EntityAffiliationType.Builder getAffiliationType() {
            return this.affiliationType;
        }

        @Override
        public String getCampusCode() {
            return this.campusCode;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public String getObjectId() {
            return this.objectId;
        }

        public boolean isDefaultValue() {
            return this.defaultValue;
        }

        public boolean isActive() {
            return this.active;
        }

        public String getId() {
            return this.id;
        }

        public void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        public void setAffiliationType(EntityAffiliationType.Builder affiliationType) {
            this.affiliationType = affiliationType;
        }

        public void setCampusCode(String campusCode) {
            this.campusCode = campusCode;
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public void setObjectId(String objectId) {
            this.objectId = objectId;
        }

        public void setDefaultValue(boolean defaultValue) {
            this.defaultValue = defaultValue;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public void setId(String id) {
            if (StringUtils.isWhitespace((String)id)) {
                throw new IllegalArgumentException("id is blank");
            }
            this.id = id;
        }
    }
}

