/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.framework.personnel;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItem;
import org.kuali.coeus.common.budget.framework.personnel.AddPersonnelLineItemBudgetEvent;
import org.kuali.coeus.common.budget.framework.personnel.AddSummaryPersonnelLineItemBudgetEvent;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelDetails;
import org.kuali.coeus.common.budget.framework.personnel.PersonnelApplyToPeriodsBudgetEvent;
import org.kuali.coeus.common.framework.ruleengine.KcBusinessRule;
import org.kuali.coeus.common.framework.ruleengine.KcEventMethod;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

@KcBusinessRule(value="budgetPersonnelExpenseRule")
public class BudgetPersonnelExpenseRule {
    @KcEventMethod
    public boolean processCheckSummaryAddBusinessRules(AddSummaryPersonnelLineItemBudgetEvent event) {
        boolean valid = true;
        MessageMap errorMap = GlobalVariables.getMessageMap();
        errorMap.addToErrorPath(event.getErrorPath());
        if (event.getBudgetLineItem().getBudgetPersonnelDetailsList().size() > 0) {
            errorMap.putError("personSequenceNumber", "error.personnelExists", new String[0]);
            valid = false;
        }
        if (event.getBudgetLineItem().getBudgetPersonnelDetailsList().size() == 0) {
            errorMap.putError("personSequenceNumber", "error.summaryLineItemExists", new String[0]);
            valid = false;
        }
        errorMap.removeFromErrorPath(event.getErrorPath());
        return valid;
    }

    @KcEventMethod
    public boolean processCheckPersonAddBusinessRules(AddPersonnelLineItemBudgetEvent event) {
        boolean valid = true;
        MessageMap errorMap = GlobalVariables.getMessageMap();
        errorMap.addToErrorPath(event.getErrorPath());
        if (event.getBudgetLineItem().getBudgetPersonnelDetailsList().size() == 0) {
            errorMap.putError("personSequenceNumber", "error.summaryLineItemExists.addPerson", new String[0]);
            valid = false;
        }
        errorMap.removeFromErrorPath(event.getErrorPath());
        return valid;
    }

    @KcEventMethod
    public boolean processCheckDuplicateBudgetPersonnel(PersonnelApplyToPeriodsBudgetEvent event) {
        return this.processCheckDuplicateBudgetPersonnel(event.getBudget(), event.getBudgetLineItem(), event.getErrorPath());
    }

    protected boolean processCheckDuplicateBudgetPersonnel(Budget budget, BudgetLineItem budgetLineItem, String errorPath) {
        boolean valid = true;
        MessageMap errorMap = GlobalVariables.getMessageMap();
        errorMap.addToErrorPath(errorPath);
        int k = 0;
        int l = 0;
        HashMap<CallSite, CallSite> errorCombinations = new HashMap<CallSite, CallSite>();
        for (BudgetPersonnelDetails personnelDetails : budgetLineItem.getBudgetPersonnelDetailsList()) {
            l = 0;
            for (BudgetPersonnelDetails personnelDetailsForcomparison : budgetLineItem.getBudgetPersonnelDetailsList()) {
                if (k != l && personnelDetails.getPersonSequenceNumber().intValue() == personnelDetailsForcomparison.getPersonSequenceNumber().intValue() && StringUtils.equals((CharSequence)personnelDetails.getJobCode(), (CharSequence)personnelDetailsForcomparison.getJobCode()) && personnelDetails.getStartDate().equals(personnelDetailsForcomparison.getStartDate())) {
                    if (errorCombinations.get("" + k + l) == null) {
                        errorMap.putError("budgetPersonnelDetailsList[" + l + "].startDate", "error.duplicate.personnel", new String[]{personnelDetailsForcomparison.getBudgetPerson().getPersonName()});
                    }
                    errorCombinations.put((CallSite)((Object)("" + k + l)), (CallSite)((Object)("" + l + k)));
                    errorCombinations.put((CallSite)((Object)("" + l + k)), (CallSite)((Object)("" + k + l)));
                    valid = false;
                }
                ++l;
            }
            ++k;
        }
        errorMap.removeFromErrorPath(errorPath);
        return valid;
    }
}

