/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.StepListener;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.delete.DeleteSnapshotRequest;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateApplier;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.NotMasterException;
import org.elasticsearch.cluster.RepositoryCleanupInProgress;
import org.elasticsearch.cluster.RestoreInProgress;
import org.elasticsearch.cluster.SnapshotDeletionsInProgress;
import org.elasticsearch.cluster.SnapshotsInProgress;
import org.elasticsearch.cluster.coordination.FailedToCommitClusterStateException;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.RepositoriesMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryData;
import org.elasticsearch.repositories.RepositoryException;
import org.elasticsearch.repositories.RepositoryMissingException;
import org.elasticsearch.repositories.ShardGenerations;
import org.elasticsearch.snapshots.ConcurrentSnapshotExecutionException;
import org.elasticsearch.snapshots.InvalidSnapshotNameException;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotException;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotMissingException;
import org.elasticsearch.snapshots.SnapshotShardFailure;
import org.elasticsearch.threadpool.ThreadPool;

public class SnapshotsService
extends AbstractLifecycleComponent
implements ClusterStateApplier {
    public static final Version NO_REPO_INITIALIZE_VERSION = Version.V_7_5_0;
    public static final Version SHARD_GEN_IN_REPO_DATA_VERSION = Version.V_7_6_0;
    public static final Version OLD_SNAPSHOT_FORMAT = Version.V_7_5_0;
    public static final Version MULTI_DELETE_VERSION = Version.V_7_8_0;
    private static final Logger logger = LogManager.getLogger(SnapshotsService.class);
    public static final String UPDATE_SNAPSHOT_STATUS_ACTION_NAME = "internal:cluster/snapshot/update_snapshot_status";
    private final ClusterService clusterService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final RepositoriesService repositoriesService;
    private final ThreadPool threadPool;
    private final Map<Snapshot, List<ActionListener<Tuple<RepositoryData, SnapshotInfo>>>> snapshotCompletionListeners = new ConcurrentHashMap<Snapshot, List<ActionListener<Tuple<RepositoryData, SnapshotInfo>>>>();
    private final Set<Snapshot> initializingSnapshots = Collections.synchronizedSet(new HashSet());
    private final Set<Snapshot> endingSnapshots = Collections.synchronizedSet(new HashSet());

    public SnapshotsService(Settings settings, ClusterService clusterService, IndexNameExpressionResolver indexNameExpressionResolver, RepositoriesService repositoriesService, ThreadPool threadPool) {
        this.clusterService = clusterService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.repositoriesService = repositoriesService;
        this.threadPool = threadPool;
        if (DiscoveryNode.isMasterNode(settings)) {
            clusterService.addLowPriorityApplier(this);
        }
    }

    public void executeSnapshot(CreateSnapshotRequest request, ActionListener<SnapshotInfo> listener) {
        this.createSnapshot(request, ActionListener.wrap(snapshot -> this.addListener((Snapshot)snapshot, ActionListener.map(listener, Tuple::v2)), listener::onFailure));
    }

    public void createSnapshot(final CreateSnapshotRequest request, final ActionListener<Snapshot> listener) {
        final String repositoryName = request.repository();
        final String snapshotName = this.indexNameExpressionResolver.resolveDateMathExpression(request.snapshot());
        SnapshotsService.validate(repositoryName, snapshotName);
        final SnapshotId snapshotId = new SnapshotId(snapshotName, UUIDs.randomBase64UUID());
        final Repository repository = this.repositoriesService.repository(request.repository());
        final Map<String, Object> userMeta = repository.adaptUserMetadata(request.userMetadata());
        this.clusterService.submitStateUpdateTask("create_snapshot [" + snapshotName + ']', new ClusterStateUpdateTask(){
            private SnapshotsInProgress.Entry newSnapshot = null;
            private List<String> indices;

            @Override
            public ClusterState execute(ClusterState currentState) {
                SnapshotsService.validate(repositoryName, snapshotName, currentState);
                SnapshotDeletionsInProgress deletionsInProgress = (SnapshotDeletionsInProgress)currentState.custom("snapshot_deletions");
                if (deletionsInProgress != null && deletionsInProgress.hasDeletionsInProgress()) {
                    throw new ConcurrentSnapshotExecutionException(repositoryName, snapshotName, "cannot snapshot while a snapshot deletion is in-progress in [" + deletionsInProgress + "]");
                }
                RepositoryCleanupInProgress repositoryCleanupInProgress = (RepositoryCleanupInProgress)currentState.custom("repository_cleanup");
                if (repositoryCleanupInProgress != null && repositoryCleanupInProgress.hasCleanupInProgress()) {
                    throw new ConcurrentSnapshotExecutionException(repositoryName, snapshotName, "cannot snapshot while a repository cleanup is in-progress in [" + repositoryCleanupInProgress + "]");
                }
                SnapshotsInProgress snapshots = (SnapshotsInProgress)currentState.custom("snapshots");
                if (snapshots != null && snapshots.entries().stream().anyMatch(entry -> !(entry.state() == SnapshotsInProgress.State.INIT && !SnapshotsService.this.initializingSnapshots.contains(entry.snapshot())))) {
                    throw new ConcurrentSnapshotExecutionException(repositoryName, snapshotName, " a snapshot is already running");
                }
                this.indices = Arrays.asList(SnapshotsService.this.indexNameExpressionResolver.concreteIndexNames(currentState, request.indicesOptions(), request.indices()));
                logger.trace("[{}][{}] creating snapshot for indices [{}]", (Object)repositoryName, (Object)snapshotName, this.indices);
                this.newSnapshot = new SnapshotsInProgress.Entry(new Snapshot(repositoryName, snapshotId), request.includeGlobalState(), request.partial(), SnapshotsInProgress.State.INIT, Collections.emptyList(), SnapshotsService.this.threadPool.absoluteTimeInMillis(), -2L, null, userMeta, Version.CURRENT);
                SnapshotsService.this.initializingSnapshots.add(this.newSnapshot.snapshot());
                snapshots = new SnapshotsInProgress(this.newSnapshot);
                return ClusterState.builder(currentState).putCustom("snapshots", snapshots).build();
            }

            @Override
            public void onFailure(String source, Exception e) {
                logger.warn(() -> new ParameterizedMessage("[{}][{}] failed to create snapshot", (Object)repositoryName, (Object)snapshotName), (Throwable)e);
                if (this.newSnapshot != null) {
                    SnapshotsService.this.initializingSnapshots.remove(this.newSnapshot.snapshot());
                }
                this.newSnapshot = null;
                listener.onFailure(e);
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                if (this.newSnapshot != null) {
                    final Snapshot current = this.newSnapshot.snapshot();
                    assert (SnapshotsService.this.initializingSnapshots.contains(current));
                    assert (this.indices != null);
                    SnapshotsService.this.beginSnapshot(newState, this.newSnapshot, request.partial(), this.indices, repository, new ActionListener<Snapshot>(){

                        @Override
                        public void onResponse(Snapshot snapshot) {
                            SnapshotsService.this.initializingSnapshots.remove(snapshot);
                            listener.onResponse(snapshot);
                        }

                        @Override
                        public void onFailure(Exception e) {
                            SnapshotsService.this.initializingSnapshots.remove(current);
                            listener.onFailure(e);
                        }
                    });
                }
            }

            @Override
            public TimeValue timeout() {
                return request.masterNodeTimeout();
            }
        });
    }

    private static void validate(String repositoryName, String snapshotName, ClusterState state) {
        RepositoriesMetadata repositoriesMetadata = (RepositoriesMetadata)state.getMetadata().custom("repositories");
        if (repositoriesMetadata == null || repositoriesMetadata.repository(repositoryName) == null) {
            throw new RepositoryMissingException(repositoryName);
        }
        SnapshotsService.validate(repositoryName, snapshotName);
    }

    private static void validate(String repositoryName, String snapshotName) {
        if (!Strings.hasLength(snapshotName)) {
            throw new InvalidSnapshotNameException(repositoryName, snapshotName, "cannot be empty");
        }
        if (snapshotName.contains(" ")) {
            throw new InvalidSnapshotNameException(repositoryName, snapshotName, "must not contain whitespace");
        }
        if (snapshotName.contains(",")) {
            throw new InvalidSnapshotNameException(repositoryName, snapshotName, "must not contain ','");
        }
        if (snapshotName.contains("#")) {
            throw new InvalidSnapshotNameException(repositoryName, snapshotName, "must not contain '#'");
        }
        if (snapshotName.charAt(0) == '_') {
            throw new InvalidSnapshotNameException(repositoryName, snapshotName, "must not start with '_'");
        }
        if (!snapshotName.toLowerCase(Locale.ROOT).equals(snapshotName)) {
            throw new InvalidSnapshotNameException(repositoryName, snapshotName, "must be lowercase");
        }
        if (!Strings.validFileName(snapshotName)) {
            throw new InvalidSnapshotNameException(repositoryName, snapshotName, "must not contain the following characters " + Strings.INVALID_FILENAME_CHARS);
        }
    }

    private void beginSnapshot(final ClusterState clusterState, final SnapshotsInProgress.Entry snapshot, final boolean partial, final List<String> indices, final Repository repository, final ActionListener<Snapshot> userCreateSnapshotListener) {
        this.threadPool.executor("snapshot").execute(new AbstractRunnable(){
            boolean hadAbortedInitializations;

            @Override
            protected void doRun() {
                assert (SnapshotsService.this.initializingSnapshots.contains(snapshot.snapshot()));
                if (repository.isReadOnly()) {
                    throw new RepositoryException(repository.getMetadata().name(), "cannot create snapshot in a readonly repository");
                }
                String snapshotName = snapshot.snapshot().getSnapshotId().getName();
                StepListener<RepositoryData> repositoryDataListener = new StepListener<RepositoryData>();
                repository.getRepositoryData(repositoryDataListener);
                repositoryDataListener.whenComplete(repositoryData -> {
                    if (repositoryData.getSnapshotIds().stream().anyMatch(s -> s.getName().equals(snapshotName))) {
                        throw new InvalidSnapshotNameException(repository.getMetadata().name(), snapshotName, "snapshot with the same name already exists");
                    }
                    if (!clusterState.nodes().getMinNodeVersion().onOrAfter(NO_REPO_INITIALIZE_VERSION)) {
                        repository.initializeSnapshot(snapshot.snapshot().getSnapshotId(), snapshot.indices(), SnapshotsService.metadataForSnapshot(snapshot, clusterState.metadata()));
                    }
                    logger.info("snapshot [{}] started", (Object)snapshot.snapshot());
                    Version version = SnapshotsService.this.minCompatibleVersion(clusterState.nodes().getMinNodeVersion(), snapshot.repository(), (RepositoryData)repositoryData, null);
                    if (indices.isEmpty()) {
                        userCreateSnapshotListener.onResponse(snapshot.snapshot());
                        SnapshotsService.this.endSnapshot(new SnapshotsInProgress.Entry(snapshot, SnapshotsInProgress.State.STARTED, Collections.emptyList(), repositoryData.getGenId(), null, version, null), clusterState.metadata());
                        return;
                    }
                    SnapshotsService.this.clusterService.submitStateUpdateTask("update_snapshot [" + snapshot.snapshot() + "]", new ClusterStateUpdateTask((RepositoryData)repositoryData, indices, version, partial, userCreateSnapshotListener){
                        final /* synthetic */ RepositoryData val$repositoryData;
                        final /* synthetic */ List val$indices;
                        final /* synthetic */ Version val$version;
                        final /* synthetic */ boolean val$partial;
                        final /* synthetic */ ActionListener val$userCreateSnapshotListener;
                        {
                            this.val$repositoryData = repositoryData;
                            this.val$indices = list;
                            this.val$version = version;
                            this.val$partial = bl;
                            this.val$userCreateSnapshotListener = actionListener;
                        }

                        @Override
                        public ClusterState execute(ClusterState currentState) {
                            SnapshotsInProgress snapshots = (SnapshotsInProgress)currentState.custom("snapshots");
                            ArrayList<SnapshotsInProgress.Entry> entries = new ArrayList<SnapshotsInProgress.Entry>();
                            for (SnapshotsInProgress.Entry entry : snapshots.entries()) {
                                if (!entry.snapshot().equals(snapshot.snapshot())) {
                                    entries.add(entry);
                                    continue;
                                }
                                if (entry.state() == SnapshotsInProgress.State.ABORTED) {
                                    entries.add(entry);
                                    assert (entry.shards().isEmpty());
                                    hadAbortedInitializations = true;
                                    continue;
                                }
                                List<IndexId> indexIds = this.val$repositoryData.resolveNewIndices(this.val$indices);
                                ImmutableOpenMap shards = SnapshotsService.shards(currentState, indexIds, SnapshotsService.useShardGenerations(this.val$version), this.val$repositoryData);
                                if (!this.val$partial) {
                                    Tuple indicesWithMissingShards = SnapshotsService.indicesWithMissingShards(shards, currentState.metadata());
                                    Set missing = (Set)indicesWithMissingShards.v1();
                                    Set closed = (Set)indicesWithMissingShards.v2();
                                    if (!missing.isEmpty() || !closed.isEmpty()) {
                                        StringBuilder failureMessage = new StringBuilder();
                                        if (!missing.isEmpty()) {
                                            failureMessage.append("Indices don't have primary shards ");
                                            failureMessage.append(missing);
                                        }
                                        if (!closed.isEmpty()) {
                                            if (failureMessage.length() > 0) {
                                                failureMessage.append("; ");
                                            }
                                            failureMessage.append("Indices are closed ");
                                            failureMessage.append(closed);
                                        }
                                        entries.add(new SnapshotsInProgress.Entry(entry, SnapshotsInProgress.State.FAILED, indexIds, this.val$repositoryData.getGenId(), shards, this.val$version, failureMessage.toString()));
                                        continue;
                                    }
                                }
                                entries.add(new SnapshotsInProgress.Entry(entry, SnapshotsInProgress.State.STARTED, indexIds, this.val$repositoryData.getGenId(), shards, this.val$version, null));
                            }
                            return ClusterState.builder(currentState).putCustom("snapshots", new SnapshotsInProgress(Collections.unmodifiableList(entries))).build();
                        }

                        @Override
                        public void onFailure(String source, Exception e) {
                            logger.warn(() -> new ParameterizedMessage("[{}] failed to create snapshot", (Object)snapshot.snapshot().getSnapshotId()), (Throwable)e);
                            SnapshotsService.this.removeSnapshotFromClusterState(snapshot.snapshot(), e, new CleanupAfterErrorListener(this.val$userCreateSnapshotListener, e));
                        }

                        @Override
                        public void onNoLongerMaster(String source) {
                            logger.warn("[{}] failed to create snapshot - no longer a master", (Object)snapshot.snapshot().getSnapshotId());
                            this.val$userCreateSnapshotListener.onFailure(new SnapshotException(snapshot.snapshot(), "master changed during snapshot initialization"));
                        }

                        @Override
                        public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                            this.val$userCreateSnapshotListener.onResponse(snapshot.snapshot());
                            if (hadAbortedInitializations) {
                                SnapshotsInProgress snapshotsInProgress = (SnapshotsInProgress)newState.custom("snapshots");
                                assert (snapshotsInProgress != null);
                                SnapshotsInProgress.Entry entry = snapshotsInProgress.snapshot(snapshot.snapshot());
                                assert (entry != null);
                                SnapshotsService.this.endSnapshot(entry, newState.metadata());
                            }
                        }
                    });
                }, this::onFailure);
            }

            @Override
            public void onFailure(Exception e) {
                logger.warn(() -> new ParameterizedMessage("failed to create snapshot [{}]", (Object)snapshot.snapshot().getSnapshotId()), (Throwable)e);
                SnapshotsService.this.removeSnapshotFromClusterState(snapshot.snapshot(), e, new CleanupAfterErrorListener(userCreateSnapshotListener, e));
            }
        });
    }

    private static ShardGenerations buildGenerations(SnapshotsInProgress.Entry snapshot, Metadata metadata) {
        ShardGenerations.Builder builder = ShardGenerations.builder();
        HashMap indexLookup = new HashMap();
        snapshot.indices().forEach(idx -> indexLookup.put(idx.getName(), idx));
        snapshot.shards().forEach(c -> {
            if (metadata.index(((ShardId)c.key).getIndex()) == null) {
                assert (snapshot.partial()) : "Index [" + ((ShardId)c.key).getIndex() + "] was deleted during a snapshot but snapshot was not partial.";
                return;
            }
            IndexId indexId = (IndexId)indexLookup.get(((ShardId)c.key).getIndexName());
            if (indexId != null) {
                builder.put(indexId, ((ShardId)c.key).id(), ((SnapshotsInProgress.ShardSnapshotStatus)c.value).generation());
            }
        });
        return builder.build();
    }

    private static Metadata metadataForSnapshot(SnapshotsInProgress.Entry snapshot, Metadata metadata) {
        if (!snapshot.includeGlobalState()) {
            Metadata.Builder builder = Metadata.builder();
            for (IndexId index : snapshot.indices()) {
                IndexMetadata indexMetadata = metadata.index(index.getName());
                if (indexMetadata == null) {
                    assert (snapshot.partial()) : "Index [" + index + "] was deleted during a snapshot but snapshot was not partial.";
                    continue;
                }
                builder.put(indexMetadata, false);
            }
            metadata = builder.build();
        }
        return metadata;
    }

    public static List<SnapshotsInProgress.Entry> currentSnapshots(@Nullable SnapshotsInProgress snapshotsInProgress, String repository, List<String> snapshots) {
        if (snapshotsInProgress == null || snapshotsInProgress.entries().isEmpty()) {
            return Collections.emptyList();
        }
        if ("_all".equals(repository)) {
            return snapshotsInProgress.entries();
        }
        if (snapshotsInProgress.entries().size() == 1) {
            SnapshotsInProgress.Entry entry = snapshotsInProgress.entries().get(0);
            if (!entry.snapshot().getRepository().equals(repository)) {
                return Collections.emptyList();
            }
            if (!snapshots.isEmpty()) {
                for (String snapshot : snapshots) {
                    if (!entry.snapshot().getSnapshotId().getName().equals(snapshot)) continue;
                    return snapshotsInProgress.entries();
                }
                return Collections.emptyList();
            }
            return snapshotsInProgress.entries();
        }
        ArrayList<SnapshotsInProgress.Entry> builder = new ArrayList<SnapshotsInProgress.Entry>();
        block1: for (SnapshotsInProgress.Entry entry : snapshotsInProgress.entries()) {
            if (!entry.snapshot().getRepository().equals(repository)) continue;
            if (!snapshots.isEmpty()) {
                for (String snapshot : snapshots) {
                    if (!entry.snapshot().getSnapshotId().getName().equals(snapshot)) continue;
                    builder.add(entry);
                    continue block1;
                }
                continue;
            }
            builder.add(entry);
        }
        return Collections.unmodifiableList(builder);
    }

    @Override
    public void applyClusterState(ClusterChangedEvent event) {
        try {
            if (event.localNodeMaster()) {
                boolean newMaster;
                SnapshotsInProgress snapshotsInProgress = (SnapshotsInProgress)event.state().custom("snapshots");
                boolean bl = newMaster = !event.previousState().nodes().isLocalNodeElectedMaster();
                if (snapshotsInProgress != null) {
                    if (newMaster || SnapshotsService.removedNodesCleanupNeeded(snapshotsInProgress, event.nodesDelta().removedNodes())) {
                        this.processSnapshotsOnRemovedNodes();
                    }
                    if (event.routingTableChanged() && SnapshotsService.waitingShardsStartedOrUnassigned(snapshotsInProgress, event)) {
                        this.processStartedShards();
                    }
                    snapshotsInProgress.entries().stream().filter(entry -> entry.state().completed() || !this.initializingSnapshots.contains(entry.snapshot()) && (entry.state() == SnapshotsInProgress.State.INIT || SnapshotsInProgress.completed(entry.shards().values()))).forEach(entry -> this.endSnapshot((SnapshotsInProgress.Entry)entry, event.state().metadata()));
                }
                if (newMaster) {
                    this.finalizeSnapshotDeletionFromPreviousMaster(event.state());
                }
            } else if (!this.snapshotCompletionListeners.isEmpty()) {
                for (Snapshot snapshot : new HashSet<Snapshot>(this.snapshotCompletionListeners.keySet())) {
                    if (!this.endingSnapshots.add(snapshot)) continue;
                    this.failSnapshotCompletionListeners(snapshot, new SnapshotException(snapshot, "no longer master"));
                }
            }
        }
        catch (Exception e) {
            assert (false) : new AssertionError((Object)e);
            logger.warn("Failed to update snapshot state ", (Throwable)e);
        }
        assert (this.assertConsistentWithClusterState(event.state()));
    }

    private boolean assertConsistentWithClusterState(ClusterState state) {
        SnapshotsInProgress snapshotsInProgress = (SnapshotsInProgress)state.custom("snapshots");
        if (snapshotsInProgress != null && !snapshotsInProgress.entries().isEmpty()) {
            Set runningSnapshots = snapshotsInProgress.entries().stream().map(SnapshotsInProgress.Entry::snapshot).collect(Collectors.toSet());
            Set<Snapshot> snapshotListenerKeys = this.snapshotCompletionListeners.keySet();
            assert (runningSnapshots.containsAll(snapshotListenerKeys)) : "Saw completion listeners for unknown snapshots in " + snapshotListenerKeys + " but running snapshots are " + runningSnapshots;
        }
        return true;
    }

    private void finalizeSnapshotDeletionFromPreviousMaster(ClusterState state) {
        SnapshotDeletionsInProgress deletionsInProgress = (SnapshotDeletionsInProgress)state.custom("snapshot_deletions");
        if (deletionsInProgress != null && deletionsInProgress.hasDeletionsInProgress()) {
            assert (deletionsInProgress.getEntries().size() == 1) : "only one in-progress deletion allowed per cluster";
            SnapshotDeletionsInProgress.Entry entry = deletionsInProgress.getEntries().get(0);
            this.deleteSnapshotsFromRepository(entry.repository(), entry.getSnapshots(), null, entry.repositoryStateId(), state.nodes().getMinNodeVersion());
        }
    }

    private void processSnapshotsOnRemovedNodes() {
        this.clusterService.submitStateUpdateTask("update snapshot state after node removal", new ClusterStateUpdateTask(){

            @Override
            public ClusterState execute(ClusterState currentState) {
                DiscoveryNodes nodes = currentState.nodes();
                SnapshotsInProgress snapshots = (SnapshotsInProgress)currentState.custom("snapshots");
                if (snapshots == null) {
                    return currentState;
                }
                boolean changed = false;
                ArrayList<SnapshotsInProgress.Entry> entries = new ArrayList<SnapshotsInProgress.Entry>();
                Iterator<SnapshotsInProgress.Entry> iterator = snapshots.entries().iterator();
                while (iterator.hasNext()) {
                    SnapshotsInProgress.Entry snapshot;
                    SnapshotsInProgress.Entry updatedSnapshot = snapshot = iterator.next();
                    if (snapshot.state() == SnapshotsInProgress.State.STARTED || snapshot.state() == SnapshotsInProgress.State.ABORTED) {
                        ImmutableOpenMap.Builder<ShardId, SnapshotsInProgress.ShardSnapshotStatus> shards = ImmutableOpenMap.builder();
                        boolean snapshotChanged = false;
                        for (ObjectObjectCursor<ShardId, SnapshotsInProgress.ShardSnapshotStatus> objectObjectCursor : snapshot.shards()) {
                            SnapshotsInProgress.ShardSnapshotStatus shardStatus = (SnapshotsInProgress.ShardSnapshotStatus)objectObjectCursor.value;
                            ShardId shardId = (ShardId)objectObjectCursor.key;
                            if (!shardStatus.state().completed() && shardStatus.nodeId() != null) {
                                if (nodes.nodeExists(shardStatus.nodeId())) {
                                    shards.put(shardId, shardStatus);
                                    continue;
                                }
                                snapshotChanged = true;
                                logger.warn("failing snapshot of shard [{}] on closed node [{}]", (Object)shardId, (Object)shardStatus.nodeId());
                                shards.put(shardId, new SnapshotsInProgress.ShardSnapshotStatus(shardStatus.nodeId(), SnapshotsInProgress.ShardState.FAILED, "node shutdown", shardStatus.generation()));
                                continue;
                            }
                            shards.put(shardId, shardStatus);
                        }
                        if (snapshotChanged) {
                            changed = true;
                            ImmutableOpenMap<ShardId, SnapshotsInProgress.ShardSnapshotStatus> shardsMap = shards.build();
                            updatedSnapshot = !snapshot.state().completed() && SnapshotsInProgress.completed(shardsMap.values()) ? new SnapshotsInProgress.Entry(snapshot, SnapshotsInProgress.State.SUCCESS, shardsMap) : new SnapshotsInProgress.Entry(snapshot, snapshot.state(), shardsMap);
                        }
                        entries.add(updatedSnapshot);
                    } else if (snapshot.state() == SnapshotsInProgress.State.INIT && !SnapshotsService.this.initializingSnapshots.contains(snapshot.snapshot())) {
                        changed = true;
                    }
                    assert (updatedSnapshot.shards().size() == snapshot.shards().size()) : "Shard count changed during snapshot status update from [" + snapshot + "] to [" + updatedSnapshot + "]";
                }
                if (changed) {
                    return ClusterState.builder(currentState).putCustom("snapshots", new SnapshotsInProgress(Collections.unmodifiableList(entries))).build();
                }
                return currentState;
            }

            @Override
            public void onFailure(String source, Exception e) {
                logger.warn("failed to update snapshot state after node removal");
            }
        });
    }

    private void processStartedShards() {
        this.clusterService.submitStateUpdateTask("update snapshot state after shards started", new ClusterStateUpdateTask(){

            @Override
            public ClusterState execute(ClusterState currentState) {
                RoutingTable routingTable = currentState.routingTable();
                SnapshotsInProgress snapshots = (SnapshotsInProgress)currentState.custom("snapshots");
                if (snapshots != null) {
                    boolean changed = false;
                    ArrayList<SnapshotsInProgress.Entry> entries = new ArrayList<SnapshotsInProgress.Entry>();
                    Iterator<SnapshotsInProgress.Entry> iterator = snapshots.entries().iterator();
                    while (iterator.hasNext()) {
                        SnapshotsInProgress.Entry snapshot;
                        SnapshotsInProgress.Entry updatedSnapshot = snapshot = iterator.next();
                        if (snapshot.state() != SnapshotsInProgress.State.STARTED) continue;
                        ImmutableOpenMap shards = SnapshotsService.processWaitingShards(snapshot.shards(), routingTable);
                        if (shards != null) {
                            changed = true;
                            updatedSnapshot = !snapshot.state().completed() && SnapshotsInProgress.completed(shards.values()) ? new SnapshotsInProgress.Entry(snapshot, SnapshotsInProgress.State.SUCCESS, shards) : new SnapshotsInProgress.Entry(snapshot, shards);
                        }
                        entries.add(updatedSnapshot);
                    }
                    if (changed) {
                        return ClusterState.builder(currentState).putCustom("snapshots", new SnapshotsInProgress(Collections.unmodifiableList(entries))).build();
                    }
                }
                return currentState;
            }

            @Override
            public void onFailure(String source, Exception e) {
                logger.warn(() -> new ParameterizedMessage("failed to update snapshot state after shards started from [{}] ", (Object)source), (Throwable)e);
            }
        });
    }

    private static ImmutableOpenMap<ShardId, SnapshotsInProgress.ShardSnapshotStatus> processWaitingShards(ImmutableOpenMap<ShardId, SnapshotsInProgress.ShardSnapshotStatus> snapshotShards, RoutingTable routingTable) {
        boolean snapshotChanged = false;
        ImmutableOpenMap.Builder<ShardId, SnapshotsInProgress.ShardSnapshotStatus> shards = ImmutableOpenMap.builder();
        for (ObjectObjectCursor<ShardId, SnapshotsInProgress.ShardSnapshotStatus> objectObjectCursor : snapshotShards) {
            SnapshotsInProgress.ShardSnapshotStatus shardStatus = (SnapshotsInProgress.ShardSnapshotStatus)objectObjectCursor.value;
            ShardId shardId = (ShardId)objectObjectCursor.key;
            if (shardStatus.state() == SnapshotsInProgress.ShardState.WAITING) {
                IndexShardRoutingTable shardRouting;
                IndexRoutingTable indexShardRoutingTable = routingTable.index(shardId.getIndex());
                if (indexShardRoutingTable != null && (shardRouting = indexShardRoutingTable.shard(shardId.id())) != null && shardRouting.primaryShard() != null) {
                    if (shardRouting.primaryShard().started()) {
                        snapshotChanged = true;
                        logger.trace("starting shard that we were waiting for [{}] on node [{}]", (Object)shardId, (Object)shardStatus.nodeId());
                        shards.put(shardId, new SnapshotsInProgress.ShardSnapshotStatus(shardRouting.primaryShard().currentNodeId(), shardStatus.generation()));
                        continue;
                    }
                    if (shardRouting.primaryShard().initializing() || shardRouting.primaryShard().relocating()) {
                        shards.put(shardId, shardStatus);
                        continue;
                    }
                }
                snapshotChanged = true;
                logger.warn("failing snapshot of shard [{}] on unassigned shard [{}]", (Object)shardId, (Object)shardStatus.nodeId());
                shards.put(shardId, new SnapshotsInProgress.ShardSnapshotStatus(shardStatus.nodeId(), SnapshotsInProgress.ShardState.FAILED, "shard is unassigned", shardStatus.generation()));
                continue;
            }
            shards.put(shardId, shardStatus);
        }
        if (snapshotChanged) {
            return shards.build();
        }
        return null;
    }

    private static boolean waitingShardsStartedOrUnassigned(SnapshotsInProgress snapshotsInProgress, ClusterChangedEvent event) {
        for (SnapshotsInProgress.Entry entry : snapshotsInProgress.entries()) {
            if (entry.state() != SnapshotsInProgress.State.STARTED) continue;
            for (ObjectCursor index : entry.waitingIndices().keys()) {
                if (!event.indexRoutingTableChanged((String)index.value)) continue;
                IndexRoutingTable indexShardRoutingTable = event.state().getRoutingTable().index((String)index.value);
                if (indexShardRoutingTable == null) {
                    return true;
                }
                for (ShardId shardId : entry.waitingIndices().get((String)index.value)) {
                    ShardRouting shardRouting = indexShardRoutingTable.shard(shardId.id()).primaryShard();
                    if (shardRouting == null || !shardRouting.started() && !shardRouting.unassigned()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean removedNodesCleanupNeeded(SnapshotsInProgress snapshotsInProgress, List<DiscoveryNode> removedNodes) {
        if (removedNodes.isEmpty()) return false;
        if (!snapshotsInProgress.entries().stream().flatMap(snapshot -> StreamSupport.stream(((Iterable)() -> snapshot.shards().valuesIt()).spliterator(), false).filter(s -> !s.state().completed()).map(SnapshotsInProgress.ShardSnapshotStatus::nodeId)).anyMatch(removedNodes.stream().map(DiscoveryNode::getId).collect(Collectors.toSet())::contains)) return false;
        return true;
    }

    private static Tuple<Set<String>, Set<String>> indicesWithMissingShards(ImmutableOpenMap<ShardId, SnapshotsInProgress.ShardSnapshotStatus> shards, Metadata metadata) {
        HashSet<String> missing = new HashSet<String>();
        HashSet<String> closed = new HashSet<String>();
        for (ObjectObjectCursor<ShardId, SnapshotsInProgress.ShardSnapshotStatus> objectObjectCursor : shards) {
            if (((SnapshotsInProgress.ShardSnapshotStatus)objectObjectCursor.value).state() != SnapshotsInProgress.ShardState.MISSING) continue;
            if (metadata.hasIndex(((ShardId)objectObjectCursor.key).getIndex().getName()) && metadata.getIndexSafe(((ShardId)objectObjectCursor.key).getIndex()).getState() == IndexMetadata.State.CLOSE) {
                closed.add(((ShardId)objectObjectCursor.key).getIndex().getName());
                continue;
            }
            missing.add(((ShardId)objectObjectCursor.key).getIndex().getName());
        }
        return new Tuple(missing, closed);
    }

    private void endSnapshot(final SnapshotsInProgress.Entry entry, final Metadata metadata) {
        if (!this.endingSnapshots.add(entry.snapshot())) {
            return;
        }
        final Snapshot snapshot = entry.snapshot();
        if (entry.repositoryStateId() == -2L) {
            logger.debug("[{}] was aborted before starting", (Object)snapshot);
            this.removeSnapshotFromClusterState(entry.snapshot(), new SnapshotException(snapshot, "Aborted on initialization"), null);
            return;
        }
        this.threadPool.executor("snapshot").execute(new AbstractRunnable(){

            @Override
            protected void doRun() {
                Repository repository = SnapshotsService.this.repositoriesService.repository(snapshot.getRepository());
                String failure = entry.failure();
                logger.trace("[{}] finalizing snapshot in repository, state: [{}], failure[{}]", (Object)snapshot, (Object)entry.state(), (Object)failure);
                ArrayList<SnapshotShardFailure> shardFailures = new ArrayList<SnapshotShardFailure>();
                for (ObjectObjectCursor<ShardId, SnapshotsInProgress.ShardSnapshotStatus> objectObjectCursor : entry.shards()) {
                    ShardId shardId = (ShardId)objectObjectCursor.key;
                    SnapshotsInProgress.ShardSnapshotStatus status = (SnapshotsInProgress.ShardSnapshotStatus)objectObjectCursor.value;
                    SnapshotsInProgress.ShardState state2 = status.state();
                    if (state2.failed()) {
                        shardFailures.add(new SnapshotShardFailure(status.nodeId(), shardId, status.reason()));
                        continue;
                    }
                    if (!state2.completed()) {
                        shardFailures.add(new SnapshotShardFailure(status.nodeId(), shardId, "skipped"));
                        continue;
                    }
                    assert (state2 == SnapshotsInProgress.ShardState.SUCCESS);
                }
                ShardGenerations shardGenerations = SnapshotsService.buildGenerations(entry, metadata);
                repository.finalizeSnapshot(snapshot.getSnapshotId(), shardGenerations, entry.startTime(), failure, entry.partial() ? shardGenerations.totalShards() : entry.shards().size(), Collections.unmodifiableList(shardFailures), entry.repositoryStateId(), entry.includeGlobalState(), SnapshotsService.metadataForSnapshot(entry, metadata), entry.userMetadata(), entry.version(), state -> SnapshotsService.stateWithoutSnapshot(state, snapshot), ActionListener.wrap(result -> {
                    List completionListeners = (List)SnapshotsService.this.snapshotCompletionListeners.remove(snapshot);
                    if (completionListeners != null) {
                        try {
                            ActionListener.onResponse(completionListeners, result);
                        }
                        catch (Exception e) {
                            logger.warn("Failed to notify listeners", (Throwable)e);
                        }
                    }
                    SnapshotsService.this.endingSnapshots.remove(snapshot);
                    logger.info("snapshot [{}] completed with state [{}]", (Object)snapshot, (Object)((SnapshotInfo)result.v2()).state());
                }, this::onFailure));
            }

            @Override
            public void onFailure(Exception e) {
                Snapshot snapshot2 = entry.snapshot();
                if (ExceptionsHelper.unwrap(e, NotMasterException.class, FailedToCommitClusterStateException.class) != null) {
                    logger.debug(() -> new ParameterizedMessage("[{}] failed to update cluster state during snapshot finalization", (Object)snapshot2), (Throwable)e);
                    SnapshotsService.this.failSnapshotCompletionListeners(snapshot2, new SnapshotException(snapshot2, "Failed to update cluster state during snapshot finalization", e));
                } else {
                    logger.warn(() -> new ParameterizedMessage("[{}] failed to finalize snapshot", (Object)snapshot2), (Throwable)e);
                    SnapshotsService.this.removeSnapshotFromClusterState(snapshot2, e, null);
                }
            }
        });
    }

    private static ClusterState stateWithoutSnapshot(ClusterState state, Snapshot snapshot) {
        SnapshotsInProgress snapshots = (SnapshotsInProgress)state.custom("snapshots");
        if (snapshots != null) {
            boolean changed = false;
            ArrayList<SnapshotsInProgress.Entry> entries = new ArrayList<SnapshotsInProgress.Entry>();
            for (SnapshotsInProgress.Entry entry : snapshots.entries()) {
                if (entry.snapshot().equals(snapshot)) {
                    changed = true;
                    continue;
                }
                entries.add(entry);
            }
            if (changed) {
                return ClusterState.builder(state).putCustom("snapshots", new SnapshotsInProgress(Collections.unmodifiableList(entries))).build();
            }
        }
        return state;
    }

    private void removeSnapshotFromClusterState(final Snapshot snapshot, final Exception failure, final @Nullable CleanupAfterErrorListener listener) {
        assert (failure != null) : "Failure must be supplied";
        this.clusterService.submitStateUpdateTask("remove snapshot metadata", new ClusterStateUpdateTask(){

            @Override
            public ClusterState execute(ClusterState currentState) {
                return SnapshotsService.stateWithoutSnapshot(currentState, snapshot);
            }

            @Override
            public void onFailure(String source, Exception e) {
                logger.warn(() -> new ParameterizedMessage("[{}] failed to remove snapshot metadata", (Object)snapshot), (Throwable)e);
                SnapshotsService.this.failSnapshotCompletionListeners(snapshot, new SnapshotException(snapshot, "Failed to remove snapshot from cluster state", e));
                if (listener != null) {
                    listener.onFailure(e);
                }
            }

            @Override
            public void onNoLongerMaster(String source) {
                SnapshotsService.this.failSnapshotCompletionListeners(snapshot, ExceptionsHelper.useOrSuppress(failure, new SnapshotException(snapshot, "no longer master")));
                if (listener != null) {
                    listener.onNoLongerMaster();
                }
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                SnapshotsService.this.failSnapshotCompletionListeners(snapshot, failure);
                if (listener != null) {
                    listener.onFailure(null);
                }
            }
        });
    }

    private void failSnapshotCompletionListeners(Snapshot snapshot, Exception e) {
        List completionListeners = this.snapshotCompletionListeners.remove(snapshot);
        if (completionListeners != null) {
            try {
                ActionListener.onFailure(completionListeners, e);
            }
            catch (Exception ex) {
                logger.warn("Failed to notify listeners", (Throwable)ex);
            }
        }
        this.endingSnapshots.remove(snapshot);
    }

    public void deleteSnapshots(DeleteSnapshotRequest request, ActionListener<Void> listener) {
        final String[] snapshotNames = request.snapshots();
        final String repositoryName = request.repository();
        logger.info(() -> new ParameterizedMessage("deleting snapshots [{}] from repository [{}]", (Object)Strings.arrayToCommaDelimitedString(snapshotNames), (Object)repositoryName));
        Repository repository = this.repositoriesService.repository(repositoryName);
        repository.executeConsistentStateUpdate(repositoryData -> new ClusterStateUpdateTask(Priority.NORMAL, (RepositoryData)repositoryData, listener, request){
            private Snapshot runningSnapshot;
            private ClusterStateUpdateTask deleteFromRepoTask;
            private boolean abortedDuringInit;
            private List<SnapshotId> outstandingDeletes;
            final /* synthetic */ RepositoryData val$repositoryData;
            final /* synthetic */ ActionListener val$listener;
            final /* synthetic */ DeleteSnapshotRequest val$request;
            {
                this.val$repositoryData = repositoryData;
                this.val$listener = actionListener;
                this.val$request = deleteSnapshotRequest;
                super(priority);
                this.abortedDuringInit = false;
            }

            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                String failure;
                ImmutableOpenMap<ShardId, SnapshotsInProgress.ShardSnapshotStatus> shards;
                if (snapshotNames.length > 1 && currentState.nodes().getMinNodeVersion().before(MULTI_DELETE_VERSION)) {
                    throw new IllegalArgumentException("Deleting multiple snapshots in a single request is only supported in version [ " + MULTI_DELETE_VERSION + "] but cluster contained node of version [" + currentState.nodes().getMinNodeVersion() + "]");
                }
                SnapshotsInProgress snapshots = (SnapshotsInProgress)currentState.custom("snapshots");
                SnapshotsInProgress.Entry snapshotEntry = SnapshotsService.findInProgressSnapshot(snapshots, snapshotNames, repositoryName);
                List snapshotIds = SnapshotsService.matchingSnapshotIds(snapshotEntry == null ? null : snapshotEntry.snapshot().getSnapshotId(), this.val$repositoryData, snapshotNames, repositoryName);
                if (snapshotEntry == null) {
                    this.deleteFromRepoTask = SnapshotsService.this.createDeleteStateUpdate(snapshotIds, repositoryName, this.val$repositoryData.getGenId(), Priority.NORMAL, this.val$listener);
                    return this.deleteFromRepoTask.execute(currentState);
                }
                this.runningSnapshot = snapshotEntry.snapshot();
                SnapshotsInProgress.State state = snapshotEntry.state();
                this.outstandingDeletes = new ArrayList<SnapshotId>(snapshotIds);
                if (state != SnapshotsInProgress.State.INIT) {
                    this.outstandingDeletes.add(this.runningSnapshot.getSnapshotId());
                }
                if (state == SnapshotsInProgress.State.INIT) {
                    shards = snapshotEntry.shards();
                    assert (shards.isEmpty());
                    failure = "Snapshot was aborted during initialization";
                    this.abortedDuringInit = true;
                } else if (state == SnapshotsInProgress.State.STARTED) {
                    ImmutableOpenMap.Builder<ShardId, SnapshotsInProgress.ShardSnapshotStatus> shardsBuilder = ImmutableOpenMap.builder();
                    for (ObjectObjectCursor<ShardId, SnapshotsInProgress.ShardSnapshotStatus> objectObjectCursor : snapshotEntry.shards()) {
                        SnapshotsInProgress.ShardSnapshotStatus status = (SnapshotsInProgress.ShardSnapshotStatus)objectObjectCursor.value;
                        if (!status.state().completed()) {
                            status = new SnapshotsInProgress.ShardSnapshotStatus(status.nodeId(), SnapshotsInProgress.ShardState.ABORTED, "aborted by snapshot deletion", status.generation());
                        }
                        shardsBuilder.put((ShardId)objectObjectCursor.key, status);
                    }
                    shards = shardsBuilder.build();
                    failure = "Snapshot was aborted by deletion";
                } else {
                    boolean hasUncompletedShards = false;
                    for (ObjectCursor objectCursor : snapshotEntry.shards().values()) {
                        if (((SnapshotsInProgress.ShardSnapshotStatus)objectCursor.value).state().completed() || ((SnapshotsInProgress.ShardSnapshotStatus)objectCursor.value).nodeId() == null || currentState.nodes().get(((SnapshotsInProgress.ShardSnapshotStatus)objectCursor.value).nodeId()) == null) continue;
                        hasUncompletedShards = true;
                        break;
                    }
                    if (hasUncompletedShards) {
                        logger.debug("trying to delete completed snapshot - should wait for shards to finalize on all nodes");
                        return currentState;
                    }
                    logger.debug("trying to delete completed snapshot with no finalizing shards - can delete immediately");
                    shards = snapshotEntry.shards();
                    failure = snapshotEntry.failure();
                }
                return ClusterState.builder(currentState).putCustom("snapshots", new SnapshotsInProgress(snapshots.entries().stream().map(existing -> {
                    if (existing.equals(snapshotEntry)) {
                        return new SnapshotsInProgress.Entry(snapshotEntry, SnapshotsInProgress.State.ABORTED, shards, failure);
                    }
                    return existing;
                }).collect(Collectors.toList()))).build();
            }

            @Override
            public void onFailure(String source, Exception e) {
                this.val$listener.onFailure(e);
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                if (this.deleteFromRepoTask != null) {
                    assert (this.outstandingDeletes == null) : "Shouldn't have outstanding deletes after already starting delete task";
                    this.deleteFromRepoTask.clusterStateProcessed(source, oldState, newState);
                    return;
                }
                logger.trace("adding snapshot completion listener to wait for deleted snapshot to finish");
                SnapshotsService.this.addListener(this.runningSnapshot, ActionListener.wrap(result -> {
                    logger.debug("deleted snapshot completed - deleting files");
                    SnapshotsService.this.clusterService.submitStateUpdateTask("delete snapshot", SnapshotsService.this.createDeleteStateUpdate(this.outstandingDeletes, repositoryName, ((RepositoryData)result.v1()).getGenId(), Priority.IMMEDIATE, this.val$listener));
                }, e -> {
                    if (this.abortedDuringInit) {
                        logger.info("Successfully aborted snapshot [{}]", (Object)this.runningSnapshot);
                        if (this.outstandingDeletes.isEmpty()) {
                            this.val$listener.onResponse(null);
                        } else {
                            SnapshotsService.this.clusterService.submitStateUpdateTask("delete snapshot", SnapshotsService.this.createDeleteStateUpdate(this.outstandingDeletes, repositoryName, this.val$repositoryData.getGenId(), Priority.IMMEDIATE, this.val$listener));
                        }
                    } else if (ExceptionsHelper.unwrap(e, NotMasterException.class, FailedToCommitClusterStateException.class) != null) {
                        logger.warn("master failover before deleted snapshot could complete", (Throwable)e);
                        this.val$listener.onFailure((Exception)e);
                    } else {
                        logger.warn("deleted snapshot failed", (Throwable)e);
                        this.val$listener.onFailure(new SnapshotMissingException(this.runningSnapshot.getRepository(), this.runningSnapshot.getSnapshotId(), (Throwable)e));
                    }
                }));
            }

            @Override
            public TimeValue timeout() {
                return this.val$request.masterNodeTimeout();
            }
        }, "delete snapshot", listener::onFailure);
    }

    private static List<SnapshotId> matchingSnapshotIds(@Nullable SnapshotId inProgress, RepositoryData repositoryData, String[] snapshotsOrPatterns, String repositoryName) {
        Map allSnapshotIds = repositoryData.getSnapshotIds().stream().collect(Collectors.toMap(SnapshotId::getName, Function.identity()));
        HashSet<SnapshotId> foundSnapshots = new HashSet<SnapshotId>();
        for (String snapshotOrPattern : snapshotsOrPatterns) {
            if (Regex.isSimpleMatchPattern(snapshotOrPattern)) {
                for (Map.Entry entry : allSnapshotIds.entrySet()) {
                    if (!Regex.simpleMatch(snapshotOrPattern, entry.getKey())) continue;
                    foundSnapshots.add((SnapshotId)entry.getValue());
                }
                continue;
            }
            SnapshotId foundId = (SnapshotId)allSnapshotIds.get(snapshotOrPattern);
            if (foundId == null) {
                if (inProgress != null && inProgress.getName().equals(snapshotOrPattern)) continue;
                throw new SnapshotMissingException(repositoryName, snapshotOrPattern);
            }
            foundSnapshots.add((SnapshotId)allSnapshotIds.get(snapshotOrPattern));
        }
        return Collections.unmodifiableList(new ArrayList(foundSnapshots));
    }

    @Nullable
    private static SnapshotsInProgress.Entry findInProgressSnapshot(@Nullable SnapshotsInProgress snapshots, String[] snapshotNames, String repositoryName) {
        if (snapshots == null) {
            return null;
        }
        SnapshotsInProgress.Entry snapshotEntry = null;
        for (SnapshotsInProgress.Entry entry : snapshots.entries()) {
            if (!entry.repository().equals(repositoryName) || !Regex.simpleMatch(snapshotNames, entry.snapshot().getSnapshotId().getName())) continue;
            snapshotEntry = entry;
            break;
        }
        return snapshotEntry;
    }

    private ClusterStateUpdateTask createDeleteStateUpdate(final List<SnapshotId> snapshotIds, final String repoName, final long repositoryStateId, Priority priority, final ActionListener<Void> listener) {
        if (snapshotIds.isEmpty()) {
            return new ClusterStateUpdateTask(){

                @Override
                public ClusterState execute(ClusterState currentState) {
                    return currentState;
                }

                @Override
                public void onFailure(String source, Exception e) {
                    listener.onFailure(e);
                }

                @Override
                public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                    listener.onResponse(null);
                }
            };
        }
        return new ClusterStateUpdateTask(priority){

            @Override
            public ClusterState execute(ClusterState currentState) {
                SnapshotsInProgress snapshots;
                Object entry2;
                SnapshotDeletionsInProgress deletionsInProgress = (SnapshotDeletionsInProgress)currentState.custom("snapshot_deletions");
                if (deletionsInProgress != null && deletionsInProgress.hasDeletionsInProgress()) {
                    throw new ConcurrentSnapshotExecutionException(new Snapshot(repoName, (SnapshotId)snapshotIds.get(0)), "cannot delete - another snapshot is currently being deleted in [" + deletionsInProgress + "]");
                }
                RepositoryCleanupInProgress repositoryCleanupInProgress = (RepositoryCleanupInProgress)currentState.custom("repository_cleanup");
                if (repositoryCleanupInProgress != null && repositoryCleanupInProgress.hasCleanupInProgress()) {
                    throw new ConcurrentSnapshotExecutionException(new Snapshot(repoName, (SnapshotId)snapshotIds.get(0)), "cannot delete snapshots while a repository cleanup is in-progress in [" + repositoryCleanupInProgress + "]");
                }
                RestoreInProgress restoreInProgress = (RestoreInProgress)currentState.custom("restore");
                if (restoreInProgress != null) {
                    for (Object entry2 : restoreInProgress) {
                        if (!repoName.equals(((RestoreInProgress.Entry)entry2).snapshot().getRepository()) || !snapshotIds.contains(((RestoreInProgress.Entry)entry2).snapshot().getSnapshotId())) continue;
                        throw new ConcurrentSnapshotExecutionException(new Snapshot(repoName, (SnapshotId)snapshotIds.get(0)), "cannot delete snapshot during a restore in progress in [" + restoreInProgress + "]");
                    }
                }
                if ((snapshots = (SnapshotsInProgress)currentState.custom("snapshots")) != null && !snapshots.entries().isEmpty()) {
                    throw new ConcurrentSnapshotExecutionException(repoName, snapshotIds.toString(), "another snapshot is currently running cannot delete");
                }
                entry2 = new SnapshotDeletionsInProgress.Entry(snapshotIds, repoName, SnapshotsService.this.threadPool.absoluteTimeInMillis(), repositoryStateId);
                deletionsInProgress = deletionsInProgress != null ? deletionsInProgress.withAddedEntry((SnapshotDeletionsInProgress.Entry)entry2) : SnapshotDeletionsInProgress.newInstance((SnapshotDeletionsInProgress.Entry)entry2);
                return ClusterState.builder(currentState).putCustom("snapshot_deletions", deletionsInProgress).build();
            }

            @Override
            public void onFailure(String source, Exception e) {
                listener.onFailure(e);
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                SnapshotsService.this.deleteSnapshotsFromRepository(repoName, snapshotIds, listener, repositoryStateId, newState.nodes().getMinNodeVersion());
            }
        };
    }

    public Version minCompatibleVersion(Version minNodeVersion, String repositoryName, RepositoryData repositoryData, @Nullable Collection<SnapshotId> excluded) {
        Version minCompatVersion = minNodeVersion;
        Collection<SnapshotId> snapshotIds = repositoryData.getSnapshotIds();
        Repository repository = this.repositoriesService.repository(repositoryName);
        for (SnapshotId snapshotId : snapshotIds.stream().filter(excluded == null ? sn -> true : sn -> !excluded.contains(sn)).collect(Collectors.toList())) {
            Version known = repositoryData.getVersion(snapshotId);
            if (known == null) {
                assert (repositoryData.shardGenerations().totalShards() == 0) : "Saw shard generations [" + repositoryData.shardGenerations() + "] but did not have versions tracked for snapshot [" + snapshotId + "]";
                try {
                    Version foundVersion = repository.getSnapshotInfo(snapshotId).version();
                    if (!SnapshotsService.useShardGenerations(foundVersion)) {
                        return OLD_SNAPSHOT_FORMAT;
                    }
                    minCompatVersion = minCompatVersion.before(foundVersion) ? minCompatVersion : foundVersion;
                    continue;
                }
                catch (SnapshotMissingException e) {
                    logger.warn("Failed to load snapshot metadata, assuming repository is in old format", (Throwable)e);
                    return OLD_SNAPSHOT_FORMAT;
                }
            }
            minCompatVersion = minCompatVersion.before(known) ? minCompatVersion : known;
        }
        return minCompatVersion;
    }

    public static boolean useShardGenerations(Version repositoryMetaVersion) {
        return repositoryMetaVersion.onOrAfter(SHARD_GEN_IN_REPO_DATA_VERSION);
    }

    private void deleteSnapshotsFromRepository(String repoName, Collection<SnapshotId> snapshotIds, @Nullable ActionListener<Void> listener, long repositoryStateId, Version minNodeVersion) {
        this.threadPool.executor("snapshot").execute(ActionRunnable.wrap(listener, l -> {
            Repository repository = this.repositoriesService.repository(repoName);
            repository.getRepositoryData(ActionListener.wrap(repositoryData -> repository.deleteSnapshots(snapshotIds, repositoryStateId, this.minCompatibleVersion(minNodeVersion, repoName, (RepositoryData)repositoryData, snapshotIds), ActionListener.wrap(v -> {
                logger.info("snapshots {} deleted", (Object)snapshotIds);
                this.removeSnapshotDeletionFromClusterState(snapshotIds, null, (ActionListener<Void>)l);
            }, ex -> this.removeSnapshotDeletionFromClusterState(snapshotIds, (Exception)ex, (ActionListener<Void>)l))), ex -> this.removeSnapshotDeletionFromClusterState(snapshotIds, (Exception)ex, (ActionListener<Void>)l)));
        }));
    }

    private void removeSnapshotDeletionFromClusterState(final Collection<SnapshotId> snapshotIds, final @Nullable Exception failure, final @Nullable ActionListener<Void> listener) {
        this.clusterService.submitStateUpdateTask("remove snapshot deletion metadata", new ClusterStateUpdateTask(){

            @Override
            public ClusterState execute(ClusterState currentState) {
                SnapshotDeletionsInProgress deletions = (SnapshotDeletionsInProgress)currentState.custom("snapshot_deletions");
                if (deletions != null) {
                    boolean changed = false;
                    if (deletions.hasDeletionsInProgress()) {
                        assert (deletions.getEntries().size() == 1) : "should have exactly one deletion in progress";
                        SnapshotDeletionsInProgress.Entry entry = deletions.getEntries().get(0);
                        deletions = deletions.withRemovedEntry(entry);
                        changed = true;
                    }
                    if (changed) {
                        return ClusterState.builder(currentState).putCustom("snapshot_deletions", deletions).build();
                    }
                }
                return currentState;
            }

            @Override
            public void onFailure(String source, Exception e) {
                logger.warn(() -> new ParameterizedMessage("{} failed to remove snapshot deletion metadata", (Object)snapshotIds), (Throwable)e);
                if (listener != null) {
                    listener.onFailure(e);
                }
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                if (listener != null) {
                    if (failure != null) {
                        listener.onFailure(failure);
                    } else {
                        logger.info("Successfully deleted snapshots {}", (Object)snapshotIds);
                        listener.onResponse(null);
                    }
                }
            }
        });
    }

    private static ImmutableOpenMap<ShardId, SnapshotsInProgress.ShardSnapshotStatus> shards(ClusterState clusterState, List<IndexId> indices, boolean useShardGenerations, RepositoryData repositoryData) {
        ImmutableOpenMap.Builder<ShardId, SnapshotsInProgress.ShardSnapshotStatus> builder = ImmutableOpenMap.builder();
        Metadata metadata = clusterState.metadata();
        ShardGenerations shardGenerations = repositoryData.shardGenerations();
        for (IndexId index : indices) {
            String indexName = index.getName();
            boolean isNewIndex = !repositoryData.getIndices().containsKey(indexName);
            IndexMetadata indexMetadata = metadata.index(indexName);
            if (indexMetadata == null) {
                builder.put(new ShardId(indexName, "_na_", 0), new SnapshotsInProgress.ShardSnapshotStatus(null, SnapshotsInProgress.ShardState.MISSING, "missing index", null));
                continue;
            }
            IndexRoutingTable indexRoutingTable = clusterState.getRoutingTable().index(indexName);
            for (int i = 0; i < indexMetadata.getNumberOfShards(); ++i) {
                String shardRepoGeneration;
                ShardId shardId = new ShardId(indexMetadata.getIndex(), i);
                if (useShardGenerations) {
                    if (isNewIndex) {
                        assert (shardGenerations.getShardGen(index, shardId.getId()) == null) : "Found shard generation for new index [" + index + "]";
                        shardRepoGeneration = "_new";
                    } else {
                        shardRepoGeneration = shardGenerations.getShardGen(index, shardId.getId());
                    }
                } else {
                    shardRepoGeneration = null;
                }
                if (indexRoutingTable != null) {
                    ShardRouting primary = indexRoutingTable.shard(i).primaryShard();
                    if (primary == null || !primary.assignedToNode()) {
                        builder.put(shardId, new SnapshotsInProgress.ShardSnapshotStatus(null, SnapshotsInProgress.ShardState.MISSING, "primary shard is not allocated", shardRepoGeneration));
                        continue;
                    }
                    if (primary.relocating() || primary.initializing()) {
                        builder.put(shardId, new SnapshotsInProgress.ShardSnapshotStatus(primary.currentNodeId(), SnapshotsInProgress.ShardState.WAITING, shardRepoGeneration));
                        continue;
                    }
                    if (!primary.started()) {
                        builder.put(shardId, new SnapshotsInProgress.ShardSnapshotStatus(primary.currentNodeId(), SnapshotsInProgress.ShardState.MISSING, "primary shard hasn't been started yet", shardRepoGeneration));
                        continue;
                    }
                    builder.put(shardId, new SnapshotsInProgress.ShardSnapshotStatus(primary.currentNodeId(), shardRepoGeneration));
                    continue;
                }
                builder.put(shardId, new SnapshotsInProgress.ShardSnapshotStatus(null, SnapshotsInProgress.ShardState.MISSING, "missing routing table", shardRepoGeneration));
            }
        }
        return builder.build();
    }

    public static Set<Index> snapshottingIndices(ClusterState currentState, Set<Index> indicesToCheck) {
        SnapshotsInProgress snapshots = (SnapshotsInProgress)currentState.custom("snapshots");
        if (snapshots == null) {
            return Collections.emptySet();
        }
        HashSet<Index> indices = new HashSet<Index>();
        for (SnapshotsInProgress.Entry entry : snapshots.entries()) {
            if (entry.partial()) continue;
            for (IndexId index : entry.indices()) {
                IndexMetadata indexMetadata = currentState.metadata().index(index.getName());
                if (indexMetadata == null || !indicesToCheck.contains(indexMetadata.getIndex())) continue;
                indices.add(indexMetadata.getIndex());
            }
        }
        return indices;
    }

    private void addListener(Snapshot snapshot, ActionListener<Tuple<RepositoryData, SnapshotInfo>> listener) {
        this.snapshotCompletionListeners.computeIfAbsent(snapshot, k -> new CopyOnWriteArrayList()).add(listener);
    }

    @Override
    protected void doStart() {
    }

    @Override
    protected void doStop() {
    }

    @Override
    protected void doClose() {
        this.clusterService.removeApplier(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean assertAllListenersResolved() {
        Set<Snapshot> set = this.endingSnapshots;
        synchronized (set) {
            DiscoveryNode localNode = this.clusterService.localNode();
            assert (this.endingSnapshots.isEmpty()) : "Found leaked ending snapshots " + this.endingSnapshots + " on [" + localNode + "]";
            assert (this.snapshotCompletionListeners.isEmpty()) : "Found leaked snapshot completion listeners " + this.snapshotCompletionListeners + " on [" + localNode + "]";
        }
        return true;
    }

    private static class CleanupAfterErrorListener {
        private final ActionListener<Snapshot> userCreateSnapshotListener;
        private final Exception e;

        CleanupAfterErrorListener(ActionListener<Snapshot> userCreateSnapshotListener, Exception e) {
            this.userCreateSnapshotListener = userCreateSnapshotListener;
            this.e = e;
        }

        public void onFailure(@Nullable Exception e) {
            this.userCreateSnapshotListener.onFailure(ExceptionsHelper.useOrSuppress(e, this.e));
        }

        public void onNoLongerMaster() {
            this.userCreateSnapshotListener.onFailure(this.e);
        }
    }
}

