/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.util;

import java.util.Date;
import java.util.List;
import org.kuali.rice.kew.engine.node.BranchState;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.group.GroupService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public class FutureRequestDocumentStateManager {
    private boolean receiveFutureRequests;
    private boolean doNotReceiveFutureRequests;
    private boolean clearFutureRequestState;
    public static final String FUTURE_REQUESTS_VAR_KEY = "var::_receive_future_requests";
    public static final String DEACTIVATED_REQUESTS_VARY_KEY = "var::_deactivated_future_requests";

    public FutureRequestDocumentStateManager(DocumentRouteHeaderValue document, String principalId) {
        if (document.getRootBranch() != null) {
            for (BranchState state : document.getRootBranchState()) {
                if (!this.isStateForUser(state, principalId)) continue;
                if (this.isReceiveFutureRequests(state)) {
                    this.receiveFutureRequests = true;
                    continue;
                }
                if (this.isDoNotReceiveFutureRequests(state)) {
                    this.doNotReceiveFutureRequests = true;
                    continue;
                }
                if (!this.isClearFutureRequests(state)) continue;
                this.clearFutureRequestState = true;
                this.receiveFutureRequests = false;
                this.doNotReceiveFutureRequests = false;
                break;
            }
        }
        if (this.isClearFutureRequestState()) {
            this.clearStateFromDocument(document);
        }
    }

    public FutureRequestDocumentStateManager(DocumentRouteHeaderValue document, Group kimGroup) {
        GroupService ims = KimApiServiceLocator.getGroupService();
        List principalIds = ims.getMemberPrincipalIds(kimGroup.getId());
        for (String id : principalIds) {
            FutureRequestDocumentStateManager requestStateMngr = new FutureRequestDocumentStateManager(document, id);
            if (requestStateMngr.isReceiveFutureRequests()) {
                this.receiveFutureRequests = true;
                continue;
            }
            if (!requestStateMngr.isDoNotReceiveFutureRequests()) continue;
            this.doNotReceiveFutureRequests = true;
        }
    }

    protected void clearStateFromDocument(DocumentRouteHeaderValue document) {
        if (document.getRootBranchState() != null) {
            for (BranchState state : document.getRootBranchState()) {
                if (!state.getKey().contains(FUTURE_REQUESTS_VAR_KEY)) continue;
                String[] values = state.getKey().split(",");
                state.setKey("var::_deactivated_future_requests," + values[1] + "," + new Date().toString());
            }
            KEWServiceLocator.getRouteNodeService().save(document.getRootBranch());
        }
    }

    protected boolean isStateForUser(BranchState state, String principalId) {
        String[] values = state.getKey().split(",");
        if (values.length != 4 || !values[0].contains(FUTURE_REQUESTS_VAR_KEY)) {
            return false;
        }
        String statePrincipalId = values[1];
        return principalId.equals(statePrincipalId);
    }

    protected boolean isReceiveFutureRequests(BranchState state) {
        return state.getValue().equals("YES");
    }

    protected boolean isDoNotReceiveFutureRequests(BranchState state) {
        return state.getValue().equals("NO");
    }

    protected boolean isClearFutureRequests(BranchState state) {
        return state.getValue().equals("CLEAR");
    }

    public boolean isClearFutureRequestState() {
        return this.clearFutureRequestState;
    }

    public boolean isDoNotReceiveFutureRequests() {
        return this.doNotReceiveFutureRequests;
    }

    public boolean isReceiveFutureRequests() {
        return this.receiveFutureRequests;
    }
}

