/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.excon.project;

import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.bo.AbstractPersonRoleAware;
import org.kuali.kra.excon.project.ExconProject;
import org.kuali.kra.excon.project.ExconProjectAssociate;
import org.kuali.kra.excon.project.ExconProjectComment;
import org.kuali.kra.excon.project.ExconProjectUnitContactTypeValuesFinder;

public class ExconProjectUnitPerson
extends ExconProjectAssociate
implements AbstractPersonRoleAware {
    private static final long serialVersionUID = 40636319234557985L;
    private Long projectUnitPersonId;
    private String personId;
    private Integer rolodexId;
    private String fullName;
    private String unitAdministratorTypeCode;
    private String unitAdministratorUnitNumber;
    private String userName;
    private transient KcPersonService kcPersonService;

    public Long getProjectUnitPersonId() {
        return this.projectUnitPersonId;
    }

    public void setProjectPersonId(Long projectUnitPersonId) {
        this.projectUnitPersonId = projectUnitPersonId;
    }

    @Override
    public String getPersonId() {
        return this.personId;
    }

    public void setPersonId(String personId) {
        this.personId = personId;
    }

    @Override
    public Integer getRolodexId() {
        return this.rolodexId;
    }

    public void setRolodexId(Integer rolodexId) {
        this.rolodexId = rolodexId;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public String getFullName() {
        KcPerson person;
        if (this.fullName == null && (person = this.getPerson()) != null) {
            this.fullName = person.getFullName();
        }
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getUnitAdministratorTypeCode() {
        return this.unitAdministratorTypeCode;
    }

    public void setUnitAdministratorTypeCode(String unitAdministratorTypeCode) {
        this.unitAdministratorTypeCode = unitAdministratorTypeCode;
    }

    public String getUnitAdministratorTypeName() {
        if (this.unitAdministratorTypeCode != null) {
            return new ExconProjectUnitContactTypeValuesFinder().getKeyLabel(this.unitAdministratorTypeCode);
        }
        return null;
    }

    public String getUnitAdministratorUnitNumber() {
        KcPerson person;
        if (this.unitAdministratorUnitNumber == null && (person = this.getPerson()) != null) {
            this.unitAdministratorUnitNumber = person.getUnit().getUnitNumber();
        }
        return this.unitAdministratorUnitNumber;
    }

    public void setUnitAdministratorUnitNumber(String unitAdministratorUnitNumber) {
        this.unitAdministratorUnitNumber = unitAdministratorUnitNumber;
    }

    @Override
    public void resetPersistenceState() {
        this.projectUnitPersonId = null;
        this.versionNumber = null;
    }

    public int compareTo(ExconProjectComment exconProjectCommentArg) {
        return exconProjectCommentArg.getUpdateTimestamp().compareTo(this.getUpdateTimestamp());
    }

    @Override
    public KcPerson getPerson() {
        if (this.personId != null) {
            return this.getKcPersonService().getKcPersonByPersonId(this.personId);
        }
        if (this.userName != null) {
            KcPerson person = this.getKcPersonService().getKcPersonByUserName(this.userName);
            if (person != null) {
                this.setPersonId(person.getPersonId());
            }
            return person;
        }
        return null;
    }

    public ExconProject getParent() {
        return this.getExconProject();
    }

    @Override
    public String getRoleCode() {
        return this.unitAdministratorTypeCode;
    }

    @Override
    public boolean isPrincipalInvestigator() {
        return false;
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof ExconProjectUnitPerson && ((ExconProjectUnitPerson)o).getProjectUnitPersonId().equals(this.getProjectUnitPersonId());
    }

    protected KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KcServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }
}

