/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.excon.project.service.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.kuali.kra.excon.project.ExconProject;
import org.kuali.kra.excon.project.document.ExconProjectDocument;
import org.kuali.kra.lookup.KraLookupableHelperServiceImpl;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.util.UrlFactory;

public class ExconProjectLookupableHelperServiceImpl
extends KraLookupableHelperServiceImpl {
    private static final long serialVersionUID = 6369873655376681944L;

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        super.setBackLocationDocFormKey(fieldValues);
        if (fieldValues.containsKey(ExconProject.EXCON_SEQUENCE_STATUS_PROPERTY_STRING) && "BOTH".equalsIgnoreCase(fieldValues.get(ExconProject.EXCON_SEQUENCE_STATUS_PROPERTY_STRING))) {
            fieldValues.put(ExconProject.EXCON_SEQUENCE_STATUS_PROPERTY_STRING, "ACTIVE|PENDING");
        }
        List searchResults = super.getSearchResults(fieldValues);
        return new ArrayList(searchResults.stream().sorted(Comparator.comparing(ExconProject::getProjectNumber).thenComparing(Comparator.comparing(ExconProject::getSequenceNumber).reversed())).collect(Collectors.toMap(ExconProject::getProjectNumber, Function.identity(), (p, q) -> p)).values());
    }

    @Override
    public List<HtmlData> getCustomActionUrls(BusinessObject businessObject, List pkNames) {
        List<HtmlData> htmlDataList = super.getCustomActionUrls(businessObject, pkNames);
        htmlDataList.add((HtmlData)this.getOpenLink((ExconProject)businessObject, false));
        return htmlDataList;
    }

    protected HtmlData.AnchorHtmlData getOpenLink(ExconProject exconProject, Boolean viewOnly) {
        ExconProjectDocument exconProjectDocument = exconProject.getExconProjectDocument();
        HtmlData.AnchorHtmlData htmlData = new HtmlData.AnchorHtmlData();
        htmlData.setDisplayText("open");
        Properties parameters = new Properties();
        parameters.put("methodToCall", "docHandler");
        parameters.put("command", "displayDocSearchView");
        parameters.put("docTypeName", this.getDocumentTypeName());
        parameters.put("viewDocument", viewOnly.toString());
        parameters.put("docId", exconProjectDocument.getDocumentNumber());
        String href = UrlFactory.parameterizeUrl((String)("../" + this.getHtmlAction()), (Properties)parameters);
        htmlData.setHref(href);
        return htmlData;
    }

    public List<Row> getRows() {
        List rows = super.getRows();
        for (Row row : rows) {
            for (Field field : row.getFields()) {
                if (!field.getPropertyName().equals("projectStartDate") && !field.getPropertyName().equals("projectEndDate")) continue;
                field.setDatePicker(true);
            }
        }
        return rows;
    }

    @Override
    protected void addEditHtmlData(List<HtmlData> htmlDataList, BusinessObject businessObject) {
    }

    @Override
    protected String getHtmlAction() {
        return "exconProjectHome.do";
    }

    @Override
    protected String getDocumentTypeName() {
        return "ExconProjectDocument";
    }

    @Override
    protected String getKeyFieldName() {
        return "projectId";
    }
}

