/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.geo.SpatialStrategy;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.index.mapper.AbstractShapeGeometryFieldMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.GeoPointFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.QueryShardException;

public abstract class AbstractGeometryFieldMapper
extends FieldMapper {
    protected Explicit<Boolean> ignoreMalformed;
    protected Explicit<Boolean> ignoreZValue;

    protected AbstractGeometryFieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Settings indexSettings, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> ignoreZValue, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, defaultFieldType, indexSettings, multiFields, copyTo);
        this.ignoreMalformed = ignoreMalformed;
        this.ignoreZValue = ignoreZValue;
    }

    @Override
    protected void doMerge(Mapper mergeWith) {
        super.doMerge(mergeWith);
        AbstractGeometryFieldMapper gsfm = (AbstractGeometryFieldMapper)mergeWith;
        if (gsfm.ignoreMalformed.explicit()) {
            this.ignoreMalformed = gsfm.ignoreMalformed;
        }
        if (gsfm.ignoreZValue.explicit()) {
            this.ignoreZValue = gsfm.ignoreZValue;
        }
    }

    @Override
    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        throw new UnsupportedOperationException("Parsing is implemented in parse(), this method should NEVER be called");
    }

    @Override
    public void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (includeDefaults || this.ignoreMalformed.explicit()) {
            builder.field(Names.IGNORE_MALFORMED.getPreferredName(), this.ignoreMalformed.value());
        }
        if (includeDefaults || this.ignoreZValue.explicit()) {
            builder.field(Names.IGNORE_Z_VALUE.getPreferredName(), this.ignoreZValue.value());
        }
    }

    public Explicit<Boolean> ignoreMalformed() {
        return this.ignoreMalformed;
    }

    public Explicit<Boolean> ignoreZValue() {
        return this.ignoreZValue;
    }

    public static class Names {
        public static final ParseField IGNORE_MALFORMED = new ParseField("ignore_malformed", new String[0]);
        public static final ParseField IGNORE_Z_VALUE = new ParseField("ignore_z_value", new String[0]);
    }

    public static abstract class AbstractGeometryFieldType
    extends MappedFieldType {
        protected QueryProcessor geometryQueryBuilder;

        protected AbstractGeometryFieldType() {
            this.setIndexOptions(IndexOptions.DOCS);
            this.setTokenized(false);
            this.setStored(false);
            this.setStoreTermVectors(false);
            this.setOmitNorms(true);
        }

        protected AbstractGeometryFieldType(AbstractGeometryFieldType ref) {
            super(ref);
        }

        public void setGeometryQueryBuilder(QueryProcessor geometryQueryBuilder) {
            this.geometryQueryBuilder = geometryQueryBuilder;
        }

        public QueryProcessor geometryQueryBuilder() {
            return this.geometryQueryBuilder;
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            return new TermQuery(new Term("_field_names", this.name()));
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            throw new QueryShardException(context, "Geometry fields do not support exact searching, use dedicated geometry queries instead: [" + this.name() + "]", new Object[0]);
        }

        public static interface QueryProcessor {
            public Query process(Geometry var1, String var2, ShapeRelation var3, QueryShardContext var4);

            @Deprecated
            default public Query process(Geometry shape, String fieldName, SpatialStrategy strategy, ShapeRelation relation, QueryShardContext context) {
                return this.process(shape, fieldName, relation, context);
            }
        }
    }

    public static abstract class TypeParser<T extends Builder>
    implements Mapper.TypeParser {
        protected abstract T newBuilder(String var1, Map<String, Object> var2);

        public T parse(String name, Map<String, Object> node, Map<String, Object> params, Mapper.TypeParser.ParserContext parserContext) {
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String propName = entry.getKey();
                Object propNode = entry.getValue();
                if (Names.IGNORE_MALFORMED.match(propName, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE)) {
                    params.put(Names.IGNORE_MALFORMED.getPreferredName(), XContentMapValues.nodeBooleanValue(propNode, name + ".ignore_malformed"));
                    iterator.remove();
                    continue;
                }
                if (!Names.IGNORE_Z_VALUE.getPreferredName().equals(propName)) continue;
                params.put(GeoPointFieldMapper.Names.IGNORE_Z_VALUE.getPreferredName(), XContentMapValues.nodeBooleanValue(propNode, name + "." + Names.IGNORE_Z_VALUE.getPreferredName()));
                iterator.remove();
            }
            T builder = this.newBuilder(name, params);
            if (params.containsKey(GeoPointFieldMapper.Names.IGNORE_Z_VALUE.getPreferredName())) {
                ((Builder)builder).ignoreZValue((Boolean)params.get(GeoPointFieldMapper.Names.IGNORE_Z_VALUE.getPreferredName()));
            }
            if (params.containsKey(Names.IGNORE_MALFORMED.getPreferredName())) {
                ((Builder)builder).ignoreMalformed((Boolean)params.get(Names.IGNORE_MALFORMED.getPreferredName()));
            }
            return builder;
        }

        public T parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            HashMap<String, Object> params = new HashMap<String, Object>();
            return this.parse(name, node, params, parserContext);
        }
    }

    public static abstract class Builder<T extends Builder, Y extends AbstractGeometryFieldMapper>
    extends FieldMapper.Builder<T, Y> {
        protected Boolean ignoreMalformed;
        protected Boolean ignoreZValue;

        public Builder(String name, MappedFieldType fieldType, MappedFieldType defaultFieldType) {
            super(name, fieldType, defaultFieldType);
        }

        public Builder(String name, MappedFieldType fieldType, MappedFieldType defaultFieldType, boolean ignoreMalformed, boolean ignoreZValue) {
            super(name, fieldType, defaultFieldType);
            this.ignoreMalformed = ignoreMalformed;
            this.ignoreZValue = ignoreZValue;
        }

        public Builder ignoreMalformed(boolean ignoreMalformed) {
            this.ignoreMalformed = ignoreMalformed;
            return this;
        }

        protected Explicit<Boolean> ignoreMalformed(Mapper.BuilderContext context) {
            if (this.ignoreMalformed != null) {
                return new Explicit<Boolean>(this.ignoreMalformed, true);
            }
            if (context.indexSettings() != null) {
                return new Explicit<Boolean>(FieldMapper.IGNORE_MALFORMED_SETTING.get(context.indexSettings()), false);
            }
            return Defaults.IGNORE_MALFORMED;
        }

        public Explicit<Boolean> ignoreMalformed() {
            if (this.ignoreMalformed != null) {
                return new Explicit<Boolean>(this.ignoreMalformed, true);
            }
            return AbstractShapeGeometryFieldMapper.Defaults.IGNORE_MALFORMED;
        }

        protected Explicit<Boolean> ignoreZValue(Mapper.BuilderContext context) {
            if (this.ignoreZValue != null) {
                return new Explicit<Boolean>(this.ignoreZValue, true);
            }
            return Defaults.IGNORE_Z_VALUE;
        }

        public Explicit<Boolean> ignoreZValue() {
            if (this.ignoreZValue != null) {
                return new Explicit<Boolean>(this.ignoreZValue, true);
            }
            return AbstractShapeGeometryFieldMapper.Defaults.IGNORE_Z_VALUE;
        }

        public Builder ignoreZValue(boolean ignoreZValue) {
            this.ignoreZValue = ignoreZValue;
            return this;
        }

        @Override
        protected void setupFieldType(Mapper.BuilderContext context) {
            super.setupFieldType(context);
            if (this.name().isEmpty()) {
                throw new IllegalArgumentException("name cannot be empty string");
            }
        }
    }

    public static class Defaults {
        public static final Explicit<Boolean> IGNORE_MALFORMED = new Explicit<Boolean>(false, false);
        public static final Explicit<Boolean> IGNORE_Z_VALUE = new Explicit<Boolean>(true, false);
    }
}

