/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search;

import java.io.Closeable;
import java.io.IOException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.queryparser.classic.Token;
import org.apache.lucene.queryparser.classic.XQueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SynonymQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanOrQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.mapper.FieldNamesFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.ExistsQueryBuilder;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.support.QueryParsers;
import org.elasticsearch.index.search.MatchQuery;
import org.elasticsearch.index.search.MultiMatchQuery;
import org.elasticsearch.index.search.QueryParserHelper;

public class QueryStringQueryParser
extends XQueryParser {
    private static final String EXISTS_FIELD = "_exists_";
    private final QueryShardContext context;
    private final Map<String, Float> fieldsAndWeights;
    private final boolean lenient;
    private final MultiMatchQuery queryBuilder;
    private MultiMatchQueryBuilder.Type type = MultiMatchQueryBuilder.Type.BEST_FIELDS;
    private Float groupTieBreaker;
    private Analyzer forceAnalyzer;
    private Analyzer forceQuoteAnalyzer;
    private String quoteFieldSuffix;
    private boolean analyzeWildcard;
    private ZoneId timeZone;
    private Fuzziness fuzziness = Fuzziness.AUTO;
    private int fuzzyMaxExpansions = 50;
    private MultiTermQuery.RewriteMethod fuzzyRewriteMethod;
    private boolean fuzzyTranspositions = true;

    public QueryStringQueryParser(QueryShardContext context, String defaultField) {
        this(context, defaultField, Collections.emptyMap(), false, context.getMapperService().searchAnalyzer());
    }

    public QueryStringQueryParser(QueryShardContext context, String defaultField, boolean lenient) {
        this(context, defaultField, Collections.emptyMap(), lenient, context.getMapperService().searchAnalyzer());
    }

    public QueryStringQueryParser(QueryShardContext context, Map<String, Float> fieldsAndWeights) {
        this(context, null, fieldsAndWeights, false, context.getMapperService().searchAnalyzer());
    }

    public QueryStringQueryParser(QueryShardContext context, Map<String, Float> fieldsAndWeights, boolean lenient) {
        this(context, null, fieldsAndWeights, lenient, context.getMapperService().searchAnalyzer());
    }

    public QueryStringQueryParser(QueryShardContext context, boolean lenient) {
        this(context, "*", QueryParserHelper.resolveMappingField(context, "*", 1.0f, false, false, null), lenient, context.getMapperService().searchAnalyzer());
    }

    private QueryStringQueryParser(QueryShardContext context, String defaultField, Map<String, Float> fieldsAndWeights, boolean lenient, Analyzer analyzer) {
        super(defaultField, analyzer);
        this.context = context;
        this.fieldsAndWeights = Collections.unmodifiableMap(fieldsAndWeights);
        this.queryBuilder = new MultiMatchQuery(context);
        this.queryBuilder.setZeroTermsQuery(MatchQuery.ZeroTermsQuery.NULL);
        this.queryBuilder.setLenient(lenient);
        this.lenient = lenient;
    }

    public void setEnablePositionIncrements(boolean enable) {
        super.setEnablePositionIncrements(enable);
        this.queryBuilder.setEnablePositionIncrements(enable);
    }

    public void setDefaultOperator(QueryParser.Operator op) {
        super.setDefaultOperator(op);
        this.queryBuilder.setOccur(op == QueryParser.Operator.AND ? BooleanClause.Occur.MUST : BooleanClause.Occur.SHOULD);
    }

    public void setPhraseSlop(int phraseSlop) {
        super.setPhraseSlop(phraseSlop);
        this.queryBuilder.setPhraseSlop(phraseSlop);
    }

    public void setType(MultiMatchQueryBuilder.Type type) {
        this.type = type;
    }

    public void setFuzziness(Fuzziness fuzziness) {
        this.fuzziness = fuzziness;
    }

    public void setFuzzyRewriteMethod(MultiTermQuery.RewriteMethod fuzzyRewriteMethod) {
        this.fuzzyRewriteMethod = fuzzyRewriteMethod;
    }

    public void setFuzzyMaxExpansions(int fuzzyMaxExpansions) {
        this.fuzzyMaxExpansions = fuzzyMaxExpansions;
    }

    public void setForceAnalyzer(Analyzer analyzer) {
        this.forceAnalyzer = analyzer;
    }

    public void setForceQuoteAnalyzer(Analyzer analyzer) {
        this.forceQuoteAnalyzer = analyzer;
    }

    public void setQuoteFieldSuffix(String quoteFieldSuffix) {
        this.quoteFieldSuffix = quoteFieldSuffix;
    }

    public void setAnalyzeWildcard(boolean analyzeWildcard) {
        this.analyzeWildcard = analyzeWildcard;
    }

    public void setTimeZone(ZoneId timeZone) {
        this.timeZone = timeZone;
    }

    public void setGroupTieBreaker(float groupTieBreaker) {
        this.queryBuilder.setTieBreaker(groupTieBreaker);
        this.groupTieBreaker = Float.valueOf(groupTieBreaker);
    }

    public void setAutoGenerateMultiTermSynonymsPhraseQuery(boolean enable) {
        this.queryBuilder.setAutoGenerateSynonymsPhraseQuery(enable);
    }

    public void setFuzzyTranspositions(boolean fuzzyTranspositions) {
        this.fuzzyTranspositions = fuzzyTranspositions;
    }

    private Query applyBoost(Query q, Float boost) {
        if (boost != null && boost.floatValue() != 1.0f) {
            return new BoostQuery(q, boost.floatValue());
        }
        return q;
    }

    private Map<String, Float> extractMultiFields(String field, boolean quoted) {
        Map<String, Float> extractedFields;
        if (field != null) {
            boolean allFields = Regex.isMatchAllPattern(field);
            if (allFields && this.field != null && this.field.equals(field)) {
                Map<String, Float> map = this.fieldsAndWeights;
            }
            boolean multiFields = Regex.isSimpleMatchPattern(field);
            extractedFields = QueryParserHelper.resolveMappingField(this.context, field, 1.0f, !allFields, !multiFields, quoted ? this.quoteFieldSuffix : null);
        } else {
            extractedFields = quoted && this.quoteFieldSuffix != null ? QueryParserHelper.resolveMappingFields(this.context, this.fieldsAndWeights, this.quoteFieldSuffix) : this.fieldsAndWeights;
        }
        QueryParserHelper.checkForTooManyFields(extractedFields.size(), this.context, field);
        return extractedFields;
    }

    protected Query newMatchAllDocsQuery() {
        return Queries.newMatchAllQuery();
    }

    public Query getFieldQuery(String field, String queryText, boolean quoted) throws ParseException {
        Map<String, Float> fields;
        if (field != null && EXISTS_FIELD.equals(field)) {
            return this.existsQuery(queryText);
        }
        if (quoted) {
            return this.getFieldQuery(field, queryText, this.getPhraseSlop());
        }
        if (field != null && queryText.length() > 1) {
            if (queryText.charAt(0) == '>') {
                if (queryText.length() > 2 && queryText.charAt(1) == '=') {
                    return this.getRangeQuery(field, queryText.substring(2), null, true, true);
                }
                return this.getRangeQuery(field, queryText.substring(1), null, false, true);
            }
            if (queryText.charAt(0) == '<') {
                if (queryText.length() > 2 && queryText.charAt(1) == '=') {
                    return this.getRangeQuery(field, null, queryText.substring(2), true, true);
                }
                return this.getRangeQuery(field, null, queryText.substring(1), true, false);
            }
            if (this.context.fieldMapper(field) instanceof DateFieldMapper.DateFieldType && this.timeZone != null) {
                return this.getRangeQuery(field, queryText, queryText, true, true);
            }
        }
        if ((fields = this.extractMultiFields(field, quoted)).isEmpty()) {
            return Queries.newUnmappedFieldQuery(field);
        }
        Analyzer oldAnalyzer = this.queryBuilder.analyzer;
        try {
            if (this.forceAnalyzer != null) {
                this.queryBuilder.setAnalyzer(this.forceAnalyzer);
            }
            Query query = this.queryBuilder.parse(this.type, fields, queryText, null);
            return query;
        }
        catch (IOException e) {
            throw new ParseException(e.getMessage());
        }
        finally {
            this.queryBuilder.setAnalyzer(oldAnalyzer);
        }
    }

    protected Query getFieldQuery(String field, String queryText, int slop) throws ParseException {
        if (field != null && EXISTS_FIELD.equals(field)) {
            return this.existsQuery(queryText);
        }
        Map<String, Float> fields = this.extractMultiFields(field, true);
        if (fields.isEmpty()) {
            return Queries.newUnmappedFieldQuery(field);
        }
        Analyzer oldAnalyzer = this.queryBuilder.analyzer;
        int oldSlop = this.queryBuilder.phraseSlop;
        try {
            if (this.forceQuoteAnalyzer != null) {
                this.queryBuilder.setAnalyzer(this.forceQuoteAnalyzer);
            } else if (this.forceAnalyzer != null) {
                this.queryBuilder.setAnalyzer(this.forceAnalyzer);
            }
            this.queryBuilder.setPhraseSlop(slop);
            Query query = this.queryBuilder.parse(MultiMatchQueryBuilder.Type.PHRASE, fields, queryText, null);
            if (query == null) {
                Query query2 = null;
                return query2;
            }
            Query query3 = this.applySlop(query, slop);
            return query3;
        }
        catch (IOException e) {
            throw new ParseException(e.getMessage());
        }
        finally {
            this.queryBuilder.setAnalyzer(oldAnalyzer);
            this.queryBuilder.setPhraseSlop(oldSlop);
        }
    }

    protected Query getRangeQuery(String field, String part1, String part2, boolean startInclusive, boolean endInclusive) throws ParseException {
        Map<String, Float> fields;
        if ("*".equals(part1)) {
            part1 = null;
        }
        if ("*".equals(part2)) {
            part2 = null;
        }
        if ((fields = this.extractMultiFields(field, false)).isEmpty()) {
            return Queries.newUnmappedFieldQuery(field);
        }
        ArrayList<Query> queries = new ArrayList<Query>();
        for (Map.Entry<String, Float> entry : fields.entrySet()) {
            Query q = this.getRangeQuerySingle(entry.getKey(), part1, part2, startInclusive, endInclusive, this.context);
            assert (q != null);
            queries.add(this.applyBoost(q, entry.getValue()));
        }
        if (queries.size() == 1) {
            return (Query)queries.get(0);
        }
        float tiebreaker = this.groupTieBreaker == null ? this.type.tieBreaker() : this.groupTieBreaker.floatValue();
        return new DisjunctionMaxQuery(queries, tiebreaker);
    }

    private Query getRangeQuerySingle(String field, String part1, String part2, boolean startInclusive, boolean endInclusive, QueryShardContext context) {
        MappedFieldType currentFieldType = context.fieldMapper(field);
        if (currentFieldType == null) {
            return Queries.newUnmappedFieldQuery(field);
        }
        try {
            Analyzer normalizer = this.forceAnalyzer == null ? this.queryBuilder.context.getSearchAnalyzer(currentFieldType) : this.forceAnalyzer;
            BytesRef part1Binary = part1 == null ? null : normalizer.normalize(field, part1);
            BytesRef part2Binary = part2 == null ? null : normalizer.normalize(field, part2);
            Query rangeQuery = currentFieldType.rangeQuery(part1Binary, part2Binary, startInclusive, endInclusive, null, this.timeZone, null, context);
            return rangeQuery;
        }
        catch (RuntimeException e) {
            if (this.lenient) {
                return Queries.newLenientFieldQuery(field, e);
            }
            throw e;
        }
    }

    @Override
    protected Query handleBareFuzzy(String field, Token fuzzySlop, String termImage) throws ParseException {
        if (fuzzySlop.image.length() == 1) {
            return this.getFuzzyQuery(field, termImage, this.fuzziness.asDistance(termImage));
        }
        float distance = Fuzziness.build(fuzzySlop.image.substring(1)).asDistance(termImage);
        return this.getFuzzyQuery(field, termImage, distance);
    }

    protected Query getFuzzyQuery(String field, String termStr, float minSimilarity) throws ParseException {
        Map<String, Float> fields = this.extractMultiFields(field, false);
        if (fields.isEmpty()) {
            return Queries.newUnmappedFieldQuery(field);
        }
        ArrayList<Query> queries = new ArrayList<Query>();
        for (Map.Entry<String, Float> entry : fields.entrySet()) {
            Query q = this.getFuzzyQuerySingle(entry.getKey(), termStr, minSimilarity);
            assert (q != null);
            queries.add(this.applyBoost(q, entry.getValue()));
        }
        if (queries.size() == 1) {
            return (Query)queries.get(0);
        }
        float tiebreaker = this.groupTieBreaker == null ? this.type.tieBreaker() : this.groupTieBreaker.floatValue();
        return new DisjunctionMaxQuery(queries, tiebreaker);
    }

    private Query getFuzzyQuerySingle(String field, String termStr, float minSimilarity) throws ParseException {
        MappedFieldType currentFieldType = this.context.fieldMapper(field);
        if (currentFieldType == null) {
            return Queries.newUnmappedFieldQuery(field);
        }
        try {
            Analyzer normalizer = this.forceAnalyzer == null ? this.queryBuilder.context.getSearchAnalyzer(currentFieldType) : this.forceAnalyzer;
            BytesRef term = termStr == null ? null : normalizer.normalize(field, termStr);
            return currentFieldType.fuzzyQuery(term, Fuzziness.fromEdits((int)minSimilarity), this.getFuzzyPrefixLength(), this.fuzzyMaxExpansions, this.fuzzyTranspositions, this.context);
        }
        catch (RuntimeException e) {
            if (this.lenient) {
                return Queries.newLenientFieldQuery(field, e);
            }
            throw e;
        }
    }

    protected Query newFuzzyQuery(Term term, float minimumSimilarity, int prefixLength) {
        int numEdits = Fuzziness.build(Float.valueOf(minimumSimilarity)).asDistance(term.text());
        FuzzyQuery query = new FuzzyQuery(term, numEdits, prefixLength, this.fuzzyMaxExpansions, this.fuzzyTranspositions);
        QueryParsers.setRewriteMethod((MultiTermQuery)query, this.fuzzyRewriteMethod);
        return query;
    }

    protected Query getPrefixQuery(String field, String termStr) throws ParseException {
        Map<String, Float> fields = this.extractMultiFields(field, false);
        if (fields.isEmpty()) {
            return Queries.newUnmappedFieldQuery(termStr);
        }
        ArrayList<Query> queries = new ArrayList<Query>();
        for (Map.Entry<String, Float> entry : fields.entrySet()) {
            Query q = this.getPrefixQuerySingle(entry.getKey(), termStr);
            if (q == null) continue;
            queries.add(this.applyBoost(q, entry.getValue()));
        }
        if (queries.isEmpty()) {
            return null;
        }
        if (queries.size() == 1) {
            return (Query)queries.get(0);
        }
        float tiebreaker = this.groupTieBreaker == null ? this.type.tieBreaker() : this.groupTieBreaker.floatValue();
        return new DisjunctionMaxQuery(queries, tiebreaker);
    }

    private Query getPrefixQuerySingle(String field, String termStr) throws ParseException {
        Analyzer oldAnalyzer = this.getAnalyzer();
        try {
            MappedFieldType currentFieldType = this.context.fieldMapper(field);
            if (currentFieldType == null) {
                Query query = Queries.newUnmappedFieldQuery(field);
                return query;
            }
            this.setAnalyzer(this.forceAnalyzer == null ? this.queryBuilder.context.getSearchAnalyzer(currentFieldType) : this.forceAnalyzer);
            Query query = null;
            query = !currentFieldType.tokenized() ? currentFieldType.prefixQuery(termStr, this.getMultiTermRewriteMethod(), this.context) : this.getPossiblyAnalyzedPrefixQuery(currentFieldType.name(), termStr, currentFieldType);
            Query query2 = query;
            return query2;
        }
        catch (RuntimeException e) {
            if (this.lenient) {
                Query query = Queries.newLenientFieldQuery(field, e);
                return query;
            }
            throw e;
        }
        finally {
            this.setAnalyzer(oldAnalyzer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Query getPossiblyAnalyzedPrefixQuery(String field, String termStr, MappedFieldType currentFieldType) throws ParseException {
        ArrayList tlist;
        block26: {
            if (!this.analyzeWildcard) {
                return currentFieldType.prefixQuery(this.getAnalyzer().normalize(field, termStr).utf8ToString(), this.getMultiTermRewriteMethod(), this.context);
            }
            TokenStream source = null;
            try {
                try {
                    source = this.getAnalyzer().tokenStream(field, termStr);
                    source.reset();
                }
                catch (IOException e) {
                    Query query = super.getPrefixQuery(field, termStr);
                    if (source != null) {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{source});
                    }
                    return query;
                }
            }
            catch (Throwable throwable) {
                if (source != null) {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{source});
                }
                throw throwable;
            }
            {
                block25: {
                    tlist = new ArrayList();
                    ArrayList<String> currentPos = new ArrayList<String>();
                    CharTermAttribute termAtt = (CharTermAttribute)source.addAttribute(CharTermAttribute.class);
                    PositionIncrementAttribute posAtt = (PositionIncrementAttribute)source.addAttribute(PositionIncrementAttribute.class);
                    while (true) {
                        block24: {
                            try {
                                if (!source.incrementToken()) {
                                }
                                break block24;
                            }
                            catch (IOException e) {}
                            if (!currentPos.isEmpty()) {
                                break;
                            }
                            break block25;
                        }
                        if (!currentPos.isEmpty() && posAtt.getPositionIncrement() > 0) {
                            tlist.add(currentPos);
                            currentPos = new ArrayList();
                        }
                        currentPos.add(termAtt.toString());
                    }
                    tlist.add(currentPos);
                }
                if (source == null) break block26;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{source});
        }
        if (tlist.size() == 0) {
            return null;
        }
        if (tlist.size() == 1 && ((List)tlist.get(0)).size() == 1) {
            return currentFieldType.prefixQuery((String)((List)tlist.get(0)).get(0), this.getMultiTermRewriteMethod(), this.context);
        }
        ArrayList<BooleanClause> clauses = new ArrayList<BooleanClause>();
        int pos = 0;
        while (pos < tlist.size()) {
            Query posQuery;
            boolean isLastPos;
            List plist = (List)tlist.get(pos);
            boolean bl = isLastPos = pos == tlist.size() - 1;
            if (plist.size() == 1) {
                posQuery = isLastPos ? currentFieldType.prefixQuery((String)plist.get(0), this.getMultiTermRewriteMethod(), this.context) : this.newTermQuery(new Term(field, (String)plist.get(0)), 1.0f);
            } else if (!isLastPos) {
                Term[] terms = new Term[plist.size()];
                for (int i = 0; i < plist.size(); ++i) {
                    terms[i] = new Term(field, (String)plist.get(i));
                }
                posQuery = new SynonymQuery(terms);
            } else {
                ArrayList<BooleanClause> innerClauses = new ArrayList<BooleanClause>();
                for (String token : plist) {
                    innerClauses.add(new BooleanClause(super.getPrefixQuery(field, token), BooleanClause.Occur.SHOULD));
                }
                posQuery = this.getBooleanQuery(innerClauses);
            }
            clauses.add(new BooleanClause(posQuery, this.getDefaultOperator() == QueryParser.Operator.AND ? BooleanClause.Occur.MUST : BooleanClause.Occur.SHOULD));
            ++pos;
        }
        return this.getBooleanQuery(clauses);
    }

    private Query existsQuery(String fieldName) {
        FieldNamesFieldMapper.FieldNamesFieldType fieldNamesFieldType = (FieldNamesFieldMapper.FieldNamesFieldType)this.context.getMapperService().fieldType("_field_names");
        if (fieldNamesFieldType == null) {
            return new MatchNoDocsQuery("No mappings yet");
        }
        if (!fieldNamesFieldType.isEnabled()) {
            return new WildcardQuery(new Term(fieldName, "*"));
        }
        return ExistsQueryBuilder.newFilter(this.context, fieldName, false);
    }

    protected Query getWildcardQuery(String field, String termStr) throws ParseException {
        String actualField;
        String string = actualField = field != null ? field : this.field;
        if (termStr.equals("*") && actualField != null) {
            if (Regex.isMatchAllPattern(actualField)) {
                return this.newMatchAllDocsQuery();
            }
            return this.existsQuery(actualField);
        }
        Map<String, Float> fields = this.extractMultiFields(field, false);
        if (fields.isEmpty()) {
            return Queries.newUnmappedFieldQuery(termStr);
        }
        ArrayList<Query> queries = new ArrayList<Query>();
        for (Map.Entry<String, Float> entry : fields.entrySet()) {
            Query q = this.getWildcardQuerySingle(entry.getKey(), termStr);
            assert (q != null);
            queries.add(this.applyBoost(q, entry.getValue()));
        }
        if (queries.size() == 1) {
            return (Query)queries.get(0);
        }
        float tiebreaker = this.groupTieBreaker == null ? this.type.tieBreaker() : this.groupTieBreaker.floatValue();
        return new DisjunctionMaxQuery(queries, tiebreaker);
    }

    private Query getWildcardQuerySingle(String field, String termStr) throws ParseException {
        if ("*".equals(termStr)) {
            return this.existsQuery(field);
        }
        String indexedNameField = field;
        Analyzer oldAnalyzer = this.getAnalyzer();
        try {
            MappedFieldType currentFieldType = this.queryBuilder.context.fieldMapper(field);
            if (currentFieldType != null) {
                this.setAnalyzer(this.forceAnalyzer == null ? this.queryBuilder.context.getSearchAnalyzer(currentFieldType) : this.forceAnalyzer);
                indexedNameField = currentFieldType.name();
            }
            Query query = super.getWildcardQuery(indexedNameField, termStr);
            return query;
        }
        catch (RuntimeException e) {
            if (this.lenient) {
                Query query = Queries.newLenientFieldQuery(field, e);
                return query;
            }
            throw e;
        }
        finally {
            this.setAnalyzer(oldAnalyzer);
        }
    }

    protected Query getRegexpQuery(String field, String termStr) throws ParseException {
        int maxAllowedRegexLength = this.context.getIndexSettings().getMaxRegexLength();
        if (termStr.length() > maxAllowedRegexLength) {
            throw new IllegalArgumentException("The length of regex [" + termStr.length() + "] used in the [query_string] has exceeded the allowed maximum of [" + maxAllowedRegexLength + "]. This maximum can be set by changing the [" + IndexSettings.MAX_REGEX_LENGTH_SETTING.getKey() + "] index level setting.");
        }
        Map<String, Float> fields = this.extractMultiFields(field, false);
        if (fields.isEmpty()) {
            return Queries.newUnmappedFieldQuery(termStr);
        }
        ArrayList<Query> queries = new ArrayList<Query>();
        for (Map.Entry<String, Float> entry : fields.entrySet()) {
            Query q = this.getRegexpQuerySingle(entry.getKey(), termStr);
            assert (q != null);
            queries.add(this.applyBoost(q, entry.getValue()));
        }
        if (queries.size() == 1) {
            return (Query)queries.get(0);
        }
        float tiebreaker = this.groupTieBreaker == null ? this.type.tieBreaker() : this.groupTieBreaker.floatValue();
        return new DisjunctionMaxQuery(queries, tiebreaker);
    }

    private Query getRegexpQuerySingle(String field, String termStr) throws ParseException {
        Analyzer oldAnalyzer = this.getAnalyzer();
        try {
            Query query;
            MappedFieldType currentFieldType = this.queryBuilder.context.fieldMapper(field);
            if (currentFieldType == null) {
                Query query2 = Queries.newUnmappedFieldQuery(field);
                return query2;
            }
            this.setAnalyzer(this.forceAnalyzer == null ? this.queryBuilder.context.getSearchAnalyzer(currentFieldType) : this.forceAnalyzer);
            Query query3 = query = super.getRegexpQuery(field, termStr);
            return query3;
        }
        catch (RuntimeException e) {
            if (this.lenient) {
                Query query = Queries.newLenientFieldQuery(field, e);
                return query;
            }
            throw e;
        }
        finally {
            this.setAnalyzer(oldAnalyzer);
        }
    }

    protected Query getBooleanQuery(List<BooleanClause> clauses) throws ParseException {
        Query q = super.getBooleanQuery(clauses);
        if (q == null) {
            return null;
        }
        return Queries.fixNegativeQueryIfNeeded(q);
    }

    private Query applySlop(Query q, int slop) {
        if (q instanceof PhraseQuery) {
            assert (!(q instanceof BoostQuery));
            return this.addSlopToPhrase((PhraseQuery)q, slop);
        }
        if (q instanceof MultiPhraseQuery) {
            MultiPhraseQuery.Builder builder = new MultiPhraseQuery.Builder((MultiPhraseQuery)q);
            builder.setSlop(slop);
            return builder.build();
        }
        if (q instanceof SpanQuery) {
            return this.addSlopToSpan((SpanQuery)q, slop);
        }
        return q;
    }

    private Query addSlopToSpan(SpanQuery query, int slop) {
        if (query instanceof SpanNearQuery) {
            return new SpanNearQuery(((SpanNearQuery)query).getClauses(), slop, ((SpanNearQuery)query).isInOrder());
        }
        if (query instanceof SpanOrQuery) {
            SpanQuery[] clauses = new SpanQuery[((SpanOrQuery)query).getClauses().length];
            int pos = 0;
            for (SpanQuery clause : ((SpanOrQuery)query).getClauses()) {
                clauses[pos++] = (SpanQuery)this.addSlopToSpan(clause, slop);
            }
            return new SpanOrQuery(clauses);
        }
        return query;
    }

    private PhraseQuery addSlopToPhrase(PhraseQuery query, int slop) {
        PhraseQuery.Builder builder = new PhraseQuery.Builder();
        builder.setSlop(slop);
        Term[] terms = query.getTerms();
        int[] positions = query.getPositions();
        for (int i = 0; i < terms.length; ++i) {
            builder.add(terms[i], positions[i]);
        }
        return builder.build();
    }

    public Query parse(String query) throws ParseException {
        if (query.trim().isEmpty()) {
            return Queries.newMatchNoDocsQuery("Matching no documents because no terms present");
        }
        return super.parse(query);
    }
}

