/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.document;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.coi.framework.Project;
import org.kuali.coeus.coi.framework.ProjectPublisher;
import org.kuali.coeus.coi.framework.ProjectRetrievalService;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.BudgetParentDocument;
import org.kuali.coeus.common.framework.auth.perm.Permissionable;
import org.kuali.coeus.common.framework.auth.task.Task;
import org.kuali.coeus.common.framework.custom.DocumentCustomData;
import org.kuali.coeus.common.framework.krms.KcKrmsFactBuilderService;
import org.kuali.coeus.common.framework.krms.KrmsRulesContext;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.coeus.common.framework.version.history.VersionHistoryService;
import org.kuali.coeus.sys.framework.controller.DocHandlerService;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.workflow.KcWorkflowService;
import org.kuali.kra.award.awardhierarchy.sync.service.AwardSyncService;
import org.kuali.kra.award.budget.AwardBudgetExt;
import org.kuali.kra.award.contacts.AwardPerson;
import org.kuali.kra.award.contacts.AwardPersonCreditSplit;
import org.kuali.kra.award.contacts.AwardPersonUnit;
import org.kuali.kra.award.document.authorization.AwardTask;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardComment;
import org.kuali.kra.award.home.AwardService;
import org.kuali.kra.award.home.fundingproposal.AwardFundingProposal;
import org.kuali.kra.award.infrastructure.AwardPermissionConstants;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTerm;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTermRecipient;
import org.kuali.kra.award.specialreview.AwardSpecialReview;
import org.kuali.kra.award.version.service.AwardVersionService;
import org.kuali.kra.external.award.AwardAccountService;
import org.kuali.kra.institutionalproposal.ProposalStatus;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalBoLite;
import org.kuali.kra.institutionalproposal.service.InstitutionalProposalService;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.coreservice.framework.parameter.ParameterConstants;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteLevelChange;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.kns.web.ui.ExtraButton;
import org.kuali.rice.krad.document.Copyable;
import org.kuali.rice.krad.document.SessionDocument;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;
import org.kuali.rice.krad.rules.rule.event.SaveDocumentEvent;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krms.api.engine.Facts;

@ParameterConstants.NAMESPACE(namespace="KC-AWARD")
@ParameterConstants.COMPONENT(component="Document")
public class AwardDocument
extends BudgetParentDocument<Award>
implements Copyable,
SessionDocument,
KrmsRulesContext {
    private static final Logger LOG = LogManager.getLogger(AwardDocument.class);
    public static final String PLACEHOLDER_DOC_DESCRIPTION = "*****PLACEHOLDER*****";
    private static final long serialVersionUID = 1668673531338660064L;
    public static final String DOCUMENT_TYPE_CODE = "AWRD";
    private static final String DEFAULT_TAB = "Versions";
    private static final String ALTERNATE_OPEN_TAB = "Parameters";
    private List<Award> awardList;
    private List<AwardBudgetExt> budgets;
    private static final String RETURN_TO_AWARD_ALT_TEXT = "return to award";
    private static final String RETURN_TO_AWARD_METHOD_TO_CALL = "methodToCall.returnToAward";
    private static final String KRA_EXTERNALIZABLE_IMAGES_URI_KEY = "kra.externalizable.images.url";
    private static final String HAS_SYNC_SPLITNODE = "hasSync";
    private static final String IS_SYNC_CHILD_SPLITNODE = "isSyncChild";
    private transient boolean documentSaveAfterVersioning;
    private transient AwardService awardService;
    private transient BusinessObjectService businessObjectService;
    private transient ProjectRetrievalService projectRetrievalService;
    private transient ProjectPublisher projectPublisher;
    private transient AwardAccountService awardAccountService;
    private transient AwardVersionService awardVersionService;

    public AwardDocument() {
        this.init();
    }

    public Award getAward() {
        return this.awardList.size() > 0 ? this.awardList.get(0) : new Award();
    }

    public void setAward(Award award) {
        this.awardList.set(0, award);
    }

    public List<Award> getAwardList() {
        return this.awardList;
    }

    public void setAwardList(List<Award> awardList) {
        this.awardList = awardList;
    }

    @Override
    public KcPersistableBusinessObjectBase getBusinessObject() {
        return this.getAward();
    }

    @Override
    public String getDocumentTypeCode() {
        return DOCUMENT_TYPE_CODE;
    }

    public boolean isDocumentSaveAfterVersioning() {
        return this.documentSaveAfterVersioning;
    }

    public void setDocumentSaveAfterAwardLookupEditOrVersion(boolean documentSaveAfterVersioning) {
        this.documentSaveAfterVersioning = documentSaveAfterVersioning;
    }

    public List buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        Award award = this.getAward();
        this.addAwardPersonUnitsCollection(managedLists, award);
        managedLists.add(award.getProjectPersons());
        managedLists.add(award.getAwardUnitContacts());
        managedLists.add(award.getSponsorContacts());
        managedLists.add(award.getAwardCostShares());
        managedLists.add(award.getApprovedEquipmentItems());
        managedLists.add(award.getApprovedForeignTravelTrips());
        managedLists.add(award.getAwardFandaRate());
        managedLists.add(this.getAward().getAwardSponsorTerms());
        managedLists.add(award.getPaymentScheduleItems());
        managedLists.add(award.getAwardTransferringSponsors());
        managedLists.add(award.getAwardDirectFandADistributions());
        managedLists.add(award.getAwardApprovedSubawards());
        managedLists.add(award.getAwardCloseoutItems());
        managedLists.add(award.getAwardAttachments());
        ArrayList specialReviewExemptions = new ArrayList();
        for (AwardSpecialReview specialReview : this.getAward().getSpecialReviews()) {
            specialReviewExemptions.addAll(specialReview.getSpecialReviewExemptions());
        }
        managedLists.add(specialReviewExemptions);
        managedLists.add(award.getSpecialReviews());
        List<AwardReportTerm> reportTerms = award.getAwardReportTermItems();
        ArrayList<AwardReportTermRecipient> recipients = new ArrayList<AwardReportTermRecipient>();
        for (AwardReportTerm reportTerm : reportTerms) {
            recipients.addAll(reportTerm.getAwardReportTermRecipients());
        }
        managedLists.add(recipients);
        managedLists.add(reportTerms);
        managedLists.add(award.getFundingProposals());
        managedLists.add(award.getAwardCfdas());
        managedLists.add(this.awardList);
        return managedLists;
    }

    @Override
    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        this.executeAsLastActionUser(() -> {
            super.doRouteStatusChange(statusChangeEvent);
            String newStatus = statusChangeEvent.getNewRouteStatus();
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("********************* Status Change: from %s to %s", statusChangeEvent.getOldRouteStatus(), newStatus));
            }
            if ("F".equalsIgnoreCase(newStatus) || "P".equalsIgnoreCase(newStatus)) {
                this.getAwardService().updateAwardSequenceStatus(this.getAward(), VersionStatus.ACTIVE);
                this.getVersionHistoryService().updateVersionHistory(this.getAward(), VersionStatus.ACTIVE, GlobalVariables.getUserSession().getPrincipalName());
                if ("P".equalsIgnoreCase(newStatus)) {
                    this.autoPostAward(this.getAward().getAwardId(), this.getAward().getAccountNumber(), this.getAward().getAwardNumber(), this.getDocumentNumber(), Boolean.TRUE);
                }
            }
            if (newStatus.equalsIgnoreCase("X") || newStatus.equalsIgnoreCase("D")) {
                this.revertFundedProposals();
                this.disableAwardComments();
                this.getAwardService().updateAwardSequenceStatus(this.getAward(), VersionStatus.CANCELED);
                this.getVersionHistoryService().updateVersionHistory(this.getAward(), VersionStatus.CANCELED, GlobalVariables.getUserSession().getPrincipalName());
            }
            for (Award award : this.awardList) {
                award.setAwardDocument(this);
            }
            this.publishProject(this.getAward().getAwardNumber());
            this.rePublishCurrentActiveAward(newStatus, this.getAward().getAwardNumber());
            return null;
        });
    }

    public void publishProject(String awardNumber) {
        Project project = this.getProjectRetrievalService().retrieveProject(awardNumber);
        if (project != null) {
            this.getProjectPublisher().publishProject(project);
        }
    }

    public Project rePublishCurrentActiveAward(String newStatus, String awardNumber) throws SQLException {
        Award activeAward;
        Project project = null;
        if (newStatus.equalsIgnoreCase("X") && Objects.nonNull(activeAward = this.getAwardVersionService().getActiveAwardVersion(awardNumber)) && (project = this.getProjectRetrievalService().convertObjectToProject(activeAward)) != null) {
            this.getProjectPublisher().publishProject(project);
        }
        return project;
    }

    protected boolean isAutoPostAward() {
        return this.getParameterService().getParameterValueAsBoolean("KC-AWARD", "All", "AWARD_AUTO_POST_ENABLED");
    }

    protected void autoPostAward(Long awardId, String accountNumber, String awardNumber, String documentNumber, boolean postAward) {
        if (accountNumber != null && this.isAutoPostAward() && this.getAwardAccountService().isFinancialRestApiEnabled()) {
            this.getAwardService().addPostEntry(awardId, accountNumber, awardNumber, documentNumber, postAward);
        }
    }

    public void doRouteLevelChange(DocumentRouteLevelChange levelChangeEvent) {
        this.executeAsLastActionUser(() -> {
            if (StringUtils.equalsIgnoreCase((CharSequence)levelChangeEvent.getNewNodeName(), (CharSequence)"SyncValidationApproval") && !this.getAward().getSyncChanges().isEmpty()) {
                this.getAwardSyncService().validateHierarchyChanges(this.getAward());
            } else if (StringUtils.equalsIgnoreCase((CharSequence)levelChangeEvent.getNewNodeName(), (CharSequence)"ApplySync") && !this.getAward().getSyncChanges().isEmpty()) {
                this.getAwardSyncService().applyAwardSyncChangesToHierarchy(this.getAward());
            }
            this.publishProject(this.getAward().getAwardNumber());
            return null;
        });
    }

    @Override
    public boolean answerSplitNodeQuestion(String routeNodeName) {
        LOG.debug("Processing answerSplitNodeQuestion:" + routeNodeName);
        if (StringUtils.equals((CharSequence)HAS_SYNC_SPLITNODE, (CharSequence)routeNodeName)) {
            return !this.getAward().getSyncChanges().isEmpty();
        }
        if (StringUtils.equals((CharSequence)IS_SYNC_CHILD_SPLITNODE, (CharSequence)routeNodeName)) {
            return this.getAward().isSyncChild();
        }
        return super.answerSplitNodeQuestion(routeNodeName);
    }

    protected void init() {
        this.awardList = new ArrayList<Award>();
        this.awardList.add(new Award());
        this.budgets = new ArrayList<AwardBudgetExt>();
    }

    public void prepareForSave() {
        Award award;
        super.prepareForSave();
        if (this.getVersionNumber() == null) {
            this.setVersionNumber(0L);
        }
        if (this.getBudgetDocumentVersions() != null) {
            this.updateDocumentDescriptions(this.getAward().getBudgets());
        }
        if (!(award = this.getAward()).getProjectPersons().isEmpty()) {
            List<AwardPerson> aList = award.getProjectPersonsSorted();
            award.getProjectPersons().clear();
            award.getProjectPersons().addAll(aList);
            this.removeKeyPersonRoleForNoneKeyPerson();
        }
    }

    public void updateDocumentDescriptions(List<AwardBudgetExt> budgets) {
        for (Budget budget : budgets) {
            if (!budget.isNameUpdatable() || StringUtils.isBlank((CharSequence)budget.getName())) continue;
            budget.setNameUpdatable(false);
        }
    }

    void removeKeyPersonRoleForNoneKeyPerson() {
        for (AwardPerson person : this.getAward().getProjectPersons()) {
            if (person.getContactRole() == null || StringUtils.equalsIgnoreCase((CharSequence)person.getContactRole().getRoleCode(), (CharSequence)"KP") || !StringUtils.isNotEmpty((CharSequence)person.getKeyPersonRole())) continue;
            person.setKeyPersonRole(null);
        }
    }

    @Override
    public void postProcessSave(DocumentEvent event) {
        if (event instanceof SaveDocumentEvent) {
            this.updateFundedProposals();
        }
    }

    private void updateFundedProposals() {
        HashSet<String> modifiedProposals = new HashSet<String>();
        for (AwardFundingProposal afp : this.getAward().getFundingProposals()) {
            InstitutionalProposalBoLite proposal = afp.getProposal();
            if (ProposalStatus.FUNDED.equals(proposal.getStatusCode())) continue;
            modifiedProposals.add(proposal.getProposalNumber());
        }
        if (modifiedProposals.size() > 0) {
            this.getInstitutionalProposalService().fundInstitutionalProposals(modifiedProposals).forEach(ip -> {
                List<AwardFundingProposal> removedFundingProposals = this.getAward().removeFundingProposals(ip.getProposalNumber());
                this.getBusinessObjectService().delete(removedFundingProposals);
                this.getAward().add((InstitutionalProposal)ip);
            });
        }
    }

    private void addAwardPersonUnitsCollection(List managedLists, Award award) {
        ArrayList<AwardPersonUnit> personUnits = new ArrayList<AwardPersonUnit>();
        ArrayList<AwardPersonCreditSplit> personSplits = new ArrayList<AwardPersonCreditSplit>();
        for (AwardPerson p : award.getProjectPersons()) {
            personUnits.addAll(p.getUnits());
            personSplits.addAll(p.getCreditSplits());
        }
        managedLists.add(personUnits);
        managedLists.add(personSplits);
    }

    public boolean isAuthorizedToPostAward(String principalId) {
        return this.isInStateToBePosted() && this.hasPostAwardPermission(principalId);
    }

    public boolean isInStateToBePosted() {
        return this.isPostAwardFeatureEnabled() && this.getDocumentHeader().getWorkflowDocument().isFinal() && !this.getAward().isPosted();
    }

    public boolean hasPostAwardPermission(String principalId) {
        return this.getPermissionService().hasPermission(principalId, "KC-SYS", AwardPermissionConstants.POST_AWARD.getAwardPermission());
    }

    protected AwardAccountService getAwardAccountService() {
        if (this.awardAccountService == null) {
            this.awardAccountService = KcServiceLocator.getService(AwardAccountService.class);
        }
        return this.awardAccountService;
    }

    protected boolean isPostAwardFeatureEnabled() {
        return this.getAwardAccountService().isFinancialRestApiEnabled();
    }

    protected VersionHistoryService getVersionHistoryService() {
        return KcServiceLocator.getService(VersionHistoryService.class);
    }

    protected AwardSyncService getAwardSyncService() {
        return KcServiceLocator.getService(AwardSyncService.class);
    }

    public List<AwardBudgetExt> getBudgetDocumentVersions() {
        return this.getAward().getBudgets();
    }

    public List<AwardBudgetExt> getBudgets() {
        return this.budgets;
    }

    public void setBudgets(List<AwardBudgetExt> budgets) {
        this.budgets = budgets;
    }

    @Override
    public String getDocumentKey() {
        return "award";
    }

    @Override
    public String getDocumentNumberForPermission() {
        return this.getAward().getAwardId().toString();
    }

    @Override
    public List<String> getRoleNames() {
        return new ArrayList<String>();
    }

    @Override
    public Permissionable getBudgetPermissionable() {
        return new Permissionable(){

            @Override
            public String getDocumentKey() {
                return "awardbudget";
            }

            @Override
            public String getDocumentNumberForPermission() {
                return AwardDocument.this.getAward().getAwardId().toString();
            }

            @Override
            public List<String> getRoleNames() {
                return new ArrayList<String>();
            }

            @Override
            public String getNamespace() {
                return "KC-AWARD";
            }

            @Override
            public String getLeadUnitNumber() {
                return AwardDocument.this.getAward().getLeadUnitNumber();
            }

            @Override
            public String getDocumentRoleTypeCode() {
                return "KC-AWARD";
            }

            @Override
            public void populateAdditionalQualifiedRoleAttributes(Map<String, String> qualifiedRoleAttributes) {
            }
        };
    }

    public String getTaskGroupName() {
        return "awardBudget";
    }

    @Override
    public ExtraButton configureReturnToParentTopButton() {
        ExtraButton returnToProposalButton = new ExtraButton();
        returnToProposalButton.setExtraButtonProperty(RETURN_TO_AWARD_METHOD_TO_CALL);
        returnToProposalButton.setExtraButtonSource(this.buildExtraButtonSourceURI("tinybutton-returntoaward.gif"));
        returnToProposalButton.setExtraButtonAltText(RETURN_TO_AWARD_ALT_TEXT);
        return returnToProposalButton;
    }

    private String buildExtraButtonSourceURI(String buttonFileName) {
        return this.lookupKualiConfigurationService().getPropertyValueAsString(KRA_EXTERNALIZABLE_IMAGES_URI_KEY) + buttonFileName;
    }

    private ConfigurationService lookupKualiConfigurationService() {
        return CoreApiServiceLocator.getKualiConfigurationService();
    }

    @Override
    public Award getBudgetParent() {
        return this.getAward();
    }

    @Override
    public Budget getBudgetDocumentVersion(int selectedLine) {
        return this.getBudgetParent().getBudgets().get(selectedLine);
    }

    public Task getParentAuthZTask(String taskName) {
        return new AwardTask(taskName, this.getAward());
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    public boolean isEditable() {
        WorkflowDocument workflowDoc = this.getDocumentHeader().getWorkflowDocument();
        return workflowDoc.isInitiated() || workflowDoc.isSaved();
    }

    public boolean isSaved() {
        return this.getDocumentHeader().getWorkflowDocument().isSaved();
    }

    @Override
    public String getDocumentBoNumber() {
        return this.getAward().getAwardNumber();
    }

    @Override
    public String getNamespace() {
        return "KC-AWARD";
    }

    @Override
    public String getLeadUnitNumber() {
        return this.getAward().getLeadUnitNumber();
    }

    @Override
    public String getDocumentRoleTypeCode() {
        return "KC-AWARD";
    }

    public String getProposalBudgetFlag() {
        return "false";
    }

    public boolean getCanModify() {
        HashMap<String, String> qualifications = new HashMap<String, String>();
        qualifications.put("unitNumber", this.getLeadUnitNumber());
        return this.getPermissionService().isAuthorized(GlobalVariables.getUserSession().getPrincipalId(), "KC-AWARD", "Modify Award", qualifications);
    }

    protected PermissionService getPermissionService() {
        return KcServiceLocator.getService(PermissionService.class);
    }

    protected InstitutionalProposalService getInstitutionalProposalService() {
        return KcServiceLocator.getService(InstitutionalProposalService.class);
    }

    public AwardBudgetExt getBudgetVersionOverview() {
        AwardBudgetExt budget = new AwardBudgetExt();
        List<AwardBudgetExt> awardBudgetDocuments = this.getBudgetDocumentVersions();
        for (AwardBudgetExt version : awardBudgetDocuments) {
            if (version == null || budget.getBudgetVersionNumber() != null && (budget.getBudgetVersionNumber() == null || version.getBudgetVersionNumber() <= budget.getBudgetVersionNumber())) continue;
            budget = version;
        }
        return budget;
    }

    public boolean isPlaceHolderDocument() {
        if (this.getDocumentHeader() != null) {
            return PLACEHOLDER_DOC_DESCRIPTION.equals(this.getDocumentHeader().getDocumentDescription());
        }
        return false;
    }

    private void revertFundedProposals() {
        HashSet<String> proposalsToUpdate = new HashSet<String>();
        for (AwardFundingProposal awardFundingProposal : this.getAward().getFundingProposals()) {
            proposalsToUpdate.add(awardFundingProposal.getProposal().getProposalNumber());
        }
        this.getInstitutionalProposalService().defundInstitutionalProposals(proposalsToUpdate, this.getAward().getAwardNumber(), this.getAward().getSequenceNumber());
        this.getBusinessObjectService().delete(this.getAward().getFundingProposals());
        this.getAward().getFundingProposals().clear();
    }

    private void disableAwardComments() {
        for (AwardComment awardComment : this.getAward().getAwardComments()) {
            awardComment.disableComment();
        }
    }

    @Override
    public boolean isProcessComplete() {
        boolean isComplete = false;
        if (this.getDocumentHeader().hasWorkflowDocument()) {
            if (this.getDocumentHeader().getWorkflowDocument().isFinal() || this.getDocumentHeader().getWorkflowDocument().isProcessed() || KcServiceLocator.getService(KcWorkflowService.class).hasPendingApprovalRequests(this.getDocumentHeader().getWorkflowDocument())) {
                isComplete = true;
            } else if (!this.getAward().getSyncChanges().isEmpty() && this.getAward().getSyncStatuses().size() > 1) {
                isComplete = true;
            }
        }
        return isComplete;
    }

    @Override
    public void afterWorkflowEngineProcess(boolean success) {
        if (CollectionUtils.isNotEmpty(this.getAwardList())) {
            this.getAwardList().get(0);
        }
        super.afterWorkflowEngineProcess(success);
    }

    public void refreshBudgetDocumentVersions() {
        this.budgets.clear();
    }

    public AwardService getAwardService() {
        if (this.awardService == null) {
            this.awardService = KcServiceLocator.getService(AwardService.class);
        }
        return this.awardService;
    }

    public void setAwardService(AwardService awardService) {
        this.awardService = awardService;
    }

    @Override
    public void populateContextQualifiers(Map<String, String> qualifiers) {
        qualifiers.put("namespaceCode", this.getNamespace());
        qualifiers.put("name", this.getRuleContextName());
    }

    @Override
    public void addFacts(Facts.Builder factsBuilder) {
        KcKrmsFactBuilderService fbService = (KcKrmsFactBuilderService)KcServiceLocator.getService("awardFactBuilderService");
        fbService.addFacts(factsBuilder, this);
    }

    public String getRuleContextName() {
        return "KC Award Context";
    }

    @Override
    public void populateAgendaQualifiers(Map<String, String> qualifiers) {
        qualifiers.put("Unit Number", this.getLeadUnitNumber());
    }

    public String buildForwardUrl() {
        DocHandlerService researchDocumentService = KcServiceLocator.getService(DocHandlerService.class);
        Object forward = researchDocumentService.getDocHandlerUrl(this.getDocumentNumber());
        forward = !((String)(forward = ((String)forward).replaceFirst(DEFAULT_TAB, ALTERNATE_OPEN_TAB))).contains("?") ? (String)forward + "?" : (String)forward + "&";
        forward = (String)forward + "docId=" + this.documentNumber;
        forward = (String)forward + "&command=displayDocSearchView";
        if (GlobalVariables.getUserSession().isBackdoorInUse()) {
            forward = (String)forward + "&backdoorId=" + GlobalVariables.getUserSession().getPrincipalName();
        }
        return "<a href=\"" + (String)forward + "\"target=\"_blank\">" + this.documentNumber + "</a>";
    }

    @Override
    public List<? extends DocumentCustomData> getDocumentCustomData() {
        return this.getAward().getAwardCustomDataList();
    }

    public boolean isCanceled() {
        WorkflowDocument workflow = this.getDocumentHeader().getWorkflowDocument();
        return workflow.isCanceled();
    }

    public BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public ProjectPublisher getProjectPublisher() {
        if (this.projectPublisher == null) {
            this.projectPublisher = KcServiceLocator.getService(ProjectPublisher.class);
        }
        return this.projectPublisher;
    }

    public AwardVersionService getAwardVersionService() {
        if (this.awardVersionService == null) {
            this.awardVersionService = KcServiceLocator.getService(AwardVersionService.class);
        }
        return this.awardVersionService;
    }

    public void setAwardVersionService(AwardVersionService awardVersionService) {
        this.awardVersionService = awardVersionService;
    }

    public void setProjectPublisher(ProjectPublisher projectPublisher) {
        this.projectPublisher = projectPublisher;
    }

    public ProjectRetrievalService getProjectRetrievalService() {
        if (this.projectRetrievalService == null) {
            this.projectRetrievalService = (ProjectRetrievalService)KcServiceLocator.getService("awardProjectRetrievalService");
        }
        return this.projectRetrievalService;
    }

    public void setProjectRetrievalService(ProjectRetrievalService projectRetrievalService) {
        this.projectRetrievalService = projectRetrievalService;
    }

    @Override
    public Map<String, String> getKrmsRoleQualifiers() {
        HashMap<String, String> qualifiers = new HashMap<String, String>();
        qualifiers.put("award", this.getAward().getAwardId().toString());
        return qualifiers;
    }
}

