/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.lookup.keyvalue;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.util.ValuesFinderUtils;
import org.kuali.kra.bo.NsfCode;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.uif.control.UifKeyValuesFinderBase;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="nsfCodeFinder")
public class NsfCodeFinder
extends UifKeyValuesFinderBase {
    @Autowired
    @Qualifier(value="businessObjectService")
    private transient BusinessObjectService businessObjectService;

    public List<KeyValue> getKeyValues() {
        return Stream.concat(Stream.of(ValuesFinderUtils.getSelectOption()), this.getBusinessObjectService().findAll(NsfCode.class).stream().map(nsfCode -> new ConcreteKeyValue(nsfCode.getNsfSequenceNumber().toString(), nsfCode.getDescription()))).collect(Collectors.toList());
    }

    public BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

