/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.util.documentserializer;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.DataDictionary;
import org.kuali.rice.krad.datadictionary.DocumentEntry;
import org.kuali.rice.krad.datadictionary.WorkflowProperties;
import org.kuali.rice.krad.datadictionary.WorkflowProperty;
import org.kuali.rice.krad.datadictionary.WorkflowPropertyGroup;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.util.documentserializer.PropertySerializabilityEvaluator;
import org.kuali.rice.krad.util.documentserializer.PropertySerializabilityEvaluatorBase;
import org.kuali.rice.krad.util.documentserializer.PropertySerializerTrie;

public class BusinessObjectPropertySerializibilityEvaluator
extends PropertySerializabilityEvaluatorBase
implements PropertySerializabilityEvaluator {
    @Override
    public void initializeEvaluatorForDocument(Document document) {
        DataDictionary dictionary = KRADServiceLocatorWeb.getDataDictionaryService().getDataDictionary();
        DocumentEntry docEntry = dictionary.getDocumentEntry(document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName());
        WorkflowProperties workflowProperties = docEntry.getWorkflowProperties();
        List<WorkflowPropertyGroup> groups = workflowProperties.getWorkflowPropertyGroups();
        this.serializableProperties = new PropertySerializerTrie();
        for (WorkflowPropertyGroup group : groups) {
            if (StringUtils.isEmpty((String)group.getBasePath())) {
                this.serializableProperties.addSerializablePropertyName(document.getBasePathToDocumentDuringSerialization(), false);
            } else {
                this.serializableProperties.addSerializablePropertyName(group.getBasePath(), false);
            }
            for (WorkflowProperty property : group.getWorkflowProperties()) {
                String fullPath = StringUtils.isEmpty((String)group.getBasePath()) ? document.getBasePathToDocumentDuringSerialization() + "." + property.getPath() : group.getBasePath() + "." + property.getPath();
                this.serializableProperties.addSerializablePropertyName(fullPath, false);
            }
        }
    }
}

