/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.dc.subaward.amntinfo;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.dc.common.db.ConnectionDaoService;
import org.kuali.coeus.dc.subaward.amntinfo.SubAwardAmountInfoDao;
import org.kuali.coeus.dc.tm.TimeAndMoneyDocumentStatusDaoImpl;

public class SubAwardAmountInfoDaoImpl
implements SubAwardAmountInfoDao {
    private static final String DELETE_AMOUNT_INFO = "delete from subaward_amount_info where subaward_amount_info_id = ?";
    private static final String SELECT_AMOUNT_INFOS = "select subaward_amount_info_id, obligated_amount, obligated_change, anticipated_amount, anticipated_change, effective_date, comments, file_name, mime_type, modification_effective_date, modification_number, performance_start_date, performance_end_date from subaward_amount_info where subaward_id = ? order by subaward_amount_info_id";
    private static final String SELECT_SUBAWARDS = "select subaward_id, subaward_code, sequence_number from subaward order by subaward_code, sequence_number";
    private static final String QUERY_DUPED_TABLE = "select count(*) from subaward_amount_info_dups";
    private static final String CREATE_DUPED_TABLE = "create table subaward_amount_info_dups as select * from subaward_amount_info where 1 = 0";
    private static final String INSERT_DUP_RECORD = "insert into subaward_amount_info_dups select * from subaward_amount_info where subaward_amount_info_id = ?";
    private static final Logger LOG = LogManager.getLogger((String)TimeAndMoneyDocumentStatusDaoImpl.class.getName());
    private ConnectionDaoService connectionDaoService;

    @Override
    public void fixSubAwardAmountInfoHistory() {
        ArrayList<String> subAwardsWithErrors = new ArrayList<String>();
        int numberOfAmountInfosDeleted = 0;
        int numberOfAmountInfosWithDifferences = 0;
        int numberOfSubAwardsWithNoErrors = 0;
        Connection connection = this.connectionDaoService.getCoeusConnection();
        try (PreparedStatement querySubAwards = connection.prepareStatement(SELECT_SUBAWARDS);
             PreparedStatement queryAmountInfoForVersion = connection.prepareStatement(SELECT_AMOUNT_INFOS);
             PreparedStatement deleteAmountInfo = connection.prepareStatement(DELETE_AMOUNT_INFO);
             PreparedStatement queryDupedTable = connection.prepareStatement(QUERY_DUPED_TABLE);
             PreparedStatement createDupedTable = connection.prepareStatement(CREATE_DUPED_TABLE);
             PreparedStatement insertDupRecord = connection.prepareStatement(INSERT_DUP_RECORD);){
            Map<String, List<SubAwardVersionInfo>> subAwards;
            try {
                ResultSet rs = queryDupedTable.executeQuery();
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                createDupedTable.execute();
            }
            try (ResultSet subAwardResultSet = querySubAwards.executeQuery();){
                subAwards = this.getSubAwardVersions(subAwardResultSet);
            }
            for (Map.Entry<String, List<SubAwardVersionInfo>> entry : subAwards.entrySet()) {
                ArrayList previousAmountInfos = new ArrayList();
                boolean hadError = false;
                for (SubAwardVersionInfo version : entry.getValue()) {
                    ArrayList<AmountInfo> duplicateAmountInfos = new ArrayList<AmountInfo>();
                    List<AmountInfo> currentAmountInfos = this.getAmountInfosForSubawardVersion(version.subAwardId, queryAmountInfoForVersion);
                    if (currentAmountInfos.size() < previousAmountInfos.size()) {
                        LOG.debug("SUBAWARD-AMOUNTINFO:Current version of subaward " + entry.getKey() + " has fewer amount infos than the previous version. Assuming already cleaned.");
                        continue;
                    }
                    int i = 0;
                    for (i = 0; i < previousAmountInfos.size() && i < currentAmountInfos.size(); ++i) {
                        Long subAwardAmountInfoId = currentAmountInfos.get((int)i).subAwardAmountInfoId;
                        if (((AmountInfo)previousAmountInfos.get(i)).equals(currentAmountInfos.get(i))) {
                            if (!this.deleteAmountInfo(subAwardAmountInfoId, insertDupRecord, deleteAmountInfo)) {
                                hadError = true;
                                continue;
                            }
                            duplicateAmountInfos.add(currentAmountInfos.get(i));
                            ++numberOfAmountInfosDeleted;
                            continue;
                        }
                        LOG.debug("SUBAWARD-AMOUNTINFO:Differences detected for " + subAwardAmountInfoId + " based on original ordering, looking for exact match in any amount info.");
                        AmountInfo previousAmountInfo = (AmountInfo)previousAmountInfos.get(i);
                        List<AmountInfo> matchingItems = this.findMatchingAmountInfos(previousAmountInfo, currentAmountInfos);
                        if (matchingItems.size() == 1) {
                            if (!this.deleteAmountInfo(matchingItems.get((int)0).subAwardAmountInfoId, insertDupRecord, deleteAmountInfo)) {
                                hadError = true;
                                continue;
                            }
                            duplicateAmountInfos.add(matchingItems.get(0));
                            ++numberOfAmountInfosDeleted;
                            continue;
                        }
                        LOG.error("SUBAWARD-AMOUNTINFO:Cannot determine matching subaward amount info to delete. Found " + matchingItems.size() + " potential matches in subaward_code(" + entry.getKey() + ") subaward_id(" + version.subAwardId + ") for previous subaward_amount_info_id(" + previousAmountInfo.subAwardAmountInfoId + ")");
                        ++numberOfAmountInfosWithDifferences;
                        hadError = true;
                    }
                    previousAmountInfos.addAll(currentAmountInfos.stream().filter(amountInfo -> !duplicateAmountInfos.contains(amountInfo)).collect(Collectors.toList()));
                }
                if (hadError) {
                    subAwardsWithErrors.add(entry.getKey());
                    continue;
                }
                ++numberOfSubAwardsWithNoErrors;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        LOG.info("SUBAWARD-AMOUNTINFO:Number of Subawards With No Errors = " + numberOfSubAwardsWithNoErrors);
        LOG.info("SUBAWARD-AMOUNTINFO:Number of Amount Infos deleted = " + numberOfAmountInfosDeleted);
        LOG.error("SUBAWARD-AMOUNTINFO:Number of amount infos not deleted due to differences = " + numberOfAmountInfosWithDifferences);
        LOG.error("SUBAWARD-AMOUNTINFO:Number of subawards with errors = " + subAwardsWithErrors.size());
        LOG.error("SUBAWARD-AMOUNTINFO:Subawards in error = " + subAwardsWithErrors.stream().collect(Collectors.joining(", ")));
    }

    protected List<AmountInfo> getAmountInfosForSubawardVersion(Long subAwardId, PreparedStatement queryAmountInfoForVersion) throws SQLException {
        ArrayList<AmountInfo> currentAmountInfos = new ArrayList<AmountInfo>();
        queryAmountInfoForVersion.setLong(1, subAwardId);
        try (ResultSet rs = queryAmountInfoForVersion.executeQuery();){
            while (rs.next()) {
                currentAmountInfos.add(new AmountInfo(rs));
            }
        }
        return currentAmountInfos;
    }

    protected List<AmountInfo> findMatchingAmountInfos(AmountInfo previousAmountInfo, List<AmountInfo> currentAmountInfos) {
        List<AmountInfo> matchingItems = currentAmountInfos.stream().filter(amountInfo -> amountInfo.equals(previousAmountInfo)).collect(Collectors.toList());
        return matchingItems;
    }

    protected Map<String, List<SubAwardVersionInfo>> getSubAwardVersions(ResultSet subAwardResultSet) throws SQLException {
        HashMap<String, List<SubAwardVersionInfo>> subAwards = new HashMap<String, List<SubAwardVersionInfo>>();
        while (subAwardResultSet.next()) {
            String subAwardCode = subAwardResultSet.getString(2);
            Long subAwardId = subAwardResultSet.getLong(1);
            Integer sequenceNumber = subAwardResultSet.getInt(3);
            List versions = (List)subAwards.get(subAwardCode);
            if (versions == null) {
                subAwards.put(subAwardCode, new ArrayList<SubAwardVersionInfo>(Collections.singletonList(new SubAwardVersionInfo(subAwardId, sequenceNumber))));
                continue;
            }
            versions.add(new SubAwardVersionInfo(subAwardId, sequenceNumber));
        }
        return subAwards;
    }

    protected boolean deleteAmountInfo(Long subAwardAmountInfoId, PreparedStatement insertDupRecord, PreparedStatement deleteAmountInfo) throws SQLException {
        LOG.debug("Going to delete " + subAwardAmountInfoId);
        insertDupRecord.setLong(1, subAwardAmountInfoId);
        if (insertDupRecord.executeUpdate() != 1) {
            LOG.error("SUBAWARD-AMOUNTINFO:Insert into dup table did not return expected results. Refusing to delete amount info with subaward_amount_info_id = " + subAwardAmountInfoId);
            return false;
        }
        deleteAmountInfo.setLong(1, subAwardAmountInfoId);
        if (deleteAmountInfo.executeUpdate() != 1) {
            LOG.error("SUBAWARD-AMOUNTINFO:Delete from amount info did not return expected results with subaward_amount_info_id = " + subAwardAmountInfoId);
            return false;
        }
        return true;
    }

    public ConnectionDaoService getConnectionDaoService() {
        return this.connectionDaoService;
    }

    public void setConnectionDaoService(ConnectionDaoService connectionDaoService) {
        this.connectionDaoService = connectionDaoService;
    }

    static class AmountInfo {
        Long subAwardAmountInfoId;
        BigDecimal obligatedAmount;
        BigDecimal obligatedChange;
        BigDecimal anticipatedAmount;
        BigDecimal anticipatedChange;
        Date effectiveDate;
        String comments;
        String fileName;
        String mimeType;
        Date modificationEffectiveDate;
        String modificationNumber;
        Date performanceStartDate;
        Date performanceEndDate;

        public AmountInfo(ResultSet rs) throws SQLException {
            this.subAwardAmountInfoId = rs.getLong(1);
            this.obligatedAmount = rs.getBigDecimal(2);
            this.obligatedChange = rs.getBigDecimal(3);
            this.anticipatedAmount = rs.getBigDecimal(4);
            this.anticipatedChange = rs.getBigDecimal(5);
            this.effectiveDate = rs.getDate(6);
            this.comments = rs.getString(7);
            this.fileName = rs.getString(8);
            this.mimeType = rs.getString(9);
            this.modificationEffectiveDate = rs.getDate(10);
            this.modificationNumber = rs.getString(11);
            this.performanceStartDate = rs.getDate(12);
            this.performanceEndDate = rs.getDate(13);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AmountInfo that = (AmountInfo)o;
            if (this.subAwardAmountInfoId != null ? !this.subAwardAmountInfoId.equals(that.subAwardAmountInfoId) : that.subAwardAmountInfoId != null) {
                return false;
            }
            if (this.obligatedAmount != null ? !this.obligatedAmount.equals(that.obligatedAmount) : that.obligatedAmount != null) {
                return false;
            }
            if (this.obligatedChange != null ? !this.obligatedChange.equals(that.obligatedChange) : that.obligatedChange != null) {
                return false;
            }
            if (this.anticipatedAmount != null ? !this.anticipatedAmount.equals(that.anticipatedAmount) : that.anticipatedAmount != null) {
                return false;
            }
            if (this.anticipatedChange != null ? !this.anticipatedChange.equals(that.anticipatedChange) : that.anticipatedChange != null) {
                return false;
            }
            if (this.effectiveDate != null ? !this.effectiveDate.equals(that.effectiveDate) : that.effectiveDate != null) {
                return false;
            }
            if (this.comments != null ? !this.comments.equals(that.comments) : that.comments != null) {
                return false;
            }
            if (this.fileName != null ? !this.fileName.equals(that.fileName) : that.fileName != null) {
                return false;
            }
            if (this.mimeType != null ? !this.mimeType.equals(that.mimeType) : that.mimeType != null) {
                return false;
            }
            if (this.modificationEffectiveDate != null ? !this.modificationEffectiveDate.equals(that.modificationEffectiveDate) : that.modificationEffectiveDate != null) {
                return false;
            }
            if (this.modificationNumber != null ? !this.modificationNumber.equals(that.modificationNumber) : that.modificationNumber != null) {
                return false;
            }
            if (this.performanceStartDate != null ? !this.performanceStartDate.equals(that.performanceStartDate) : that.performanceStartDate != null) {
                return false;
            }
            return this.performanceEndDate != null ? this.performanceEndDate.equals(that.performanceEndDate) : that.performanceEndDate == null;
        }

        public int hashCode() {
            int result = this.subAwardAmountInfoId != null ? this.subAwardAmountInfoId.hashCode() : 0;
            result = 31 * result + (this.obligatedAmount != null ? this.obligatedAmount.hashCode() : 0);
            result = 31 * result + (this.obligatedChange != null ? this.obligatedChange.hashCode() : 0);
            result = 31 * result + (this.anticipatedAmount != null ? this.anticipatedAmount.hashCode() : 0);
            result = 31 * result + (this.anticipatedChange != null ? this.anticipatedChange.hashCode() : 0);
            result = 31 * result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            result = 31 * result + (this.comments != null ? this.comments.hashCode() : 0);
            result = 31 * result + (this.fileName != null ? this.fileName.hashCode() : 0);
            result = 31 * result + (this.mimeType != null ? this.mimeType.hashCode() : 0);
            result = 31 * result + (this.modificationEffectiveDate != null ? this.modificationEffectiveDate.hashCode() : 0);
            result = 31 * result + (this.modificationNumber != null ? this.modificationNumber.hashCode() : 0);
            result = 31 * result + (this.performanceStartDate != null ? this.performanceStartDate.hashCode() : 0);
            result = 31 * result + (this.performanceEndDate != null ? this.performanceEndDate.hashCode() : 0);
            return result;
        }
    }

    static class SubAwardVersionInfo {
        Long subAwardId;
        Integer sequenceNumber;

        public SubAwardVersionInfo(Long subAwardId, Integer sequenceNumber) {
            this.subAwardId = subAwardId;
            this.sequenceNumber = sequenceNumber;
        }
    }
}

