/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actionlist.web;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.ComparatorUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.displaytag.pagination.PaginatedList;
import org.displaytag.properties.SortOrderEnum;
import org.displaytag.util.LookupUtil;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.delegation.DelegationType;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.kew.actionitem.ActionItem;
import org.kuali.rice.kew.actionitem.ActionItemBase;
import org.kuali.rice.kew.actionitem.OutboxItem;
import org.kuali.rice.kew.actionlist.ActionListFilter;
import org.kuali.rice.kew.actionlist.ActionToTake;
import org.kuali.rice.kew.actionlist.PaginatedActionList;
import org.kuali.rice.kew.actionlist.service.ActionListService;
import org.kuali.rice.kew.actionlist.web.ActionListForm;
import org.kuali.rice.kew.actionlist.web.ActionListUtil;
import org.kuali.rice.kew.actionrequest.Recipient;
import org.kuali.rice.kew.api.KewApiConstants;
import org.kuali.rice.kew.api.action.ActionInvocation;
import org.kuali.rice.kew.api.action.ActionItem;
import org.kuali.rice.kew.api.action.ActionItemContract;
import org.kuali.rice.kew.api.action.ActionItemCustomization;
import org.kuali.rice.kew.api.action.ActionSet;
import org.kuali.rice.kew.api.action.ActionType;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.api.preferences.Preferences;
import org.kuali.rice.kew.framework.KewFrameworkServiceLocator;
import org.kuali.rice.kew.framework.actionlist.ActionListCustomizationMediator;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.util.PerformanceLogger;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;
import org.kuali.rice.kns.web.struts.action.KualiAction;
import org.kuali.rice.kns.web.ui.ExtraButton;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.exception.AuthorizationException;
import org.kuali.rice.krad.util.GlobalVariables;

public class ActionListAction
extends KualiAction {
    private static final Logger LOG = LogManager.getLogger(ActionListAction.class);
    protected static final String MAX_ACTION_ITEM_DATE_FORMAT = "yyyy-MM-dd hh:mm:ss.S";
    private static final String ACTION_LIST_KEY = "actionList";
    private static final String ACTION_LIST_PAGE_KEY = "actionListPage";
    private static final String ACTION_LIST_USER_KEY = "actionList.user";
    private static final String ACTION_ITEM_COUNT_FOR_USER_KEY = "actionList.count";
    private static final String MAX_ACTION_ITEM_DATE_ASSIGNED_FOR_USER_KEY = "actionList.maxActionItemDateAssigned";
    private static final String ACTIONREQUESTCD_PROP = "actionRequestCd";
    private static final String CUSTOMACTIONLIST_PROP = "customActionList";
    private static final String ACTIONITEM_PROP = "actionitem";
    private static final String HELPDESK_ACTIONLIST_USERNAME = "helpDeskActionListUserName";
    private static final String ACTIONITEM_ACTIONREQUESTCD_INVALID_ERRKEY = "actionitem.actionrequestcd.invalid";
    private static final String ACTIONLIST_BAD_CUSTOM_ACTION_LIST_ITEMS_ERRKEY = "actionlist.badCustomActionListItems";
    private static final String ACTIONLIST_BAD_ACTION_ITEMS_ERRKEY = "actionlist.badActionItems";
    private static final String HELPDESK_LOGIN_EMPTY_ERRKEY = "helpdesk.login.empty";
    private static final String HELPDESK_LOGIN_INVALID_ERRKEY = "helpdesk.login.invalid";
    private static final ActionType[] actionListActionTypes = new ActionType[]{ActionType.APPROVE, ActionType.DISAPPROVE, ActionType.CANCEL, ActionType.ACKNOWLEDGE, ActionType.FYI};
    private static final String OUT_BOX_MODE = "_OUT_BOX_MODE";

    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionListForm frm = (ActionListForm)actionForm;
        request.setAttribute("Constants", this.getServlet().getServletContext().getAttribute("KewApiConstants"));
        request.setAttribute("preferences", this.getUserSession().retrieveObject("Preferences"));
        frm.setHeaderButtons(this.getHeaderButtons());
        return super.execute(mapping, actionForm, request, response);
    }

    private List<ExtraButton> getHeaderButtons() {
        ArrayList<ExtraButton> headerButtons = new ArrayList<ExtraButton>();
        ExtraButton eb = new ExtraButton();
        String krBaseUrl = ConfigContext.getCurrentContextConfig().getKRBaseURL();
        eb.setExtraButtonSource(krBaseUrl + "/images/tinybutton-preferences.gif");
        eb.setExtraButtonOnclick("Preferences.do?returnMapping=viewActionList");
        headerButtons.add(eb);
        eb = new ExtraButton();
        eb.setExtraButtonSource(krBaseUrl + "/images/tinybutton-refresh.gif");
        eb.setExtraButtonProperty("methodToCall.refresh");
        headerButtons.add(eb);
        eb = new ExtraButton();
        eb.setExtraButtonSource(krBaseUrl + "/images/tinybutton-filter.gif");
        eb.setExtraButtonOnclick("javascript: window.open('ActionListFilter.do?methodToCall=start');");
        headerButtons.add(eb);
        return headerButtons;
    }

    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.getSession().setAttribute("requeryActionList", (Object)"true");
        return this.start(mapping, form, request, response);
    }

    protected ActionForward defaultDispatch(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.start(mapping, form, request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward start(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PerformanceLogger plog = new PerformanceLogger();
        plog.log("Starting ActionList fetch");
        ActionListForm form = (ActionListForm)actionForm;
        ActionListService actionListSrv = KEWServiceLocator.getActionListService();
        Integer page = form.getPage();
        String sortCriterion = form.getSort();
        SortOrderEnum sortOrder = SortOrderEnum.ASCENDING;
        UserSession uSession = this.getUserSession();
        if (form.getDir() != null) {
            sortOrder = this.parseSortOrder(form.getDir());
        } else if (!StringUtils.isEmpty((String)((String)uSession.retrieveObject("sortOrder")))) {
            sortOrder = this.parseSortOrder((String)uSession.retrieveObject("sortOrder"));
        }
        if (page == null && sortCriterion == null) {
            page = 1;
            sortCriterion = "routeHeader.createDate";
        } else if (!StringUtils.isEmpty((String)((String)uSession.retrieveObject("sortCriteria")))) {
            sortCriterion = (String)uSession.retrieveObject("sortCriteria");
        }
        if (page == null) {
            page = form.getCurrentPage();
        }
        form.setCurrentPage(page);
        if (!StringUtils.isEmpty((String)sortCriterion)) {
            form.setCurrentSort(sortCriterion);
            form.setCurrentDir(this.getSortOrderValue(sortOrder));
        }
        form.setDefaultActionToTake("NONE");
        boolean freshActionList = true;
        ArrayList<ActionItemBase> actionList = (ArrayList<OutboxItem>)request.getSession().getAttribute(ACTION_LIST_KEY);
        plog.log("Time to initialize");
        try {
            boolean forceListRefresh;
            ActionListFilter filter;
            String principalId = null;
            if (uSession.retrieveObject("ActionListFilter") == null) {
                filter = new ActionListFilter();
                filter.setDelegationType(DelegationType.SECONDARY.getCode());
                filter.setExcludeDelegationType(true);
                uSession.addObject("ActionListFilter", (Object)filter);
            }
            filter = (ActionListFilter)uSession.retrieveObject("ActionListFilter");
            boolean bl = forceListRefresh = request.getSession().getAttribute("requeryActionList") != null;
            if (uSession.retrieveObject("helpDeskActionListPrincipal") != null) {
                principalId = ((PrincipalContract)uSession.retrieveObject("helpDeskActionListPrincipal")).getPrincipalId();
            } else {
                if (!StringUtils.isEmpty((String)form.getDocType())) {
                    filter.setDocumentType(form.getDocType());
                    filter.setExcludeDocumentType(false);
                    forceListRefresh = true;
                }
                principalId = uSession.getPerson().getPrincipalId();
            }
            Preferences preferences = (Preferences)this.getUserSession().retrieveObject("Preferences");
            if (!StringUtils.isEmpty((String)form.getDelegationId())) {
                if (!"Choose Secondary Delegation".equals(form.getDelegationId())) {
                    if (StringUtils.isNotBlank((String)form.getPrimaryDelegateId()) && !"Choose Primary Delegate".equals(form.getPrimaryDelegateId())) {
                        if (form.getPrimaryDelegateId().equals(request.getParameter("oldPrimaryDelegateId")) && !form.getDelegationId().equals(request.getParameter("oldDelegationId"))) {
                            form.setPrimaryDelegateId("Choose Primary Delegate");
                        } else {
                            form.setDelegationId("Choose Secondary Delegation");
                        }
                    } else if (StringUtils.isNotBlank((String)filter.getPrimaryDelegateId()) && !"Choose Primary Delegate".equals(filter.getPrimaryDelegateId())) {
                        filter.setPrimaryDelegateId("Choose Primary Delegate");
                    }
                }
                filter.setDelegatorId(form.getDelegationId());
                filter.setExcludeDelegatorId(false);
                actionList = null;
            }
            if (!StringUtils.isEmpty((String)form.getPrimaryDelegateId())) {
                if (StringUtils.isBlank((String)form.getDelegationId()) && !"Choose Primary Delegate".equals(form.getPrimaryDelegateId()) && StringUtils.isNotBlank((String)filter.getDelegatorId()) && !"Choose Secondary Delegation".equals(filter.getDelegatorId())) {
                    filter.setDelegatorId("Choose Secondary Delegation");
                }
                filter.setPrimaryDelegateId(form.getPrimaryDelegateId());
                filter.setExcludeDelegatorId(false);
                actionList = null;
            }
            if (!principalId.equals(request.getSession().getAttribute(ACTION_LIST_USER_KEY))) {
                actionList = null;
            }
            if (this.isOutboxMode(form, request, preferences)) {
                actionList = new ArrayList<OutboxItem>(actionListSrv.getOutbox(principalId, filter));
                form.setOutBoxEmpty(actionList.isEmpty());
            } else {
                List<Object> countAndMaxDate;
                SimpleDateFormat dFormatter = new SimpleDateFormat(MAX_ACTION_ITEM_DATE_FORMAT);
                if (actionList == null) {
                    countAndMaxDate = actionListSrv.getMaxActionItemDateAssignedAndCountForUser(principalId);
                    if (countAndMaxDate.isEmpty() || countAndMaxDate.get(0) == null) {
                        if (countAndMaxDate.isEmpty()) {
                            countAndMaxDate.add(0, new Date(0L));
                            countAndMaxDate.add(1, 0);
                        } else {
                            countAndMaxDate.set(0, new Date(0L));
                        }
                    }
                    request.getSession().setAttribute(MAX_ACTION_ITEM_DATE_ASSIGNED_FOR_USER_KEY, (Object)dFormatter.format(countAndMaxDate.get(0)));
                    request.getSession().setAttribute(ACTION_ITEM_COUNT_FOR_USER_KEY, (Object)((Long)countAndMaxDate.get(1)));
                    actionList = new ArrayList<ActionItem>(actionListSrv.getActionList(principalId, filter));
                    request.getSession().setAttribute(ACTION_LIST_USER_KEY, (Object)principalId);
                } else if (forceListRefresh) {
                    actionList = new ArrayList<ActionItem>(actionListSrv.getActionList(principalId, filter));
                    request.getSession().setAttribute(ACTION_LIST_USER_KEY, (Object)principalId);
                    countAndMaxDate = actionListSrv.getMaxActionItemDateAssignedAndCountForUser(principalId);
                    if (countAndMaxDate.isEmpty() || countAndMaxDate.get(0) == null) {
                        if (countAndMaxDate.isEmpty()) {
                            countAndMaxDate.add(0, new Date(0L));
                            countAndMaxDate.add(1, 0);
                        } else {
                            countAndMaxDate.set(0, new Date(0L));
                        }
                    }
                    request.getSession().setAttribute(MAX_ACTION_ITEM_DATE_ASSIGNED_FOR_USER_KEY, (Object)dFormatter.format(countAndMaxDate.get(0)));
                    request.getSession().setAttribute(ACTION_ITEM_COUNT_FOR_USER_KEY, (Object)((Long)countAndMaxDate.get(1)));
                } else if (this.refreshList(request, principalId)) {
                    actionList = new ArrayList<ActionItem>(actionListSrv.getActionList(principalId, filter));
                    request.getSession().setAttribute(ACTION_LIST_USER_KEY, (Object)principalId);
                } else {
                    Boolean update = (Boolean)uSession.retrieveObject("updateActionList");
                    if (update == null || !update.booleanValue()) {
                        freshActionList = false;
                    }
                }
                request.getSession().setAttribute(ACTION_LIST_KEY, actionList);
            }
            request.getSession().setAttribute("requeryActionList", null);
            if ("Secondary Delegators on Action List Page".equalsIgnoreCase(preferences.getDelegatorFilter())) {
                Collection<Recipient> delegators = actionListSrv.findUserSecondaryDelegators(principalId);
                form.setDelegators(ActionListUtil.getWebFriendlyRecipients(delegators));
                form.setDelegationId(filter.getDelegatorId());
            }
            if ("Primary Delegates on Action List Page".equalsIgnoreCase(preferences.getPrimaryDelegateFilter())) {
                Collection<Recipient> pDelegates = actionListSrv.findUserPrimaryDelegations(principalId);
                form.setPrimaryDelegates(ActionListUtil.getWebFriendlyRecipients(pDelegates));
                form.setPrimaryDelegateId(filter.getPrimaryDelegateId());
            }
            form.setFilterLegend(filter.getFilterLegend());
            plog.log("Setting attributes");
            int pageSize = this.getPageSize(preferences);
            if (freshActionList) {
                plog.log("calling initializeActionList");
                this.initializeActionList(actionList, preferences);
                plog.log("done w/ initializeActionList");
                if (sortCriterion == null) {
                    sortCriterion = form.getCurrentSort();
                    sortOrder = this.parseSortOrder(form.getCurrentDir());
                }
            }
            if (sortCriterion != null) {
                this.sortActionList(actionList, sortCriterion, sortOrder);
            }
            plog.log("calling buildCurrentPage");
            PaginatedList currentPage = this.buildCurrentPage(actionList, form.getCurrentPage(), form.getCurrentSort(), form.getCurrentDir(), pageSize, preferences, form);
            plog.log("done w/ buildCurrentPage");
            request.setAttribute(ACTION_LIST_PAGE_KEY, (Object)currentPage);
            UserSession userSession = uSession;
            synchronized (userSession) {
                uSession.addObject("updateActionList", (Object)Boolean.FALSE);
                uSession.addObject("currentPage", (Object)form.getCurrentPage());
                uSession.addObject("sortCriteria", (Object)form.getSort());
                uSession.addObject("sortOrder", (Object)form.getCurrentDir());
            }
            plog.log("finished setting attributes, finishing action list fetch");
        }
        catch (Exception e) {
            LOG.error("Error loading action list.", (Throwable)e);
        }
        LOG.debug("end start ActionListAction");
        return mapping.findForward("viewActionList");
    }

    private boolean refreshList(HttpServletRequest request, String principalId) {
        List<Object> maxActionItemDateAssignedAndCount = KEWServiceLocator.getActionListService().getMaxActionItemDateAssignedAndCountForUser(principalId);
        long count = (Long)maxActionItemDateAssignedAndCount.get(1);
        int previousCount = 0;
        Object actionItemCountFromSession = request.getSession().getAttribute(ACTION_ITEM_COUNT_FOR_USER_KEY);
        if (actionItemCountFromSession != null) {
            previousCount = Integer.parseInt(actionItemCountFromSession.toString());
        }
        SimpleDateFormat dFormatter = new SimpleDateFormat(MAX_ACTION_ITEM_DATE_FORMAT);
        Date maxActionItemDateAssigned = (Date)maxActionItemDateAssignedAndCount.get(0);
        if (maxActionItemDateAssigned == null) {
            maxActionItemDateAssigned = new Date(0L);
        }
        Date previousMaxActionItemDateAssigned = null;
        try {
            Object dateAttributeFromSession = request.getSession().getAttribute(MAX_ACTION_ITEM_DATE_ASSIGNED_FOR_USER_KEY);
            if (dateAttributeFromSession != null) {
                previousMaxActionItemDateAssigned = dFormatter.parse(dateAttributeFromSession.toString());
            }
        }
        catch (ParseException e) {
            LOG.warn("actionList.maxActionItemDateAssigned in session did not have expected date format.  Was: " + request.getSession().getAttribute(MAX_ACTION_ITEM_DATE_ASSIGNED_FOR_USER_KEY), (Throwable)e);
        }
        if ((long)previousCount != count) {
            request.getSession().setAttribute(MAX_ACTION_ITEM_DATE_ASSIGNED_FOR_USER_KEY, (Object)dFormatter.format(maxActionItemDateAssigned));
            request.getSession().setAttribute(ACTION_ITEM_COUNT_FOR_USER_KEY, (Object)count);
            return true;
        }
        if (previousMaxActionItemDateAssigned == null || previousMaxActionItemDateAssigned.compareTo(maxActionItemDateAssigned) != 0) {
            request.getSession().setAttribute(MAX_ACTION_ITEM_DATE_ASSIGNED_FOR_USER_KEY, (Object)dFormatter.format(maxActionItemDateAssigned));
            request.getSession().setAttribute(ACTION_ITEM_COUNT_FOR_USER_KEY, (Object)count);
            return true;
        }
        return false;
    }

    private SortOrderEnum parseSortOrder(String dir) throws WorkflowException {
        if ("asc".equals(dir)) {
            return SortOrderEnum.ASCENDING;
        }
        if ("desc".equals(dir)) {
            return SortOrderEnum.DESCENDING;
        }
        throw new WorkflowException("Invalid sort direction: " + dir);
    }

    private String getSortOrderValue(SortOrderEnum sortOrder) {
        if (SortOrderEnum.ASCENDING.equals((Object)sortOrder)) {
            return "asc";
        }
        if (SortOrderEnum.DESCENDING.equals((Object)sortOrder)) {
            return "desc";
        }
        return null;
    }

    private boolean isOutboxMode(ActionListForm alForm, HttpServletRequest request, Preferences preferences) {
        boolean outBoxView = false;
        if (!preferences.isUsingOutbox() || !ConfigContext.getCurrentContextConfig().getOutBoxOn().booleanValue()) {
            request.getSession().setAttribute(OUT_BOX_MODE, (Object)Boolean.FALSE);
            alForm.setViewOutbox("false");
            alForm.setShowOutbox(false);
            return false;
        }
        alForm.setShowOutbox(true);
        if (StringUtils.isNotEmpty((String)alForm.getViewOutbox())) {
            if (!Boolean.valueOf(alForm.getViewOutbox()).booleanValue()) {
                request.getSession().setAttribute(OUT_BOX_MODE, (Object)Boolean.FALSE);
                outBoxView = false;
            } else {
                request.getSession().setAttribute(OUT_BOX_MODE, (Object)Boolean.TRUE);
                outBoxView = true;
            }
        } else {
            outBoxView = request.getSession().getAttribute(OUT_BOX_MODE) == null ? false : (Boolean)request.getSession().getAttribute(OUT_BOX_MODE);
        }
        if (outBoxView) {
            alForm.setViewOutbox("true");
        } else {
            alForm.setViewOutbox("false");
        }
        return outBoxView;
    }

    private void sortActionList(List<? extends ActionItemBase> actionList, String sortName, SortOrderEnum sortOrder) {
        if (StringUtils.isEmpty((String)sortName)) {
            return;
        }
        Comparator<ActionItemBase> comparator = new ActionItemComparator(sortName);
        if (SortOrderEnum.DESCENDING.equals((Object)sortOrder)) {
            comparator = ComparatorUtils.reversedComparator((Comparator)comparator);
        }
        Collections.sort(actionList, comparator);
        int index = 0;
        for (ActionItemBase actionItemBase : actionList) {
            actionItemBase.setActionListIndex(index++);
        }
    }

    private void initializeActionList(List<? extends ActionItemBase> actionList, Preferences preferences) {
        ArrayList<String> actionItemProblemIds = new ArrayList<String>();
        int index = 0;
        this.generateActionItemErrors(actionList);
        Iterator<? extends ActionItemBase> iterator = actionList.iterator();
        while (iterator.hasNext()) {
            ActionItemBase actionItem = iterator.next();
            if (actionItem.getDocumentId() == null) {
                LOG.error("Somehow there exists an ActionItem with a null document id!  actionItemId=" + actionItem.getId());
                iterator.remove();
                continue;
            }
            try {
                actionItem.initialize(preferences);
                actionItem.setActionListIndex(index);
                ++index;
            }
            catch (Exception e) {
                LOG.error("Error loading action list for action item " + actionItem.getId(), (Throwable)e);
                iterator.remove();
                actionItemProblemIds.add(actionItem.getDocumentId());
            }
        }
        this.generateActionItemErrors(ACTIONITEM_PROP, ACTIONLIST_BAD_ACTION_ITEMS_ERRKEY, actionItemProblemIds);
    }

    protected int getPageSize(Preferences preferences) {
        return Integer.parseInt(preferences.getPageSize());
    }

    protected PaginatedList buildCurrentPage(List<? extends ActionItemBase> actionList, Integer page, String sortCriterion, String sortDirection, int pageSize, Preferences preferences, ActionListForm form) throws WorkflowException {
        ArrayList<ActionItemBase> currentPage = new ArrayList<ActionItemBase>(pageSize);
        boolean haveCustomActions = false;
        boolean haveDisplayParameters = false;
        boolean showClearFyi = "yes".equalsIgnoreCase(preferences.getShowClearFyi());
        HashSet<ActionType> pageActions = new HashSet<ActionType>();
        ArrayList<String> customActionListProblemIds = new ArrayList<String>();
        SortOrderEnum sortOrder = this.parseSortOrder(sortDirection);
        int startIndex = (page - 1) * pageSize;
        int endIndex = startIndex + pageSize;
        this.generateActionItemErrors(actionList);
        LOG.info("Beginning processing of Action List Customizations (total: " + actionList.size() + " Action Items)");
        long start = System.currentTimeMillis();
        Map customizationMap = new HashMap();
        if (!StringUtils.equalsIgnoreCase((String)"true", (String)form.getViewOutbox())) {
            customizationMap = this.getActionListCustomizationMediator().getActionListCustomizations(this.getUserSession().getPrincipalId(), this.convertToApiActionItems(actionList));
        }
        long end = System.currentTimeMillis();
        LOG.info("Finished processing of Action List Customizations (total time: " + (end - start) + " ms)");
        for (int index = startIndex; index < endIndex && index < actionList.size(); ++index) {
            ActionItemBase actionItem = actionList.get(index);
            try {
                ActionItemCustomization customization = (ActionItemCustomization)customizationMap.get(actionItem.getId());
                if (customization != null) {
                    ActionSet actionSet = customization.getActionSet();
                    LinkedHashMap<String, String> customActions = new LinkedHashMap<String, String>();
                    customActions.put("NONE", "NONE");
                    for (ActionType actionType : actionListActionTypes) {
                        boolean isFyi;
                        if (!actionSet.hasAction(actionType.getCode()) || !this.isActionCompatibleRequest(actionItem, actionType.getCode())) continue;
                        boolean bl = isFyi = ActionType.FYI == actionType;
                        if (isFyi && (!isFyi || !showClearFyi)) continue;
                        customActions.put(actionType.getCode(), actionType.getLabel());
                        pageActions.add(actionType);
                    }
                    if (customActions.size() > 1 && !StringUtils.equalsIgnoreCase((String)"true", (String)form.getViewOutbox())) {
                        actionItem.setCustomActions(customActions);
                        haveCustomActions = true;
                    }
                    actionItem.setDisplayParameters(customization.getDisplayParameters());
                    haveDisplayParameters = haveDisplayParameters || actionItem.getDisplayParameters() != null;
                }
            }
            catch (Exception e) {
                LOG.error("Problem loading custom action list attribute", (Throwable)e);
                customActionListProblemIds.add(actionItem.getDocumentId());
            }
            currentPage.add(actionItem);
        }
        form.setHasCustomActions(haveCustomActions);
        LinkedHashMap<String, String> defaultActions = new LinkedHashMap<String, String>();
        defaultActions.put("NONE", "NONE");
        for (ActionType actionType : actionListActionTypes) {
            boolean isFyi;
            if (!pageActions.contains(actionType)) continue;
            boolean bl = isFyi = ActionType.FYI == actionType;
            if (isFyi) {
                if (!showClearFyi) continue;
                defaultActions.put(actionType.getCode(), actionType.getLabel());
                continue;
            }
            defaultActions.put(actionType.getCode(), actionType.getLabel());
            form.setCustomActionList(Boolean.TRUE);
        }
        if (defaultActions.size() > 1) {
            form.setDefaultActions(defaultActions);
        }
        form.setHasDisplayParameters(haveDisplayParameters);
        this.generateActionItemErrors(CUSTOMACTIONLIST_PROP, ACTIONLIST_BAD_CUSTOM_ACTION_LIST_ITEMS_ERRKEY, customActionListProblemIds);
        return new PaginatedActionList(currentPage, actionList.size(), page, pageSize, ACTION_LIST_KEY, sortCriterion, sortOrder);
    }

    private List<org.kuali.rice.kew.api.action.ActionItem> convertToApiActionItems(List<? extends ActionItemBase> actionList) {
        ArrayList<org.kuali.rice.kew.api.action.ActionItem> apiActionItems = new ArrayList<org.kuali.rice.kew.api.action.ActionItem>(actionList.size());
        for (ActionItemBase actionItemBase : actionList) {
            apiActionItems.add(ActionItem.Builder.create((ActionItemContract)actionItemBase).build());
        }
        return apiActionItems;
    }

    private void generateActionItemErrors(String propertyName, String errorKey, List<String> documentIds) {
        if (!documentIds.isEmpty()) {
            String documentIdsString = StringUtils.join(documentIds.iterator(), (String)", ");
            GlobalVariables.getMessageMap().putError(propertyName, errorKey, new String[]{documentIdsString});
        }
    }

    private void generateActionItemErrors(List<? extends ActionItemBase> actionList) {
        for (ActionItemBase actionItemBase : actionList) {
            if (KewApiConstants.ACTION_REQUEST_CODES.containsKey(actionItemBase.getActionRequestCd())) continue;
            GlobalVariables.getMessageMap().putError(ACTIONREQUESTCD_PROP, ACTIONITEM_ACTIONREQUESTCD_INVALID_ERRKEY, new String[]{actionItemBase.getId()});
        }
    }

    public ActionForward takeMassActions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionListForm actionListForm = (ActionListForm)form;
        List actionList = (List)request.getSession().getAttribute(ACTION_LIST_KEY);
        if (actionList == null) {
            return this.start(mapping, (ActionForm)new ActionListForm(), request, response);
        }
        ActionMessages messages = new ActionMessages();
        ArrayList<ActionInvocation> invocations = new ArrayList<ActionInvocation>();
        int index = 0;
        for (ActionToTake element : actionListForm.getActionsToTake()) {
            ActionToTake actionToTake = element;
            if (actionToTake != null && actionToTake.getActionTakenCd() != null && !"".equals(actionToTake.getActionTakenCd()) && !"NONE".equalsIgnoreCase(actionToTake.getActionTakenCd()) && actionToTake.getActionItemId() != null) {
                ActionItemBase actionItem = this.getActionItemFromActionList(actionList, actionToTake.getActionItemId());
                if (actionItem == null) {
                    LOG.warn("Could not locate the ActionItem to take mass action against in the action list: " + actionToTake.getActionItemId());
                    continue;
                }
                invocations.add(ActionInvocation.create((ActionType)ActionType.fromCode((String)actionToTake.getActionTakenCd()), (String)actionItem.getId()));
            }
            ++index;
        }
        KEWServiceLocator.getWorkflowDocumentService().takeMassActions(this.getUserSession().getPrincipalId(), invocations);
        messages.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("general.routing.processed"));
        this.saveMessages(request, messages);
        ActionListForm cleanForm = new ActionListForm();
        request.setAttribute(mapping.getName(), (Object)cleanForm);
        request.getSession().setAttribute("requeryActionList", (Object)"true");
        return this.start(mapping, (ActionForm)cleanForm, request, response);
    }

    protected ActionItemBase getActionItemFromActionList(List<? extends ActionItemBase> actionList, String actionItemId) {
        for (ActionItemBase actionItemBase : actionList) {
            if (!actionItemBase.getId().equals(actionItemId)) continue;
            return actionItemBase;
        }
        return null;
    }

    public ActionForward helpDeskActionListLogin(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionListForm actionListForm = (ActionListForm)form;
        String name = actionListForm.getHelpDeskActionListUserName();
        if (!"true".equals(request.getAttribute("helpDeskActionList"))) {
            throw new AuthorizationException(this.getUserSession().getPrincipalId(), "helpDeskActionListLogin", ((Object)((Object)this)).getClass().getSimpleName());
        }
        try {
            Principal helpDeskActionListPrincipal = KEWServiceLocator.getIdentityHelperService().getPrincipalByPrincipalName(name);
            Person helpDeskActionListPerson = KEWServiceLocator.getIdentityHelperService().getPersonByPrincipalName(name);
            GlobalVariables.getUserSession().addObject("helpDeskActionListPrincipal", (Object)helpDeskActionListPrincipal);
            GlobalVariables.getUserSession().addObject("helpDeskActionListPerson", (Object)helpDeskActionListPerson);
        }
        catch (RiceRuntimeException rre) {
            GlobalVariables.getMessageMap().putError(HELPDESK_ACTIONLIST_USERNAME, HELPDESK_LOGIN_INVALID_ERRKEY, new String[]{name});
        }
        catch (RiceIllegalArgumentException e) {
            GlobalVariables.getMessageMap().putError(HELPDESK_ACTIONLIST_USERNAME, HELPDESK_LOGIN_INVALID_ERRKEY, new String[]{name});
        }
        catch (NullPointerException npe) {
            GlobalVariables.getMessageMap().putError("null", HELPDESK_LOGIN_EMPTY_ERRKEY, new String[]{name});
        }
        actionListForm.setDelegator(null);
        request.getSession().setAttribute("requeryActionList", (Object)"true");
        return this.start(mapping, form, request, response);
    }

    public ActionForward clearFilter(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug("clearFilter ActionListAction");
        UserSession commonUserSession = this.getUserSession();
        commonUserSession.removeObject("ActionListFilter");
        request.getSession().setAttribute("requeryActionList", (Object)"true");
        LOG.debug("end clearFilter ActionListAction");
        return this.start(mapping, form, request, response);
    }

    public ActionForward clearHelpDeskActionListUser(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug("clearHelpDeskActionListUser ActionListAction");
        GlobalVariables.getUserSession().removeObject("helpDeskActionListPrincipal");
        GlobalVariables.getUserSession().removeObject("helpDeskActionListPerson");
        LOG.debug("end clearHelpDeskActionListUser ActionListAction");
        return this.start(mapping, form, request, response);
    }

    public ActionForward count(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionListForm alForm = (ActionListForm)form;
        Person user = this.getUserSession().getPerson();
        alForm.setCount(KEWServiceLocator.getActionListService().getCount(user.getPrincipalId()));
        LOG.info("Fetched Action List count of " + alForm.getCount() + " for user " + user.getPrincipalName());
        return mapping.findForward("count");
    }

    public ActionForward removeOutboxItems(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionListForm alForm = (ActionListForm)form;
        if (alForm.getOutboxItems() != null) {
            KEWServiceLocator.getActionListService().removeOutboxItems(this.getUserSession().getPrincipalId(), Arrays.asList(alForm.getOutboxItems()));
        }
        alForm.setViewOutbox("true");
        return this.start(mapping, form, request, response);
    }

    public ActionForward viewFilter(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.start(mapping, actionForm, request, response);
        return mapping.findForward("viewFilter");
    }

    public ActionForward viewPreferences(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.start(mapping, actionForm, request, response);
        return mapping.findForward("viewPreferences");
    }

    private boolean isActionCompatibleRequest(ActionItemBase actionItem, String actionTakenCode) {
        boolean actionCompatible = false;
        String requestCd = actionItem.getActionRequestCd();
        if ("F".equals(requestCd) && "F".equals(actionTakenCode)) {
            actionCompatible = true;
        }
        if ("K".equals(requestCd) && "K".equals(actionTakenCode)) {
            actionCompatible = true;
        }
        if ("A".equals(requestCd) && !"F".equals(actionTakenCode) && !"K".equals(actionTakenCode)) {
            actionCompatible = true;
        }
        if ("C".equals(requestCd) && !"F".equals(actionTakenCode) && !"K".equals(actionTakenCode)) {
            actionCompatible = true;
        }
        return actionCompatible;
    }

    private UserSession getUserSession() {
        return GlobalVariables.getUserSession();
    }

    private ActionListCustomizationMediator getActionListCustomizationMediator() {
        return ActionListCustomizationMediatorHolder.actionListCustomizationMediator;
    }

    private static class ActionListCustomizationMediatorHolder {
        static final ActionListCustomizationMediator actionListCustomizationMediator = KewFrameworkServiceLocator.getActionListCustomizationMediator();

        private ActionListCustomizationMediatorHolder() {
        }
    }

    private static class ActionItemComparator
    implements Comparator<ActionItemBase> {
        private static final String ACTION_LIST_DEFAULT_SORT = "routeHeader.createDate";
        private final String sortName;

        public ActionItemComparator(String sortName) {
            if (StringUtils.isEmpty((String)sortName)) {
                sortName = ACTION_LIST_DEFAULT_SORT;
            }
            this.sortName = sortName;
        }

        @Override
        public int compare(ActionItemBase actionItem1, ActionItemBase actionItem2) {
            try {
                Object property1 = LookupUtil.getProperty((Object)actionItem1, (String)this.sortName);
                Object property2 = LookupUtil.getProperty((Object)actionItem2, (String)this.sortName);
                if (property1 == null && property2 == null) {
                    return 0;
                }
                if (property1 == null) {
                    return -1;
                }
                if (property2 == null) {
                    return 1;
                }
                if (property1 instanceof Comparable) {
                    return ((Comparable)property1).compareTo(property2);
                }
                return property1.toString().compareTo(property2.toString());
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException("Could not sort for the given sort name: " + this.sortName, e);
            }
        }
    }
}

