/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.xml.xstream;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kew.rule.xmlrouting.XPathHelper;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XStreamSafeEvaluator {
    private static final String MATCH_ANY = "//";
    private static final String MATCH_ROOT = "/";
    private static final String MATCH_CURRENT = ".";
    private static final String XSTREAM_REFERENCE_ATTRIBUTE = "reference";
    private XPath xpath;

    public XStreamSafeEvaluator() {
    }

    public XStreamSafeEvaluator(XPath xpath) {
        this.xpath = xpath;
    }

    public NodeList evaluate(String xPathExpression, Node rootSearchNode) throws XPathExpressionException {
        XPath xpathEval = this.getXpath();
        ArrayList segments = new ArrayList();
        this.parseExpression(segments, xPathExpression, true);
        SimpleNodeList nodes = new SimpleNodeList();
        nodes.getList().add(rootSearchNode);
        Iterator iterator = segments.iterator();
        while (iterator.hasNext()) {
            SimpleNodeList newNodeList = new SimpleNodeList();
            XPathSegment expression = (XPathSegment)iterator.next();
            for (Node node : nodes.getList()) {
                NodeList evalSet;
                if ((node = this.resolveNodeReference(xpathEval, node)) == null || (evalSet = (NodeList)xpathEval.evaluate(expression.getXPathExpression(), node, XPathConstants.NODESET)) == null) continue;
                for (int nodeIndex = 0; nodeIndex < evalSet.getLength(); ++nodeIndex) {
                    Node newNode = evalSet.item(nodeIndex);
                    newNodeList.getList().add(newNode);
                }
            }
            nodes = newNodeList;
        }
        SimpleNodeList newNodes = new SimpleNodeList();
        for (Node node : nodes.getList()) {
            newNodes.getList().add(this.resolveNodeReference(xpathEval, node));
        }
        return newNodes;
    }

    private void parseExpression(List segments, String xPathExpression, boolean isInitialSegment) throws XPathExpressionException {
        if (StringUtils.isEmpty((String)xPathExpression)) {
            return;
        }
        XPathSegment segment = isInitialSegment ? this.parseInitialSegment(xPathExpression) : this.parseNextSegment(xPathExpression);
        segments.add(segment);
        this.parseExpression(segments, xPathExpression.substring(segment.getLength()), false);
    }

    private XPathSegment parseInitialSegment(String xPathExpression) throws XPathExpressionException {
        if (xPathExpression.startsWith(".//")) {
            throw new XPathExpressionException("XStream safe evaluator currenlty does not support expressions that start with .//");
        }
        int operatorLength = 2;
        int firstIndex = xPathExpression.indexOf("./");
        if (firstIndex != 0 && (firstIndex = xPathExpression.indexOf(MATCH_ANY)) != 0) {
            operatorLength = 1;
            firstIndex = xPathExpression.indexOf(MATCH_ROOT);
        }
        if (firstIndex != 0) {
            throw new XPathExpressionException("Could not locate an appropriate ./, /, or // operator at the begginingg of the xpath segment: " + xPathExpression);
        }
        int nextIndex = xPathExpression.indexOf(MATCH_ROOT, operatorLength);
        if (nextIndex == -1) {
            nextIndex = xPathExpression.length();
        }
        return new XPathSegment(xPathExpression.substring(0, operatorLength), xPathExpression.substring(operatorLength, nextIndex), true);
    }

    private XPathSegment parseNextSegment(String xPathExpression) throws XPathExpressionException {
        if (!xPathExpression.startsWith(MATCH_ROOT)) {
            throw new XPathExpressionException("Illegal xPath segment, the given segment is not a valid segment and should start with a '/'.  Value was: " + xPathExpression);
        }
        int operatorLength = MATCH_ROOT.length();
        int nextIndex = xPathExpression.indexOf(MATCH_ROOT, operatorLength);
        if (nextIndex == -1) {
            nextIndex = xPathExpression.length();
        }
        return new XPathSegment("./", xPathExpression.substring(operatorLength, nextIndex), false);
    }

    private Node resolveNodeReference(XPath xpath, Node node) throws XPathExpressionException {
        Node referenceNode;
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null && (referenceNode = attributes.getNamedItem(XSTREAM_REFERENCE_ATTRIBUTE)) != null) {
            node = (Node)xpath.evaluate(referenceNode.getNodeValue(), node, XPathConstants.NODE);
            if (node != null) {
                node = this.resolveNodeReference(xpath, node);
            } else {
                throw new XPathExpressionException("Could not locate the node for the given XStream references expression: '" + referenceNode.getNodeValue() + "'");
            }
        }
        return node;
    }

    public XPath getXpath() {
        if (this.xpath == null) {
            return XPathHelper.newXPath();
        }
        return this.xpath;
    }

    public void setXpath(XPath xpath) {
        this.xpath = xpath;
    }

    private class SimpleNodeList
    implements NodeList {
        private List nodes = new ArrayList();

        private SimpleNodeList() {
        }

        @Override
        public Node item(int index) {
            return (Node)this.nodes.get(index);
        }

        @Override
        public int getLength() {
            return this.nodes.size();
        }

        public List getList() {
            return this.nodes;
        }
    }

    private class XPathSegment {
        private final String operator;
        private final String value;
        private final boolean isInitialSegment;

        public XPathSegment(String operator, String value, boolean isInitialSegment) {
            this.operator = operator;
            this.value = value;
            this.isInitialSegment = isInitialSegment;
        }

        public int getLength() {
            if (!this.isInitialSegment) {
                return this.operator.length() + this.value.length() - 1;
            }
            return this.operator.length() + this.value.length();
        }

        public String getXPathExpression() {
            return this.operator + this.value;
        }
    }
}

