/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.tasks.cancel;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.StepListener;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.admin.cluster.node.tasks.cancel.CancelTasksRequest;
import org.elasticsearch.action.admin.cluster.node.tasks.cancel.CancelTasksResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.action.support.tasks.TransportTasksAction;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.tasks.TaskInfo;
import org.elasticsearch.transport.EmptyTransportResponseHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class TransportCancelTasksAction
extends TransportTasksAction<CancellableTask, CancelTasksRequest, CancelTasksResponse, TaskInfo> {
    public static final String BAN_PARENT_ACTION_NAME = "internal:admin/tasks/ban";

    @Inject
    public TransportCancelTasksAction(ClusterService clusterService, TransportService transportService, ActionFilters actionFilters) {
        super("cluster:admin/tasks/cancel", clusterService, transportService, actionFilters, CancelTasksRequest::new, CancelTasksResponse::new, TaskInfo::new, "management");
        transportService.registerRequestHandler(BAN_PARENT_ACTION_NAME, "same", x$0 -> new BanParentTaskRequest(x$0), new BanParentRequestHandler());
    }

    @Override
    protected CancelTasksResponse newResponse(CancelTasksRequest request, List<TaskInfo> tasks, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
        return new CancelTasksResponse(tasks, taskOperationFailures, failedNodeExceptions);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void processTasks(CancelTasksRequest request, Consumer<CancellableTask> operation) {
        if (request.getTaskId().isSet()) {
            CancellableTask task = this.taskManager.getCancellableTask(request.getTaskId().getId());
            if (task != null) {
                if (!request.match(task)) throw new IllegalArgumentException("task [" + request.getTaskId() + "] doesn't support this operation");
                operation.accept(task);
                return;
            }
            if (this.taskManager.getTask(request.getTaskId().getId()) != null) {
                throw new IllegalArgumentException("task [" + request.getTaskId() + "] doesn't support cancellation");
            }
            throw new ResourceNotFoundException("task [{}] is not found", request.getTaskId());
        }
        Iterator<CancellableTask> iterator = this.taskManager.getCancellableTasks().values().iterator();
        while (iterator.hasNext()) {
            CancellableTask task = iterator.next();
            if (!request.match(task)) continue;
            operation.accept(task);
        }
    }

    @Override
    protected void taskOperation(CancelTasksRequest request, CancellableTask cancellableTask, ActionListener<TaskInfo> listener) {
        String nodeId = this.clusterService.localNode().getId();
        this.cancelTaskAndDescendants(cancellableTask, request.getReason(), request.waitForCompletion(), ActionListener.map(listener, r -> cancellableTask.taskInfo(nodeId, false)));
    }

    void cancelTaskAndDescendants(CancellableTask task, String reason, boolean waitForCompletion, ActionListener<Void> listener) {
        TaskId taskId = task.taskInfo(this.clusterService.localNode().getId(), false).getTaskId();
        if (task.shouldCancelChildrenOnCancellation()) {
            this.logger.trace("cancelling task [{}] and its descendants", (Object)taskId);
            StepListener<Void> completedListener = new StepListener<Void>();
            GroupedActionListener groupedListener = new GroupedActionListener(ActionListener.map(completedListener, r -> null), 3);
            Collection<DiscoveryNode> childrenNodes = this.taskManager.startBanOnChildrenNodes(task.getId(), () -> {
                this.logger.trace("child tasks of parent [{}] are completed", (Object)taskId);
                groupedListener.onResponse(null);
            });
            this.taskManager.cancel(task, reason, () -> {
                this.logger.trace("task [{}] is cancelled", (Object)taskId);
                groupedListener.onResponse(null);
            });
            StepListener<Void> banOnNodesListener = new StepListener<Void>();
            this.setBanOnNodes(reason, waitForCompletion, task, childrenNodes, banOnNodesListener);
            banOnNodesListener.whenComplete(groupedListener::onResponse, groupedListener::onFailure);
            Runnable removeBansRunnable = this.transportService.getThreadPool().getThreadContext().preserveContext(() -> this.removeBanOnNodes(task, childrenNodes));
            completedListener.whenComplete(r -> removeBansRunnable.run(), e -> removeBansRunnable.run());
            if (waitForCompletion) {
                completedListener.whenComplete(r -> listener.onResponse(null), listener::onFailure);
            } else {
                banOnNodesListener.whenComplete(r -> listener.onResponse(null), listener::onFailure);
            }
        } else {
            this.logger.trace("task [{}] doesn't have any children that should be cancelled", (Object)taskId);
            if (waitForCompletion) {
                this.taskManager.cancel(task, reason, () -> listener.onResponse(null));
            } else {
                this.taskManager.cancel(task, reason, () -> {});
                listener.onResponse(null);
            }
        }
    }

    private void setBanOnNodes(String reason, boolean waitForCompletion, CancellableTask task, Collection<DiscoveryNode> childNodes, ActionListener<Void> listener) {
        if (childNodes.isEmpty()) {
            listener.onResponse(null);
            return;
        }
        final TaskId taskId = new TaskId(this.clusterService.localNode().getId(), task.getId());
        this.logger.trace("cancelling child tasks of [{}] on child nodes {}", (Object)taskId, childNodes);
        final GroupedActionListener groupedListener = new GroupedActionListener(ActionListener.map(listener, r -> null), childNodes.size());
        BanParentTaskRequest banRequest = BanParentTaskRequest.createSetBanParentTaskRequest(taskId, reason, waitForCompletion);
        for (final DiscoveryNode node : childNodes) {
            this.transportService.sendRequest(node, BAN_PARENT_ACTION_NAME, banRequest, new EmptyTransportResponseHandler("same"){

                @Override
                public void handleResponse(TransportResponse.Empty response) {
                    TransportCancelTasksAction.this.logger.trace("sent ban for tasks with the parent [{}] to the node [{}]", (Object)taskId, (Object)node);
                    groupedListener.onResponse(null);
                }

                @Override
                public void handleException(TransportException exp) {
                    assert (!(ExceptionsHelper.unwrapCause(exp) instanceof ElasticsearchSecurityException));
                    TransportCancelTasksAction.this.logger.warn("Cannot send ban for tasks with the parent [{}] to the node [{}]", (Object)taskId, (Object)node);
                    groupedListener.onFailure(exp);
                }
            });
        }
    }

    private void removeBanOnNodes(CancellableTask task, Collection<DiscoveryNode> childNodes) {
        final BanParentTaskRequest request = BanParentTaskRequest.createRemoveBanParentTaskRequest(new TaskId(this.clusterService.localNode().getId(), task.getId()));
        for (final DiscoveryNode node : childNodes) {
            this.logger.trace("Sending remove ban for tasks with the parent [{}] to the node [{}]", (Object)request.parentTaskId, (Object)node);
            this.transportService.sendRequest(node, BAN_PARENT_ACTION_NAME, request, new EmptyTransportResponseHandler("same"){

                @Override
                public void handleException(TransportException exp) {
                    assert (!(ExceptionsHelper.unwrapCause(exp) instanceof ElasticsearchSecurityException));
                    TransportCancelTasksAction.this.logger.info("failed to remove the parent ban for task {} on node {}", (Object)request.parentTaskId, (Object)node);
                }
            });
        }
    }

    class BanParentRequestHandler
    implements TransportRequestHandler<BanParentTaskRequest> {
        BanParentRequestHandler() {
        }

        @Override
        public void messageReceived(BanParentTaskRequest request, TransportChannel channel, Task task) throws Exception {
            if (request.ban) {
                TransportCancelTasksAction.this.logger.debug("Received ban for the parent [{}] on the node [{}], reason: [{}]", (Object)request.parentTaskId, (Object)TransportCancelTasksAction.this.clusterService.localNode().getId(), (Object)request.reason);
                List<CancellableTask> childTasks = TransportCancelTasksAction.this.taskManager.setBan(request.parentTaskId, request.reason);
                GroupedActionListener<Void> listener = new GroupedActionListener<Void>(ActionListener.map(new ChannelActionListener(channel, TransportCancelTasksAction.BAN_PARENT_ACTION_NAME, request), r -> TransportResponse.Empty.INSTANCE), childTasks.size() + 1);
                for (CancellableTask childTask : childTasks) {
                    TransportCancelTasksAction.this.cancelTaskAndDescendants(childTask, request.reason, request.waitForCompletion, listener);
                }
                listener.onResponse(null);
            } else {
                TransportCancelTasksAction.this.logger.debug("Removing ban for the parent [{}] on the node [{}]", (Object)request.parentTaskId, (Object)TransportCancelTasksAction.this.clusterService.localNode().getId());
                TransportCancelTasksAction.this.taskManager.removeBan(request.parentTaskId);
                channel.sendResponse(TransportResponse.Empty.INSTANCE);
            }
        }
    }

    private static class BanParentTaskRequest
    extends TransportRequest {
        private final TaskId parentTaskId;
        private final boolean ban;
        private final boolean waitForCompletion;
        private final String reason;

        static BanParentTaskRequest createSetBanParentTaskRequest(TaskId parentTaskId, String reason, boolean waitForCompletion) {
            return new BanParentTaskRequest(parentTaskId, reason, waitForCompletion);
        }

        static BanParentTaskRequest createRemoveBanParentTaskRequest(TaskId parentTaskId) {
            return new BanParentTaskRequest(parentTaskId);
        }

        private BanParentTaskRequest(TaskId parentTaskId, String reason, boolean waitForCompletion) {
            this.parentTaskId = parentTaskId;
            this.ban = true;
            this.reason = reason;
            this.waitForCompletion = waitForCompletion;
        }

        private BanParentTaskRequest(TaskId parentTaskId) {
            this.parentTaskId = parentTaskId;
            this.ban = false;
            this.reason = null;
            this.waitForCompletion = false;
        }

        private BanParentTaskRequest(StreamInput in) throws IOException {
            super(in);
            this.parentTaskId = TaskId.readFromStream(in);
            this.ban = in.readBoolean();
            this.reason = this.ban ? in.readString() : null;
            this.waitForCompletion = in.getVersion().onOrAfter(Version.V_7_8_0) ? in.readBoolean() : false;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.parentTaskId.writeTo(out);
            out.writeBoolean(this.ban);
            if (this.ban) {
                out.writeString(this.reason);
            }
            if (out.getVersion().onOrAfter(Version.V_7_8_0)) {
                out.writeBoolean(this.waitForCompletion);
            }
        }
    }
}

