/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.bytes;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.concurrent.AbstractRefCounted;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public final class ReleasableBytesReference
extends AbstractRefCounted
implements Releasable,
BytesReference {
    public static final Releasable NO_OP = () -> {};
    private final BytesReference delegate;
    private final Releasable releasable;

    public ReleasableBytesReference(BytesReference delegate, Releasable releasable) {
        super("bytes-reference");
        this.delegate = delegate;
        this.releasable = releasable;
    }

    public static ReleasableBytesReference wrap(BytesReference reference) {
        return new ReleasableBytesReference(reference, NO_OP);
    }

    protected void closeInternal() {
        Releasables.close(this.releasable);
    }

    public ReleasableBytesReference retain() {
        this.incRef();
        return this;
    }

    public ReleasableBytesReference retainedSlice(int from, int length) {
        BytesReference slice = this.delegate.slice(from, length);
        this.incRef();
        return new ReleasableBytesReference(slice, this);
    }

    @Override
    public void close() {
        this.decRef();
    }

    @Override
    public byte get(int index) {
        return this.delegate.get(index);
    }

    @Override
    public int getInt(int index) {
        return this.delegate.getInt(index);
    }

    @Override
    public int indexOf(byte marker, int from) {
        return this.delegate.indexOf(marker, from);
    }

    @Override
    public int length() {
        return this.delegate.length();
    }

    @Override
    public BytesReference slice(int from, int length) {
        return this.delegate.slice(from, length);
    }

    @Override
    public long ramBytesUsed() {
        return this.delegate.ramBytesUsed();
    }

    @Override
    public StreamInput streamInput() throws IOException {
        return this.delegate.streamInput();
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        this.delegate.writeTo(os);
    }

    @Override
    public String utf8ToString() {
        return this.delegate.utf8ToString();
    }

    @Override
    public BytesRef toBytesRef() {
        return this.delegate.toBytesRef();
    }

    @Override
    public BytesRefIterator iterator() {
        return this.delegate.iterator();
    }

    @Override
    public int compareTo(BytesReference o) {
        return this.delegate.compareTo(o);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.delegate.toXContent(builder, params);
    }

    public boolean isFragment() {
        return this.delegate.isFragment();
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }
}

