/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import com.carrotsearch.hppc.ObjectLongMap;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.channels.ClosedByInterruptException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.index.CheckIndex;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.UsageTrackingQueryCachingPolicy;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.SetOnce;
import org.apache.lucene.util.ThreadInterruptedException;
import org.elasticsearch.Assertions;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.admin.indices.flush.FlushRequest;
import org.elasticsearch.action.admin.indices.forcemerge.ForceMergeRequest;
import org.elasticsearch.action.admin.indices.upgrade.post.UpgradeRequest;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.CheckedConsumer;
import org.elasticsearch.common.CheckedFunction;
import org.elasticsearch.common.CheckedRunnable;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.index.ElasticsearchDirectoryReader;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.metrics.MeanMetric;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.AsyncIOProcessor;
import org.elasticsearch.common.util.concurrent.RunOnce;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.gateway.WriteStateException;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.cache.IndexCache;
import org.elasticsearch.index.cache.bitset.ShardBitsetFilterCache;
import org.elasticsearch.index.cache.request.ShardRequestCache;
import org.elasticsearch.index.codec.CodecService;
import org.elasticsearch.index.engine.CommitStats;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.EngineConfig;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.engine.EngineFactory;
import org.elasticsearch.index.engine.ReadOnlyEngine;
import org.elasticsearch.index.engine.RefreshFailedEngineException;
import org.elasticsearch.index.engine.SafeCommitInfo;
import org.elasticsearch.index.engine.Segment;
import org.elasticsearch.index.engine.SegmentsStats;
import org.elasticsearch.index.fielddata.FieldDataStats;
import org.elasticsearch.index.fielddata.ShardFieldData;
import org.elasticsearch.index.flush.FlushStats;
import org.elasticsearch.index.get.GetStats;
import org.elasticsearch.index.get.ShardGetService;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.DocumentMapperForType;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.RootObjectMapper;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.merge.MergeStats;
import org.elasticsearch.index.recovery.RecoveryStats;
import org.elasticsearch.index.refresh.RefreshStats;
import org.elasticsearch.index.search.stats.SearchStats;
import org.elasticsearch.index.search.stats.ShardSearchStats;
import org.elasticsearch.index.seqno.ReplicationTracker;
import org.elasticsearch.index.seqno.RetentionLease;
import org.elasticsearch.index.seqno.RetentionLeaseStats;
import org.elasticsearch.index.seqno.RetentionLeaseSyncer;
import org.elasticsearch.index.seqno.RetentionLeases;
import org.elasticsearch.index.seqno.SeqNoStats;
import org.elasticsearch.index.seqno.SequenceNumbers;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.DocsStats;
import org.elasticsearch.index.shard.GlobalCheckpointListeners;
import org.elasticsearch.index.shard.IllegalIndexShardStateException;
import org.elasticsearch.index.shard.IndexEventListener;
import org.elasticsearch.index.shard.IndexShardClosedException;
import org.elasticsearch.index.shard.IndexShardNotRecoveringException;
import org.elasticsearch.index.shard.IndexShardNotStartedException;
import org.elasticsearch.index.shard.IndexShardOperationPermits;
import org.elasticsearch.index.shard.IndexShardRecoveringException;
import org.elasticsearch.index.shard.IndexShardRelocatedException;
import org.elasticsearch.index.shard.IndexShardStartedException;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.IndexingOperationListener;
import org.elasticsearch.index.shard.IndexingStats;
import org.elasticsearch.index.shard.InternalIndexingStats;
import org.elasticsearch.index.shard.LocalShardSnapshot;
import org.elasticsearch.index.shard.PrimaryReplicaSyncer;
import org.elasticsearch.index.shard.RefreshListeners;
import org.elasticsearch.index.shard.ReplicationGroup;
import org.elasticsearch.index.shard.SearchOperationListener;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardNotInPrimaryModeException;
import org.elasticsearch.index.shard.ShardPath;
import org.elasticsearch.index.shard.ShardStateMetadata;
import org.elasticsearch.index.shard.StoreRecovery;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.store.StoreFileMetadata;
import org.elasticsearch.index.store.StoreStats;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogConfig;
import org.elasticsearch.index.translog.TranslogStats;
import org.elasticsearch.index.warmer.ShardIndexWarmerService;
import org.elasticsearch.index.warmer.WarmerStats;
import org.elasticsearch.indices.IndexingMemoryController;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.TypeMissingException;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.cluster.IndicesClusterStateService;
import org.elasticsearch.indices.recovery.PeerRecoveryTargetService;
import org.elasticsearch.indices.recovery.RecoveryFailedException;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.suggest.completion.CompletionStats;
import org.elasticsearch.threadpool.ThreadPool;

public class IndexShard
extends AbstractIndexShardComponent
implements IndicesClusterStateService.Shard {
    private final ThreadPool threadPool;
    private final MapperService mapperService;
    private final IndexCache indexCache;
    private final Store store;
    private final InternalIndexingStats internalIndexingStats;
    private final ShardSearchStats searchStats = new ShardSearchStats();
    private final ShardGetService getService;
    private final ShardIndexWarmerService shardWarmerService;
    private final ShardRequestCache requestCacheStats;
    private final ShardFieldData shardFieldData;
    private final ShardBitsetFilterCache shardBitsetFilterCache;
    private final Object mutex = new Object();
    private final String checkIndexOnStartup;
    private final CodecService codecService;
    private final Engine.Warmer warmer;
    private final SimilarityService similarityService;
    private final TranslogConfig translogConfig;
    private final IndexEventListener indexEventListener;
    private final QueryCachingPolicy cachingPolicy;
    private final Supplier<Sort> indexSortSupplier;
    final CircuitBreakerService circuitBreakerService;
    private final SearchOperationListener searchOperationListener;
    private final GlobalCheckpointListeners globalCheckpointListeners;
    private final ReplicationTracker replicationTracker;
    protected volatile ShardRouting shardRouting;
    protected volatile IndexShardState state;
    private final Object postRecoveryMutex = new Object();
    private volatile long pendingPrimaryTerm;
    private final Object engineMutex = new Object();
    private final AtomicReference<Engine> currentEngineReference = new AtomicReference();
    final EngineFactory engineFactory;
    private final IndexingOperationListener indexingOperationListeners;
    private final Runnable globalCheckpointSyncer;
    private final RetentionLeaseSyncer retentionLeaseSyncer;
    @Nullable
    private RecoveryState recoveryState;
    private final RecoveryStats recoveryStats = new RecoveryStats();
    private final MeanMetric refreshMetric = new MeanMetric();
    private final MeanMetric externalRefreshMetric = new MeanMetric();
    private final MeanMetric flushMetric = new MeanMetric();
    private final CounterMetric periodicFlushMetric = new CounterMetric();
    private final ShardEventListener shardEventListener = new ShardEventListener();
    private final ShardPath path;
    private final IndexShardOperationPermits indexShardOperationPermits;
    private static final EnumSet<IndexShardState> readAllowedStates = EnumSet.of(IndexShardState.STARTED, IndexShardState.POST_RECOVERY);
    private static final EnumSet<IndexShardState> writeAllowedStates = EnumSet.of(IndexShardState.RECOVERING, IndexShardState.POST_RECOVERY, IndexShardState.STARTED);
    private final CheckedFunction<DirectoryReader, DirectoryReader, IOException> readerWrapper;
    private final AtomicBoolean active = new AtomicBoolean();
    private final RefreshListeners refreshListeners;
    private final AtomicLong lastSearcherAccess = new AtomicLong();
    private final AtomicReference<Translog.Location> pendingRefreshLocation = new AtomicReference();
    private final RefreshPendingLocationListener refreshPendingLocationListener;
    private volatile boolean useRetentionLeasesInPeerRecovery;
    private final AtomicBoolean primaryReplicaResyncInProgress = new AtomicBoolean();
    public static final int OPERATIONS_BLOCKED = -1;
    private final AsyncIOProcessor<Translog.Location> translogSyncProcessor;
    private final AtomicBoolean flushOrRollRunning = new AtomicBoolean();

    Runnable getGlobalCheckpointSyncer() {
        return this.globalCheckpointSyncer;
    }

    public IndexShard(ShardRouting shardRouting, IndexSettings indexSettings, ShardPath path, Store store, Supplier<Sort> indexSortSupplier, IndexCache indexCache, MapperService mapperService, SimilarityService similarityService, @Nullable EngineFactory engineFactory, IndexEventListener indexEventListener, CheckedFunction<DirectoryReader, DirectoryReader, IOException> indexReaderWrapper, ThreadPool threadPool, BigArrays bigArrays, Engine.Warmer warmer, List<SearchOperationListener> searchOperationListener, List<IndexingOperationListener> listeners, Runnable globalCheckpointSyncer, RetentionLeaseSyncer retentionLeaseSyncer, CircuitBreakerService circuitBreakerService) throws IOException {
        super(shardRouting.shardId(), indexSettings);
        long primaryTerm;
        assert (shardRouting.initializing());
        this.shardRouting = shardRouting;
        Settings settings = indexSettings.getSettings();
        this.codecService = new CodecService(mapperService, this.logger);
        this.warmer = warmer;
        this.similarityService = similarityService;
        Objects.requireNonNull(store, "Store must be provided to the index shard");
        this.engineFactory = Objects.requireNonNull(engineFactory);
        this.store = store;
        this.indexSortSupplier = indexSortSupplier;
        this.indexEventListener = indexEventListener;
        this.threadPool = threadPool;
        this.translogSyncProcessor = IndexShard.createTranslogSyncProcessor(this.logger, threadPool.getThreadContext(), this::getEngine);
        this.mapperService = mapperService;
        this.indexCache = indexCache;
        this.internalIndexingStats = new InternalIndexingStats();
        ArrayList<IndexingOperationListener> listenersList = new ArrayList<IndexingOperationListener>(listeners);
        listenersList.add(this.internalIndexingStats);
        this.indexingOperationListeners = new IndexingOperationListener.CompositeListener(listenersList, this.logger);
        this.globalCheckpointSyncer = globalCheckpointSyncer;
        this.retentionLeaseSyncer = Objects.requireNonNull(retentionLeaseSyncer);
        ArrayList<SearchOperationListener> searchListenersList = new ArrayList<SearchOperationListener>(searchOperationListener);
        searchListenersList.add(this.searchStats);
        this.searchOperationListener = new SearchOperationListener.CompositeListener(searchListenersList, this.logger);
        this.getService = new ShardGetService(indexSettings, this, mapperService);
        this.shardWarmerService = new ShardIndexWarmerService(this.shardId, indexSettings);
        this.requestCacheStats = new ShardRequestCache();
        this.shardFieldData = new ShardFieldData();
        this.shardBitsetFilterCache = new ShardBitsetFilterCache(this.shardId, indexSettings);
        this.state = IndexShardState.CREATED;
        this.path = path;
        this.circuitBreakerService = circuitBreakerService;
        this.logger.debug("state: [CREATED]");
        this.checkIndexOnStartup = indexSettings.getValue(IndexSettings.INDEX_CHECK_ON_STARTUP);
        this.translogConfig = new TranslogConfig(this.shardId, this.shardPath().resolveTranslog(), indexSettings, bigArrays);
        String aId = shardRouting.allocationId().getId();
        this.pendingPrimaryTerm = primaryTerm = indexSettings.getIndexMetadata().primaryTerm(this.shardId.id());
        this.globalCheckpointListeners = new GlobalCheckpointListeners(this.shardId, threadPool.scheduler(), this.logger);
        this.replicationTracker = new ReplicationTracker(this.shardId, aId, indexSettings, primaryTerm, -2L, this.globalCheckpointListeners::globalCheckpointUpdated, threadPool::absoluteTimeInMillis, (retentionLeases, listener) -> retentionLeaseSyncer.sync(this.shardId, aId, this.getPendingPrimaryTerm(), (RetentionLeases)retentionLeases, (ActionListener<ReplicationResponse>)listener), this::getSafeCommitInfo);
        this.cachingPolicy = IndexModule.INDEX_QUERY_CACHE_EVERYTHING_SETTING.get(settings) != false ? new QueryCachingPolicy(){

            public void onUse(Query query) {
            }

            public boolean shouldCache(Query query) {
                return true;
            }
        } : new UsageTrackingQueryCachingPolicy();
        this.indexShardOperationPermits = new IndexShardOperationPermits(this.shardId, threadPool);
        this.readerWrapper = indexReaderWrapper;
        this.refreshListeners = this.buildRefreshListeners();
        this.lastSearcherAccess.set(threadPool.relativeTimeInMillis());
        IndexShard.persistMetadata(path, indexSettings, shardRouting, null, this.logger);
        this.useRetentionLeasesInPeerRecovery = this.replicationTracker.hasAllPeerRecoveryRetentionLeases();
        this.refreshPendingLocationListener = new RefreshPendingLocationListener();
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public Store store() {
        return this.store;
    }

    public Sort getIndexSort() {
        return this.indexSortSupplier.get();
    }

    public ShardGetService getService() {
        return this.getService;
    }

    public ShardBitsetFilterCache shardBitsetFilterCache() {
        return this.shardBitsetFilterCache;
    }

    public MapperService mapperService() {
        return this.mapperService;
    }

    public SearchOperationListener getSearchOperationListener() {
        return this.searchOperationListener;
    }

    public ShardIndexWarmerService warmerService() {
        return this.shardWarmerService;
    }

    public ShardRequestCache requestCache() {
        return this.requestCacheStats;
    }

    public ShardFieldData fieldData() {
        return this.shardFieldData;
    }

    public long getPendingPrimaryTerm() {
        return this.pendingPrimaryTerm;
    }

    public long getOperationPrimaryTerm() {
        return this.replicationTracker.getOperationPrimaryTerm();
    }

    @Override
    public ShardRouting routingEntry() {
        return this.shardRouting;
    }

    public QueryCachingPolicy getQueryCachingPolicy() {
        return this.cachingPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateShardState(ShardRouting newRouting, long newPrimaryTerm, BiConsumer<IndexShard, ActionListener<PrimaryReplicaSyncer.ResyncTask>> primaryReplicaSyncer, long applyingClusterStateVersion, Set<String> inSyncAllocationIds, IndexShardRoutingTable routingTable) throws IOException {
        ShardRouting currentRouting;
        Object object = this.mutex;
        synchronized (object) {
            currentRouting = this.shardRouting;
            assert (currentRouting != null);
            if (!newRouting.shardId().equals(this.shardId())) {
                throw new IllegalArgumentException("Trying to set a routing entry with shardId " + newRouting.shardId() + " on a shard with shardId " + this.shardId());
            }
            if (!newRouting.isSameAllocation(currentRouting)) {
                throw new IllegalArgumentException("Trying to set a routing entry with a different allocation. Current " + currentRouting + ", new " + newRouting);
            }
            if (currentRouting.primary() && !newRouting.primary()) {
                throw new IllegalArgumentException("illegal state: trying to move shard from primary mode to replica mode. Current " + currentRouting + ", new " + newRouting);
            }
            if (newRouting.primary()) {
                this.replicationTracker.updateFromMaster(applyingClusterStateVersion, inSyncAllocationIds, routingTable);
            }
            if (this.state == IndexShardState.POST_RECOVERY && newRouting.active()) {
                assert (!currentRouting.active()) : "we are in POST_RECOVERY, but our shard routing is active " + currentRouting;
                assert (!currentRouting.isRelocationTarget() || !currentRouting.primary() || this.replicationTracker.isPrimaryMode()) : "a primary relocation is completed by the master, but primary mode is not active " + currentRouting;
                this.changeState(IndexShardState.STARTED, "global state is [" + (Object)((Object)newRouting.state()) + "]");
            } else if (currentRouting.primary() && currentRouting.relocating() && this.replicationTracker.isRelocated() && (!newRouting.relocating() || !newRouting.equalsIgnoringMetadata(currentRouting))) {
                throw new IndexShardRelocatedException(this.shardId(), "Shard is marked as relocated, cannot safely move to state " + (Object)((Object)newRouting.state()));
            }
            assert (!newRouting.active() || this.state == IndexShardState.STARTED || this.state == IndexShardState.CLOSED) : "routing is active, but local shard state isn't. routing: " + newRouting + ", local state: " + (Object)((Object)this.state);
            IndexShard.persistMetadata(this.path, this.indexSettings, newRouting, currentRouting, this.logger);
            CountDownLatch shardStateUpdated = new CountDownLatch(1);
            if (newRouting.primary()) {
                if (newPrimaryTerm == this.pendingPrimaryTerm) {
                    if (currentRouting.initializing() && !currentRouting.isRelocationTarget() && newRouting.active()) {
                        this.replicationTracker.activatePrimaryMode(this.getLocalCheckpoint());
                        this.ensurePeerRecoveryRetentionLeasesExist();
                    }
                } else {
                    assert (!currentRouting.primary()) : "term is only increased as part of primary promotion";
                    assert (!newRouting.initializing()) : "a started primary shard should never update its term; shard " + newRouting + ", current term [" + this.pendingPrimaryTerm + "], new term [" + newPrimaryTerm + "]";
                    assert (newPrimaryTerm > this.pendingPrimaryTerm) : "primary terms can only go up; current term [" + this.pendingPrimaryTerm + "], new term [" + newPrimaryTerm + "]";
                    boolean resyncStarted = this.primaryReplicaResyncInProgress.compareAndSet(false, true);
                    if (!resyncStarted) {
                        throw new IllegalStateException("cannot start resync while it's already in progress");
                    }
                    this.bumpPrimaryTerm(newPrimaryTerm, () -> {
                        shardStateUpdated.await();
                        assert (this.pendingPrimaryTerm == newPrimaryTerm) : "shard term changed on primary. expected [" + newPrimaryTerm + "] but was [" + this.pendingPrimaryTerm + "], current routing: " + currentRouting + ", new routing: " + newRouting;
                        assert (this.getOperationPrimaryTerm() == newPrimaryTerm);
                        try {
                            this.replicationTracker.activatePrimaryMode(this.getLocalCheckpoint());
                            this.ensurePeerRecoveryRetentionLeasesExist();
                            Engine engine = this.getEngine();
                            engine.restoreLocalHistoryFromTranslog((resettingEngine, snapshot) -> this.runTranslogRecovery(resettingEngine, snapshot, Engine.Operation.Origin.LOCAL_RESET, () -> {}));
                            engine.rollTranslogGeneration();
                            engine.fillSeqNoGaps(newPrimaryTerm);
                            this.replicationTracker.updateLocalCheckpoint(currentRouting.allocationId().getId(), this.getLocalCheckpoint());
                            primaryReplicaSyncer.accept(this, new ActionListener<PrimaryReplicaSyncer.ResyncTask>(){

                                @Override
                                public void onResponse(PrimaryReplicaSyncer.ResyncTask resyncTask) {
                                    IndexShard.this.logger.info("primary-replica resync completed with {} operations", (Object)resyncTask.getResyncedOperations());
                                    boolean resyncCompleted = IndexShard.this.primaryReplicaResyncInProgress.compareAndSet(true, false);
                                    assert (resyncCompleted) : "primary-replica resync finished but was not started";
                                }

                                @Override
                                public void onFailure(Exception e) {
                                    boolean resyncCompleted = IndexShard.this.primaryReplicaResyncInProgress.compareAndSet(true, false);
                                    assert (resyncCompleted) : "primary-replica resync finished but was not started";
                                    if (IndexShard.this.state != IndexShardState.CLOSED) {
                                        IndexShard.this.failShard("exception during primary-replica resync", e);
                                    }
                                }
                            });
                        }
                        catch (AlreadyClosedException alreadyClosedException) {
                            // empty catch block
                        }
                    }, null);
                }
            }
            this.shardRouting = newRouting;
            assert (!this.shardRouting.primary() || !this.shardRouting.started() || this.indexShardOperationPermits.isBlocked() || this.replicationTracker.isPrimaryMode()) : "a started primary with non-pending operation term must be in primary mode " + this.shardRouting;
            shardStateUpdated.countDown();
        }
        if (!currentRouting.active() && newRouting.active()) {
            this.indexEventListener.afterIndexShardStarted(this);
        }
        if (!newRouting.equals(currentRouting)) {
            this.indexEventListener.shardRoutingChanged(this, currentRouting, newRouting);
        }
        if (this.indexSettings.isSoftDeleteEnabled() && !this.useRetentionLeasesInPeerRecovery && this.state() == IndexShardState.STARTED) {
            RetentionLeases retentionLeases = this.replicationTracker.getRetentionLeases();
            HashSet<ShardRouting> shardRoutings = new HashSet<ShardRouting>(routingTable.getShards());
            shardRoutings.addAll(routingTable.assignedShards());
            if (shardRoutings.stream().allMatch(shr -> shr.assignedToNode() && retentionLeases.contains(ReplicationTracker.getPeerRecoveryRetentionLeaseId(shr)))) {
                this.useRetentionLeasesInPeerRecovery = true;
                this.turnOffTranslogRetention();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexShardState markAsRecovering(String reason, RecoveryState recoveryState) throws IndexShardStartedException, IndexShardRelocatedException, IndexShardRecoveringException, IndexShardClosedException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.state == IndexShardState.CLOSED) {
                throw new IndexShardClosedException(this.shardId);
            }
            if (this.state == IndexShardState.STARTED) {
                throw new IndexShardStartedException(this.shardId);
            }
            if (this.state == IndexShardState.RECOVERING) {
                throw new IndexShardRecoveringException(this.shardId);
            }
            if (this.state == IndexShardState.POST_RECOVERY) {
                throw new IndexShardRecoveringException(this.shardId);
            }
            this.recoveryState = recoveryState;
            return this.changeState(IndexShardState.RECOVERING, reason);
        }
    }

    public void relocated(String targetAllocationId, Consumer<ReplicationTracker.PrimaryContext> consumer) throws IllegalIndexShardStateException, IllegalStateException, InterruptedException {
        assert (this.shardRouting.primary()) : "only primaries can be marked as relocated: " + this.shardRouting;
        try (Releasable forceRefreshes = this.refreshListeners.forceRefreshes();){
            this.indexShardOperationPermits.blockOperations(30L, TimeUnit.MINUTES, () -> {
                forceRefreshes.close();
                assert (this.indexShardOperationPermits.getActiveOperationsCount() == -1) : "in-flight operations in progress while moving shard state to relocated";
                this.verifyRelocatingState();
                ReplicationTracker.PrimaryContext primaryContext = this.replicationTracker.startRelocationHandoff(targetAllocationId);
                try {
                    consumer.accept(primaryContext);
                    Object object = this.mutex;
                    synchronized (object) {
                        this.verifyRelocatingState();
                        this.replicationTracker.completeRelocationHandoff();
                    }
                }
                catch (Exception e) {
                    try {
                        this.replicationTracker.abortRelocationHandoff();
                    }
                    catch (Exception inner) {
                        e.addSuppressed(inner);
                    }
                    throw e;
                }
            });
        }
        catch (TimeoutException e) {
            this.logger.warn("timed out waiting for relocation hand-off to complete");
            this.failShard("timed out waiting for relocation hand-off to complete", null);
            throw new IndexShardClosedException(this.shardId(), "timed out waiting for relocation hand-off to complete");
        }
    }

    private void verifyRelocatingState() {
        if (this.state != IndexShardState.STARTED) {
            throw new IndexShardNotStartedException(this.shardId, this.state);
        }
        if (!this.shardRouting.relocating()) {
            throw new IllegalIndexShardStateException(this.shardId, IndexShardState.STARTED, ": shard is no longer relocating " + this.shardRouting, new Object[0]);
        }
        if (this.primaryReplicaResyncInProgress.get()) {
            throw new IllegalIndexShardStateException(this.shardId, IndexShardState.STARTED, ": primary relocation is forbidden while primary-replica resync is in progress " + this.shardRouting, new Object[0]);
        }
    }

    @Override
    public IndexShardState state() {
        return this.state;
    }

    private IndexShardState changeState(IndexShardState newState, String reason) {
        assert (Thread.holdsLock(this.mutex));
        this.logger.debug("state: [{}]->[{}], reason [{}]", (Object)this.state, (Object)newState, (Object)reason);
        IndexShardState previousState = this.state;
        this.state = newState;
        this.indexEventListener.indexShardStateChanged(this, previousState, newState, reason);
        return previousState;
    }

    public Engine.IndexResult applyIndexOperationOnPrimary(long version, VersionType versionType, SourceToParse sourceToParse, long ifSeqNo, long ifPrimaryTerm, long autoGeneratedTimestamp, boolean isRetry) throws IOException {
        assert (versionType.validateVersionForWrites(version));
        return this.applyIndexOperation(this.getEngine(), -2L, this.getOperationPrimaryTerm(), version, versionType, ifSeqNo, ifPrimaryTerm, autoGeneratedTimestamp, isRetry, Engine.Operation.Origin.PRIMARY, sourceToParse);
    }

    public Engine.IndexResult applyIndexOperationOnReplica(long seqNo, long opPrimaryTerm, long version, long autoGeneratedTimeStamp, boolean isRetry, SourceToParse sourceToParse) throws IOException {
        return this.applyIndexOperation(this.getEngine(), seqNo, opPrimaryTerm, version, null, -2L, 0L, autoGeneratedTimeStamp, isRetry, Engine.Operation.Origin.REPLICA, sourceToParse);
    }

    private Engine.IndexResult applyIndexOperation(Engine engine, long seqNo, long opPrimaryTerm, long version, @Nullable VersionType versionType, long ifSeqNo, long ifPrimaryTerm, long autoGeneratedTimeStamp, boolean isRetry, Engine.Operation.Origin origin, SourceToParse sourceToParse) throws IOException {
        Engine.Index operation;
        assert (opPrimaryTerm <= this.getOperationPrimaryTerm()) : "op term [ " + opPrimaryTerm + " ] > shard term [" + this.getOperationPrimaryTerm() + "]";
        this.ensureWriteAllowed(origin);
        try {
            String resolvedType = this.mapperService.resolveDocumentType(sourceToParse.type());
            SourceToParse sourceWithResolvedType = resolvedType.equals(sourceToParse.type()) ? sourceToParse : new SourceToParse(sourceToParse.index(), resolvedType, sourceToParse.id(), sourceToParse.source(), sourceToParse.getXContentType(), sourceToParse.routing());
            operation = IndexShard.prepareIndex(this.docMapper(resolvedType), sourceWithResolvedType, seqNo, opPrimaryTerm, version, versionType, origin, autoGeneratedTimeStamp, isRetry, ifSeqNo, ifPrimaryTerm);
            Mapping update = operation.parsedDoc().dynamicMappingsUpdate();
            if (update != null) {
                return new Engine.IndexResult(update);
            }
        }
        catch (Exception e) {
            this.verifyNotClosed(e);
            return new Engine.IndexResult(e, version, opPrimaryTerm, seqNo);
        }
        return this.index(engine, operation);
    }

    public static Engine.Index prepareIndex(DocumentMapperForType docMapper, SourceToParse source, long seqNo, long primaryTerm, long version, VersionType versionType, Engine.Operation.Origin origin, long autoGeneratedIdTimestamp, boolean isRetry, long ifSeqNo, long ifPrimaryTerm) {
        long startTime = System.nanoTime();
        ParsedDocument doc = docMapper.getDocumentMapper().parse(source);
        if (docMapper.getMapping() != null) {
            doc.addDynamicMappingsUpdate(docMapper.getMapping());
        }
        Term uid = new Term("_id", Uid.encodeId(doc.id()));
        return new Engine.Index(uid, doc, seqNo, primaryTerm, version, versionType, origin, startTime, autoGeneratedIdTimestamp, isRetry, ifSeqNo, ifPrimaryTerm);
    }

    private Engine.IndexResult index(Engine engine, Engine.Index index) throws IOException {
        Engine.IndexResult result;
        this.active.set(true);
        index = this.indexingOperationListeners.preIndex(this.shardId, index);
        try {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("index [{}][{}] seq# [{}] allocation-id [{}] primaryTerm [{}] operationPrimaryTerm [{}] origin [{}]", (Object)index.type(), (Object)index.id(), (Object)index.seqNo(), (Object)this.routingEntry().allocationId(), (Object)index.primaryTerm(), (Object)this.getOperationPrimaryTerm(), (Object)index.origin());
            }
            result = engine.index(index);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("index-done [{}][{}] seq# [{}] allocation-id [{}] primaryTerm [{}] operationPrimaryTerm [{}] origin [{}] result-seq# [{}] result-term [{}] failure [{}]", (Object)index.type(), (Object)index.id(), (Object)index.seqNo(), (Object)this.routingEntry().allocationId(), (Object)index.primaryTerm(), (Object)this.getOperationPrimaryTerm(), (Object)index.origin(), (Object)result.getSeqNo(), (Object)result.getTerm(), (Object)result.getFailure());
            }
        }
        catch (Exception e) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Message)new ParameterizedMessage("index-fail [{}][{}] seq# [{}] allocation-id [{}] primaryTerm [{}] operationPrimaryTerm [{}] origin [{}]", new Object[]{index.type(), index.id(), index.seqNo(), this.routingEntry().allocationId(), index.primaryTerm(), this.getOperationPrimaryTerm(), index.origin()}), (Throwable)e);
            }
            this.indexingOperationListeners.postIndex(this.shardId, index, e);
            throw e;
        }
        this.indexingOperationListeners.postIndex(this.shardId, index, result);
        return result;
    }

    public Engine.NoOpResult markSeqNoAsNoop(long seqNo, long opPrimaryTerm, String reason) throws IOException {
        return this.markSeqNoAsNoop(this.getEngine(), seqNo, opPrimaryTerm, reason, Engine.Operation.Origin.REPLICA);
    }

    private Engine.NoOpResult markSeqNoAsNoop(Engine engine, long seqNo, long opPrimaryTerm, String reason, Engine.Operation.Origin origin) throws IOException {
        assert (opPrimaryTerm <= this.getOperationPrimaryTerm()) : "op term [ " + opPrimaryTerm + " ] > shard term [" + this.getOperationPrimaryTerm() + "]";
        long startTime = System.nanoTime();
        this.ensureWriteAllowed(origin);
        Engine.NoOp noOp = new Engine.NoOp(seqNo, opPrimaryTerm, origin, startTime, reason);
        return this.noOp(engine, noOp);
    }

    private Engine.NoOpResult noOp(Engine engine, Engine.NoOp noOp) throws IOException {
        this.active.set(true);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("noop (seq# [{}])", (Object)noOp.seqNo());
        }
        return engine.noOp(noOp);
    }

    public Engine.IndexResult getFailedIndexResult(Exception e, long version) {
        return new Engine.IndexResult(e, version);
    }

    public Engine.DeleteResult getFailedDeleteResult(Exception e, long version) {
        return new Engine.DeleteResult(e, version, this.getOperationPrimaryTerm());
    }

    public Engine.DeleteResult applyDeleteOperationOnPrimary(long version, String type, String id, VersionType versionType, long ifSeqNo, long ifPrimaryTerm) throws IOException {
        assert (versionType.validateVersionForWrites(version));
        return this.applyDeleteOperation(this.getEngine(), -2L, this.getOperationPrimaryTerm(), version, type, id, versionType, ifSeqNo, ifPrimaryTerm, Engine.Operation.Origin.PRIMARY);
    }

    public Engine.DeleteResult applyDeleteOperationOnReplica(long seqNo, long opPrimaryTerm, long version, String type, String id) throws IOException {
        return this.applyDeleteOperation(this.getEngine(), seqNo, opPrimaryTerm, version, type, id, null, -2L, 0L, Engine.Operation.Origin.REPLICA);
    }

    private Engine.DeleteResult applyDeleteOperation(Engine engine, long seqNo, long opPrimaryTerm, long version, String type, String id, @Nullable VersionType versionType, long ifSeqNo, long ifPrimaryTerm, Engine.Operation.Origin origin) throws IOException {
        assert (opPrimaryTerm <= this.getOperationPrimaryTerm()) : "op term [ " + opPrimaryTerm + " ] > shard term [" + this.getOperationPrimaryTerm() + "]";
        this.ensureWriteAllowed(origin);
        try {
            Mapping update = this.docMapper(type).getMapping();
            if (update != null) {
                return new Engine.DeleteResult(update);
            }
        }
        catch (IllegalArgumentException | MapperParsingException | TypeMissingException e) {
            return new Engine.DeleteResult(e, version, this.getOperationPrimaryTerm(), seqNo, false);
        }
        if (!this.mapperService.resolveDocumentType(type).equals(this.mapperService.documentMapper().type())) {
            throw new IllegalStateException("Deleting document from type [" + this.mapperService.resolveDocumentType(type) + "] while current type is [" + this.mapperService.documentMapper().type() + "]");
        }
        Term uid = new Term("_id", Uid.encodeId(id));
        Engine.Delete delete = this.prepareDelete(type, id, uid, seqNo, opPrimaryTerm, version, versionType, origin, ifSeqNo, ifPrimaryTerm);
        return this.delete(engine, delete);
    }

    private Engine.Delete prepareDelete(String type, String id, Term uid, long seqNo, long primaryTerm, long version, VersionType versionType, Engine.Operation.Origin origin, long ifSeqNo, long ifPrimaryTerm) {
        long startTime = System.nanoTime();
        return new Engine.Delete(this.mapperService.resolveDocumentType(type), id, uid, seqNo, primaryTerm, version, versionType, origin, startTime, ifSeqNo, ifPrimaryTerm);
    }

    private Engine.DeleteResult delete(Engine engine, Engine.Delete delete) throws IOException {
        Engine.DeleteResult result;
        this.active.set(true);
        delete = this.indexingOperationListeners.preDelete(this.shardId, delete);
        try {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("delete [{}] (seq no [{}])", (Object)delete.uid().text(), (Object)delete.seqNo());
            }
            result = engine.delete(delete);
        }
        catch (Exception e) {
            this.indexingOperationListeners.postDelete(this.shardId, delete, e);
            throw e;
        }
        this.indexingOperationListeners.postDelete(this.shardId, delete, result);
        return result;
    }

    public Engine.GetResult get(Engine.Get get) {
        this.readAllowed();
        DocumentMapper mapper = this.mapperService.documentMapper();
        if (mapper == null || !mapper.type().equals(this.mapperService.resolveDocumentType(get.type()))) {
            return Engine.GetResult.NOT_EXISTS;
        }
        return this.getEngine().get(get, this::acquireSearcher);
    }

    public void refresh(String source) {
        this.verifyNotClosed();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("refresh with source [{}]", (Object)source);
        }
        this.getEngine().refresh(source);
    }

    public long getWritingBytes() {
        Engine engine = this.getEngineOrNull();
        if (engine == null) {
            return 0L;
        }
        return engine.getWritingBytes();
    }

    public RefreshStats refreshStats() {
        int listeners = this.refreshListeners.pendingCount();
        return new RefreshStats(this.refreshMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.refreshMetric.sum()), this.externalRefreshMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.externalRefreshMetric.sum()), listeners);
    }

    public FlushStats flushStats() {
        return new FlushStats(this.flushMetric.count(), this.periodicFlushMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.flushMetric.sum()));
    }

    public DocsStats docStats() {
        this.readAllowed();
        return this.getEngine().docStats();
    }

    public CommitStats commitStats() {
        return this.getEngine().commitStats();
    }

    public SeqNoStats seqNoStats() {
        return this.getEngine().getSeqNoStats(this.replicationTracker.getGlobalCheckpoint());
    }

    public IndexingStats indexingStats(String ... types) {
        long throttleTimeInMillis;
        boolean throttled;
        Engine engine = this.getEngineOrNull();
        if (engine == null) {
            throttled = false;
            throttleTimeInMillis = 0L;
        } else {
            throttled = engine.isThrottled();
            throttleTimeInMillis = engine.getIndexThrottleTimeInMillis();
        }
        return this.internalIndexingStats.stats(throttled, throttleTimeInMillis, types);
    }

    public SearchStats searchStats(String ... groups) {
        return this.searchStats.stats(groups);
    }

    public GetStats getStats() {
        return this.getService.stats();
    }

    public StoreStats storeStats() {
        try {
            return this.store.stats();
        }
        catch (IOException e) {
            this.failShard("Failing shard because of exception during storeStats", e);
            throw new ElasticsearchException("io exception while building 'store stats'", (Throwable)e, new Object[0]);
        }
    }

    public MergeStats mergeStats() {
        Engine engine = this.getEngineOrNull();
        if (engine == null) {
            return new MergeStats();
        }
        return engine.getMergeStats();
    }

    public SegmentsStats segmentStats(boolean includeSegmentFileSizes, boolean includeUnloadedSegments) {
        SegmentsStats segmentsStats = this.getEngine().segmentsStats(includeSegmentFileSizes, includeUnloadedSegments);
        segmentsStats.addBitsetMemoryInBytes(this.shardBitsetFilterCache.getMemorySizeInBytes());
        return segmentsStats;
    }

    public WarmerStats warmerStats() {
        return this.shardWarmerService.stats();
    }

    public FieldDataStats fieldDataStats(String ... fields) {
        return this.shardFieldData.stats(fields);
    }

    public TranslogStats translogStats() {
        return this.getEngine().getTranslogStats();
    }

    public CompletionStats completionStats(String ... fields) {
        this.readAllowed();
        return this.getEngine().completionStats(fields);
    }

    public Engine.SyncedFlushResult syncFlush(String syncId, Engine.CommitId expectedCommitId) {
        this.verifyNotClosed();
        this.logger.trace("trying to sync flush. sync id [{}]. expected commit id [{}]]", (Object)syncId, (Object)expectedCommitId);
        return this.getEngine().syncFlush(syncId, expectedCommitId);
    }

    public Engine.CommitId flush(FlushRequest request) {
        boolean waitIfOngoing = request.waitIfOngoing();
        boolean force = request.force();
        this.logger.trace("flush with {}", (Object)request);
        this.verifyNotClosed();
        long time = System.nanoTime();
        Engine.CommitId commitId = this.getEngine().flush(force, waitIfOngoing);
        this.flushMetric.inc(System.nanoTime() - time);
        return commitId;
    }

    public void trimTranslog() {
        this.verifyNotClosed();
        Engine engine = this.getEngine();
        engine.trimUnreferencedTranslogFiles();
    }

    public void rollTranslogGeneration() {
        Engine engine = this.getEngine();
        engine.rollTranslogGeneration();
    }

    public void forceMerge(ForceMergeRequest forceMerge) throws IOException {
        this.verifyActive();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("force merge with {}", (Object)forceMerge);
        }
        Engine engine = this.getEngine();
        engine.forceMerge(forceMerge.flush(), forceMerge.maxNumSegments(), forceMerge.onlyExpungeDeletes(), false, false, forceMerge.forceMergeUUID());
    }

    public org.apache.lucene.util.Version upgrade(UpgradeRequest upgrade) throws IOException {
        this.verifyActive();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("upgrade with {}", (Object)upgrade);
        }
        org.apache.lucene.util.Version previousVersion = this.minimumCompatibleVersion();
        Engine engine = this.getEngine();
        engine.forceMerge(true, Integer.MAX_VALUE, false, true, upgrade.upgradeOnlyAncientSegments(), null);
        org.apache.lucene.util.Version version = this.minimumCompatibleVersion();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("upgraded segments for {} from version {} to version {}", (Object)this.shardId, (Object)previousVersion, (Object)version);
        }
        return version;
    }

    public org.apache.lucene.util.Version minimumCompatibleVersion() {
        org.apache.lucene.util.Version luceneVersion = null;
        for (Segment segment : this.getEngine().segments(false)) {
            if (luceneVersion != null && !luceneVersion.onOrAfter(segment.getVersion())) continue;
            luceneVersion = segment.getVersion();
        }
        return luceneVersion == null ? this.indexSettings.getIndexVersionCreated().luceneVersion : luceneVersion;
    }

    public Engine.IndexCommitRef acquireLastIndexCommit(boolean flushFirst) throws EngineException {
        IndexShardState state = this.state;
        if (state == IndexShardState.STARTED || state == IndexShardState.CLOSED) {
            return this.getEngine().acquireLastIndexCommit(flushFirst);
        }
        throw new IllegalIndexShardStateException(this.shardId, state, "snapshot is not allowed", new Object[0]);
    }

    public Engine.IndexCommitRef acquireSafeIndexCommit() throws EngineException {
        IndexShardState state = this.state;
        if (state == IndexShardState.STARTED || state == IndexShardState.CLOSED) {
            return this.getEngine().acquireSafeIndexCommit();
        }
        throw new IllegalIndexShardStateException(this.shardId, state, "snapshot is not allowed", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Store.MetadataSnapshot snapshotStoreMetadata() throws IOException {
        Object object;
        Engine.IndexCommitRef indexCommit;
        block8: {
            Store.MetadataSnapshot metadataSnapshot;
            assert (!Thread.holdsLock(this.mutex)) : "snapshotting store metadata under mutex";
            indexCommit = null;
            this.store.incRef();
            try {
                object = this.engineMutex;
                // MONITORENTER : object
                Engine engine = this.getEngineOrNull();
                if (engine != null) {
                    indexCommit = engine.acquireLastIndexCommit(false);
                }
                if (indexCommit != null) break block8;
                metadataSnapshot = this.store.getMetadata(null, true);
                // MONITOREXIT : object
                this.store.decRef();
            }
            catch (Throwable throwable) {
                this.store.decRef();
                IOUtils.close((Closeable[])new Closeable[]{indexCommit});
                throw throwable;
            }
            IOUtils.close((Closeable[])new Closeable[]{indexCommit});
            return metadataSnapshot;
        }
        // MONITOREXIT : object
        object = this.store.getMetadata(indexCommit.getIndexCommit());
        this.store.decRef();
        IOUtils.close((Closeable[])new Closeable[]{indexCommit});
        return object;
    }

    public void failShard(String reason, @Nullable Exception e) {
        this.getEngine().failEngine(reason, e);
    }

    public Engine.Searcher acquireCanMatchSearcher() {
        this.readAllowed();
        this.markSearcherAccessed();
        return this.getEngine().acquireSearcher("can_match", Engine.SearcherScope.EXTERNAL);
    }

    public Engine.Searcher acquireSearcher(String source) {
        return this.acquireSearcher(source, Engine.SearcherScope.EXTERNAL);
    }

    private void markSearcherAccessed() {
        this.lastSearcherAccess.lazySet(this.threadPool.relativeTimeInMillis());
    }

    private Engine.Searcher acquireSearcher(String source, Engine.SearcherScope scope) {
        this.readAllowed();
        this.markSearcherAccessed();
        Engine engine = this.getEngine();
        Engine.Searcher searcher = engine.acquireSearcher(source, scope);
        return this.wrapSearcher(searcher);
    }

    private Engine.Searcher wrapSearcher(Engine.Searcher searcher) {
        Engine.Searcher searcher2;
        block7: {
            assert (ElasticsearchDirectoryReader.unwrap((DirectoryReader)searcher.getDirectoryReader()) != null) : "DirectoryReader must be an instance or ElasticsearchDirectoryReader";
            boolean success = false;
            try {
                Engine.Searcher newSearcher;
                Engine.Searcher searcher3 = newSearcher = this.readerWrapper == null ? searcher : IndexShard.wrapSearcher(searcher, this.readerWrapper);
                assert (newSearcher != null);
                success = true;
                searcher2 = newSearcher;
                if (success) break block7;
            }
            catch (IOException ex) {
                try {
                    throw new ElasticsearchException("failed to wrap searcher", (Throwable)ex, new Object[0]);
                }
                catch (Throwable throwable) {
                    if (!success) {
                        Releasables.close(success, searcher);
                    }
                    throw throwable;
                }
            }
            Releasables.close(success, searcher);
        }
        return searcher2;
    }

    static Engine.Searcher wrapSearcher(Engine.Searcher engineSearcher, CheckedFunction<DirectoryReader, DirectoryReader, IOException> readerWrapper) throws IOException {
        assert (readerWrapper != null);
        ElasticsearchDirectoryReader elasticsearchDirectoryReader = ElasticsearchDirectoryReader.getElasticsearchDirectoryReader(engineSearcher.getDirectoryReader());
        if (elasticsearchDirectoryReader == null) {
            throw new IllegalStateException("Can't wrap non elasticsearch directory reader");
        }
        NonClosingReaderWrapper nonClosingReaderWrapper = new NonClosingReaderWrapper(engineSearcher.getDirectoryReader());
        DirectoryReader reader = (DirectoryReader)readerWrapper.apply((Object)nonClosingReaderWrapper);
        if (reader != nonClosingReaderWrapper) {
            if (reader.getReaderCacheHelper() != elasticsearchDirectoryReader.getReaderCacheHelper()) {
                throw new IllegalStateException("wrapped directory reader doesn't delegate IndexReader#getCoreCacheKey, wrappers must override this method and delegate to the original readers core cache key. Wrapped readers can't be used as cache keys since their are used only per request which would lead to subtle bugs");
            }
            if (ElasticsearchDirectoryReader.getElasticsearchDirectoryReader(reader) != elasticsearchDirectoryReader) {
                throw new IllegalStateException("wrapped directory reader hides actual ElasticsearchDirectoryReader but shouldn't");
            }
        }
        if (reader == nonClosingReaderWrapper) {
            return engineSearcher;
        }
        return new Engine.Searcher(engineSearcher.source(), (IndexReader)reader, engineSearcher.getSimilarity(), engineSearcher.getQueryCache(), engineSearcher.getQueryCachingPolicy(), () -> IOUtils.close((Closeable[])new Closeable[]{reader, engineSearcher}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(String reason, boolean flushEngine) throws IOException {
        Object object = this.engineMutex;
        synchronized (object) {
            try {
                Object object2 = this.mutex;
                synchronized (object2) {
                    this.changeState(IndexShardState.CLOSED, reason);
                }
            }
            catch (Throwable throwable) {
                Engine engine = this.currentEngineReference.getAndSet(null);
                try {
                    if (engine != null && flushEngine) {
                        engine.flushAndClose();
                    }
                }
                catch (Throwable throwable2) {
                    IOUtils.close((Closeable[])new Closeable[]{engine, this.globalCheckpointListeners, this.refreshListeners});
                    this.indexShardOperationPermits.close();
                    throw throwable2;
                }
                IOUtils.close((Closeable[])new Closeable[]{engine, this.globalCheckpointListeners, this.refreshListeners});
                this.indexShardOperationPermits.close();
                throw throwable;
            }
            Engine engine = this.currentEngineReference.getAndSet(null);
            try {
                if (engine != null && flushEngine) {
                    engine.flushAndClose();
                }
            }
            catch (Throwable throwable) {
                IOUtils.close((Closeable[])new Closeable[]{engine, this.globalCheckpointListeners, this.refreshListeners});
                this.indexShardOperationPermits.close();
                throw throwable;
            }
            IOUtils.close((Closeable[])new Closeable[]{engine, this.globalCheckpointListeners, this.refreshListeners});
            this.indexShardOperationPermits.close();
        }
    }

    public void preRecovery() {
        IndexShardState currentState = this.state;
        if (currentState == IndexShardState.CLOSED) {
            throw new IndexShardNotRecoveringException(this.shardId, currentState);
        }
        assert (currentState == IndexShardState.RECOVERING) : "expected a recovering shard " + this.shardId + " but got " + (Object)((Object)currentState);
        this.indexEventListener.beforeIndexShardRecovery(this, this.indexSettings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postRecovery(String reason) throws IndexShardStartedException, IndexShardRelocatedException, IndexShardClosedException {
        Object object = this.postRecoveryMutex;
        synchronized (object) {
            this.getEngine().refresh("post_recovery");
            Object object2 = this.mutex;
            synchronized (object2) {
                if (this.state == IndexShardState.CLOSED) {
                    throw new IndexShardClosedException(this.shardId);
                }
                if (this.state == IndexShardState.STARTED) {
                    throw new IndexShardStartedException(this.shardId);
                }
                this.recoveryState.setStage(RecoveryState.Stage.DONE);
                this.changeState(IndexShardState.POST_RECOVERY, reason);
            }
        }
    }

    public void prepareForIndexRecovery() {
        if (this.state != IndexShardState.RECOVERING) {
            throw new IndexShardNotRecoveringException(this.shardId, this.state);
        }
        this.recoveryState.setStage(RecoveryState.Stage.INDEX);
        assert (this.currentEngineReference.get() == null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long recoverLocallyUpToGlobalCheckpoint() {
        Optional<SequenceNumbers.CommitInfo> safeCommit;
        long globalCheckpoint;
        assert (!Thread.holdsLock(this.mutex)) : "recover locally under mutex";
        if (this.state != IndexShardState.RECOVERING) {
            throw new IndexShardNotRecoveringException(this.shardId, this.state);
        }
        this.recoveryState.validateCurrentStage(RecoveryState.Stage.INDEX);
        assert (this.routingEntry().recoverySource().getType() == RecoverySource.Type.PEER) : "not a peer recovery [" + this.routingEntry() + "]";
        try {
            String translogUUID = (String)this.store.readLastCommittedSegmentsInfo().getUserData().get("translog_uuid");
            globalCheckpoint = Translog.readGlobalCheckpoint(this.translogConfig.getTranslogPath(), translogUUID);
            safeCommit = this.store.findSafeIndexCommit(globalCheckpoint);
        }
        catch (org.apache.lucene.index.IndexNotFoundException e) {
            this.logger.trace("skip local recovery as no index commit found");
            return -2L;
        }
        catch (Exception e) {
            this.logger.debug("skip local recovery as failed to find the safe commit", (Throwable)e);
            return -2L;
        }
        try {
            Object translogRecoveryRunner;
            this.maybeCheckIndex();
            this.recoveryState.setStage(RecoveryState.Stage.TRANSLOG);
            if (!safeCommit.isPresent()) {
                this.logger.trace("skip local recovery as no safe commit found");
                return -2L;
            }
            assert (safeCommit.get().localCheckpoint <= globalCheckpoint) : safeCommit.get().localCheckpoint + " > " + globalCheckpoint;
            if (safeCommit.get().localCheckpoint == globalCheckpoint) {
                this.logger.trace("skip local recovery as the safe commit is up to date; safe commit {} global checkpoint {}", (Object)safeCommit.get(), (Object)globalCheckpoint);
                this.recoveryState.getTranslog().totalLocal(0);
                return globalCheckpoint + 1L;
            }
            if (this.indexSettings.getIndexMetadata().getState() == IndexMetadata.State.CLOSE || IndexMetadata.INDEX_BLOCKS_WRITE_SETTING.get(this.indexSettings.getSettings()).booleanValue()) {
                this.logger.trace("skip local recovery as the index was closed or not allowed to write; safe commit {} global checkpoint {}", (Object)safeCommit.get(), (Object)globalCheckpoint);
                this.recoveryState.getTranslog().totalLocal(0);
                return safeCommit.get().localCheckpoint + 1L;
            }
            try {
                translogRecoveryRunner = (engine, snapshot) -> {
                    this.recoveryState.getTranslog().totalLocal(snapshot.totalOperations());
                    int recoveredOps = this.runTranslogRecovery(engine, snapshot, Engine.Operation.Origin.LOCAL_TRANSLOG_RECOVERY, this.recoveryState.getTranslog()::incrementRecoveredOperations);
                    this.recoveryState.getTranslog().totalLocal(recoveredOps);
                    return recoveredOps;
                };
                this.innerOpenEngineAndTranslog(() -> globalCheckpoint);
                this.getEngine().recoverFromTranslog((Engine.TranslogRecoveryRunner)translogRecoveryRunner, globalCheckpoint);
                this.logger.trace("shard locally recovered up to {}", (Object)this.getEngine().getSeqNoStats(globalCheckpoint));
                translogRecoveryRunner = this.engineMutex;
            }
            catch (Throwable throwable) {
                Object object = this.engineMutex;
                synchronized (object) {
                    IOUtils.close((Closeable[])new Closeable[]{this.currentEngineReference.getAndSet(null)});
                }
                throw throwable;
            }
            synchronized (translogRecoveryRunner) {
                IOUtils.close((Closeable[])new Closeable[]{this.currentEngineReference.getAndSet(null)});
            }
        }
        catch (Exception e) {
            this.logger.debug((Message)new ParameterizedMessage("failed to recover shard locally up to global checkpoint {}", (Object)globalCheckpoint), (Throwable)e);
            return -2L;
        }
        try {
            Optional<SequenceNumbers.CommitInfo> newSafeCommit = this.store.findSafeIndexCommit(globalCheckpoint);
            assert (newSafeCommit.isPresent()) : "no safe commit found after local recovery";
            return newSafeCommit.get().localCheckpoint + 1L;
        }
        catch (Exception e) {
            this.logger.debug((Message)new ParameterizedMessage("failed to find the safe commit after recovering shard locally up to global checkpoint {}", (Object)globalCheckpoint), (Throwable)e);
            return -2L;
        }
    }

    public void trimOperationOfPreviousPrimaryTerms(long aboveSeqNo) {
        this.getEngine().trimOperationsFromTranslog(this.getOperationPrimaryTerm(), aboveSeqNo);
    }

    public long getMaxSeenAutoIdTimestamp() {
        return this.getEngine().getMaxSeenAutoIdTimestamp();
    }

    public void updateMaxUnsafeAutoIdTimestamp(long maxSeenAutoIdTimestampFromPrimary) {
        this.getEngine().updateMaxUnsafeAutoIdTimestamp(maxSeenAutoIdTimestampFromPrimary);
    }

    public Engine.Result applyTranslogOperation(Translog.Operation operation, Engine.Operation.Origin origin) throws IOException {
        return this.applyTranslogOperation(this.getEngine(), operation, origin);
    }

    private Engine.Result applyTranslogOperation(Engine engine, Translog.Operation operation, Engine.Operation.Origin origin) throws IOException {
        Engine.Result result;
        VersionType versionType = origin == Engine.Operation.Origin.PRIMARY ? VersionType.EXTERNAL : null;
        switch (operation.opType()) {
            case INDEX: {
                Translog.Index index = (Translog.Index)operation;
                result = this.applyIndexOperation(engine, index.seqNo(), index.primaryTerm(), index.version(), versionType, -2L, 0L, index.getAutoGeneratedIdTimestamp(), true, origin, new SourceToParse(this.shardId.getIndexName(), index.type(), index.id(), index.source(), XContentHelper.xContentType(index.source()), index.routing()));
                break;
            }
            case DELETE: {
                Translog.Delete delete = (Translog.Delete)operation;
                result = this.applyDeleteOperation(engine, delete.seqNo(), delete.primaryTerm(), delete.version(), delete.type(), delete.id(), versionType, -2L, 0L, origin);
                break;
            }
            case NO_OP: {
                Translog.NoOp noOp = (Translog.NoOp)operation;
                result = this.markSeqNoAsNoop(engine, noOp.seqNo(), noOp.primaryTerm(), noOp.reason(), origin);
                break;
            }
            default: {
                throw new IllegalStateException("No operation defined for [" + operation + "]");
            }
        }
        return result;
    }

    int runTranslogRecovery(Engine engine, Translog.Snapshot snapshot, Engine.Operation.Origin origin, Runnable onOperationRecovered) throws IOException {
        Translog.Operation operation;
        int opsRecovered = 0;
        while ((operation = snapshot.next()) != null) {
            try {
                this.logger.trace("[translog] recover op {}", (Object)operation);
                Engine.Result result = this.applyTranslogOperation(engine, operation, origin);
                switch (result.getResultType()) {
                    case FAILURE: {
                        throw result.getFailure();
                    }
                    case MAPPING_UPDATE_REQUIRED: {
                        throw new IllegalArgumentException("unexpected mapping update: " + result.getRequiredMappingUpdate());
                    }
                    case SUCCESS: {
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unknown result type [" + (Object)((Object)result.getResultType()) + "]"));
                    }
                }
                ++opsRecovered;
                onOperationRecovered.run();
            }
            catch (Exception e) {
                if (origin == Engine.Operation.Origin.LOCAL_TRANSLOG_RECOVERY && ExceptionsHelper.status(e) == RestStatus.BAD_REQUEST) {
                    this.logger.info("ignoring recovery of a corrupt translog entry", (Throwable)e);
                    continue;
                }
                throw ExceptionsHelper.convertToRuntime(e);
            }
        }
        return opsRecovered;
    }

    private void loadGlobalCheckpointToReplicationTracker() throws IOException {
        String translogUUID = (String)this.store.readLastCommittedSegmentsInfo().getUserData().get("translog_uuid");
        long globalCheckpoint = Translog.readGlobalCheckpoint(this.translogConfig.getTranslogPath(), translogUUID);
        this.replicationTracker.updateGlobalCheckpointOnReplica(globalCheckpoint, "read from translog checkpoint");
    }

    public void openEngineAndRecoverFromTranslog() throws IOException {
        this.recoveryState.validateCurrentStage(RecoveryState.Stage.INDEX);
        this.maybeCheckIndex();
        this.recoveryState.setStage(RecoveryState.Stage.TRANSLOG);
        RecoveryState.Translog translogRecoveryStats = this.recoveryState.getTranslog();
        Engine.TranslogRecoveryRunner translogRecoveryRunner = (engine, snapshot) -> {
            translogRecoveryStats.totalOperations(snapshot.totalOperations());
            translogRecoveryStats.totalOperationsOnStart(snapshot.totalOperations());
            return this.runTranslogRecovery(engine, snapshot, Engine.Operation.Origin.LOCAL_TRANSLOG_RECOVERY, translogRecoveryStats::incrementRecoveredOperations);
        };
        this.loadGlobalCheckpointToReplicationTracker();
        this.innerOpenEngineAndTranslog(this.replicationTracker);
        this.getEngine().recoverFromTranslog(translogRecoveryRunner, Long.MAX_VALUE);
    }

    public void openEngineAndSkipTranslogRecovery() throws IOException {
        assert (this.routingEntry().recoverySource().getType() == RecoverySource.Type.PEER) : "not a peer recovery [" + this.routingEntry() + "]";
        this.recoveryState.validateCurrentStage(RecoveryState.Stage.TRANSLOG);
        this.loadGlobalCheckpointToReplicationTracker();
        this.innerOpenEngineAndTranslog(this.replicationTracker);
        this.getEngine().skipTranslogRecovery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerOpenEngineAndTranslog(LongSupplier globalCheckpointSupplier) throws IOException {
        assert (!Thread.holdsLock(this.mutex)) : "opening engine under mutex";
        if (this.state != IndexShardState.RECOVERING) {
            throw new IndexShardNotRecoveringException(this.shardId, this.state);
        }
        EngineConfig config = this.newEngineConfig(globalCheckpointSupplier);
        config.setEnableGcDeletes(false);
        this.updateRetentionLeasesOnReplica(this.loadRetentionLeases());
        assert (!this.recoveryState.getRecoverySource().expectEmptyRetentionLeases() || this.getRetentionLeases().leases().isEmpty()) : "expected empty set of retention leases with recovery source [" + this.recoveryState.getRecoverySource() + "] but got " + this.getRetentionLeases();
        Object object = this.engineMutex;
        synchronized (object) {
            assert (this.currentEngineReference.get() == null) : "engine is running";
            this.verifyNotClosed();
            Engine newEngine = this.engineFactory.newReadWriteEngine(config);
            this.onNewEngine(newEngine);
            this.currentEngineReference.set(newEngine);
            this.active.set(true);
        }
        this.onSettingsChanged();
        assert (this.assertSequenceNumbersInCommit());
        this.recoveryState.validateCurrentStage(RecoveryState.Stage.TRANSLOG);
    }

    private boolean assertSequenceNumbersInCommit() throws IOException {
        Map userData = SegmentInfos.readLatestCommit((Directory)this.store.directory()).getUserData();
        assert (userData.containsKey("local_checkpoint")) : "commit point doesn't contains a local checkpoint";
        assert (userData.containsKey("max_seq_no")) : "commit point doesn't contains a maximum sequence number";
        assert (userData.containsKey("history_uuid")) : "commit point doesn't contains a history uuid";
        assert (((String)userData.get("history_uuid")).equals(this.getHistoryUUID())) : "commit point history uuid [" + (String)userData.get("history_uuid") + "] is different than engine [" + this.getHistoryUUID() + "]";
        assert (userData.containsKey("max_unsafe_auto_id_timestamp")) : "opening index which was created post 5.5.0 but max_unsafe_auto_id_timestamp is not found in commit";
        return true;
    }

    private void onNewEngine(Engine newEngine) {
        assert (Thread.holdsLock(this.engineMutex));
        this.refreshListeners.setCurrentRefreshLocationSupplier(newEngine::getTranslogLastWriteLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performRecoveryRestart() throws IOException {
        assert (!Thread.holdsLock(this.mutex)) : "restart recovery under mutex";
        Object object = this.engineMutex;
        synchronized (object) {
            assert (this.refreshListeners.pendingCount() == 0) : "we can't restart with pending listeners";
            IOUtils.close((Closeable[])new Closeable[]{this.currentEngineReference.getAndSet(null)});
            this.resetRecoveryStage();
        }
    }

    public void resetRecoveryStage() {
        assert (this.routingEntry().recoverySource().getType() == RecoverySource.Type.PEER) : "not a peer recovery [" + this.routingEntry() + "]";
        assert (this.currentEngineReference.get() == null);
        if (this.state != IndexShardState.RECOVERING) {
            throw new IndexShardNotRecoveringException(this.shardId, this.state);
        }
        this.recoveryState().setStage(RecoveryState.Stage.INIT);
    }

    public RecoveryStats recoveryStats() {
        return this.recoveryStats;
    }

    @Override
    public RecoveryState recoveryState() {
        return this.recoveryState;
    }

    public void finalizeRecovery() {
        this.recoveryState().setStage(RecoveryState.Stage.FINALIZE);
        Engine engine = this.getEngine();
        engine.refresh("recovery_finalization");
        engine.config().setEnableGcDeletes(true);
    }

    public boolean ignoreRecoveryAttempt() {
        IndexShardState state = this.state();
        return state == IndexShardState.POST_RECOVERY || state == IndexShardState.RECOVERING || state == IndexShardState.STARTED || state == IndexShardState.CLOSED;
    }

    public void readAllowed() throws IllegalIndexShardStateException {
        IndexShardState state = this.state;
        if (!readAllowedStates.contains((Object)state)) {
            throw new IllegalIndexShardStateException(this.shardId, state, "operations only allowed when shard state is one of " + readAllowedStates.toString(), new Object[0]);
        }
    }

    public boolean isReadAllowed() {
        return readAllowedStates.contains((Object)this.state);
    }

    private void ensureWriteAllowed(Engine.Operation.Origin origin) throws IllegalIndexShardStateException {
        IndexShardState state = this.state;
        if (origin.isRecovery()) {
            if (state != IndexShardState.RECOVERING) {
                throw new IllegalIndexShardStateException(this.shardId, state, "operation only allowed when recovering, origin [" + (Object)((Object)origin) + "]", new Object[0]);
            }
        } else {
            if (origin == Engine.Operation.Origin.PRIMARY) {
                assert (this.assertPrimaryMode());
            } else if (origin == Engine.Operation.Origin.REPLICA) {
                assert (this.assertReplicationTarget());
            } else {
                assert (origin == Engine.Operation.Origin.LOCAL_RESET);
                assert (this.getActiveOperationsCount() == -1) : "locally resetting without blocking operations, active operations are [" + this.getActiveOperations() + "]";
            }
            if (!writeAllowedStates.contains((Object)state)) {
                throw new IllegalIndexShardStateException(this.shardId, state, "operation only allowed when shard state is one of " + writeAllowedStates + ", origin [" + (Object)((Object)origin) + "]", new Object[0]);
            }
        }
    }

    private boolean assertPrimaryMode() {
        assert (this.shardRouting.primary() && this.replicationTracker.isPrimaryMode()) : "shard " + this.shardRouting + " is not a primary shard in primary mode";
        return true;
    }

    private boolean assertReplicationTarget() {
        assert (!this.replicationTracker.isPrimaryMode()) : "shard " + this.shardRouting + " in primary mode cannot be a replication target";
        return true;
    }

    private void verifyNotClosed() throws IllegalIndexShardStateException {
        this.verifyNotClosed(null);
    }

    private void verifyNotClosed(Exception suppressed) throws IllegalIndexShardStateException {
        IndexShardState state = this.state;
        if (state == IndexShardState.CLOSED) {
            IndexShardClosedException exc = new IndexShardClosedException(this.shardId, "operation only allowed when not closed");
            if (suppressed != null) {
                exc.addSuppressed(suppressed);
            }
            throw exc;
        }
    }

    protected final void verifyActive() throws IllegalIndexShardStateException {
        IndexShardState state = this.state;
        if (state != IndexShardState.STARTED) {
            throw new IllegalIndexShardStateException(this.shardId, state, "operation only allowed when shard is active", new Object[0]);
        }
    }

    public long getIndexBufferRAMBytesUsed() {
        Engine engine = this.getEngineOrNull();
        if (engine == null) {
            return 0L;
        }
        try {
            return engine.getIndexBufferRAMBytesUsed();
        }
        catch (AlreadyClosedException ex) {
            return 0L;
        }
    }

    public void addShardFailureCallback(Consumer<ShardFailure> onShardFailure) {
        this.shardEventListener.delegates.add(onShardFailure);
    }

    public void checkIdle(long inactiveTimeNS) {
        boolean wasActive;
        Engine engineOrNull = this.getEngineOrNull();
        if (engineOrNull != null && System.nanoTime() - engineOrNull.getLastWriteNanos() >= inactiveTimeNS && (wasActive = this.active.getAndSet(false))) {
            this.logger.debug("shard is now inactive");
            try {
                this.indexEventListener.onShardInactive(this);
            }
            catch (Exception e) {
                this.logger.warn("failed to notify index event listener", (Throwable)e);
            }
        }
    }

    public boolean isActive() {
        return this.active.get();
    }

    public ShardPath shardPath() {
        return this.path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoverFromLocalShards(BiConsumer<String, MappingMetadata> mappingUpdateConsumer, List<IndexShard> localShards, ActionListener<Boolean> listener) throws IOException {
        assert (this.shardRouting.primary()) : "recover from local shards only makes sense if the shard is a primary shard";
        assert (this.recoveryState.getRecoverySource().getType() == RecoverySource.Type.LOCAL_SHARDS) : "invalid recovery type: " + this.recoveryState.getRecoverySource();
        ArrayList<LocalShardSnapshot> snapshots = new ArrayList<LocalShardSnapshot>();
        ActionListener<Boolean> recoveryListener = ActionListener.runBefore(listener, () -> IOUtils.close((Iterable)snapshots));
        boolean success = false;
        try {
            for (IndexShard shard : localShards) {
                snapshots.add(new LocalShardSnapshot(shard));
            }
            assert (this.shardRouting.primary()) : "recover from local shards only makes sense if the shard is a primary shard";
            StoreRecovery storeRecovery = new StoreRecovery(this.shardId, this.logger);
            storeRecovery.recoverFromLocalShards(mappingUpdateConsumer, this, snapshots, recoveryListener);
            success = true;
        }
        finally {
            if (!success) {
                IOUtils.close(snapshots);
            }
        }
    }

    public void recoverFromStore(ActionListener<Boolean> listener) {
        assert (this.shardRouting.primary()) : "recover from store only makes sense if the shard is a primary shard";
        assert (this.shardRouting.initializing()) : "can only start recovery on initializing shard";
        StoreRecovery storeRecovery = new StoreRecovery(this.shardId, this.logger);
        storeRecovery.recoverFromStore(this, listener);
    }

    public void restoreFromRepository(Repository repository, ActionListener<Boolean> listener) {
        try {
            assert (this.shardRouting.primary()) : "recover from store only makes sense if the shard is a primary shard";
            assert (this.recoveryState.getRecoverySource().getType() == RecoverySource.Type.SNAPSHOT) : "invalid recovery type: " + this.recoveryState.getRecoverySource();
            StoreRecovery storeRecovery = new StoreRecovery(this.shardId, this.logger);
            storeRecovery.recoverFromRepository(this, repository, listener);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    boolean shouldPeriodicallyFlush() {
        Engine engine = this.getEngineOrNull();
        if (engine != null) {
            try {
                return engine.shouldPeriodicallyFlush();
            }
            catch (AlreadyClosedException alreadyClosedException) {
                // empty catch block
            }
        }
        return false;
    }

    boolean shouldRollTranslogGeneration() {
        Engine engine = this.getEngineOrNull();
        if (engine != null) {
            try {
                return engine.shouldRollTranslogGeneration();
            }
            catch (AlreadyClosedException alreadyClosedException) {
                // empty catch block
            }
        }
        return false;
    }

    public void onSettingsChanged() {
        Engine engineOrNull = this.getEngineOrNull();
        if (engineOrNull != null) {
            boolean disableTranslogRetention = this.indexSettings.isSoftDeleteEnabled() && this.useRetentionLeasesInPeerRecovery;
            engineOrNull.onSettingsChanged(disableTranslogRetention ? TimeValue.MINUS_ONE : this.indexSettings.getTranslogRetentionAge(), disableTranslogRetention ? new ByteSizeValue(-1L) : this.indexSettings.getTranslogRetentionSize(), this.indexSettings.getSoftDeleteRetentionOperations());
        }
    }

    private void turnOffTranslogRetention() {
        this.logger.debug("turn off the translog retention for the replication group {} as it starts using retention leases exclusively in peer recoveries", (Object)this.shardId);
        this.threadPool.generic().execute(new AbstractRunnable(){

            @Override
            public void onFailure(Exception e) {
                if (IndexShard.this.state != IndexShardState.CLOSED) {
                    IndexShard.this.logger.warn("failed to turn off translog retention", (Throwable)e);
                }
            }

            @Override
            protected void doRun() {
                IndexShard.this.onSettingsChanged();
                IndexShard.this.trimTranslog();
            }
        });
    }

    public Closeable acquireHistoryRetentionLock(Engine.HistorySource source) {
        return this.getEngine().acquireHistoryRetentionLock(source);
    }

    public int estimateNumberOfHistoryOperations(String reason, Engine.HistorySource source, long startingSeqNo) throws IOException {
        return this.getEngine().estimateNumberOfHistoryOperations(reason, source, this.mapperService, startingSeqNo);
    }

    public Translog.Snapshot getHistoryOperations(String reason, Engine.HistorySource source, long startingSeqNo) throws IOException {
        return this.getEngine().readHistoryOperations(reason, source, this.mapperService, startingSeqNo);
    }

    public boolean hasCompleteHistoryOperations(String reason, Engine.HistorySource source, long startingSeqNo) throws IOException {
        return this.getEngine().hasCompleteOperationHistory(reason, source, this.mapperService, startingSeqNo);
    }

    public long getMinRetainedSeqNo() {
        return this.getEngine().getMinRetainedSeqNo();
    }

    public Translog.Snapshot newChangesSnapshot(String source, long fromSeqNo, long toSeqNo, boolean requiredFullRange) throws IOException {
        return this.getEngine().newChangesSnapshot(source, this.mapperService, fromSeqNo, toSeqNo, requiredFullRange);
    }

    public List<Segment> segments(boolean verbose) {
        return this.getEngine().segments(verbose);
    }

    public String getHistoryUUID() {
        return this.getEngine().getHistoryUUID();
    }

    public IndexEventListener getIndexEventListener() {
        return this.indexEventListener;
    }

    public void activateThrottling() {
        try {
            this.getEngine().activateThrottling();
        }
        catch (AlreadyClosedException alreadyClosedException) {
            // empty catch block
        }
    }

    public void deactivateThrottling() {
        try {
            this.getEngine().deactivateThrottling();
        }
        catch (AlreadyClosedException alreadyClosedException) {
            // empty catch block
        }
    }

    private void handleRefreshException(Exception e) {
        if (!(e instanceof AlreadyClosedException)) {
            if (e instanceof RefreshFailedEngineException) {
                RefreshFailedEngineException rfee = (RefreshFailedEngineException)e;
                if (!(rfee.getCause() instanceof InterruptedException || rfee.getCause() instanceof ClosedByInterruptException || rfee.getCause() instanceof ThreadInterruptedException || this.state == IndexShardState.CLOSED)) {
                    this.logger.warn("Failed to perform engine refresh", (Throwable)e);
                }
            } else if (this.state != IndexShardState.CLOSED) {
                this.logger.warn("Failed to perform engine refresh", (Throwable)e);
            }
        }
    }

    public void writeIndexingBuffer() {
        try {
            Engine engine = this.getEngine();
            engine.writeIndexingBuffer();
        }
        catch (Exception e) {
            this.handleRefreshException(e);
        }
    }

    public void updateLocalCheckpointForShard(String allocationId, long checkpoint) {
        assert (this.assertPrimaryMode());
        this.verifyNotClosed();
        this.replicationTracker.updateLocalCheckpoint(allocationId, checkpoint);
    }

    public void updateGlobalCheckpointForShard(String allocationId, long globalCheckpoint) {
        assert (this.assertPrimaryMode());
        this.verifyNotClosed();
        this.replicationTracker.updateGlobalCheckpointForShard(allocationId, globalCheckpoint);
    }

    public void addGlobalCheckpointListener(long waitingForGlobalCheckpoint, GlobalCheckpointListeners.GlobalCheckpointListener listener, TimeValue timeout) {
        this.globalCheckpointListeners.add(waitingForGlobalCheckpoint, listener, timeout);
    }

    private void ensureSoftDeletesEnabled(String feature) {
        if (!this.indexSettings.isSoftDeleteEnabled()) {
            String message = feature + " requires soft deletes but " + this.indexSettings.getIndex() + " does not have soft deletes enabled";
            assert (false) : message;
            throw new IllegalStateException(message);
        }
    }

    public RetentionLeases getRetentionLeases() {
        return (RetentionLeases)this.getRetentionLeases(false).v2();
    }

    public Tuple<Boolean, RetentionLeases> getRetentionLeases(boolean expireLeases) {
        assert (!expireLeases || this.assertPrimaryMode());
        this.verifyNotClosed();
        return this.replicationTracker.getRetentionLeases(expireLeases);
    }

    public RetentionLeaseStats getRetentionLeaseStats() {
        this.verifyNotClosed();
        return new RetentionLeaseStats(this.getRetentionLeases());
    }

    public RetentionLease addRetentionLease(String id, long retainingSequenceNumber, String source, ActionListener<ReplicationResponse> listener) {
        RetentionLease retentionLease;
        block9: {
            Objects.requireNonNull(listener);
            assert (this.assertPrimaryMode());
            this.verifyNotClosed();
            this.ensureSoftDeletesEnabled("retention leases");
            Closeable ignore = this.acquireHistoryRetentionLock(Engine.HistorySource.INDEX);
            try {
                long actualRetainingSequenceNumber = retainingSequenceNumber == -1L ? this.getMinRetainedSeqNo() : retainingSequenceNumber;
                retentionLease = this.replicationTracker.addRetentionLease(id, actualRetainingSequenceNumber, source, listener);
                if (ignore == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new AssertionError((Object)e);
                }
            }
            ignore.close();
        }
        return retentionLease;
    }

    public RetentionLease renewRetentionLease(String id, long retainingSequenceNumber, String source) {
        RetentionLease retentionLease;
        block9: {
            assert (this.assertPrimaryMode());
            this.verifyNotClosed();
            this.ensureSoftDeletesEnabled("retention leases");
            Closeable ignore = this.acquireHistoryRetentionLock(Engine.HistorySource.INDEX);
            try {
                long actualRetainingSequenceNumber = retainingSequenceNumber == -1L ? this.getMinRetainedSeqNo() : retainingSequenceNumber;
                retentionLease = this.replicationTracker.renewRetentionLease(id, actualRetainingSequenceNumber, source);
                if (ignore == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new AssertionError((Object)e);
                }
            }
            ignore.close();
        }
        return retentionLease;
    }

    public void removeRetentionLease(String id, ActionListener<ReplicationResponse> listener) {
        Objects.requireNonNull(listener);
        assert (this.assertPrimaryMode());
        this.verifyNotClosed();
        this.ensureSoftDeletesEnabled("retention leases");
        this.replicationTracker.removeRetentionLease(id, listener);
    }

    public void updateRetentionLeasesOnReplica(RetentionLeases retentionLeases) {
        assert (this.assertReplicationTarget());
        this.verifyNotClosed();
        this.replicationTracker.updateRetentionLeasesOnReplica(retentionLeases);
    }

    public RetentionLeases loadRetentionLeases() throws IOException {
        this.verifyNotClosed();
        return this.replicationTracker.loadRetentionLeases(this.path.getShardStatePath());
    }

    public void persistRetentionLeases() throws WriteStateException {
        this.verifyNotClosed();
        this.replicationTracker.persistRetentionLeases(this.path.getShardStatePath());
    }

    public boolean assertRetentionLeasesPersisted() throws IOException {
        return this.replicationTracker.assertRetentionLeasesPersisted(this.path.getShardStatePath());
    }

    public void syncRetentionLeases() {
        assert (this.assertPrimaryMode());
        this.verifyNotClosed();
        this.replicationTracker.renewPeerRecoveryRetentionLeases();
        Tuple<Boolean, RetentionLeases> retentionLeases = this.getRetentionLeases(true);
        if (((Boolean)retentionLeases.v1()).booleanValue()) {
            this.logger.trace("syncing retention leases [{}] after expiration check", retentionLeases.v2());
            this.retentionLeaseSyncer.sync(this.shardId, this.shardRouting.allocationId().getId(), this.getPendingPrimaryTerm(), (RetentionLeases)retentionLeases.v2(), ActionListener.wrap(r -> {}, e -> this.logger.warn((Message)new ParameterizedMessage("failed to sync retention leases [{}] after expiration check", (Object)retentionLeases), (Throwable)e)));
        } else {
            this.logger.trace("background syncing retention leases [{}] after expiration check", retentionLeases.v2());
            this.retentionLeaseSyncer.backgroundSync(this.shardId, this.shardRouting.allocationId().getId(), this.getPendingPrimaryTerm(), (RetentionLeases)retentionLeases.v2());
        }
    }

    public void initiateTracking(String allocationId) {
        assert (this.assertPrimaryMode());
        this.replicationTracker.initiateTracking(allocationId);
    }

    public void markAllocationIdAsInSync(String allocationId, long localCheckpoint) throws InterruptedException {
        assert (this.assertPrimaryMode());
        this.replicationTracker.markAllocationIdAsInSync(allocationId, localCheckpoint);
    }

    public long getLocalCheckpoint() {
        return this.getEngine().getPersistedLocalCheckpoint();
    }

    public long getLastKnownGlobalCheckpoint() {
        return this.replicationTracker.getGlobalCheckpoint();
    }

    public long getLastSyncedGlobalCheckpoint() {
        return this.getEngine().getLastSyncedGlobalCheckpoint();
    }

    public ObjectLongMap<String> getInSyncGlobalCheckpoints() {
        assert (this.assertPrimaryMode());
        this.verifyNotClosed();
        return this.replicationTracker.getInSyncGlobalCheckpoints();
    }

    public void maybeSyncGlobalCheckpoint(String reason) {
        boolean asyncDurability;
        this.verifyNotClosed();
        assert (this.shardRouting.primary()) : "only call maybeSyncGlobalCheckpoint on primary shard";
        if (!this.replicationTracker.isPrimaryMode()) {
            return;
        }
        assert (this.assertPrimaryMode());
        SeqNoStats stats = this.getEngine().getSeqNoStats(this.replicationTracker.getGlobalCheckpoint());
        boolean bl = asyncDurability = this.indexSettings().getTranslogDurability() == Translog.Durability.ASYNC;
        if (stats.getMaxSeqNo() == stats.getGlobalCheckpoint() || asyncDurability) {
            boolean syncNeeded;
            ObjectLongMap<String> globalCheckpoints = this.getInSyncGlobalCheckpoints();
            long globalCheckpoint = this.replicationTracker.getGlobalCheckpoint();
            boolean bl2 = syncNeeded = asyncDurability && (stats.getGlobalCheckpoint() < stats.getMaxSeqNo() || this.replicationTracker.pendingInSync()) || StreamSupport.stream(globalCheckpoints.values().spliterator(), false).anyMatch(v -> v.value < globalCheckpoint);
            if (syncNeeded && this.indexSettings.getIndexMetadata().getState() == IndexMetadata.State.OPEN) {
                this.logger.trace("syncing global checkpoint for [{}]", (Object)reason);
                this.globalCheckpointSyncer.run();
            }
        }
    }

    public ReplicationGroup getReplicationGroup() {
        assert (this.assertPrimaryMode());
        this.verifyNotClosed();
        return this.replicationTracker.getReplicationGroup();
    }

    public void updateGlobalCheckpointOnReplica(long globalCheckpoint, String reason) {
        assert (this.assertReplicationTarget());
        long localCheckpoint = this.getLocalCheckpoint();
        if (globalCheckpoint > localCheckpoint) {
            assert (this.state() != IndexShardState.POST_RECOVERY && this.state() != IndexShardState.STARTED) : "supposedly in-sync shard copy received a global checkpoint [" + globalCheckpoint + "] that is higher than its local checkpoint [" + localCheckpoint + "]";
            return;
        }
        this.replicationTracker.updateGlobalCheckpointOnReplica(globalCheckpoint, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateWithPrimaryContext(ReplicationTracker.PrimaryContext primaryContext) {
        assert (this.shardRouting.primary() && this.shardRouting.isRelocationTarget()) : "only primary relocation target can update allocation IDs from primary context: " + this.shardRouting;
        assert (primaryContext.getCheckpointStates().containsKey(this.routingEntry().allocationId().getId())) : "primary context [" + primaryContext + "] does not contain relocation target [" + this.routingEntry() + "]";
        assert (this.getLocalCheckpoint() == primaryContext.getCheckpointStates().get(this.routingEntry().allocationId().getId()).getLocalCheckpoint() || this.indexSettings().getTranslogDurability() == Translog.Durability.ASYNC) : "local checkpoint [" + this.getLocalCheckpoint() + "] does not match checkpoint from primary context [" + primaryContext + "]";
        Object object = this.mutex;
        synchronized (object) {
            this.replicationTracker.activateWithPrimaryContext(primaryContext);
        }
        this.ensurePeerRecoveryRetentionLeasesExist();
    }

    private void ensurePeerRecoveryRetentionLeasesExist() {
        this.threadPool.generic().execute(() -> this.replicationTracker.createMissingPeerRecoveryRetentionLeases(ActionListener.wrap(r -> this.logger.trace("created missing peer recovery retention leases"), e -> this.logger.debug("failed creating missing peer recovery retention leases", (Throwable)e))));
    }

    public boolean pendingInSync() {
        assert (this.assertPrimaryMode());
        return this.replicationTracker.pendingInSync();
    }

    public void noopUpdate(String type) {
        this.internalIndexingStats.noopUpdate(type);
    }

    public void maybeCheckIndex() {
        this.recoveryState.setStage(RecoveryState.Stage.VERIFY_INDEX);
        if (Booleans.isTrue((String)this.checkIndexOnStartup) || "checksum".equals(this.checkIndexOnStartup)) {
            try {
                this.checkIndex();
            }
            catch (IOException ex) {
                throw new RecoveryFailedException(this.recoveryState, "check index failed", (Throwable)ex);
            }
        }
    }

    void checkIndex() throws IOException {
        if (this.store.tryIncRef()) {
            try {
                this.doCheckIndex();
            }
            catch (IOException e) {
                this.store.markStoreCorrupted(e);
                throw e;
            }
            finally {
                this.store.decRef();
            }
        }
    }

    private void doCheckIndex() throws IOException {
        long timeNS = System.nanoTime();
        if (!Lucene.indexExists(this.store.directory())) {
            return;
        }
        BytesStreamOutput os = new BytesStreamOutput();
        PrintStream out = new PrintStream((OutputStream)os, false, StandardCharsets.UTF_8.name());
        if ("checksum".equals(this.checkIndexOnStartup)) {
            IOException corrupt = null;
            Store.MetadataSnapshot metadata = this.snapshotStoreMetadata();
            for (Map.Entry<String, StoreFileMetadata> entry : metadata.asMap().entrySet()) {
                try {
                    Store.checkIntegrity(entry.getValue(), this.store.directory());
                    out.println("checksum passed: " + entry.getKey());
                }
                catch (IOException exc) {
                    out.println("checksum failed: " + entry.getKey());
                    exc.printStackTrace(out);
                    corrupt = exc;
                }
            }
            out.flush();
            if (corrupt != null) {
                this.logger.warn("check index [failure]\n{}", (Object)os.bytes().utf8ToString());
                throw corrupt;
            }
        } else {
            CheckIndex.Status status = this.store.checkIndex(out);
            out.flush();
            if (!status.clean) {
                if (this.state == IndexShardState.CLOSED) {
                    return;
                }
                this.logger.warn("check index [failure]\n{}", (Object)os.bytes().utf8ToString());
                throw new IOException("index check failure");
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("check index [success]\n{}", (Object)os.bytes().utf8ToString());
        }
        this.recoveryState.getVerifyIndex().checkIndexTime(Math.max(0L, TimeValue.nsecToMSec((long)(System.nanoTime() - timeNS))));
    }

    Engine getEngine() {
        Engine engine = this.getEngineOrNull();
        if (engine == null) {
            throw new AlreadyClosedException("engine is closed");
        }
        return engine;
    }

    protected Engine getEngineOrNull() {
        return this.currentEngineReference.get();
    }

    public void startRecovery(RecoveryState recoveryState, PeerRecoveryTargetService recoveryTargetService, PeerRecoveryTargetService.RecoveryListener recoveryListener, RepositoriesService repositoriesService, BiConsumer<String, MappingMetadata> mappingUpdateConsumer, IndicesService indicesService) {
        assert (recoveryState.getRecoverySource().equals(this.shardRouting.recoverySource()));
        switch (recoveryState.getRecoverySource().getType()) {
            case EMPTY_STORE: 
            case EXISTING_STORE: {
                this.executeRecovery("from store", recoveryState, recoveryListener, this::recoverFromStore);
                break;
            }
            case PEER: {
                try {
                    this.markAsRecovering("from " + recoveryState.getSourceNode(), recoveryState);
                    recoveryTargetService.startRecovery(this, recoveryState.getSourceNode(), recoveryListener);
                }
                catch (Exception e) {
                    this.failShard("corrupted preexisting index", e);
                    recoveryListener.onRecoveryFailure(recoveryState, new RecoveryFailedException(recoveryState, null, (Throwable)e), true);
                }
                break;
            }
            case SNAPSHOT: {
                String repo = ((RecoverySource.SnapshotRecoverySource)recoveryState.getRecoverySource()).snapshot().getRepository();
                this.executeRecovery("from snapshot", recoveryState, recoveryListener, l -> this.restoreFromRepository(repositoriesService.repository(repo), (ActionListener<Boolean>)l));
                break;
            }
            case LOCAL_SHARDS: {
                int numShards;
                Set<Object> requiredShards;
                IndexMetadata indexMetadata = this.indexSettings().getIndexMetadata();
                Index resizeSourceIndex = indexMetadata.getResizeSourceIndex();
                ArrayList<IndexShard> startedShards = new ArrayList<IndexShard>();
                IndexService sourceIndexService = indicesService.indexService(resizeSourceIndex);
                if (sourceIndexService != null) {
                    requiredShards = IndexMetadata.selectRecoverFromShards(this.shardId().id(), sourceIndexService.getMetadata(), indexMetadata.getNumberOfShards());
                    for (IndexShard shard : sourceIndexService) {
                        if (shard.state() != IndexShardState.STARTED || !requiredShards.contains(shard.shardId())) continue;
                        startedShards.add(shard);
                    }
                    numShards = requiredShards.size();
                } else {
                    numShards = -1;
                    requiredShards = Collections.emptySet();
                }
                if (numShards == startedShards.size()) {
                    assert (!requiredShards.isEmpty());
                    this.executeRecovery("from local shards", recoveryState, recoveryListener, l -> this.recoverFromLocalShards(mappingUpdateConsumer, startedShards.stream().filter(s -> requiredShards.contains(s.shardId())).collect(Collectors.toList()), (ActionListener<Boolean>)l));
                    break;
                }
                RuntimeException e = numShards == -1 ? new IndexNotFoundException(resizeSourceIndex) : new IllegalStateException("not all required shards of index " + resizeSourceIndex + " are started yet, expected " + numShards + " found " + startedShards.size() + " can't recover shard " + this.shardId());
                throw e;
            }
            default: {
                throw new IllegalArgumentException("Unknown recovery source " + recoveryState.getRecoverySource());
            }
        }
    }

    private void executeRecovery(String reason, RecoveryState recoveryState, PeerRecoveryTargetService.RecoveryListener recoveryListener, CheckedConsumer<ActionListener<Boolean>, Exception> action) {
        this.markAsRecovering(reason, recoveryState);
        this.threadPool.generic().execute(ActionRunnable.wrap(ActionListener.wrap(r -> {
            if (r.booleanValue()) {
                recoveryListener.onRecoveryDone(recoveryState);
            }
        }, e -> recoveryListener.onRecoveryFailure(recoveryState, new RecoveryFailedException(recoveryState, null, (Throwable)e), true)), action));
    }

    public boolean isRelocatedPrimary() {
        assert (this.shardRouting.primary()) : "only call isRelocatedPrimary on primary shard";
        return this.replicationTracker.isRelocated();
    }

    public RetentionLease addPeerRecoveryRetentionLease(String nodeId, long globalCheckpoint, ActionListener<ReplicationResponse> listener) {
        assert (this.assertPrimaryMode());
        assert (this.indexSettings.getIndexVersionCreated().before(Version.V_7_4_0) || !this.indexSettings.isSoftDeleteEnabled());
        return this.replicationTracker.addPeerRecoveryRetentionLease(nodeId, globalCheckpoint, listener);
    }

    public RetentionLease cloneLocalPeerRecoveryRetentionLease(String nodeId, ActionListener<ReplicationResponse> listener) {
        assert (this.assertPrimaryMode());
        return this.replicationTracker.cloneLocalPeerRecoveryRetentionLease(nodeId, listener);
    }

    public void removePeerRecoveryRetentionLease(String nodeId, ActionListener<ReplicationResponse> listener) {
        assert (this.assertPrimaryMode());
        this.replicationTracker.removePeerRecoveryRetentionLease(nodeId, listener);
    }

    public List<RetentionLease> getPeerRecoveryRetentionLeases() {
        return this.replicationTracker.getPeerRecoveryRetentionLeases();
    }

    public boolean useRetentionLeasesInPeerRecovery() {
        return this.useRetentionLeasesInPeerRecovery;
    }

    private SafeCommitInfo getSafeCommitInfo() {
        Engine engine = this.getEngineOrNull();
        return engine == null ? SafeCommitInfo.EMPTY : engine.getSafeCommitInfo();
    }

    private static void persistMetadata(ShardPath shardPath, IndexSettings indexSettings, ShardRouting newRouting, @Nullable ShardRouting currentRouting, Logger logger) throws IOException {
        assert (newRouting != null) : "newRouting must not be null";
        ShardId shardId = newRouting.shardId();
        if (currentRouting == null || currentRouting.primary() != newRouting.primary() || !currentRouting.allocationId().equals(newRouting.allocationId())) {
            assert (currentRouting == null || currentRouting.isSameAllocation(newRouting));
            String writeReason = currentRouting == null ? "initial state with allocation id [" + newRouting.allocationId() + "]" : "routing changed from " + currentRouting + " to " + newRouting;
            logger.trace("{} writing shard state, reason [{}]", (Object)shardId, (Object)writeReason);
            ShardStateMetadata newShardStateMetadata = new ShardStateMetadata(newRouting.primary(), indexSettings.getUUID(), newRouting.allocationId());
            ShardStateMetadata.FORMAT.writeAndCleanup(newShardStateMetadata, shardPath.getShardStatePath());
        } else {
            logger.trace("{} skip writing shard state, has been written before", (Object)shardId);
        }
    }

    private DocumentMapperForType docMapper(String type) {
        return this.mapperService.documentMapperWithAutoCreate(this.mapperService.resolveDocumentType(type));
    }

    private EngineConfig newEngineConfig(LongSupplier globalCheckpointSupplier) {
        Sort indexSort = this.indexSortSupplier.get();
        Engine.Warmer warmer = reader -> {
            assert (!Thread.holdsLock(this.mutex)) : "warming engine under mutex";
            assert (reader != null);
            if (this.warmer != null) {
                this.warmer.warm(reader);
            }
        };
        return new EngineConfig(this.shardId, this.shardRouting.allocationId().getId(), this.threadPool, this.indexSettings, warmer, this.store, this.indexSettings.getMergePolicy(), this.mapperService != null ? this.mapperService.indexAnalyzer() : null, this.similarityService.similarity(this.mapperService), this.codecService, this.shardEventListener, this.indexCache != null ? this.indexCache.query() : null, this.cachingPolicy, this.translogConfig, IndexingMemoryController.SHARD_INACTIVE_TIME_SETTING.get(this.indexSettings.getSettings()), Arrays.asList(this.refreshListeners, this.refreshPendingLocationListener), Collections.singletonList(new RefreshMetricUpdater(this.refreshMetric)), indexSort, this.circuitBreakerService, globalCheckpointSupplier, this.replicationTracker::getRetentionLeases, () -> this.getOperationPrimaryTerm(), this.tombstoneDocSupplier());
    }

    public void acquirePrimaryOperationPermit(ActionListener<Releasable> onPermitAcquired, String executorOnDelay, Object debugInfo) {
        this.verifyNotClosed();
        assert (this.shardRouting.primary()) : "acquirePrimaryOperationPermit should only be called on primary shard: " + this.shardRouting;
        this.indexShardOperationPermits.acquire(this.wrapPrimaryOperationPermitListener(onPermitAcquired), executorOnDelay, false, debugInfo);
    }

    public void acquireAllPrimaryOperationsPermits(ActionListener<Releasable> onPermitAcquired, TimeValue timeout) {
        this.verifyNotClosed();
        assert (this.shardRouting.primary()) : "acquireAllPrimaryOperationsPermits should only be called on primary shard: " + this.shardRouting;
        this.asyncBlockOperations(this.wrapPrimaryOperationPermitListener(onPermitAcquired), timeout.duration(), timeout.timeUnit());
    }

    private ActionListener<Releasable> wrapPrimaryOperationPermitListener(ActionListener<Releasable> listener) {
        return ActionListener.delegateFailure(listener, (l, r) -> {
            if (this.replicationTracker.isPrimaryMode()) {
                l.onResponse(r);
            } else {
                r.close();
                l.onFailure(new ShardNotInPrimaryModeException(this.shardId, this.state));
            }
        });
    }

    private void asyncBlockOperations(ActionListener<Releasable> onPermitAcquired, long timeout, TimeUnit timeUnit) {
        Releasable forceRefreshes = this.refreshListeners.forceRefreshes();
        ActionListener<Releasable> wrappedListener = ActionListener.wrap(r -> {
            forceRefreshes.close();
            onPermitAcquired.onResponse((Releasable)r);
        }, e -> {
            forceRefreshes.close();
            onPermitAcquired.onFailure((Exception)e);
        });
        try {
            this.indexShardOperationPermits.asyncBlockOperations(wrappedListener, timeout, timeUnit);
        }
        catch (Exception e2) {
            forceRefreshes.close();
            throw e2;
        }
    }

    public void runUnderPrimaryPermit(Runnable runnable, Consumer<Exception> onFailure, String executorOnDelay, Object debugInfo) {
        this.verifyNotClosed();
        assert (this.shardRouting.primary()) : "runUnderPrimaryPermit should only be called on primary shard but was " + this.shardRouting;
        ActionListener<Releasable> onPermitAcquired = ActionListener.wrap(releasable -> {
            try (Releasable ignore = releasable;){
                runnable.run();
            }
        }, onFailure);
        this.acquirePrimaryOperationPermit(onPermitAcquired, executorOnDelay, debugInfo);
    }

    private <E extends Exception> void bumpPrimaryTerm(final long newPrimaryTerm, final CheckedRunnable<E> onBlocked, final @Nullable ActionListener<Releasable> combineWithAction) {
        assert (Thread.holdsLock(this.mutex));
        assert (newPrimaryTerm > this.pendingPrimaryTerm || newPrimaryTerm >= this.pendingPrimaryTerm && combineWithAction != null);
        assert (this.getOperationPrimaryTerm() <= this.pendingPrimaryTerm);
        final CountDownLatch termUpdated = new CountDownLatch(1);
        this.asyncBlockOperations(new ActionListener<Releasable>(){

            @Override
            public void onFailure(Exception e) {
                try {
                    this.innerFail(e);
                }
                finally {
                    if (combineWithAction != null) {
                        combineWithAction.onFailure(e);
                    }
                }
            }

            private void innerFail(Exception e) {
                try {
                    IndexShard.this.failShard("exception during primary term transition", e);
                }
                catch (AlreadyClosedException alreadyClosedException) {
                    // empty catch block
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResponse(Releasable releasable) {
                RunOnce releaseOnce = new RunOnce(releasable::close);
                try {
                    assert (IndexShard.this.getOperationPrimaryTerm() <= IndexShard.this.pendingPrimaryTerm);
                    termUpdated.await();
                    if (IndexShard.this.getOperationPrimaryTerm() < newPrimaryTerm) {
                        IndexShard.this.replicationTracker.setOperationPrimaryTerm(newPrimaryTerm);
                        onBlocked.run();
                    }
                }
                catch (Exception e) {
                    if (combineWithAction == null) {
                        releaseOnce.run();
                    }
                    this.innerFail(e);
                }
                finally {
                    if (combineWithAction != null) {
                        combineWithAction.onResponse(releasable);
                    } else {
                        releaseOnce.run();
                    }
                }
            }
        }, 30L, TimeUnit.MINUTES);
        this.pendingPrimaryTerm = newPrimaryTerm;
        termUpdated.countDown();
    }

    public void acquireReplicaOperationPermit(long opPrimaryTerm, long globalCheckpoint, long maxSeqNoOfUpdatesOrDeletes, ActionListener<Releasable> onPermitAcquired, String executorOnDelay, Object debugInfo) {
        this.innerAcquireReplicaOperationPermit(opPrimaryTerm, globalCheckpoint, maxSeqNoOfUpdatesOrDeletes, onPermitAcquired, false, listener -> this.indexShardOperationPermits.acquire((ActionListener<Releasable>)listener, executorOnDelay, true, debugInfo));
    }

    public void acquireAllReplicaOperationsPermits(long opPrimaryTerm, long globalCheckpoint, long maxSeqNoOfUpdatesOrDeletes, ActionListener<Releasable> onPermitAcquired, TimeValue timeout) {
        this.innerAcquireReplicaOperationPermit(opPrimaryTerm, globalCheckpoint, maxSeqNoOfUpdatesOrDeletes, onPermitAcquired, true, listener -> this.asyncBlockOperations((ActionListener<Releasable>)listener, timeout.duration(), timeout.timeUnit()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerAcquireReplicaOperationPermit(long opPrimaryTerm, long globalCheckpoint, long maxSeqNoOfUpdatesOrDeletes, ActionListener<Releasable> onPermitAcquired, boolean allowCombineOperationWithPrimaryTermUpdate, Consumer<ActionListener<Releasable>> operationExecutor) {
        this.verifyNotClosed();
        ActionListener<Releasable> operationListener = ActionListener.delegateFailure(onPermitAcquired, (delegatedListener, releasable) -> {
            if (opPrimaryTerm < this.getOperationPrimaryTerm()) {
                releasable.close();
                String message = String.format(Locale.ROOT, "%s operation primary term [%d] is too old (current [%d])", this.shardId, opPrimaryTerm, this.getOperationPrimaryTerm());
                delegatedListener.onFailure(new IllegalStateException(message));
            } else {
                assert (this.assertReplicationTarget());
                try {
                    this.updateGlobalCheckpointOnReplica(globalCheckpoint, "operation");
                    this.advanceMaxSeqNoOfUpdatesOrDeletes(maxSeqNoOfUpdatesOrDeletes);
                }
                catch (Exception e) {
                    releasable.close();
                    delegatedListener.onFailure(e);
                    return;
                }
                delegatedListener.onResponse(releasable);
            }
        });
        if (this.requirePrimaryTermUpdate(opPrimaryTerm, allowCombineOperationWithPrimaryTermUpdate)) {
            Object object = this.mutex;
            synchronized (object) {
                if (this.requirePrimaryTermUpdate(opPrimaryTerm, allowCombineOperationWithPrimaryTermUpdate)) {
                    IndexShardState shardState = this.state();
                    if (shardState != IndexShardState.POST_RECOVERY && shardState != IndexShardState.STARTED) {
                        throw new IndexShardNotStartedException(this.shardId, shardState);
                    }
                    this.bumpPrimaryTerm(opPrimaryTerm, () -> {
                        this.updateGlobalCheckpointOnReplica(globalCheckpoint, "primary term transition");
                        long currentGlobalCheckpoint = this.getLastKnownGlobalCheckpoint();
                        long maxSeqNo = this.seqNoStats().getMaxSeqNo();
                        this.logger.info("detected new primary with primary term [{}], global checkpoint [{}], max_seq_no [{}]", (Object)opPrimaryTerm, (Object)currentGlobalCheckpoint, (Object)maxSeqNo);
                        if (currentGlobalCheckpoint < maxSeqNo) {
                            this.resetEngineToGlobalCheckpoint();
                        } else {
                            this.getEngine().rollTranslogGeneration();
                        }
                    }, allowCombineOperationWithPrimaryTermUpdate ? operationListener : null);
                    if (allowCombineOperationWithPrimaryTermUpdate) {
                        this.logger.debug("operation execution has been combined with primary term update");
                        return;
                    }
                }
            }
        }
        assert (opPrimaryTerm <= this.pendingPrimaryTerm) : "operation primary term [" + opPrimaryTerm + "] should be at most [" + this.pendingPrimaryTerm + "]";
        operationExecutor.accept(operationListener);
    }

    private boolean requirePrimaryTermUpdate(long opPrimaryTerm, boolean allPermits) {
        return opPrimaryTerm > this.pendingPrimaryTerm || allPermits && opPrimaryTerm > this.getOperationPrimaryTerm();
    }

    public int getActiveOperationsCount() {
        return this.indexShardOperationPermits.getActiveOperationsCount();
    }

    public List<String> getActiveOperations() {
        return this.indexShardOperationPermits.getActiveOperations();
    }

    private static AsyncIOProcessor<Translog.Location> createTranslogSyncProcessor(final Logger logger, ThreadContext threadContext, final Supplier<Engine> engineSupplier) {
        return new AsyncIOProcessor<Translog.Location>(logger, 1024, threadContext){

            @Override
            protected void write(List<Tuple<Translog.Location, Consumer<Exception>>> candidates) throws IOException {
                try {
                    ((Engine)engineSupplier.get()).ensureTranslogSynced(candidates.stream().map(Tuple::v1));
                }
                catch (AlreadyClosedException alreadyClosedException) {
                }
                catch (IOException ex) {
                    logger.debug("failed to sync translog", (Throwable)ex);
                    throw ex;
                }
            }
        };
    }

    public final void sync(Translog.Location location, Consumer<Exception> syncListener) {
        this.verifyNotClosed();
        this.translogSyncProcessor.put(location, syncListener);
    }

    public void sync() throws IOException {
        this.verifyNotClosed();
        this.getEngine().syncTranslog();
    }

    public boolean isSyncNeeded() {
        return this.getEngine().isTranslogSyncNeeded();
    }

    public Translog.Durability getTranslogDurability() {
        return this.indexSettings.getTranslogDurability();
    }

    public void afterWriteOperation() {
        if ((this.shouldPeriodicallyFlush() || this.shouldRollTranslogGeneration()) && this.flushOrRollRunning.compareAndSet(false, true)) {
            if (this.shouldPeriodicallyFlush()) {
                this.logger.debug("submitting async flush request");
                AbstractRunnable flush = new AbstractRunnable(){

                    @Override
                    public void onFailure(Exception e) {
                        if (IndexShard.this.state != IndexShardState.CLOSED) {
                            IndexShard.this.logger.warn("failed to flush index", (Throwable)e);
                        }
                    }

                    @Override
                    protected void doRun() throws IOException {
                        IndexShard.this.flush(new FlushRequest(new String[0]));
                        IndexShard.this.periodicFlushMetric.inc();
                    }

                    @Override
                    public void onAfter() {
                        IndexShard.this.flushOrRollRunning.compareAndSet(true, false);
                        IndexShard.this.afterWriteOperation();
                    }
                };
                this.threadPool.executor("flush").execute(flush);
            } else if (this.shouldRollTranslogGeneration()) {
                this.logger.debug("submitting async roll translog generation request");
                AbstractRunnable roll = new AbstractRunnable(){

                    @Override
                    public void onFailure(Exception e) {
                        if (IndexShard.this.state != IndexShardState.CLOSED) {
                            IndexShard.this.logger.warn("failed to roll translog generation", (Throwable)e);
                        }
                    }

                    @Override
                    protected void doRun() throws Exception {
                        IndexShard.this.rollTranslogGeneration();
                    }

                    @Override
                    public void onAfter() {
                        IndexShard.this.flushOrRollRunning.compareAndSet(true, false);
                        IndexShard.this.afterWriteOperation();
                    }
                };
                this.threadPool.executor("flush").execute(roll);
            } else {
                this.flushOrRollRunning.compareAndSet(true, false);
            }
        }
    }

    private RefreshListeners buildRefreshListeners() {
        return new RefreshListeners(this.indexSettings::getMaxRefreshListeners, () -> this.refresh("too_many_listeners"), this.logger, this.threadPool.getThreadContext(), this.externalRefreshMetric);
    }

    EngineFactory getEngineFactory() {
        return this.engineFactory;
    }

    ReplicationTracker getReplicationTracker() {
        return this.replicationTracker;
    }

    public boolean scheduledRefresh() {
        this.verifyNotClosed();
        boolean listenerNeedsRefresh = this.refreshListeners.refreshNeeded();
        if (this.isReadAllowed() && (listenerNeedsRefresh || this.getEngine().refreshNeeded())) {
            if (!listenerNeedsRefresh && this.isSearchIdle() && !this.indexSettings.isExplicitRefresh() && this.active.get()) {
                Engine engine = this.getEngine();
                engine.maybePruneDeletes();
                this.setRefreshPending(engine);
                return false;
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("refresh with source [schedule]");
            }
            return this.getEngine().maybeRefresh("schedule");
        }
        Engine engine = this.getEngine();
        engine.maybePruneDeletes();
        return false;
    }

    public final boolean isSearchIdle() {
        return this.threadPool.relativeTimeInMillis() - this.lastSearcherAccess.get() >= this.indexSettings.getSearchIdleAfter().getMillis();
    }

    final long getLastSearcherAccess() {
        return this.lastSearcherAccess.get();
    }

    public final boolean hasRefreshPending() {
        return this.pendingRefreshLocation.get() != null;
    }

    private void setRefreshPending(Engine engine) {
        Translog.Location lastWriteLocation = engine.getTranslogLastWriteLocation();
        this.pendingRefreshLocation.updateAndGet(curr -> {
            if (curr == null || curr.compareTo(lastWriteLocation) <= 0) {
                return lastWriteLocation;
            }
            return curr;
        });
    }

    public final void awaitShardSearchActive(Consumer<Boolean> listener) {
        this.markSearcherAccessed();
        Translog.Location location = this.pendingRefreshLocation.get();
        if (location != null) {
            this.addRefreshListener(location, b -> {
                this.pendingRefreshLocation.compareAndSet(location, null);
                listener.accept(true);
            });
        } else {
            listener.accept(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRefreshListener(Translog.Location location, Consumer<Boolean> listener) {
        boolean readAllowed;
        if (this.isReadAllowed()) {
            readAllowed = true;
        } else {
            Object object = this.postRecoveryMutex;
            synchronized (object) {
                readAllowed = this.isReadAllowed();
            }
        }
        if (readAllowed) {
            this.refreshListeners.addOrNotify(location, listener);
        } else {
            listener.accept(false);
        }
    }

    private EngineConfig.TombstoneDocSupplier tombstoneDocSupplier() {
        RootObjectMapper.Builder noopRootMapper = new RootObjectMapper.Builder("__noop");
        final DocumentMapper noopDocumentMapper = this.mapperService != null ? new DocumentMapper.Builder(noopRootMapper, this.mapperService).build(this.mapperService) : null;
        return new EngineConfig.TombstoneDocSupplier(){

            @Override
            public ParsedDocument newDeleteTombstoneDoc(String type, String id) {
                return IndexShard.this.docMapper(type).getDocumentMapper().createDeleteTombstoneDoc(IndexShard.this.shardId.getIndexName(), type, id);
            }

            @Override
            public ParsedDocument newNoopTombstoneDoc(String reason) {
                return noopDocumentMapper.createNoopTombstoneDoc(IndexShard.this.shardId.getIndexName(), reason);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetEngineToGlobalCheckpoint() throws IOException {
        assert (!Thread.holdsLock(this.mutex)) : "resetting engine under mutex";
        assert (this.getActiveOperationsCount() == -1) : "resetting engine without blocking operations; active operations are [" + this.getActiveOperations() + ']';
        this.sync();
        SeqNoStats seqNoStats = this.seqNoStats();
        TranslogStats translogStats = this.translogStats();
        this.flush(new FlushRequest(new String[0]).waitIfOngoing(true));
        final SetOnce newEngineReference = new SetOnce();
        long globalCheckpoint = this.getLastKnownGlobalCheckpoint();
        assert (globalCheckpoint == this.getLastSyncedGlobalCheckpoint());
        Object object = this.engineMutex;
        synchronized (object) {
            this.verifyNotClosed();
            ReadOnlyEngine readOnlyEngine = new ReadOnlyEngine(this.newEngineConfig(this.replicationTracker), seqNoStats, translogStats, false, Function.identity(), true){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Engine.IndexCommitRef acquireLastIndexCommit(boolean flushFirst) {
                    Object object = IndexShard.this.engineMutex;
                    synchronized (object) {
                        if (newEngineReference.get() == null) {
                            throw new AlreadyClosedException("engine was closed");
                        }
                        return ((Engine)newEngineReference.get()).acquireLastIndexCommit(false);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Engine.IndexCommitRef acquireSafeIndexCommit() {
                    Object object = IndexShard.this.engineMutex;
                    synchronized (object) {
                        if (newEngineReference.get() == null) {
                            throw new AlreadyClosedException("engine was closed");
                        }
                        return ((Engine)newEngineReference.get()).acquireSafeIndexCommit();
                    }
                }

                @Override
                public void close() throws IOException {
                    assert (Thread.holdsLock(IndexShard.this.engineMutex));
                    Engine newEngine = (Engine)newEngineReference.get();
                    if (newEngine == IndexShard.this.currentEngineReference.get()) {
                        newEngine = null;
                    }
                    IOUtils.close((Closeable[])new Closeable[]{() -> super.close(), newEngine});
                }
            };
            IOUtils.close((Closeable[])new Closeable[]{this.currentEngineReference.getAndSet(readOnlyEngine)});
            newEngineReference.set((Object)this.engineFactory.newReadWriteEngine(this.newEngineConfig(this.replicationTracker)));
            this.onNewEngine((Engine)newEngineReference.get());
        }
        Engine.TranslogRecoveryRunner translogRunner = (engine, snapshot) -> this.runTranslogRecovery(engine, snapshot, Engine.Operation.Origin.LOCAL_RESET, () -> {});
        ((Engine)newEngineReference.get()).recoverFromTranslog(translogRunner, globalCheckpoint);
        ((Engine)newEngineReference.get()).refresh("reset_engine");
        Object object2 = this.engineMutex;
        synchronized (object2) {
            this.verifyNotClosed();
            IOUtils.close((Closeable[])new Closeable[]{this.currentEngineReference.getAndSet((Engine)newEngineReference.get())});
            this.active.set(true);
        }
        this.onSettingsChanged();
    }

    public long getMaxSeqNoOfUpdatesOrDeletes() {
        return this.getEngine().getMaxSeqNoOfUpdatesOrDeletes();
    }

    public void advanceMaxSeqNoOfUpdatesOrDeletes(long seqNo) {
        this.getEngine().advanceMaxSeqNoOfUpdatesOrDeletes(seqNo);
    }

    public void verifyShardBeforeIndexClosing() throws IllegalStateException {
        this.getEngine().verifyEngineBeforeIndexClosing();
    }

    RetentionLeaseSyncer getRetentionLeaseSyncer() {
        return this.retentionLeaseSyncer;
    }

    class ShardEventListener
    implements Engine.EventListener {
        private final CopyOnWriteArrayList<Consumer<ShardFailure>> delegates = new CopyOnWriteArrayList();

        ShardEventListener() {
        }

        @Override
        public void onFailedEngine(String reason, @Nullable Exception failure) {
            ShardFailure shardFailure = new ShardFailure(IndexShard.this.shardRouting, reason, failure);
            for (Consumer<ShardFailure> listener : this.delegates) {
                try {
                    listener.accept(shardFailure);
                }
                catch (Exception inner) {
                    inner.addSuppressed(failure);
                    IndexShard.this.logger.warn("exception while notifying engine failure", (Throwable)inner);
                }
            }
        }
    }

    private class RefreshPendingLocationListener
    implements ReferenceManager.RefreshListener {
        Translog.Location lastWriteLocation;

        private RefreshPendingLocationListener() {
        }

        public void beforeRefresh() {
            try {
                this.lastWriteLocation = IndexShard.this.getEngine().getTranslogLastWriteLocation();
            }
            catch (AlreadyClosedException exc) {
                this.lastWriteLocation = null;
            }
        }

        public void afterRefresh(boolean didRefresh) {
            if (didRefresh && this.lastWriteLocation != null) {
                IndexShard.this.pendingRefreshLocation.updateAndGet(pendingLocation -> {
                    if (pendingLocation == null || pendingLocation.compareTo(this.lastWriteLocation) <= 0) {
                        return null;
                    }
                    return pendingLocation;
                });
            }
        }
    }

    private static final class NonClosingReaderWrapper
    extends FilterDirectoryReader {
        private NonClosingReaderWrapper(DirectoryReader in) throws IOException {
            super(in, new FilterDirectoryReader.SubReaderWrapper(){

                public LeafReader wrap(LeafReader reader) {
                    return reader;
                }
            });
        }

        protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) throws IOException {
            return new NonClosingReaderWrapper(in);
        }

        protected void doClose() throws IOException {
        }

        public IndexReader.CacheHelper getReaderCacheHelper() {
            return this.in.getReaderCacheHelper();
        }
    }

    private static class RefreshMetricUpdater
    implements ReferenceManager.RefreshListener {
        private final MeanMetric refreshMetric;
        private long currentRefreshStartTime;
        private Thread callingThread = null;

        private RefreshMetricUpdater(MeanMetric refreshMetric) {
            this.refreshMetric = refreshMetric;
        }

        public void beforeRefresh() throws IOException {
            if (Assertions.ENABLED) {
                assert (this.callingThread == null) : "beforeRefresh was called by " + this.callingThread.getName() + " without a corresponding call to afterRefresh";
                this.callingThread = Thread.currentThread();
            }
            this.currentRefreshStartTime = System.nanoTime();
        }

        public void afterRefresh(boolean didRefresh) throws IOException {
            if (Assertions.ENABLED) {
                assert (this.callingThread != null) : "afterRefresh called but not beforeRefresh";
                assert (this.callingThread == Thread.currentThread()) : "beforeRefreshed called by a different thread. current [" + Thread.currentThread().getName() + "], thread that called beforeRefresh [" + this.callingThread.getName() + "]";
                this.callingThread = null;
            }
            this.refreshMetric.inc(System.nanoTime() - this.currentRefreshStartTime);
        }
    }

    public static final class ShardFailure {
        public final ShardRouting routing;
        public final String reason;
        @Nullable
        public final Exception cause;

        public ShardFailure(ShardRouting routing, String reason, @Nullable Exception cause) {
            this.routing = routing;
            this.reason = reason;
            this.cause = cause;
        }
    }
}

