/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ScoreMode;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.CompensatedSum;
import org.elasticsearch.search.aggregations.metrics.InternalStats;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.internal.SearchContext;

class StatsAggregator
extends NumericMetricsAggregator.MultiValue {
    final ValuesSource.Numeric valuesSource;
    final DocValueFormat format;
    LongArray counts;
    DoubleArray sums;
    DoubleArray compensations;
    DoubleArray mins;
    DoubleArray maxes;

    StatsAggregator(String name, ValuesSource.Numeric valuesSource, DocValueFormat format, SearchContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        this.valuesSource = valuesSource;
        if (valuesSource != null) {
            BigArrays bigArrays = context.bigArrays();
            this.counts = bigArrays.newLongArray(1L, true);
            this.sums = bigArrays.newDoubleArray(1L, true);
            this.compensations = bigArrays.newDoubleArray(1L, true);
            this.mins = bigArrays.newDoubleArray(1L, false);
            this.mins.fill(0L, this.mins.size(), Double.POSITIVE_INFINITY);
            this.maxes = bigArrays.newDoubleArray(1L, false);
            this.maxes.fill(0L, this.maxes.size(), Double.NEGATIVE_INFINITY);
        }
        this.format = format;
    }

    @Override
    public ScoreMode scoreMode() {
        return this.valuesSource != null && this.valuesSource.needsScores() ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final BigArrays bigArrays = this.context.bigArrays();
        final SortedNumericDoubleValues values = this.valuesSource.doubleValues(ctx);
        final CompensatedSum kahanSummation = new CompensatedSum(0.0, 0.0);
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (bucket >= StatsAggregator.this.counts.size()) {
                    long from = StatsAggregator.this.counts.size();
                    long overSize = BigArrays.overSize(bucket + 1L);
                    StatsAggregator.this.counts = bigArrays.resize(StatsAggregator.this.counts, overSize);
                    StatsAggregator.this.sums = bigArrays.resize(StatsAggregator.this.sums, overSize);
                    StatsAggregator.this.compensations = bigArrays.resize(StatsAggregator.this.compensations, overSize);
                    StatsAggregator.this.mins = bigArrays.resize(StatsAggregator.this.mins, overSize);
                    StatsAggregator.this.maxes = bigArrays.resize(StatsAggregator.this.maxes, overSize);
                    StatsAggregator.this.mins.fill(from, overSize, Double.POSITIVE_INFINITY);
                    StatsAggregator.this.maxes.fill(from, overSize, Double.NEGATIVE_INFINITY);
                }
                if (values.advanceExact(doc)) {
                    int valuesCount = values.docValueCount();
                    StatsAggregator.this.counts.increment(bucket, valuesCount);
                    double min = StatsAggregator.this.mins.get(bucket);
                    double max = StatsAggregator.this.maxes.get(bucket);
                    double sum = StatsAggregator.this.sums.get(bucket);
                    double compensation = StatsAggregator.this.compensations.get(bucket);
                    kahanSummation.reset(sum, compensation);
                    for (int i = 0; i < valuesCount; ++i) {
                        double value = values.nextValue();
                        kahanSummation.add(value);
                        min = Math.min(min, value);
                        max = Math.max(max, value);
                    }
                    StatsAggregator.this.sums.set(bucket, kahanSummation.value());
                    StatsAggregator.this.compensations.set(bucket, kahanSummation.delta());
                    StatsAggregator.this.mins.set(bucket, min);
                    StatsAggregator.this.maxes.set(bucket, max);
                }
            }
        };
    }

    @Override
    public boolean hasMetric(String name) {
        try {
            InternalStats.Metrics.resolve(name);
            return true;
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    @Override
    public double metric(String name, long owningBucketOrd) {
        if (this.valuesSource == null || owningBucketOrd >= this.counts.size()) {
            switch (InternalStats.Metrics.resolve(name)) {
                case count: {
                    return 0.0;
                }
                case sum: {
                    return 0.0;
                }
                case min: {
                    return Double.POSITIVE_INFINITY;
                }
                case max: {
                    return Double.NEGATIVE_INFINITY;
                }
                case avg: {
                    return Double.NaN;
                }
            }
            throw new IllegalArgumentException("Unknown value [" + name + "] in common stats aggregation");
        }
        switch (InternalStats.Metrics.resolve(name)) {
            case count: {
                return this.counts.get(owningBucketOrd);
            }
            case sum: {
                return this.sums.get(owningBucketOrd);
            }
            case min: {
                return this.mins.get(owningBucketOrd);
            }
            case max: {
                return this.maxes.get(owningBucketOrd);
            }
            case avg: {
                return this.sums.get(owningBucketOrd) / (double)this.counts.get(owningBucketOrd);
            }
        }
        throw new IllegalArgumentException("Unknown value [" + name + "] in common stats aggregation");
    }

    @Override
    public InternalAggregation buildAggregation(long bucket) {
        if (this.valuesSource == null || bucket >= this.sums.size()) {
            return this.buildEmptyAggregation();
        }
        return new InternalStats(this.name, this.counts.get(bucket), this.sums.get(bucket), this.mins.get(bucket), this.maxes.get(bucket), this.format, this.metadata());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalStats(this.name, 0L, 0.0, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, this.format, this.metadata());
    }

    @Override
    public void doClose() {
        Releasables.close(this.counts, this.maxes, this.mins, this.sums, this.compensations);
    }
}

