/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.docsearch.xml;

import com.google.common.base.Function;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.data.DataType;
import org.kuali.rice.core.api.search.Range;
import org.kuali.rice.core.api.search.SearchExpressionUtils;
import org.kuali.rice.core.api.uif.RemotableAbstractControl;
import org.kuali.rice.core.api.uif.RemotableAttributeError;
import org.kuali.rice.core.api.uif.RemotableAttributeField;
import org.kuali.rice.core.api.uif.RemotableAttributeLookupSettings;
import org.kuali.rice.core.api.uif.RemotableDatepicker;
import org.kuali.rice.core.api.uif.RemotableHiddenInput;
import org.kuali.rice.core.api.uif.RemotableQuickFinder;
import org.kuali.rice.core.api.uif.RemotableRadioButtonGroup;
import org.kuali.rice.core.api.uif.RemotableSelect;
import org.kuali.rice.core.api.uif.RemotableTextInput;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.core.api.util.xml.SafeXmlUtils;
import org.kuali.rice.core.web.format.Formatter;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.document.DocumentWithContent;
import org.kuali.rice.kew.api.document.attribute.DocumentAttribute;
import org.kuali.rice.kew.api.document.attribute.WorkflowAttributeDefinition;
import org.kuali.rice.kew.api.document.search.DocumentSearchCriteria;
import org.kuali.rice.kew.api.extension.ExtensionDefinition;
import org.kuali.rice.kew.docsearch.CaseAwareSearchableAttributeValue;
import org.kuali.rice.kew.docsearch.DocumentSearchInternalUtils;
import org.kuali.rice.kew.docsearch.SearchableAttributeValue;
import org.kuali.rice.kew.docsearch.xml.XMLSearchableAttributeContent;
import org.kuali.rice.kew.framework.document.attribute.SearchableAttribute;
import org.kuali.rice.kew.rule.xmlrouting.XPathHelper;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.group.GroupService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kns.lookup.LookupUtils;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.util.GlobalVariables;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class StandardGenericXMLSearchableAttribute
implements SearchableAttribute {
    private static final Logger LOG = LogManager.getLogger(StandardGenericXMLSearchableAttribute.class);
    private static final String FIELD_DEF_E = "fieldDef";
    private static final boolean PEDANTIC_BOUNDS_VALIDATION = true;

    public String generateSearchContent(ExtensionDefinition extensionDefinition, String documentTypeName, WorkflowAttributeDefinition attributeDefinition) {
        Map propertyDefinitionMap = attributeDefinition.getPropertyDefinitionsAsMap();
        try {
            XMLSearchableAttributeContent content = new XMLSearchableAttributeContent(this.getConfigXML(extensionDefinition));
            return content.generateSearchContent(propertyDefinitionMap);
        }
        catch (XPathExpressionException e) {
            LOG.error("error in getSearchContent ", (Throwable)e);
            throw new RuntimeException("Error trying to find xml content with xpath expression", e);
        }
        catch (Exception e) {
            LOG.error("error in getSearchContent attempting to find xml search content", (Throwable)e);
            throw new RuntimeException("Error trying to get xml search content.", e);
        }
    }

    public List<DocumentAttribute> extractDocumentAttributes(ExtensionDefinition extensionDefinition, DocumentWithContent documentWithContent) {
        List<XMLSearchableAttributeContent.FieldDef> fields;
        Document document;
        ArrayList<DocumentAttribute> searchStorageValues = new ArrayList<DocumentAttribute>();
        String fullDocumentContent = documentWithContent.getDocumentContent().getFullContent();
        if (StringUtils.isBlank((String)documentWithContent.getDocumentContent().getFullContent())) {
            LOG.warn("Empty Document Content found for document id: " + documentWithContent.getDocument().getDocumentId());
            return searchStorageValues;
        }
        try {
            document = SafeXmlUtils.safeDocumentBuilderFactory().newDocumentBuilder().parse(new InputSource(new BufferedReader(new StringReader(fullDocumentContent))));
        }
        catch (Exception e) {
            LOG.error("error parsing docContent: " + documentWithContent.getDocumentContent(), (Throwable)e);
            throw new RuntimeException("Error trying to parse docContent: " + documentWithContent.getDocumentContent(), e);
        }
        XMLSearchableAttributeContent content = new XMLSearchableAttributeContent(this.getConfigXML(extensionDefinition));
        try {
            fields = content.getFieldDefList();
        }
        catch (ParserConfigurationException | XPathExpressionException xpee) {
            throw new RuntimeException("Error parsing searchable attribute content", xpee);
        }
        XPath xpath = XPathHelper.newXPath(document);
        for (XMLSearchableAttributeContent.FieldDef field : fields) {
            if (!StringUtils.isNotEmpty((String)field.fieldEvaluationExpr)) continue;
            ArrayList<String> values = new ArrayList<String>();
            try {
                LOG.debug("Trying to retrieve node set with expression: '" + field.fieldEvaluationExpr + "'.");
                NodeList searchValues = (NodeList)xpath.evaluate(field.fieldEvaluationExpr, document.getDocumentElement(), XPathConstants.NODESET);
                for (int j = 0; j < searchValues.getLength(); ++j) {
                    Node searchValue = searchValues.item(j);
                    if (searchValue.getFirstChild() == null || !StringUtils.isNotEmpty((String)searchValue.getFirstChild().getNodeValue())) continue;
                    values.add(searchValue.getFirstChild().getNodeValue());
                }
            }
            catch (XPathExpressionException e) {
                LOG.debug("Could not retrieve node set with expression: '" + field.fieldEvaluationExpr + "'. Trying string return type.", (Throwable)e);
                try {
                    String searchValue = (String)xpath.evaluate(field.fieldEvaluationExpr, document.getDocumentElement(), XPathConstants.STRING);
                    if (StringUtils.isNotBlank((String)searchValue)) {
                        values.add(searchValue);
                    }
                }
                catch (XPathExpressionException xpee) {
                    LOG.error("Error retrieving string with expression: '" + field.fieldEvaluationExpr + "'", (Throwable)xpee);
                    throw new RuntimeException("Error retrieving string with expression: '" + field.fieldEvaluationExpr + "'", xpee);
                }
            }
            values.removeAll(Collections.singleton(null));
            if (values.isEmpty()) {
                values.add(null);
            }
            for (String value : values) {
                DocumentAttribute searchableValue = this.setupSearchableAttributeValue(field.searchDefinition.dataType, field.name, value);
                if (searchableValue == null) continue;
                searchStorageValues.add(searchableValue);
            }
        }
        return searchStorageValues;
    }

    private DocumentAttribute setupSearchableAttributeValue(String dataType, String key, String value) {
        SearchableAttributeValue attValue = DocumentSearchInternalUtils.getSearchableAttributeValueByDataTypeString(dataType);
        if (attValue == null) {
            String errorMsg = "Cannot find a SearchableAttributeValue associated with the data type '" + dataType + "'";
            LOG.error("setupSearchableAttributeValue() " + errorMsg);
            throw new RuntimeException(errorMsg);
        }
        String string = value = value != null ? value.trim() : null;
        if (StringUtils.isNotBlank((String)value) && !attValue.isPassesDefaultValidation(value)) {
            String errorMsg = "SearchableAttributeValue with the data type '" + dataType + "', key '" + key + "', and value '" + value + "' does not pass default validation and cannot be saved to the database";
            LOG.error("setupSearchableAttributeValue() " + errorMsg);
            throw new RuntimeException(errorMsg);
        }
        attValue.setSearchableAttributeKey(key);
        attValue.setupAttributeValue(value);
        return attValue.toDocumentAttribute();
    }

    public List<RemotableAttributeField> getSearchFields(ExtensionDefinition extensionDefinition, String documentTypeName) {
        List<XMLSearchableAttributeContent.FieldDef> fields;
        ArrayList<RemotableAttributeField> searchFields = new ArrayList<RemotableAttributeField>();
        List<SearchableAttributeValue> searchableAttributeValues = DocumentSearchInternalUtils.getSearchableAttributeValueObjectTypes();
        XMLSearchableAttributeContent content = new XMLSearchableAttributeContent(this.getConfigXML(extensionDefinition));
        try {
            fields = content.getFieldDefList();
        }
        catch (XPathExpressionException xpee) {
            throw new RuntimeException("Error parsing searchable attribute configuration", xpee);
        }
        catch (ParserConfigurationException pce) {
            throw new RuntimeException("Error parsing searchable attribute configuration", pce);
        }
        for (XMLSearchableAttributeContent.FieldDef field : fields) {
            searchFields.add(this.convertFieldDef(field, searchableAttributeValues));
        }
        return searchFields;
    }

    private RemotableAttributeField convertFieldDef(XMLSearchableAttributeContent.FieldDef field, Collection<SearchableAttributeValue> searchableAttributeValues) {
        Boolean caseSensitive;
        boolean isRangeSearchField;
        RemotableAttributeField.Builder fieldBuilder = RemotableAttributeField.Builder.create((String)field.name);
        fieldBuilder.setLongLabel(field.title);
        RemotableAttributeLookupSettings.Builder attributeLookupSettings = RemotableAttributeLookupSettings.Builder.create();
        fieldBuilder.setAttributeLookupSettings(attributeLookupSettings);
        if (field.defaultValue != null) {
            fieldBuilder.setDefaultValues(Collections.singletonList(field.defaultValue));
        }
        this.applyVisibility(fieldBuilder, attributeLookupSettings, field);
        RemotableAbstractControl.Builder controlBuilder = this.constructControl(field.display.type, field.display.options);
        fieldBuilder.setControl(controlBuilder);
        if ("date".equals(field.display.type)) {
            fieldBuilder.getWidgets().add(RemotableDatepicker.Builder.create());
            fieldBuilder.setDataType(DataType.DATE);
        }
        if (!field.display.selectedOptions.isEmpty()) {
            fieldBuilder.setDefaultValues(field.display.selectedOptions);
        }
        attributeLookupSettings.setInResults(field.isDisplayedInSearchResults());
        DataType dataType = DocumentSearchInternalUtils.convertValueToDataType(field.searchDefinition.dataType);
        fieldBuilder.setDataType(dataType);
        if (DataType.DATE == fieldBuilder.getDataType()) {
            fieldBuilder.getWidgets().add(RemotableDatepicker.Builder.create());
        }
        if (isRangeSearchField = this.isRangeSearchField(searchableAttributeValues, fieldBuilder.getDataType(), field)) {
            attributeLookupSettings.setRanged(true);
            attributeLookupSettings.setLowerBoundInclusive(field.searchDefinition.lowerBound.inclusive.booleanValue());
            attributeLookupSettings.setUpperBoundInclusive(field.searchDefinition.upperBound.inclusive.booleanValue());
            attributeLookupSettings.setLowerLabel(field.searchDefinition.lowerBound.label);
            attributeLookupSettings.setUpperLabel(field.searchDefinition.upperBound.label);
            attributeLookupSettings.setLowerDatePicker(field.searchDefinition.lowerBound.datePicker);
            attributeLookupSettings.setUpperDatePicker(field.searchDefinition.upperBound.datePicker);
        }
        if ((caseSensitive = field.searchDefinition.getRangeBoundOptions().caseSensitive) != null) {
            attributeLookupSettings.setCaseSensitive(caseSensitive);
        }
        String formatter = field.display.formatter == null ? null : field.display.formatter;
        fieldBuilder.setFormatterName(formatter);
        try {
            if (StringUtils.isNotEmpty((String)formatter)) {
                Formatter.registerFormatter(Class.forName(formatter), Class.forName(formatter));
            }
        }
        catch (ClassNotFoundException e) {
            LOG.error("Unable to find formatter class: " + formatter);
            throw new RuntimeException("Unable to find formatter class: " + formatter, e);
        }
        if (field.lookup.dataObjectClass != null) {
            RemotableQuickFinder.Builder quickFinderBuilder = RemotableQuickFinder.Builder.create((String)LookupUtils.getBaseLookupUrl((boolean)false), (String)field.lookup.dataObjectClass);
            quickFinderBuilder.setFieldConversions(field.lookup.fieldConversions);
            fieldBuilder.getWidgets().add(quickFinderBuilder);
        }
        return fieldBuilder.build();
    }

    private boolean isRangeSearchField(Collection<SearchableAttributeValue> searchableAttributeValues, DataType dataType, XMLSearchableAttributeContent.FieldDef field) {
        for (SearchableAttributeValue attValue : searchableAttributeValues) {
            DataType attributeValueDataType = DocumentSearchInternalUtils.convertValueToDataType(attValue.getAttributeDataType());
            if (attributeValueDataType != dataType) continue;
            return this.isRangeSearchField(attValue, field);
        }
        String errorMsg = "Could not find searchable attribute value for data type '" + dataType + "'";
        LOG.error("isRangeSearchField(List, String, NamedNodeMap, Node) " + errorMsg);
        throw new WorkflowRuntimeException(errorMsg);
    }

    private boolean isRangeSearchField(SearchableAttributeValue searchableAttributeValue, XMLSearchableAttributeContent.FieldDef field) {
        boolean allowRangedSearch = searchableAttributeValue.allowsRangeSearches();
        return allowRangedSearch && field.searchDefinition.isRangedSearch();
    }

    private void applyVisibility(RemotableAttributeField.Builder fieldBuilder, RemotableAttributeLookupSettings.Builder attributeLookupSettings, XMLSearchableAttributeContent.FieldDef field) {
        boolean visible = true;
        if (field.visibility.visible != null) {
            visible = field.visibility.visible;
        } else if (field.visibility.groupName != null) {
            UserSession session = GlobalVariables.getUserSession();
            if (session == null) {
                throw new WorkflowRuntimeException("UserSession is null!  Attempted to render the searchable attribute outside of an established session.");
            }
            GroupService groupService = KimApiServiceLocator.getGroupService();
            Group group = groupService.getGroupByNamespaceCodeAndName(field.visibility.groupNamespace, field.visibility.groupName);
            visible = group == null ? false : groupService.isMemberOfGroup(session.getPerson().getPrincipalId(), group.getId());
        }
        String type = field.visibility.type;
        if (("field".equals(type) || "fieldAndColumn".equals(type)) && !visible) {
            fieldBuilder.setControl((RemotableAbstractControl.Builder)RemotableHiddenInput.Builder.create());
        }
        if ("column".equals(type) || "fieldAndColumn".equals(type)) {
            attributeLookupSettings.setInResults(visible);
        }
    }

    private RemotableAbstractControl.Builder constructControl(String type, Collection<KeyValue> options) {
        RemotableTextInput.Builder control = null;
        LinkedHashMap<String, String> optionMap = new LinkedHashMap<String, String>();
        for (KeyValue option : options) {
            optionMap.put(option.getKey(), option.getValue());
        }
        if ("text".equals(type) || "date".equals(type)) {
            control = RemotableTextInput.Builder.create();
        } else if ("select".equals(type)) {
            control = RemotableSelect.Builder.create(optionMap);
        } else if ("radio".equals(type)) {
            control = RemotableRadioButtonGroup.Builder.create(optionMap);
        } else if ("hidden".equals(type)) {
            control = RemotableHiddenInput.Builder.create();
        } else if ("multibox".equals(type)) {
            RemotableSelect.Builder builder = RemotableSelect.Builder.create(optionMap);
            builder.setMultiple(true);
            control = builder;
        } else {
            throw new IllegalArgumentException("Illegal field type found: " + type);
        }
        return control;
    }

    public List<RemotableAttributeError> validateDocumentAttributeCriteria(ExtensionDefinition extensionDefinition, DocumentSearchCriteria documentSearchCriteria) {
        List<XMLSearchableAttributeContent.FieldDef> fields;
        ArrayList<RemotableAttributeError> errors = new ArrayList<RemotableAttributeError>();
        Map documentAttributeValues = documentSearchCriteria.getDocumentAttributeValues();
        if (documentAttributeValues == null || documentAttributeValues.isEmpty()) {
            return errors;
        }
        XMLSearchableAttributeContent content = new XMLSearchableAttributeContent(this.getConfigXML(extensionDefinition));
        try {
            fields = content.getFieldDefList();
        }
        catch (XPathExpressionException xpee) {
            throw new RuntimeException("Error parsing searchable attribute configuration", xpee);
        }
        catch (ParserConfigurationException pce) {
            throw new RuntimeException("Error parsing searchable attribute configuration", pce);
        }
        if (fields.isEmpty()) {
            LOG.warn("Could not find any field definitions (<fieldDef>) or possibly a searching configuration (<searchingConfig>) for this XMLSearchAttribute");
            return errors;
        }
        for (XMLSearchableAttributeContent.FieldDef field : fields) {
            String fieldDefTitle;
            String fieldDefName = field.name;
            String string = fieldDefTitle = field.title == null ? "" : field.title;
            List testObject = (List)documentAttributeValues.get(fieldDefName);
            if (testObject == null || testObject.isEmpty()) continue;
            SearchableAttributeValue attributeValue = DocumentSearchInternalUtils.getSearchableAttributeValueByDataTypeString(field.searchDefinition.dataType);
            if (attributeValue == null) {
                String errorMsg = "Cannot find SearchableAttributeValue for field data type '" + field.searchDefinition.dataType + "'";
                LOG.error("validateUserSearchInputs() " + errorMsg);
                throw new RuntimeException(errorMsg);
            }
            ArrayList<String> terminalValues = new ArrayList<String>();
            ArrayList<Range> rangeValues = new ArrayList<Range>();
            for (String value : testObject) {
                String[] clauses;
                if (value == null) continue;
                for (String clause : clauses = SearchExpressionUtils.splitOnClauses((String)value)) {
                    Range r = null;
                    if (StringUtils.isNotEmpty((String)value)) {
                        r = SearchExpressionUtils.parseRange((String)value);
                    }
                    if (r != null) {
                        boolean errs = false;
                        if (!field.searchDefinition.isRangedSearch()) {
                            errs = true;
                            errors.add(RemotableAttributeError.Builder.create((String)field.name, (String[])new String[]{"field does not support ranged searches but range search expression detected"}).build());
                        } else {
                            if (r.getLowerBoundValue() != null && r.isLowerBoundInclusive() != field.searchDefinition.lowerBound.inclusive.booleanValue()) {
                                errs = true;
                                errors.add(RemotableAttributeError.Builder.create((String)field.name, (String[])new String[]{"range expression ('" + value + "') and attribute definition differ on lower bound inclusivity.  Range is: " + r.isLowerBoundInclusive() + " Attrib is: " + field.searchDefinition.lowerBound.inclusive}).build());
                            }
                            if (r.getUpperBoundValue() != null && r.isUpperBoundInclusive() != field.searchDefinition.upperBound.inclusive.booleanValue()) {
                                errs = true;
                                errors.add(RemotableAttributeError.Builder.create((String)field.name, (String[])new String[]{"range expression ('" + value + "') and attribute definition differ on upper bound inclusivity.  Range is: " + r.isUpperBoundInclusive() + " Attrib is: " + field.searchDefinition.upperBound.inclusive}).build());
                            }
                        }
                        if (errs) continue;
                        rangeValues.add(r);
                        continue;
                    }
                    terminalValues.add(value);
                }
            }
            ArrayList<String> parsedValues = new ArrayList<String>();
            for (String value : terminalValues) {
                errors.addAll(this.performValidation(attributeValue, field, value, fieldDefTitle, parsedValues));
            }
            for (Range range : rangeValues) {
                Boolean rangeValid;
                String upperBoundValue;
                ArrayList<String> parsedLowerValues = new ArrayList<String>();
                ArrayList<String> parsedUpperValues = new ArrayList<String>();
                List<RemotableAttributeError> lowerErrors = this.performValidation(attributeValue, field, range.getLowerBoundValue(), this.constructRangeFieldErrorPrefix(field.title, field.searchDefinition.lowerBound), parsedLowerValues);
                errors.addAll(lowerErrors);
                List<RemotableAttributeError> upperErrors = this.performValidation(attributeValue, field, range.getUpperBoundValue(), this.constructRangeFieldErrorPrefix(field.title, field.searchDefinition.upperBound), parsedUpperValues);
                errors.addAll(upperErrors);
                if (!lowerErrors.isEmpty() || !upperErrors.isEmpty()) continue;
                String lowerBoundValue = parsedLowerValues.isEmpty() ? null : (String)parsedLowerValues.get(0);
                String string2 = upperBoundValue = parsedUpperValues.isEmpty() ? null : (String)parsedUpperValues.get(0);
                if ("string".equals(field.searchDefinition.dataType)) {
                    boolean caseSensitive = field.searchDefinition.getRangeBoundOptions().caseSensitive == null ? true : field.searchDefinition.getRangeBoundOptions().caseSensitive;
                    rangeValid = ((CaseAwareSearchableAttributeValue)attributeValue).isRangeValid(lowerBoundValue, upperBoundValue, caseSensitive);
                } else {
                    rangeValid = attributeValue.isRangeValid(lowerBoundValue, upperBoundValue);
                }
                if (rangeValid == null || rangeValid.booleanValue()) continue;
                String errorMsg = "The " + fieldDefTitle + " range is incorrect.  The " + (StringUtils.isNotBlank((String)field.searchDefinition.lowerBound.label) ? field.searchDefinition.lowerBound.label : "From") + " value entered must come before the " + (StringUtils.isNotBlank((String)field.searchDefinition.upperBound.label) ? field.searchDefinition.upperBound.label : "To") + " value";
                LOG.debug("validateUserSearchInputs() " + errorMsg + " :: field type '" + attributeValue.getAttributeDataType() + "'");
                errors.add(RemotableAttributeError.Builder.create((String)fieldDefName, (String[])new String[]{errorMsg}).build());
            }
        }
        return errors;
    }

    private String constructRangeFieldErrorPrefix(String fieldDefLabel, XMLSearchableAttributeContent.FieldDef.SearchDefinition.RangeBound rangeBound) {
        if (StringUtils.isNotBlank((String)rangeBound.label) && StringUtils.isNotBlank((String)fieldDefLabel)) {
            return fieldDefLabel + " " + rangeBound.label + " Field";
        }
        if (StringUtils.isNotBlank((String)fieldDefLabel)) {
            return fieldDefLabel + " Range Field";
        }
        if (StringUtils.isNotBlank((String)rangeBound.label)) {
            return "Range Field " + rangeBound.label + " Field";
        }
        return null;
    }

    private List<RemotableAttributeError> performValidation(SearchableAttributeValue attributeValue, final XMLSearchableAttributeContent.FieldDef field, String enteredValue, String errorMessagePrefix, List<String> resultingValues) {
        return DocumentSearchInternalUtils.validateSearchFieldValue(field.name, attributeValue, enteredValue, errorMessagePrefix, resultingValues, new Function<String, Collection<RemotableAttributeError>>(){

            public Collection<RemotableAttributeError> apply(String value) {
                Pattern pattern;
                Matcher matcher;
                if (StringUtils.isNotEmpty((String)field.validation.regex) && !(matcher = (pattern = Pattern.compile(field.validation.regex)).matcher(value)).matches()) {
                    return Collections.singletonList(RemotableAttributeError.Builder.create((String)field.name, (String[])new String[]{field.validation.message}).build());
                }
                return Collections.emptyList();
            }
        });
    }

    protected Element getConfigXML(ExtensionDefinition extensionDefinition) {
        try {
            String xmlConfigData = (String)extensionDefinition.getConfiguration().get("xmlConfigData");
            return SafeXmlUtils.safeDocumentBuilderFactory().newDocumentBuilder().parse(new InputSource(new BufferedReader(new StringReader(xmlConfigData)))).getDocumentElement();
        }
        catch (Exception e) {
            String ruleAttrStr = extensionDefinition == null ? null : extensionDefinition.getName();
            LOG.error("error parsing xml data from search attribute: " + ruleAttrStr, (Throwable)e);
            throw new RuntimeException("error parsing xml data from searchable attribute: " + ruleAttrStr, e);
        }
    }
}

