/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.s2s.connect;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.propdev.impl.s2s.S2sMultiProjectComponent;
import org.kuali.coeus.propdev.impl.s2s.S2sOppForms;
import org.kuali.coeus.propdev.impl.s2s.connect.OpportunitySchemaParserService;
import org.kuali.coeus.propdev.impl.s2s.connect.S2sCommunicationException;
import org.kuali.coeus.s2sgen.api.generate.FormMappingInfo;
import org.kuali.coeus.s2sgen.api.generate.FormMappingService;
import org.kuali.rice.core.api.util.xml.SafeXmlUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Component(value="opportunitySchemaParserService")
public class OpportunitySchemaParserServiceImpl
implements OpportunitySchemaParserService {
    private static final String SCHEMA_LOCATION = "schemaLocation";
    private static final String NAMESPACE = "namespace";
    private static final char CH_COLON = ':';
    private static final String HTTP = "http://";
    private static final String MIN_OCCURS = "minOccurs";
    private static final String REF = "ref";
    private static final String ELEMENT = "element";
    private static final String ALL = "all";
    private static final String IMPORT = "import";
    private static final String XP_APPLICATION_PACKAGE = "descendant-or-self::*[contains(@name,'ApplicationPackage')]";
    private LoadingCache<String, String> schemaCache = CacheBuilder.newBuilder().maximumSize(50L).expireAfterWrite(5L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, String>(){

        public String load(String key) throws Exception {
            return OpportunitySchemaParserServiceImpl.this.getSchemaContent(key);
        }
    });
    @Autowired
    @Qualifier(value="formMappingService")
    private FormMappingService formMappingService;

    @Override
    public List<S2sOppForms> getForms(String proposalNumber, String schema) throws S2sCommunicationException {
        Node topElementName;
        if (StringUtils.isBlank((CharSequence)proposalNumber)) {
            throw new IllegalArgumentException("proposalNumber is blank");
        }
        if (StringUtils.isBlank((CharSequence)schema)) {
            throw new IllegalArgumentException("schema is blank");
        }
        ArrayList<S2sOppForms> schemaList = new ArrayList<S2sOppForms>();
        Document document = this.getParsedSchema((String)this.schemaCache.getUnchecked((Object)schema));
        Element schemaElement = document.getDocumentElement();
        NodeList importList = document.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", IMPORT);
        Node allForms = document.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", ALL).item(0);
        if (allForms == null && (topElementName = schemaElement.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", ELEMENT).item(0).getAttributes().item(0)).getNodeName().equals("name") && !topElementName.getNodeValue().equals("GrantApplication")) {
            throw new S2sCommunicationException("error.grantsgov.no.form.element", "", "");
        }
        NodeList formsList = ((Element)allForms).getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", ELEMENT);
        String[] formNames = new String[formsList.getLength()];
        for (int formIndex = 0; formIndex < formsList.getLength(); ++formIndex) {
            Node form = formsList.item(formIndex);
            String fullFormName = ((Element)form).getAttribute(REF);
            String formName = fullFormName.substring(0, fullFormName.indexOf(58));
            String minOccurs = ((Element)form).getAttribute(MIN_OCCURS);
            String nameSpace = schemaElement.getAttribute("xmlns:" + formName);
            FormMappingInfo info = this.formMappingService.getFormInfo(nameSpace, proposalNumber);
            String displayFormName = Objects.isNull(info) || info.getFormName().contains(HTTP) ? formName : info.getFormName();
            formNames[formIndex] = nameSpace;
            for (int impIndex = 0; impIndex < importList.getLength(); ++impIndex) {
                boolean available;
                Node importNode = importList.item(impIndex);
                if (!((Element)importNode).getAttribute(NAMESPACE).equalsIgnoreCase(nameSpace)) continue;
                String schemaUrl = ((Element)importNode).getAttribute(SCHEMA_LOCATION);
                S2sOppForms oppForm = new S2sOppForms();
                oppForm.setFormName(displayFormName);
                S2sOppForms.S2sOppFormsId oppFormId = new S2sOppForms.S2sOppFormsId();
                oppFormId.setProposalNumber(proposalNumber);
                oppFormId.setOppNameSpace(nameSpace);
                oppForm.setS2sOppFormsId(oppFormId);
                oppForm.getS2sOppFormsId().setOppNameSpace(nameSpace);
                oppForm.setSchemaUrl(schemaUrl);
                boolean mandatory = minOccurs == null || minOccurs.trim().equals("") || Integer.parseInt(minOccurs) > 0;
                oppForm.setMandatory(mandatory);
                if (info != null) {
                    available = true;
                    oppForm.setUserAttachedForm(info.getUserAttachedForm());
                } else {
                    available = false;
                }
                oppForm.setAvailable(available);
                oppForm.setInclude(mandatory && available);
                schemaList.add(oppForm);
            }
        }
        return schemaList;
    }

    @Override
    public String fetchSchema(String schemaUrl) {
        return (String)this.schemaCache.getUnchecked((Object)schemaUrl);
    }

    @Override
    public List<S2sMultiProjectComponent> parseMultiProjectSchemas(String schemaUrl, String schema) throws S2sCommunicationException {
        if (StringUtils.isBlank((CharSequence)schemaUrl)) {
            throw new IllegalArgumentException("schemaUrl is blank");
        }
        try {
            String schemaContent = StringUtils.isBlank((CharSequence)schema) ? (String)this.schemaCache.getUnchecked((Object)schemaUrl) : schema;
            Document topLevelDocument = this.getParsedSchema(schemaContent);
            Node applicationPackage = ((NodeList)XPathFactory.newInstance().newXPath().evaluate(XP_APPLICATION_PACKAGE, topLevelDocument, XPathConstants.NODESET)).item(0);
            NodeList packageElements = ((Element)applicationPackage).getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", ELEMENT);
            NodeList importList = topLevelDocument.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", IMPORT);
            return IntStream.range(0, packageElements.getLength()).mapToObj(packageElements::item).map(node -> ((Element)node).getAttribute(REF)).map(name -> name.substring(0, name.indexOf(58))).map(componentType -> {
                String componentSchemaUrl = Optional.of(topLevelDocument.getDocumentElement().getAttribute("xmlns:" + componentType)).flatMap(schemaNamespace -> this.fetchByAttribute(importList, NAMESPACE, (String)schemaNamespace)).map(importElement -> importElement.getAttribute(SCHEMA_LOCATION)).orElseThrow(() -> new S2sCommunicationException("error.grantsgov.form.parsing", "Missing package schema import"));
                String componentSchema = (String)this.schemaCache.getUnchecked((Object)componentSchemaUrl);
                S2sMultiProjectComponent component = new S2sMultiProjectComponent();
                component.setComponentType((String)componentType);
                component.setSchemaUrl(componentSchemaUrl);
                component.setSchema(componentSchema);
                component.setPackageSchema(schemaContent);
                component.setPackageSchemaUrl(schemaUrl);
                return component;
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new S2sCommunicationException("error.grantsgov.form.parsing", e.getMessage(), schemaUrl);
        }
    }

    @Override
    public List<String> getAvailableComponentTypes(String schema) {
        if (StringUtils.isBlank((CharSequence)schema)) {
            throw new IllegalArgumentException("schema is blank");
        }
        try {
            Document document = this.getParsedSchema(schema);
            Node applicationPackage = ((NodeList)XPathFactory.newInstance().newXPath().evaluate(XP_APPLICATION_PACKAGE, document, XPathConstants.NODESET)).item(0);
            NodeList packageElements = ((Element)applicationPackage).getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", ELEMENT);
            return IntStream.range(0, packageElements.getLength()).mapToObj(packageElements::item).map(node -> ((Element)node).getAttribute(REF)).map(name -> name.substring(0, name.indexOf(58))).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new S2sCommunicationException("error.grantsgov.form.parsing", e.getMessage(), "");
        }
    }

    protected String getSchemaContent(String schemaUrl) {
        try {
            return IOUtils.toString((URL)new URL(schemaUrl), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new S2sCommunicationException("error.grantsgov.form.schema.server.down", e.getMessage(), schemaUrl);
        }
    }

    private Optional<Element> fetchByAttribute(NodeList list, String attributeName, String attributeValue) {
        if (StringUtils.isNotBlank((CharSequence)attributeValue)) {
            return this.fetchByAttribute(list, attributeName, (String v) -> v.equalsIgnoreCase(attributeValue));
        }
        return Optional.empty();
    }

    private Optional<Element> fetchByAttribute(NodeList list, String attributeName, Predicate<String> matcher) {
        return IntStream.range(0, list.getLength()).mapToObj(i -> (Element)list.item(i)).filter(node -> matcher.test(node.getAttribute(attributeName))).findFirst();
    }

    protected Document getParsedSchema(String schema) throws S2sCommunicationException {
        Document document;
        DocumentBuilderFactory domFactory = SafeXmlUtils.safeDocumentBuilderFactory();
        domFactory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = domFactory.newDocumentBuilder();
            document = builder.parse(IOUtils.toInputStream((String)schema, (Charset)StandardCharsets.UTF_8));
        }
        catch (ParserConfigurationException e) {
            throw new S2sCommunicationException("error.grantsgov.form.parsing", e.getMessage(), "");
        }
        catch (SAXException e) {
            throw new S2sCommunicationException("error.grantsgov.form.xmlprocess", e.getMessage(), "");
        }
        catch (IOException e) {
            throw new S2sCommunicationException("error.grantsgov.form.schema.server.down", e.getMessage(), "");
        }
        return document;
    }
}

