/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.specialreview;

import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.compliance.core.AddSpecialReviewEvent;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentControllerBase;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocumentForm;
import org.kuali.coeus.propdev.impl.specialreview.ProposalDevelopmentSpecialReviewService;
import org.kuali.coeus.propdev.impl.specialreview.ProposalSpecialReview;
import org.kuali.coeus.propdev.impl.specialreview.ProposalSpecialReviewAttachment;
import org.kuali.coeus.propdev.impl.specialreview.SpecialReviewHelper;
import org.kuali.coeus.sys.framework.controller.ControllerFileUtils;
import org.kuali.rice.krad.data.MaterializeOption;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.web.bind.UifBeanPropertyBindingResult;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.kuali.rice.krad.web.service.CollectionControllerService;
import org.kuali.rice.krad.web.service.RefreshControllerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ProposalDevelopmentSpecialReviewController
extends ProposalDevelopmentControllerBase {
    private static String NEW_SPECIAL_REVIEW_PATH = "newCollectionLines['document.developmentProposal.propSpecialReviews']";
    @Autowired
    @Qualifier(value="refreshControllerService")
    private RefreshControllerService refreshControllerService;
    @Autowired
    @Qualifier(value="collectionControllerService")
    private CollectionControllerService collectionControllerService;
    @Autowired
    @Qualifier(value="proposalDevelopmentSpecialReviewService")
    private ProposalDevelopmentSpecialReviewService proposalDevelopmentSpecialReviewService;

    @ResponseBody
    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=clearAddCompliance"})
    public void clearAddCompliance(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm pdForm, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        pdForm.getNewCollectionLines().put("document.developmentProposal.propSpecialReviews", new ProposalSpecialReview());
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=refreshAddCompliance"})
    public ModelAndView refreshAddCompliance(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm pdForm, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        ProposalSpecialReview proposalSpecialReview = (ProposalSpecialReview)pdForm.getNewCollectionLines().get("document.developmentProposal.propSpecialReviews");
        UifBeanPropertyBindingResult propertyResult = (UifBeanPropertyBindingResult)result;
        this.handleTypeChange(propertyResult.getModifiedPaths(), proposalSpecialReview, pdForm.getSpecialReviewHelper());
        return this.getRefreshControllerService().refresh((UifFormBase)pdForm);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=refreshComplianceEntry"})
    public ModelAndView refreshComplianceEntry(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm pdForm, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        String updateComponentId = request.getParameter("updateComponentId");
        String suffix = updateComponentId.substring(updateComponentId.indexOf("_line"));
        int index = Integer.valueOf(suffix.replace("_line", ""));
        ProposalSpecialReview proposalSpecialReview = pdForm.getDevelopmentProposal().getPropSpecialReviews().get(index);
        UifBeanPropertyBindingResult propertyResult = (UifBeanPropertyBindingResult)result;
        this.handleTypeChange(propertyResult.getModifiedPaths(), proposalSpecialReview, pdForm.getSpecialReviewHelper());
        return this.getRefreshControllerService().refresh((UifFormBase)pdForm);
    }

    protected void handleTypeChange(Set<String> modifiedPaths, ProposalSpecialReview specialReview, SpecialReviewHelper specialReviewHelper) {
        for (String path : modifiedPaths) {
            if (path.endsWith("specialReviewTypeCode")) {
                specialReview.setApprovalTypeCode(null);
                specialReview.setApprovalType(null);
                specialReview.setProtocolNumber(null);
                specialReview.setProtocolStatus(null);
                specialReview.setExpirationDate(null);
                specialReview.setApprovalDate(null);
                specialReview.setApplicationDate(null);
                specialReview.setComments(null);
                specialReview.setExemptionTypeCodes(new ArrayList<String>());
                this.getDataObjectService().wrap((Object)specialReview).materializeReferencedObjects(new MaterializeOption[0]);
                continue;
            }
            if (!path.endsWith("protocolNumber")) continue;
            specialReviewHelper.prepareProtocolLinkViewFields(specialReview, false);
        }
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=addComplianceEntry"})
    public ModelAndView addComplianceEntry(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm pdForm) {
        ProposalSpecialReview proposalSpecialReview = (ProposalSpecialReview)pdForm.getNewCollectionLines().get("document.developmentProposal.propSpecialReviews");
        ProposalDevelopmentDocument proposalDevelopmentDocument = (ProposalDevelopmentDocument)pdForm.getDocument();
        if (!this.getKualiRuleService().applyRules(new AddSpecialReviewEvent<ProposalSpecialReview>((Document)pdForm.getProposalDevelopmentDocument(), proposalSpecialReview, pdForm.getDevelopmentProposal().getPropSpecialReviews(), NEW_SPECIAL_REVIEW_PATH, pdForm.getSpecialReviewHelper().getIsExportControlEnabled()))) {
            pdForm.setAjaxReturnType(UifConstants.AjaxReturnTypes.UPDATECOMPONENT.getKey());
            pdForm.setUpdateComponentId("PropDev-CompliancePage_AddDialog");
            return this.getModelAndViewService().getModelAndView((UifFormBase)pdForm);
        }
        if (proposalSpecialReview.getSpecialReviewNumber() == null) {
            proposalSpecialReview.setSpecialReviewNumber(this.getProposalDevelopmentSpecialReviewService().generateSpecialReviewNumber(proposalDevelopmentDocument));
        }
        pdForm.getSpecialReviewHelper().prepareProtocolLinkViewFields(proposalSpecialReview);
        this.getCollectionControllerService().addLine((UifFormBase)pdForm);
        super.save(pdForm);
        return this.getModelAndViewService().getModelAndView((UifFormBase)pdForm);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=createProtocol"})
    public ModelAndView createProtocol(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm pdForm) throws Exception {
        DevelopmentProposal proposal = pdForm.getProposalDevelopmentDocument().getDevelopmentProposal();
        ProposalSpecialReview newSpecialReview = (ProposalSpecialReview)pdForm.getNewCollectionLines().get("document.developmentProposal.propSpecialReviews");
        ((ProposalSpecialReview)pdForm.getSpecialReviewHelper().getNewSpecialReview()).setSpecialReviewTypeCode(newSpecialReview.getSpecialReviewTypeCode());
        return this.getModelAndViewService().performRedirect((UifFormBase)pdForm, pdForm.getSpecialReviewHelper().getCreateUrl(proposal.getProposalNumber(), proposal.getTitle()));
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=getSpecialReviewAttachmentFromLine"})
    public void getSpecialReviewAttachmentFromLine(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm pdForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String selectedLine = request.getParameter("selectedLineIndex");
        if (StringUtils.isEmpty((CharSequence)selectedLine)) {
            throw new RuntimeException("Selected line index was not set properly, cannot retrieve compliance attachment");
        }
        int selectedIndex = Integer.parseInt(selectedLine);
        ProposalSpecialReviewAttachment attachment = Optional.ofNullable(pdForm.getDevelopmentProposal().getPropSpecialReview(selectedIndex)).map(ProposalSpecialReview::getSpecialReviewAttachment).orElseThrow(() -> new RuntimeException(String.format("No downloadable attachment for compliance entry %d", selectedIndex)));
        ControllerFileUtils.streamToResponse(attachment, response);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=replaceSpecialReviewAttachment"})
    public ModelAndView replaceSpecialReviewAttachment(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm pdForm) {
        String selectedLine = pdForm.getActionParamaterValue("selectedLineIndex");
        if (StringUtils.isEmpty((CharSequence)selectedLine)) {
            throw new RuntimeException("Selected line index was not set properly, cannot replace compliance attachment");
        }
        int selectedIndex = Integer.parseInt(selectedLine);
        ProposalSpecialReview specialReview = pdForm.getDevelopmentProposal().getPropSpecialReview(selectedIndex);
        if (specialReview != null && specialReview.getSpecialReviewAttachment() != null && specialReview.getSpecialReviewAttachment().getMultipartFile() != null) {
            this.prepareSpecialReviewAttachmentForSave(specialReview);
            this.getDataObjectService().save((Object)specialReview, new PersistenceOption[0]);
        }
        return this.getModelAndViewService().getModelAndView((UifFormBase)pdForm);
    }

    public ProposalDevelopmentSpecialReviewService getProposalDevelopmentSpecialReviewService() {
        return this.proposalDevelopmentSpecialReviewService;
    }

    public void setProposalDevelopmentSpecialReviewService(ProposalDevelopmentSpecialReviewService proposalDevelopmentSpecialReviewService) {
        this.proposalDevelopmentSpecialReviewService = proposalDevelopmentSpecialReviewService;
    }

    public RefreshControllerService getRefreshControllerService() {
        return this.refreshControllerService;
    }

    public void setRefreshControllerService(RefreshControllerService refreshControllerService) {
        this.refreshControllerService = refreshControllerService;
    }

    public CollectionControllerService getCollectionControllerService() {
        return this.collectionControllerService;
    }

    public void setCollectionControllerService(CollectionControllerService collectionControllerService) {
        this.collectionControllerService = collectionControllerService;
    }
}

