/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.rules;

import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.api.sponsor.SponsorContract;
import org.kuali.coeus.common.api.sponsor.SponsorService;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.institutionalproposal.document.InstitutionalProposalDocument;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.AuditError;

public class InstitutionalProposalSponsorAndProgramInformationAuditRule
implements DocumentAuditRule {
    private static final String SPONSOR_WARNINGS = "sponsorWarnings";
    public static final String PROGRAM_INFO_WARNINGS = "programInfoWarnings";
    public static final String PROGRAM_INFORMATION = "Program Information";
    public static final String SPONSORS = "Sponsors";
    private SponsorService sponsorService;
    private GlobalVariableService globalVariableService;

    public boolean processRunAuditBusinessRules(Document document) {
        boolean valid = true;
        ArrayList<AuditError> sponsorAuditWarnings = new ArrayList<AuditError>();
        ArrayList<AuditError> programInfoAuditWarnings = new ArrayList<AuditError>();
        InstitutionalProposalDocument institutionalProposalDocument = (InstitutionalProposalDocument)document;
        if (!this.getSponsorService().isValidSponsor((SponsorContract)institutionalProposalDocument.getInstitutionalProposal().getSponsor())) {
            sponsorAuditWarnings.add(new AuditError("document.institutionalProposalList[0].sponsorCode", "warning.institutionalproposal.inactive.sponsor", "home.institutionalProposal"));
            valid = false;
        }
        if (!StringUtils.isEmpty((CharSequence)institutionalProposalDocument.getInstitutionalProposal().getPrimeSponsorCode()) && !this.getSponsorService().isValidSponsor((SponsorContract)institutionalProposalDocument.getInstitutionalProposal().getPrimeSponsor())) {
            sponsorAuditWarnings.add(new AuditError("document.institutionalProposalList[0].primeSponsorCode", "warning.institutionalproposal.inactive.primesponsor", "home.institutionalProposal"));
            valid = false;
        }
        for (int i = 0; i < institutionalProposalDocument.getInstitutionalProposal().getProposalCfdas().size(); ++i) {
            String cfdaNumber = institutionalProposalDocument.getInstitutionalProposal().getProposalCfdas().get(i).getCfdaNumber();
            if (this.isValidCfda(cfdaNumber)) continue;
            programInfoAuditWarnings.add(new AuditError(String.format("document.institutionalProposalList[0].proposalCfdas[%s].cfdaNumber", i), "error.format.cfda", "home.institutionalProposal", new String[]{cfdaNumber}));
        }
        if (!sponsorAuditWarnings.isEmpty()) {
            this.getGlobalVariableService().getAuditErrorMap().put(SPONSOR_WARNINGS, new AuditCluster(SPONSORS, sponsorAuditWarnings, "Warnings"));
        }
        if (!programInfoAuditWarnings.isEmpty()) {
            this.getGlobalVariableService().getAuditErrorMap().put(PROGRAM_INFO_WARNINGS, new AuditCluster(PROGRAM_INFORMATION, programInfoAuditWarnings, "Warnings"));
        }
        return valid;
    }

    public boolean isValidCfda(String cfdaNumber) {
        return StringUtils.isBlank((CharSequence)cfdaNumber) || cfdaNumber.matches("(\\d{2})(\\.)(\\d{3})[a-zA-z]?");
    }

    public GlobalVariableService getGlobalVariableService() {
        if (this.globalVariableService == null) {
            this.globalVariableService = KcServiceLocator.getService(GlobalVariableService.class);
        }
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    private SponsorService getSponsorService() {
        if (this.sponsorService == null) {
            this.sponsorService = KcServiceLocator.getService(SponsorService.class);
        }
        return this.sponsorService;
    }

    public void setSponsorService(SponsorService sponsorService) {
        this.sponsorService = sponsorService;
    }
}

