/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.container;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;
import org.kuali.rice.krad.datadictionary.validator.Validator;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.DataBinding;
import org.kuali.rice.krad.uif.component.DelayedCopy;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.container.ContainerBase;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.container.PageGroup;
import org.kuali.rice.krad.uif.container.TabNavigationGroup;
import org.kuali.rice.krad.uif.element.Action;
import org.kuali.rice.krad.uif.field.Field;
import org.kuali.rice.krad.uif.field.FieldGroup;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleUtils;
import org.kuali.rice.krad.uif.util.ExpressionUtils;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.util.ScriptUtils;
import org.kuali.rice.krad.uif.view.ExpressionEvaluator;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.kuali.rice.krad.uif.widget.Disclosure;
import org.kuali.rice.krad.uif.widget.Inquiry;
import org.kuali.rice.krad.uif.widget.QuickFinder;
import org.kuali.rice.krad.uif.widget.Scrollpane;
import org.kuali.rice.krad.util.KRADUtils;

@BeanTags(value={@BeanTag(name="group", parent="Uif-GroupBase"), @BeanTag(name="boxGroup", parent="Uif-BoxGroupBase"), @BeanTag(name="verticalGroup", parent="Uif-VerticalBoxGroup"), @BeanTag(name="verticalSection", parent="Uif-VerticalBoxSection"), @BeanTag(name="verticalSubSection", parent="Uif-VerticalBoxSubSection"), @BeanTag(name="disclosureVerticalSection", parent="Uif-Disclosure-VerticalBoxSection"), @BeanTag(name="disclosureVerticalSubSection", parent="Uif-Disclosure-VerticalBoxSubSection"), @BeanTag(name="horizontalGroup", parent="Uif-HorizontalBoxGroup"), @BeanTag(name="horizontalSection", parent="Uif-HorizontalBoxSection"), @BeanTag(name="horizontalSubSection", parent="Uif-HorizontalBoxSubSection"), @BeanTag(name="disclosureHorizontalSection", parent="Uif-Disclosure-HorizontalBoxSection"), @BeanTag(name="disclosureHorizontalSubSection", parent="Uif-Disclosure-HorizontalBoxSubSection"), @BeanTag(name="grid", parent="Uif-GridGroup"), @BeanTag(name="gridSection", parent="Uif-GridSection"), @BeanTag(name="gridSubSection", parent="Uif-GridSubSection"), @BeanTag(name="disclosureGridSection", parent="Uif-Disclosure-GridSection"), @BeanTag(name="cssGrid", parent="Uif-CssGridGroup"), @BeanTag(name="section", parent="Uif-CssGridSection"), @BeanTag(name="subSection", parent="Uif-CssGridSubSection"), @BeanTag(name="section1Col", parent="Uif-CssGridSection-1FieldLabelColumn"), @BeanTag(name="section2Col", parent="Uif-CssGridSection-2FieldLabelColumn"), @BeanTag(name="section3Col", parent="Uif-CssGridSection-3FieldLabelColumn"), @BeanTag(name="subSection1Col", parent="Uif-CssGridSubSection-1FieldLabelColumn"), @BeanTag(name="subSection2Col", parent="Uif-CssGridSubSection-2FieldLabelColumn"), @BeanTag(name="subSection3Col", parent="Uif-CssGridSubSection-3FieldLabelColumn"), @BeanTag(name="list", parent="Uif-ListGroup"), @BeanTag(name="listSection", parent="Uif-ListSection"), @BeanTag(name="listSubSection", parent="Uif-ListSubSection"), @BeanTag(name="disclosureListSection", parent="Uif-Disclosure-ListSection"), @BeanTag(name="disclosureListSubSection", parent="Uif-Disclosure-ListSubSection"), @BeanTag(name="collectionGridItem", parent="Uif-CollectionGridItem"), @BeanTag(name="collectionVerticalBoxItem", parent="Uif-CollectionVerticalBoxItem"), @BeanTag(name="collectionHorizontalBoxItem", parent="Uif-CollectionHorizontalBoxItem"), @BeanTag(name="headerUpperGroup", parent="Uif-HeaderUpperGroup"), @BeanTag(name="headerRightGroup", parent="Uif-HeaderRightGroup"), @BeanTag(name="headerLowerGroup", parent="Uif-HeaderLowerGroup"), @BeanTag(name="footer", parent="Uif-FooterBase"), @BeanTag(name="formFooter", parent="Uif-FormFooter"), @BeanTag(name="maintenanceGrid", parent="Uif-MaintenanceGridGroup"), @BeanTag(name="maintenanceHorizontalGroup", parent="Uif-MaintenanceHorizontalBoxGroup"), @BeanTag(name="maintenanceVerticalGroup", parent="Uif-MaintenanceVerticalBoxGroup"), @BeanTag(name="maintenanceGridSection", parent="Uif-MaintenanceGridSection"), @BeanTag(name="maintenanceGridSubSection", parent="Uif-MaintenanceGridSubSection"), @BeanTag(name="maintenanceHorizontalSection", parent="Uif-MaintenanceHorizontalBoxSection"), @BeanTag(name="maintenanceVerticalSection", parent="Uif-MaintenanceVerticalBoxSection"), @BeanTag(name="maintenanceHorizontalSubSection", parent="Uif-MaintenanceHorizontalBoxSubSection"), @BeanTag(name="maintenanceVerticalSubSection", parent="Uif-MaintenanceVerticalBoxSubSection")})
public class GroupBase
extends ContainerBase
implements Group {
    private static final long serialVersionUID = 7953641325356535509L;
    private String fieldBindByNamePrefix;
    private String fieldBindingObjectPath;
    @DelayedCopy
    private Disclosure disclosure;
    private Scrollpane scrollpane;
    private List<? extends Component> items = Collections.emptyList();
    private String wrapperTag;

    @Override
    public void performInitialization(Object model) {
        if (this.isAjaxDisclosureGroup()) {
            this.setItems(new ArrayList());
        }
        super.performInitialization(model);
        Iterator<? extends Component> itemIterator = this.getItems().iterator();
        while (itemIterator.hasNext()) {
            Component component = itemIterator.next();
            if (component == null) continue;
            String excludeUnless = component.getExcludeUnless();
            if (StringUtils.isNotBlank((String)excludeUnless) && !Boolean.TRUE.equals(ObjectPropertyUtils.getPropertyValue(model, excludeUnless))) {
                itemIterator.remove();
                continue;
            }
            String excludeIf = component.getExcludeIf();
            if (StringUtils.isNotBlank((String)excludeIf) && Boolean.TRUE.equals(ObjectPropertyUtils.getPropertyValue(model, excludeIf))) {
                itemIterator.remove();
                continue;
            }
            if (component instanceof DataBinding) {
                DataBinding dataBinding = (DataBinding)component;
                if (StringUtils.isNotBlank((String)this.getFieldBindByNamePrefix())) {
                    Object bindByNamePrefixToSet = this.getFieldBindByNamePrefix();
                    if (StringUtils.isNotBlank((String)dataBinding.getBindingInfo().getBindByNamePrefix())) {
                        bindByNamePrefixToSet = (String)bindByNamePrefixToSet + "." + dataBinding.getBindingInfo().getBindByNamePrefix();
                    }
                    dataBinding.getBindingInfo().setBindByNamePrefix((String)bindByNamePrefixToSet);
                }
                if (!StringUtils.isNotBlank((String)this.fieldBindingObjectPath) || !StringUtils.isBlank((String)dataBinding.getBindingInfo().getBindingObjectPath())) continue;
                dataBinding.getBindingInfo().setBindingObjectPath(this.fieldBindingObjectPath);
                continue;
            }
            if (component instanceof FieldGroup) {
                FieldGroup fieldGroup = (FieldGroup)component;
                if (fieldGroup.getGroup() == null) continue;
                if (StringUtils.isBlank((String)fieldGroup.getGroup().getFieldBindByNamePrefix())) {
                    fieldGroup.getGroup().setFieldBindByNamePrefix(this.fieldBindByNamePrefix);
                }
                if (!StringUtils.isBlank((String)fieldGroup.getGroup().getFieldBindingObjectPath())) continue;
                fieldGroup.getGroup().setFieldBindingObjectPath(this.fieldBindingObjectPath);
                continue;
            }
            if (!(component instanceof Group)) continue;
            Group subGroup = (Group)component;
            if (StringUtils.isNotBlank((String)this.getFieldBindByNamePrefix())) {
                if (StringUtils.isNotBlank((String)subGroup.getFieldBindByNamePrefix())) {
                    subGroup.setFieldBindByNamePrefix(this.getFieldBindByNamePrefix() + "." + subGroup.getFieldBindByNamePrefix());
                } else {
                    subGroup.setFieldBindByNamePrefix(this.getFieldBindByNamePrefix());
                }
            }
            if (!StringUtils.isNotBlank((String)this.getFieldBindingObjectPath())) continue;
            if (StringUtils.isNotBlank((String)subGroup.getFieldBindingObjectPath())) {
                subGroup.setFieldBindingObjectPath(this.getFieldBindingObjectPath() + "." + subGroup.getFieldBindingObjectPath());
                continue;
            }
            subGroup.setFieldBindingObjectPath(this.getFieldBindingObjectPath());
        }
    }

    @Override
    public void afterEvaluateExpression() {
        super.afterEvaluateExpression();
        if (this.getReadOnly() == null) {
            Component parent = ViewLifecycle.getPhase().getParent();
            this.setReadOnly(parent == null ? null : parent.getReadOnly());
        }
    }

    @Override
    public void performFinalize(Object model, LifecycleElement parent) {
        super.performFinalize(model, parent);
        if (StringUtils.isBlank((String)this.wrapperTag) && StringUtils.isNotBlank((String)this.getHeaderText()) && this.getHeader().isRender()) {
            this.wrapperTag = "section";
        } else if (StringUtils.isBlank((String)this.wrapperTag)) {
            this.wrapperTag = "div";
        }
        this.setNestedComponentId(this.getInstructionalMessage(), this.getId() + "_instructional");
        this.setNestedComponentId(this.getHeader(), this.getId() + "_headerWrapper");
        this.setNestedComponentId(this.getHelp(), this.getId() + "_helpWrapper");
        if (this.getHelp() != null && this.getHelp().getHelpAction() != null) {
            this.setNestedComponentId(this.getHelp().getHelpAction(), this.getId() + "_help");
        }
        this.setupValidationScripts(ACTION_VALIDATION_COMPONENTS.QUICKFINDER, ACTION_VALIDATION_COMPONENTS.INQUIRY);
        List<Field> fields = ViewLifecycleUtils.getElementsOfTypeDeep(this.getItems(), Field.class);
        for (Field field : fields) {
            field.setOmitFromFormPost(this.isOmitFromFormPost());
        }
        if (this.isOmitFromFormPost()) {
            this.addDataAttribute("omit_group", "true");
        }
    }

    protected void setupValidationScripts(ACTION_VALIDATION_COMPONENTS ... componentsToValidate) {
        List<ACTION_VALIDATION_COMPONENTS> componentsList = Arrays.asList(componentsToValidate);
        ArrayList<InputField> inputFieldsWithActionsToValidate = new ArrayList<InputField>();
        ArrayList<InputField> allInputFields = new ArrayList<InputField>();
        for (Component component : this.getItems()) {
            if (!(component instanceof InputField)) continue;
            InputField inputField = (InputField)component;
            QuickFinder quickFinder = inputField.getQuickfinder();
            Inquiry inquiry = inputField.getInquiry();
            if (quickFinder != null && componentsList.contains((Object)ACTION_VALIDATION_COMPONENTS.QUICKFINDER) || inquiry != null && componentsList.contains((Object)ACTION_VALIDATION_COMPONENTS.INQUIRY)) {
                inputFieldsWithActionsToValidate.add(inputField);
            }
            allInputFields.add(inputField);
        }
        for (InputField inputField : inputFieldsWithActionsToValidate) {
            QuickFinder quickFinder = inputField.getQuickfinder();
            Inquiry inquiry = inputField.getInquiry();
            String script = this.buildInputFieldValidationActionScript(allInputFields, Arrays.asList(inputField.getId()));
            if (componentsList.contains((Object)ACTION_VALIDATION_COMPONENTS.QUICKFINDER) && quickFinder != null) {
                Action quickFinderAction = quickFinder.getQuickfinderAction();
                script = ScriptUtils.appendScript(script, quickFinderAction.getActionScript());
                quickFinderAction.setActionScript(script);
            }
            if (!componentsList.contains((Object)ACTION_VALIDATION_COMPONENTS.INQUIRY) || inquiry == null) continue;
            Action directInquiryAction = inquiry.getDirectInquiryAction();
            script = ScriptUtils.appendScript(script, directInquiryAction.getActionScript());
            directInquiryAction.setActionScript(script);
        }
    }

    protected String buildInputFieldValidationActionScript(List<InputField> allInputFields, List<String> excludedFields) {
        ArrayList<CallSite> controlsToValidate = new ArrayList<CallSite>();
        for (InputField inputField : allInputFields) {
            if (excludedFields != null && excludedFields.contains(inputField.getId()) || !this.validateInputField(inputField)) continue;
            controlsToValidate.add((CallSite)((Object)(inputField.getId() + "_control")));
            if (!(this instanceof CollectionGroup)) continue;
            controlsToValidate.add((CallSite)((Object)(inputField.getId() + "_add_control")));
        }
        Object script = "";
        if (!controlsToValidate.isEmpty()) {
            script = "var control;var allValid=true;";
            for (String string : controlsToValidate) {
                script = (String)script + "control=jQuery('#" + string + "');if(jQuery(control).val()){allValid=allValid&&validateFieldValue(control);}";
            }
            script = (String)script + "if(allValid == 0){return;}control = null;";
        }
        return script;
    }

    protected boolean validateInputField(InputField inputField) {
        return inputField.getValidCharactersConstraint() != null && inputField.getValidCharactersConstraint().getApplyClientSide() != null && inputField.getValidCharactersConstraint().getApplyClientSide() == Boolean.TRUE;
    }

    protected void setNestedComponentId(Component component, String newId) {
        if (component != null) {
            component.setId(newId);
        }
    }

    @Override
    public Set<Class<? extends Component>> getSupportedComponents() {
        HashSet<Class<? extends Component>> supportedComponents = new HashSet<Class<? extends Component>>();
        supportedComponents.add(Field.class);
        supportedComponents.add(Group.class);
        return supportedComponents;
    }

    @Override
    public String getComponentTypeName() {
        return "group";
    }

    @Override
    @BeanTagAttribute
    public String getFieldBindByNamePrefix() {
        return this.fieldBindByNamePrefix;
    }

    @Override
    public void setFieldBindByNamePrefix(String fieldBindByNamePrefix) {
        this.fieldBindByNamePrefix = fieldBindByNamePrefix;
    }

    @Override
    @BeanTagAttribute
    public String getFieldBindingObjectPath() {
        return this.fieldBindingObjectPath;
    }

    @Override
    public void setFieldBindingObjectPath(String fieldBindingObjectPath) {
        this.fieldBindingObjectPath = fieldBindingObjectPath;
    }

    @Override
    @BeanTagAttribute
    public Disclosure getDisclosure() {
        return this.disclosure;
    }

    @Override
    public void setDisclosure(Disclosure disclosure) {
        this.disclosure = disclosure;
    }

    @Override
    @BeanTagAttribute
    public Scrollpane getScrollpane() {
        return this.scrollpane;
    }

    @Override
    public void setScrollpane(Scrollpane scrollpane) {
        this.scrollpane = scrollpane;
    }

    @Override
    @BeanTagAttribute
    public List<? extends Component> getItems() {
        if (this.items == Collections.EMPTY_LIST && this.isMutable(true)) {
            this.items = new ArrayList<Component>();
        }
        return this.items;
    }

    @Override
    public void setItems(List<? extends Component> items) {
        if (items == null) {
            this.items = Collections.emptyList();
        } else {
            if (items.contains(this)) {
                throw new IllegalArgumentException("Attempted to add group to itself");
            }
            this.items = items;
        }
    }

    @Override
    @BeanTagAttribute
    public String getWrapperTag() {
        return this.wrapperTag;
    }

    @Override
    public void setWrapperTag(String wrapperTag) {
        this.wrapperTag = wrapperTag;
    }

    protected boolean isAjaxDisclosureGroup() {
        ViewModel model = (ViewModel)ViewLifecycle.getModel();
        View view = ViewLifecycle.getView();
        ExpressionUtils.populatePropertyExpressionsFromGraph(this);
        if (this.getDisclosure() != null && StringUtils.isNotBlank((String)this.getDisclosure().getPropertyExpression("defaultOpen"))) {
            ExpressionEvaluator expressionEvaluator = ViewLifecycle.getExpressionEvaluator();
            String expression = this.getDisclosure().getPropertyExpression("defaultOpen");
            expression = expressionEvaluator.replaceBindingPrefixes(view, this, expression);
            expression = expressionEvaluator.evaluateExpressionTemplate(this.getDisclosure().getContext(), expression);
            ObjectPropertyUtils.setPropertyValue(this.getDisclosure(), "defaultOpen", expression);
        }
        if (this.getDisclosure() != null) {
            KRADUtils.syncClientSideStateForComponent(this.getDisclosure(), model.getClientStateForSyncing());
        }
        return !this.isRetrieveViaAjax() && this.getDisclosure() != null && this.getDisclosure().isAjaxRetrievalWhenOpened() && !this.getDisclosure().isDefaultOpen();
    }

    @Override
    public void completeValidation(ValidationTrace tracer) {
        tracer.addBean(this);
        for (int i = 0; i < this.getItems().size(); ++i) {
            if (this.getItems().get(i).getClass() != PageGroup.class && this.getItems().get(i).getClass() != TabNavigationGroup.class) continue;
            String[] currentValues = new String[]{"item(" + i + ").class =" + this.getItems().get(i).getClass()};
            tracer.createError("Items in Group cannot be PageGroup or NaviagtionGroup", currentValues);
        }
        if (this.getLayoutManager() == null && Validator.checkExpressions(this, "layoutManager")) {
            String[] currentValues = new String[]{"layoutManager = " + this.getLayoutManager()};
            tracer.createError("LayoutManager must be set", currentValues);
        }
        super.completeValidation(tracer.getCopy());
    }

    @Override
    public boolean isRenderLoading() {
        return this.disclosure != null && this.disclosure.isAjaxRetrievalWhenOpened() && (!this.disclosure.isRender() || !this.disclosure.isDefaultOpen());
    }

    public static enum ACTION_VALIDATION_COMPONENTS {
        QUICKFINDER,
        INQUIRY,
        COLLECTION;

    }
}

