/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.fieldcaps;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.function.Predicate;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesIndexRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesIndexResponse;
import org.elasticsearch.action.fieldcaps.IndexFieldCapabilities;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.single.shard.TransportSingleShardAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.ShardsIterator;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportFieldCapabilitiesIndexAction
extends TransportSingleShardAction<FieldCapabilitiesIndexRequest, FieldCapabilitiesIndexResponse> {
    private static final String ACTION_NAME = "indices:data/read/field_caps[index]";
    private final IndicesService indicesService;

    @Inject
    public TransportFieldCapabilitiesIndexAction(ClusterService clusterService, TransportService transportService, IndicesService indicesService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(ACTION_NAME, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, FieldCapabilitiesIndexRequest::new, "management");
        this.indicesService = indicesService;
    }

    @Override
    protected boolean resolveIndex(FieldCapabilitiesIndexRequest request) {
        return false;
    }

    @Override
    protected ShardsIterator shards(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        return state.routingTable().index(request.concreteIndex()).randomAllActiveShardsIt();
    }

    @Override
    protected FieldCapabilitiesIndexResponse shardOperation(FieldCapabilitiesIndexRequest request, ShardId shardId) {
        MapperService mapperService = this.indicesService.indexServiceSafe(shardId.getIndex()).mapperService();
        HashSet<String> fieldNames = new HashSet<String>();
        for (String field : request.fields()) {
            fieldNames.addAll(mapperService.simpleMatchToFullName(field));
        }
        Predicate<String> fieldPredicate = this.indicesService.getFieldFilter().apply(shardId.getIndexName());
        HashMap<String, IndexFieldCapabilities> responseMap = new HashMap<String, IndexFieldCapabilities>();
        for (String field : fieldNames) {
            String parentField;
            MappedFieldType ft = mapperService.fieldType(field);
            if (ft == null || !this.indicesService.isMetadataField(mapperService.getIndexSettings().getIndexVersionCreated(), field) && !fieldPredicate.test(ft.name())) continue;
            IndexFieldCapabilities fieldCap = new IndexFieldCapabilities(field, ft.typeName(), ft.isSearchable(), ft.isAggregatable(), ft.meta());
            responseMap.put(field, fieldCap);
            int dotIndex = ft.name().lastIndexOf(46);
            while (dotIndex > -1 && !responseMap.containsKey(parentField = ft.name().substring(0, dotIndex))) {
                if (mapperService.fieldType(parentField) == null) {
                    ObjectMapper mapper = mapperService.getObjectMapper(parentField);
                    String type = mapper.nested().isNested() ? "nested" : "object";
                    IndexFieldCapabilities fieldCap2 = new IndexFieldCapabilities(parentField, type, false, false, Collections.emptyMap());
                    responseMap.put(parentField, fieldCap2);
                }
                dotIndex = parentField.lastIndexOf(46);
            }
        }
        return new FieldCapabilitiesIndexResponse(shardId.getIndexName(), responseMap);
    }

    @Override
    protected Writeable.Reader<FieldCapabilitiesIndexResponse> getResponseReader() {
        return FieldCapabilitiesIndexResponse::new;
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.METADATA_READ, request.concreteIndex());
    }
}

