/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.metrics.ExtendedStatsAggregator;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.internal.SearchContext;

class ExtendedStatsAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private final double sigma;

    ExtendedStatsAggregatorFactory(String name, ValuesSourceConfig config, double sigma, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, queryShardContext, parent, subFactoriesBuilder, metadata);
        this.sigma = sigma;
    }

    static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register("extended_stats", Arrays.asList(CoreValuesSourceType.NUMERIC, CoreValuesSourceType.DATE, CoreValuesSourceType.BOOLEAN), ExtendedStatsAggregator::new);
    }

    @Override
    protected Aggregator createUnmapped(SearchContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        return new ExtendedStatsAggregator(this.name, null, this.config.format(), searchContext, parent, this.sigma, metadata);
    }

    @Override
    protected Aggregator doCreateInternal(ValuesSource valuesSource, SearchContext searchContext, Aggregator parent, boolean collectsFromSingleBucket, Map<String, Object> metadata) throws IOException {
        if (!(valuesSource instanceof ValuesSource.Numeric)) {
            throw new AggregationExecutionException("ValuesSource type " + valuesSource.toString() + "is not supported for aggregation " + this.name());
        }
        return new ExtendedStatsAggregator(this.name, (ValuesSource.Numeric)valuesSource, this.config.format(), searchContext, parent, this.sigma, metadata);
    }
}

