/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.sequence;

import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.metadata.SequenceDescriptor;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.broker.util.sequence.SequenceManager;
import org.apache.ojb.broker.util.sequence.SequenceManagerHighLowImpl;

public class SequenceManagerFactory {
    private static Logger log = LoggerFactory.getLogger(SequenceManagerFactory.class);
    private static SequenceManagerFactory singleton;
    private Class defaultSeqManagerClass = SequenceManagerHighLowImpl.class;

    public SequenceManagerFactory() {
        if (log.isDebugEnabled()) {
            log.debug("Default sequence manager class was " + this.defaultSeqManagerClass.getName());
        }
    }

    public static synchronized SequenceManager getSequenceManager(PersistenceBroker persistenceBroker) {
        if (singleton == null) {
            singleton = new SequenceManagerFactory();
        }
        return singleton.createNewSequenceManager(persistenceBroker);
    }

    private SequenceManager createNewSequenceManager(PersistenceBroker persistenceBroker) {
        SequenceManagerFactory sequenceManagerFactory = singleton;
        synchronized (sequenceManagerFactory) {
            if (log.isDebugEnabled()) {
                log.debug("create new sequence manager for broker " + persistenceBroker);
            }
            try {
                Class clazz = this.defaultSeqManagerClass;
                SequenceDescriptor sequenceDescriptor = persistenceBroker.serviceConnectionManager().getConnectionDescriptor().getSequenceDescriptor();
                if (sequenceDescriptor != null && sequenceDescriptor.getSequenceManagerClass() != null) {
                    clazz = sequenceDescriptor.getSequenceManagerClass();
                    if (log.isDebugEnabled()) {
                        log.debug("Jdbc-Connection-Descriptor '" + persistenceBroker.serviceConnectionManager().getConnectionDescriptor().getJcdAlias() + "' use sequence manager: " + clazz);
                    }
                }
                return (SequenceManager)ClassHelper.newInstance(clazz, PersistenceBroker.class, (Object)persistenceBroker);
            }
            catch (Exception exception) {
                log.error("Could not create sequence manager for broker " + persistenceBroker, exception);
                throw new PersistenceBrokerException(exception);
            }
        }
    }
}

