/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.framework.compliance.core;

import java.sql.Date;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.compliance.core.AddSpecialReviewEvent;
import org.kuali.coeus.common.framework.compliance.core.SaveSpecialReviewEvent;
import org.kuali.coeus.common.framework.compliance.core.SpecialReview;
import org.kuali.coeus.common.framework.compliance.core.ValidSpecialReviewApproval;
import org.kuali.coeus.common.framework.compliance.exemption.SpecialReviewExemption;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.excon.project.ExconProject;
import org.kuali.kra.excon.project.service.ExconProjectService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.util.CollectionUtils;

public class SpecialReviewRuleBase<T extends SpecialReview<? extends SpecialReviewExemption>>
extends KcTransactionalDocumentRuleBase {
    private static final String TYPE_CODE_FIELD = "specialReviewTypeCode";
    private static final String APPROVAL_TYPE_CODE_FIELD = "approvalTypeCode";
    private static final String PROTOCOL_NUMBER_FIELD = "protocolNumber";
    private static final String PROTOCOL_NUMBER_TITLE = "Compliance Identifier";
    private static final String APPLICATION_DATE_FIELD = "applicationDate";
    private static final String APPLICATION_DATE_TITLE = "Application Date";
    private static final String APPROVAL_DATE_FIELD = "approvalDate";
    private static final String APPROVAL_DATE_TITLE = "Approval Date";
    private static final String EXPIRATION_DATE_FIELD = "expirationDate";
    private static final String EXPIRATION_DATE_TITLE = "Expiration Date";
    private static final String EXEMPTION_TYPE_CODE_FIELD = "exemptionTypeCodes";
    private static final String EXEMPTION_TYPE_CODE_TITLE = "Exemption #";
    private static final String EXPORT_CONTROLS_LINK_TO_EXCON_ERROR_STRING = "Export Controls/Link to EXCON";
    private ExconProjectService exconProjectService;

    protected boolean processAddSpecialReviewEvent(AddSpecialReviewEvent<T> addSpecialReviewEvent) {
        boolean rulePassed = true;
        T specialReview = addSpecialReviewEvent.getSpecialReview();
        this.getDictionaryValidationService().validateBusinessObject(specialReview);
        rulePassed &= GlobalVariables.getMessageMap().hasNoErrors();
        if (addSpecialReviewEvent.isProtocolLinkingEnabled() && "RESBOOT-1000".equals(((SpecialReview)specialReview).getSpecialReviewTypeCode())) {
            rulePassed &= this.validateProtocolNumber(specialReview, addSpecialReviewEvent.getSpecialReviews(), EXPORT_CONTROLS_LINK_TO_EXCON_ERROR_STRING);
        } else {
            rulePassed &= this.validateSpecialReviewApprovalFields(specialReview);
            rulePassed &= this.validateDateFields(specialReview);
        }
        return rulePassed;
    }

    protected boolean processSaveSpecialReviewEvent(SaveSpecialReviewEvent<T> saveSpecialReviewEvent) {
        boolean rulePassed = true;
        List<T> specialReviews = saveSpecialReviewEvent.getSpecialReviews();
        int i = 0;
        for (SpecialReview specialReview : specialReviews) {
            String errorPath = saveSpecialReviewEvent.getArrayErrorPathPrefix() + "[" + i++ + "]";
            GlobalVariables.getMessageMap().addToErrorPath(errorPath);
            if (saveSpecialReviewEvent.isExconProtocolLinkingEnabled() && "RESBOOT-1000".equals(specialReview.getSpecialReviewTypeCode())) {
                rulePassed &= this.validateProtocolNumber(specialReview, specialReviews, EXPORT_CONTROLS_LINK_TO_EXCON_ERROR_STRING);
            } else {
                rulePassed &= this.validateSpecialReviewApprovalFields(specialReview);
                rulePassed &= this.validateDateFields(specialReview);
            }
            GlobalVariables.getMessageMap().removeFromErrorPath(errorPath);
        }
        return rulePassed;
    }

    private boolean validateProtocolNumber(T specialReview, List<T> specialReviews, String errorString) {
        boolean isValid = true;
        if (!StringUtils.equals((CharSequence)"3", (CharSequence)((SpecialReview)specialReview).getApprovalTypeCode())) {
            if (StringUtils.isBlank((CharSequence)((SpecialReview)specialReview).getProtocolNumber())) {
                isValid = false;
                this.reportError(PROTOCOL_NUMBER_FIELD, "error.special.review.required.for.valid", PROTOCOL_NUMBER_TITLE, errorString);
            } else if ("RESBOOT-1000".equals(((SpecialReview)specialReview).getSpecialReviewTypeCode())) {
                ExconProject exconProject = this.getExconProjectService().getExconProject(Long.valueOf(((SpecialReview)specialReview).getProtocolNumber()));
                if (exconProject == null) {
                    isValid = false;
                    this.reportError(PROTOCOL_NUMBER_FIELD, "error.special.review.protocol.number.invalid", new String[0]);
                } else {
                    List existingSpecialReviews = ListUtils.subtract(specialReviews, Collections.singletonList(specialReview));
                    for (SpecialReview existingSpecialReview : existingSpecialReviews) {
                        if (!StringUtils.equals((CharSequence)((SpecialReview)specialReview).getProtocolNumber(), (CharSequence)existingSpecialReview.getProtocolNumber())) continue;
                        isValid = false;
                        this.reportError(PROTOCOL_NUMBER_FIELD, "error.special.review.protocol.number.duplicate", new String[0]);
                    }
                }
            }
        }
        return isValid;
    }

    private boolean validateSpecialReviewApprovalFields(T specialReview) {
        boolean isValid = true;
        if (StringUtils.isNotBlank((CharSequence)((SpecialReview)specialReview).getSpecialReviewTypeCode()) && StringUtils.isNotBlank((CharSequence)((SpecialReview)specialReview).getApprovalTypeCode())) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put(TYPE_CODE_FIELD, ((SpecialReview)specialReview).getSpecialReviewTypeCode());
            fieldValues.put(APPROVAL_TYPE_CODE_FIELD, ((SpecialReview)specialReview).getApprovalTypeCode());
            Collection validApprovals = this.getBusinessObjectService().findMatching(ValidSpecialReviewApproval.class, fieldValues);
            for (ValidSpecialReviewApproval validApproval : validApprovals) {
                String validApprovalErrorString = this.getValidApprovalErrorString(validApproval);
                isValid &= this.validateApprovalFields(validApproval, specialReview, validApprovalErrorString);
            }
        }
        return isValid;
    }

    private String getValidApprovalErrorString(ValidSpecialReviewApproval approval) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(approval.getSpecialReviewType().getDescription());
        stringBuilder.append("/");
        stringBuilder.append(approval.getSpecialReviewApprovalType().getDescription());
        return stringBuilder.toString();
    }

    private boolean validateApprovalFields(ValidSpecialReviewApproval approval, T specialReview, String errorString) {
        boolean isValid = true;
        if (approval.isProtocolNumberFlag() && StringUtils.isBlank((CharSequence)((SpecialReview)specialReview).getProtocolNumber())) {
            isValid = false;
            this.reportError(PROTOCOL_NUMBER_FIELD, "error.special.review.required.for.valid", PROTOCOL_NUMBER_TITLE, errorString);
        }
        if (approval.isApplicationDateFlag() && ((SpecialReview)specialReview).getApplicationDate() == null) {
            isValid = false;
            this.reportError(APPLICATION_DATE_FIELD, "error.special.review.required.for.valid", APPLICATION_DATE_TITLE, errorString);
        }
        if (approval.isApprovalDateFlag() && ((SpecialReview)specialReview).getApprovalDate() == null) {
            isValid = false;
            this.reportError(APPROVAL_DATE_FIELD, "error.special.review.required.for.valid", APPROVAL_DATE_TITLE, errorString);
        }
        boolean kradScreen = !StringUtils.equals((CharSequence)EXEMPTION_TYPE_CODE_FIELD, (CharSequence)this.getExemptionTypeCodeField());
        boolean noExceptions = CollectionUtils.isEmpty(kradScreen ? ((SpecialReview)specialReview).getSpecialReviewExemptions() : ((SpecialReview)specialReview).getExemptionTypeCodes());
        if (approval.isExemptNumberFlag()) {
            if (noExceptions) {
                isValid = false;
                this.reportError(this.getExemptionTypeCodeField(), "error.special.review.required.for.valid", EXEMPTION_TYPE_CODE_TITLE, errorString);
            }
        } else if (!noExceptions) {
            isValid = false;
            this.reportError(this.getExemptionTypeCodeField(), "error.special.review.cannot.select.exemption.for.valid", errorString);
        }
        return isValid;
    }

    private String getExemptionTypeCodeField() {
        List errorPath = this.getGlobalVariableService().getMessageMap().getErrorPath();
        if (errorPath.isEmpty() || StringUtils.equals((CharSequence)((CharSequence)GlobalVariables.getMessageMap().getErrorPath().get(0)), (CharSequence)"specialReviewHelper.newSpecialReview")) {
            return EXEMPTION_TYPE_CODE_FIELD;
        }
        return "specialReviewExemptions";
    }

    private boolean validateDateFields(T specialReview) {
        boolean isValid = true;
        isValid &= this.validateDateOrder(((SpecialReview)specialReview).getApplicationDate(), ((SpecialReview)specialReview).getApprovalDate(), APPROVAL_DATE_FIELD, APPLICATION_DATE_TITLE, APPROVAL_DATE_TITLE);
        isValid &= this.validateDateOrder(((SpecialReview)specialReview).getApprovalDate(), ((SpecialReview)specialReview).getExpirationDate(), EXPIRATION_DATE_FIELD, APPROVAL_DATE_TITLE, EXPIRATION_DATE_TITLE);
        return isValid &= this.validateDateOrder(((SpecialReview)specialReview).getApplicationDate(), ((SpecialReview)specialReview).getExpirationDate(), EXPIRATION_DATE_FIELD, APPLICATION_DATE_TITLE, EXPIRATION_DATE_TITLE);
    }

    private boolean validateDateOrder(Date firstDate, Date secondDate, String errorField, String firstDateTitle, String secondDateTitle) {
        boolean isValid = true;
        if (firstDate != null && secondDate != null && secondDate.before(firstDate)) {
            isValid = false;
            this.reportError(errorField, "error.special.review.date.same.or.later", secondDateTitle, firstDateTitle);
        }
        return isValid;
    }

    public ExconProjectService getExconProjectService() {
        if (this.exconProjectService == null) {
            this.exconProjectService = KcServiceLocator.getService(ExconProjectService.class);
        }
        return this.exconProjectService;
    }

    public GlobalVariableService getGlobalVariableService() {
        return KcServiceLocator.getService(GlobalVariableService.class);
    }
}

