/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.sqlscript;

import java.util.HashMap;
import java.util.Map;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.configuration.ConfigUtils;
import org.flywaydb.core.internal.resource.LoadableResource;

public class SqlScriptMetadata {
    private static final Log LOG = LogFactory.getLog(SqlScriptMetadata.class);
    private static final String EXECUTE_IN_TRANSACTION = "executeInTransaction";
    private static final String ENCODING = "encoding";
    private final Boolean executeInTransaction;
    private final String encoding;

    private SqlScriptMetadata(Map<String, String> metadata) {
        metadata = new HashMap<String, String>(metadata);
        this.executeInTransaction = ConfigUtils.removeBoolean(metadata, EXECUTE_IN_TRANSACTION);
        this.encoding = metadata.remove(ENCODING);
        ConfigUtils.checkConfigurationForUnrecognisedProperties(metadata, null);
    }

    public Boolean executeInTransaction() {
        return this.executeInTransaction;
    }

    public String encoding() {
        return this.encoding;
    }

    public static SqlScriptMetadata fromResource(LoadableResource resource) {
        if (resource != null) {
            LOG.debug("Found script configuration: " + resource.getFilename());
            return new SqlScriptMetadata(ConfigUtils.loadConfigurationFromReader(resource.read()));
        }
        return new SqlScriptMetadata(new HashMap<String, String>());
    }

    public static LoadableResource getMetadataResource(ResourceProvider resourceProvider, LoadableResource resource) {
        if (resourceProvider == null) {
            return null;
        }
        return resourceProvider.getResource(resource.getRelativePath() + ".conf");
    }
}

