/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule.dao.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.criteria.OrderByField;
import org.kuali.rice.core.api.criteria.OrderDirection;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.criteria.QueryResults;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.kew.rule.RuleBaseValues;
import org.kuali.rice.kew.rule.RuleExtensionBo;
import org.kuali.rice.kew.rule.RuleResponsibilityBo;
import org.kuali.rice.kew.rule.dao.RuleDAO;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.springframework.beans.factory.annotation.Required;

public class RuleDAOJpa
implements RuleDAO {
    private static final Logger LOG = LogManager.getLogger(RuleDAOJpa.class);
    private EntityManager entityManager;
    private DataObjectService dataObjectService;
    private static final String OLD_DELEGATIONS_SQL = "select oldDel.dlgn_rule_id from krew_rule_rsp_t oldRsp, krew_dlgn_rsp_t oldDel where oldRsp.rule_id=? and oldRsp.rule_rsp_id=oldDel.rule_rsp_id and oldDel.dlgn_rule_base_val_id not in (select newDel.dlgn_rule_base_val_id from krew_rule_rsp_t newRsp, krew_dlgn_rsp_t newDel where newRsp.rule_id=? and newRsp.rule_rsp_id=newDel.rule_rsp_id)";

    @Override
    public RuleBaseValues save(RuleBaseValues ruleBaseValues) {
        if (ruleBaseValues == null) {
            return null;
        }
        ruleBaseValues = (RuleBaseValues)((Object)this.getDataObjectService().save((Object)ruleBaseValues, new PersistenceOption[0]));
        if (ruleBaseValues.getRoleResponsibilities() != null) {
            for (RuleResponsibilityBo resp : ruleBaseValues.getRuleResponsibilities()) {
                resp.setRuleBaseValues(ruleBaseValues);
                resp.setRuleBaseValuesId(ruleBaseValues.getId());
            }
        }
        if (ruleBaseValues.getRuleResponsibilities() != null && ruleBaseValues.getRuleResponsibilities().size() > 0) {
            return (RuleBaseValues)((Object)this.getDataObjectService().save((Object)ruleBaseValues, new PersistenceOption[0]));
        }
        return ruleBaseValues;
    }

    @Override
    public List<RuleBaseValues> fetchAllCurrentRulesForTemplateDocCombination(String ruleTemplateId, List documentTypes) {
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
        List<Predicate> datePredicateList = this.generateFromToDatePredicate(new Date());
        Predicate[] datePreds = this.generateFromToDatePredicate(new Date()).toArray(new Predicate[datePredicateList.size()]);
        builder.setPredicates(new Predicate[]{PredicateFactory.in((String)"docTypeName", (Collection)documentTypes), PredicateFactory.equal((String)"ruleTemplateId", (Object)ruleTemplateId), PredicateFactory.equal((String)"currentInd", (Object)Boolean.TRUE), PredicateFactory.equal((String)"active", (Object)Boolean.TRUE), PredicateFactory.equal((String)"delegateRule", (Object)Boolean.FALSE), PredicateFactory.equal((String)"templateRuleInd", (Object)Boolean.FALSE), PredicateFactory.and((Predicate[])datePreds)});
        return this.getDataObjectService().findMatching(RuleBaseValues.class, builder.build()).getResults();
    }

    @Override
    public List<RuleBaseValues> fetchAllCurrentRulesForTemplateDocCombination(String ruleTemplateId, List documentTypes, Timestamp effectiveDate) {
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(PredicateFactory.equal((String)"ruleTemplateId", (Object)ruleTemplateId));
        predicates.add(PredicateFactory.in((String)"docTypeName", (Collection)documentTypes));
        predicates.add(PredicateFactory.equal((String)"active", (Object)Boolean.TRUE));
        predicates.add(PredicateFactory.equal((String)"delegateRule", (Object)Boolean.FALSE));
        predicates.add(PredicateFactory.equal((String)"templateRuleInd", (Object)Boolean.FALSE));
        if (effectiveDate != null) {
            predicates.add(PredicateFactory.lessThanOrEqual((String)"activationDate", (Object)effectiveDate));
            predicates.add(PredicateFactory.greaterThanOrEqual((String)"deactivationDate", (Object)effectiveDate));
        }
        List<Predicate> datePredicateList = this.generateFromToDatePredicate(new Date());
        Predicate[] datePreds = this.generateFromToDatePredicate(new Date()).toArray(new Predicate[datePredicateList.size()]);
        predicates.add(PredicateFactory.and((Predicate[])datePreds));
        Predicate[] preds = predicates.toArray(new Predicate[predicates.size()]);
        builder.setPredicates(preds);
        QueryResults results = this.getDataObjectService().findMatching(RuleBaseValues.class, builder.build());
        return results.getResults();
    }

    public List<Predicate> generateFromToDatePredicate(Date date) {
        ArrayList<Predicate> datePredicates = new ArrayList<Predicate>();
        Predicate orFromDateValue = PredicateFactory.or((Predicate[])new Predicate[]{PredicateFactory.lessThanOrEqual((String)"fromDateValue", (Object)new Timestamp(date.getTime())), PredicateFactory.isNull((String)"fromDateValue")});
        Predicate orToDateValue = PredicateFactory.or((Predicate[])new Predicate[]{PredicateFactory.greaterThanOrEqual((String)"toDateValue", (Object)new Timestamp(date.getTime())), PredicateFactory.isNull((String)"toDateValue")});
        datePredicates.add(orFromDateValue);
        datePredicates.add(orToDateValue);
        return datePredicates;
    }

    @Override
    public List<RuleBaseValues> fetchAllRules(boolean currentRules) {
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
        builder.setPredicates(new Predicate[]{PredicateFactory.equal((String)"currentInd", (Object)new Boolean(currentRules)), PredicateFactory.equal((String)"templateRuleInd", (Object)Boolean.FALSE)});
        builder.setOrderByFields(new OrderByField[]{OrderByField.Builder.create((String)"activationDate", (OrderDirection)OrderDirection.DESCENDING).build()});
        return this.getDataObjectService().findMatching(RuleBaseValues.class, builder.build()).getResults();
    }

    @Override
    public void delete(String ruleBaseValuesId) {
        this.getDataObjectService().delete(this.getDataObjectService().find(RuleBaseValues.class, (Object)ruleBaseValuesId));
    }

    @Override
    public List<RuleBaseValues> findByDocumentId(String documentId) {
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
        builder.setPredicates(new Predicate[]{PredicateFactory.equal((String)"documentId", (Object)documentId)});
        return this.getDataObjectService().findMatching(RuleBaseValues.class, builder.build()).getResults();
    }

    @Override
    public RuleBaseValues findRuleBaseValuesByName(String name) {
        if (name == null) {
            return null;
        }
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
        builder.setPredicates(new Predicate[]{PredicateFactory.equal((String)"name", (Object)name), PredicateFactory.equal((String)"currentInd", (Object)Boolean.TRUE)});
        QueryResults results = this.getDataObjectService().findMatching(RuleBaseValues.class, builder.build());
        if (results != null && !results.getResults().isEmpty()) {
            return (RuleBaseValues)((Object)results.getResults().get(0));
        }
        return null;
    }

    @Override
    public RuleBaseValues findRuleBaseValuesById(String ruleBaseValuesId) {
        if (ruleBaseValuesId == null) {
            return null;
        }
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
        builder.setPredicates(new Predicate[]{PredicateFactory.equal((String)"id", (Object)ruleBaseValuesId)});
        QueryResults results = this.getDataObjectService().findMatching(RuleBaseValues.class, builder.build());
        if (results != null && !results.getResults().isEmpty()) {
            return (RuleBaseValues)((Object)results.getResults().get(0));
        }
        return null;
    }

    @Override
    public List<RuleBaseValues> findRuleBaseValuesByResponsibilityReviewer(String reviewerName, String type) {
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
        builder.setPredicates(new Predicate[]{PredicateFactory.equal((String)"ruleResponsibilityName", (Object)reviewerName), PredicateFactory.equal((String)"ruleResponsibilityType", (Object)type)});
        List responsibilities = this.getDataObjectService().findMatching(RuleResponsibilityBo.class, builder.build()).getResults();
        ArrayList<RuleBaseValues> rules = new ArrayList<RuleBaseValues>();
        for (RuleResponsibilityBo responsibility : responsibilities) {
            RuleBaseValues rule = responsibility.getRuleBaseValues();
            if (rule == null || rule.getCurrentInd() == null || !rule.getCurrentInd().booleanValue()) continue;
            rules.add(rule);
        }
        return rules;
    }

    @Override
    public List<RuleBaseValues> findRuleBaseValuesByResponsibilityReviewerTemplateDoc(String ruleTemplateName, String documentType, String reviewerName, String type) {
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(PredicateFactory.equal((String)"ruleResponsibilityName", (Object)reviewerName));
        predicates.add(PredicateFactory.equal((String)"ruleResponsibilityType", (Object)type));
        predicates.add(PredicateFactory.equal((String)"ruleBaseValues.currentInd", (Object)Boolean.TRUE));
        if (!StringUtils.isBlank((String)ruleTemplateName)) {
            predicates.add(PredicateFactory.like((String)"ruleBaseValues.ruleTemplate.name", (CharSequence)ruleTemplateName.replace("*", "%").concat("%")));
        }
        if (!StringUtils.isBlank((String)documentType)) {
            predicates.add(PredicateFactory.like((String)"ruleBaseValues.docTypeName", (CharSequence)documentType.replace("*", "%").concat("%")));
        }
        List responsibilities = this.getDataObjectService().findMatching(RuleResponsibilityBo.class, builder.build()).getResults();
        ArrayList<RuleBaseValues> rules = new ArrayList<RuleBaseValues>();
        for (RuleResponsibilityBo responsibility : responsibilities) {
            RuleBaseValues rule = responsibility.getRuleBaseValues();
            if (rule == null || rule.getCurrentInd() == null || !rule.getCurrentInd().booleanValue()) continue;
            rules.add(rule);
        }
        return rules;
    }

    @Override
    public RuleResponsibilityBo findRuleResponsibility(String responsibilityId) {
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
        builder.setPredicates(new Predicate[]{PredicateFactory.equal((String)"responsibilityId", (Object)responsibilityId)});
        List responsibilities = this.getDataObjectService().findMatching(RuleResponsibilityBo.class, builder.build()).getResults();
        for (RuleResponsibilityBo responsibility : responsibilities) {
            if (!responsibility.getRuleBaseValues().getCurrentInd().booleanValue()) continue;
            return responsibility;
        }
        return null;
    }

    @Override
    public List<RuleBaseValues> search(String docTypeName, String ruleId, String ruleTemplateId, String ruleDescription, String groupId, String principalId, Boolean delegateRule, Boolean activeInd, Map extensionValues, String workflowIdDirective) {
        Subquery<RuleResponsibilityBo> subquery;
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(RuleBaseValues.class);
        Root root = cq.from(RuleBaseValues.class);
        List<javax.persistence.criteria.Predicate> predicates = this.getSearchCriteria((Root<RuleBaseValues>)root, (CriteriaQuery<RuleBaseValues>)cq, docTypeName, ruleTemplateId, ruleDescription, delegateRule, activeInd, extensionValues);
        if (ruleId != null) {
            predicates.add(cb.equal((Expression)root.get("id"), (Object)ruleId));
        }
        if (groupId != null) {
            predicates.add((javax.persistence.criteria.Predicate)cb.in((Expression)root.get("id")).value(this.getRuleResponsibilitySubQuery(groupId, (CriteriaQuery<RuleBaseValues>)cq)));
        }
        Collection<String> kimGroupIds = new HashSet<String>();
        Boolean searchUser = Boolean.FALSE;
        Boolean searchUserInWorkgroups = Boolean.FALSE;
        if ("group".equals(workflowIdDirective)) {
            searchUserInWorkgroups = Boolean.TRUE;
        } else if (StringUtils.isBlank((String)workflowIdDirective)) {
            searchUser = Boolean.TRUE;
            searchUserInWorkgroups = Boolean.TRUE;
        } else {
            searchUser = Boolean.TRUE;
        }
        if (!StringUtils.isEmpty((String)principalId) && searchUserInWorkgroups.booleanValue()) {
            Principal principal = null;
            principal = KimApiServiceLocator.getIdentityService().getPrincipal(principalId);
            if (principal == null) {
                throw new RiceRuntimeException("Failed to locate user for the given principal id: " + principalId);
            }
            kimGroupIds = KimApiServiceLocator.getGroupService().getGroupIdsByPrincipalId(principalId);
        }
        if ((subquery = this.addResponsibilityCriteria((CriteriaQuery<RuleBaseValues>)cq, kimGroupIds, principalId, searchUser, searchUserInWorkgroups)) != null) {
            predicates.add((javax.persistence.criteria.Predicate)cb.in((Expression)root.get("id")).value(subquery));
        }
        cq.distinct(true);
        javax.persistence.criteria.Predicate[] preds = predicates.toArray(new javax.persistence.criteria.Predicate[predicates.size()]);
        cq.where(preds);
        TypedQuery q = this.getEntityManager().createQuery(cq);
        return q.getResultList();
    }

    @Override
    public List<RuleBaseValues> search(String docTypeName, String ruleTemplateId, String ruleDescription, Collection<String> workgroupIds, String workflowId, Boolean delegateRule, Boolean activeInd, Map extensionValues, Collection actionRequestCodes) {
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(RuleBaseValues.class);
        Root root = cq.from(RuleBaseValues.class);
        List<javax.persistence.criteria.Predicate> predicates = this.getSearchCriteria((Root<RuleBaseValues>)root, (CriteriaQuery<RuleBaseValues>)cq, docTypeName, ruleTemplateId, ruleDescription, delegateRule, activeInd, extensionValues);
        Subquery<RuleResponsibilityBo> subquery = this.addResponsibilityCriteria((CriteriaQuery<RuleBaseValues>)cq, workgroupIds, workflowId, actionRequestCodes, workflowId != null, workgroupIds != null && !workgroupIds.isEmpty());
        if (subquery != null) {
            predicates.add((javax.persistence.criteria.Predicate)cb.in((Expression)root.get("id")).value(subquery));
        }
        javax.persistence.criteria.Predicate[] preds = predicates.toArray(new javax.persistence.criteria.Predicate[predicates.size()]);
        cq.where(preds);
        TypedQuery q = this.getEntityManager().createQuery(cq);
        return q.getResultList();
    }

    private Subquery<RuleResponsibilityBo> addResponsibilityCriteria(CriteriaQuery<RuleBaseValues> query, Collection<String> kimGroupIds, String principalId, Boolean searchUser, Boolean searchUserInWorkgroups) {
        ArrayList<String> workgroupIdStrings = new ArrayList<String>();
        for (String workgroupId : kimGroupIds) {
            workgroupIdStrings.add(workgroupId.toString());
        }
        return this.addResponsibilityCriteria(query, workgroupIdStrings, principalId, new ArrayList(), searchUser, searchUserInWorkgroups);
    }

    private Subquery<RuleResponsibilityBo> addResponsibilityCriteria(CriteriaQuery<RuleBaseValues> query, Collection<String> workgroupIds, String workflowId, Collection actionRequestCodes, Boolean searchUser, Boolean searchUserInWorkgroups) {
        javax.persistence.criteria.Predicate groupIdPredicate;
        javax.persistence.criteria.Predicate[] preds;
        Path exp;
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        Subquery subquery = query.subquery(RuleResponsibilityBo.class);
        Root fromResp = subquery.from(RuleResponsibilityBo.class);
        ArrayList<javax.persistence.criteria.Predicate> respPredicates = new ArrayList<javax.persistence.criteria.Predicate>();
        ArrayList<javax.persistence.criteria.Predicate> ruleRespNamePredicates = new ArrayList<javax.persistence.criteria.Predicate>();
        ArrayList<javax.persistence.criteria.Predicate> userNamePreds = new ArrayList<javax.persistence.criteria.Predicate>();
        ArrayList<javax.persistence.criteria.Predicate> workgroupPreds = new ArrayList<javax.persistence.criteria.Predicate>();
        if (actionRequestCodes != null && !actionRequestCodes.isEmpty()) {
            exp = fromResp.get("actionRequestedCd");
            javax.persistence.criteria.Predicate actionRequestPredicate = exp.in(actionRequestCodes);
            respPredicates.add(actionRequestPredicate);
        }
        if (!StringUtils.isEmpty((String)workflowId)) {
            if (searchUser != null && searchUser.booleanValue()) {
                userNamePreds.add(cb.like((Expression)fromResp.get("ruleResponsibilityName"), workflowId));
                userNamePreds.add(cb.equal((Expression)fromResp.get("ruleResponsibilityType"), (Object)"F"));
                preds = userNamePreds.toArray(new javax.persistence.criteria.Predicate[userNamePreds.size()]);
                ruleRespNamePredicates.add(cb.and(preds));
            }
            if (searchUserInWorkgroups != null && searchUserInWorkgroups.booleanValue() && workgroupIds != null && !workgroupIds.isEmpty()) {
                exp = fromResp.get("ruleResponsibilityName");
                groupIdPredicate = exp.in(workgroupIds);
                workgroupPreds.add(groupIdPredicate);
                workgroupPreds.add(cb.equal((Expression)fromResp.get("ruleResponsibilityType"), (Object)"G"));
                javax.persistence.criteria.Predicate[] preds2 = workgroupPreds.toArray(new javax.persistence.criteria.Predicate[workgroupPreds.size()]);
                ruleRespNamePredicates.add(cb.and(preds2));
            }
        } else if (workgroupIds != null && workgroupIds.size() == 1) {
            workgroupPreds.add(cb.like((Expression)fromResp.get("ruleResponsibilityName"), workgroupIds.iterator().next()));
            workgroupPreds.add(cb.equal((Expression)fromResp.get("ruleResponsibilityType"), (Object)"G"));
            preds = workgroupPreds.toArray(new javax.persistence.criteria.Predicate[workgroupPreds.size()]);
            ruleRespNamePredicates.add(cb.and(preds));
        } else if (workgroupIds != null && workgroupIds.size() > 1) {
            exp = fromResp.get("ruleResponsibilityName");
            groupIdPredicate = exp.in(workgroupIds);
            workgroupPreds.add(cb.equal((Expression)fromResp.get("ruleResponsibilityType"), (Object)"G"));
            javax.persistence.criteria.Predicate[] preds3 = workgroupPreds.toArray(new javax.persistence.criteria.Predicate[workgroupPreds.size()]);
            ruleRespNamePredicates.add(cb.and(preds3));
        }
        if (!ruleRespNamePredicates.isEmpty()) {
            preds = ruleRespNamePredicates.toArray(new javax.persistence.criteria.Predicate[ruleRespNamePredicates.size()]);
            respPredicates.add(cb.or(preds));
        }
        if (!respPredicates.isEmpty()) {
            preds = respPredicates.toArray(new javax.persistence.criteria.Predicate[respPredicates.size()]);
            subquery.where(preds);
            subquery.select((Expression)fromResp.get("ruleBaseValuesId"));
            return subquery;
        }
        return null;
    }

    private List<javax.persistence.criteria.Predicate> getSearchCriteria(Root<RuleBaseValues> root, CriteriaQuery<RuleBaseValues> query, String docTypeName, String ruleTemplateId, String ruleDescription, Boolean delegateRule, Boolean activeInd, Map extensionValues) {
        ArrayList<javax.persistence.criteria.Predicate> predicates = new ArrayList<javax.persistence.criteria.Predicate>();
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        predicates.add(cb.equal((Expression)root.get("currentInd"), (Object)Boolean.TRUE));
        predicates.add(cb.equal((Expression)root.get("templateRuleInd"), (Object)Boolean.FALSE));
        if (activeInd != null) {
            predicates.add(cb.equal((Expression)root.get("active"), (Object)activeInd));
        }
        if (docTypeName != null) {
            predicates.add(cb.like(cb.upper((Expression)root.get("docTypeName")), docTypeName.toUpperCase()));
        }
        if (ruleDescription != null && !ruleDescription.trim().equals("")) {
            predicates.add(cb.like(cb.upper((Expression)root.get("description")), ruleDescription.toUpperCase()));
        }
        if (ruleTemplateId != null) {
            predicates.add(cb.equal((Expression)root.get("ruleTemplateId"), (Object)ruleTemplateId));
        }
        if (delegateRule != null) {
            predicates.add(cb.equal((Expression)root.get("delegateRule"), (Object)delegateRule));
        }
        if (extensionValues != null && !extensionValues.isEmpty()) {
            for (Map.Entry entry : extensionValues.entrySet()) {
                if (StringUtils.isEmpty((String)((String)entry.getValue()))) continue;
                Subquery ruleExtSubQuery = query.subquery(RuleExtensionBo.class);
                Root ruleExtRoot = ruleExtSubQuery.from(RuleExtensionBo.class);
                javax.persistence.criteria.Predicate predAnd = cb.and((Expression)cb.equal((Expression)ruleExtRoot.get("extensionValues").get("key"), entry.getKey()), (Expression)cb.like((Expression)ruleExtRoot.get("extensionValues").get("value"), ("%" + (String)entry.getValue() + "%").toUpperCase()));
                ruleExtSubQuery.where((Expression)predAnd);
                ruleExtSubQuery.select((Expression)ruleExtRoot.get("ruleBaseValuesId"));
                predicates.add((javax.persistence.criteria.Predicate)cb.in((Expression)root.get("id")).value((Expression)ruleExtSubQuery));
            }
        }
        return predicates;
    }

    private Subquery<RuleResponsibilityBo> getRuleResponsibilitySubQuery(String ruleRespName, CriteriaQuery<RuleBaseValues> query) {
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        Subquery subquery = query.subquery(RuleResponsibilityBo.class);
        Root fromResp = subquery.from(RuleResponsibilityBo.class);
        subquery.where((Expression)cb.equal((Expression)fromResp.get("ruleResponsibilityName"), (Object)ruleRespName));
        subquery.select((Expression)fromResp.get("ruleBaseValuesId"));
        return subquery;
    }

    @Override
    public List<RuleBaseValues> findByPreviousRuleId(String previousRuleId) {
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
        builder.setPredicates(new Predicate[]{PredicateFactory.equal((String)"previousRuleId", (Object)previousRuleId)});
        return this.getDataObjectService().findMatching(RuleBaseValues.class, builder.build()).getResults();
    }

    @Override
    public RuleBaseValues findDefaultRuleByRuleTemplateId(String ruleTemplateId) {
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
        if (StringUtils.isNotBlank((String)ruleTemplateId)) {
            builder.setPredicates(new Predicate[]{PredicateFactory.equal((String)"ruleTemplateId", (Object)ruleTemplateId), PredicateFactory.equal((String)"templateRuleInd", (Object)Boolean.TRUE)});
            List rules = this.getDataObjectService().findMatching(RuleBaseValues.class, builder.build()).getResults();
            if (rules != null && !rules.isEmpty()) {
                return (RuleBaseValues)((Object)rules.get(0));
            }
        }
        return null;
    }

    @Override
    public void retrieveAllReferences(RuleBaseValues rule) {
    }

    @Override
    public RuleBaseValues getParentRule(String ruleBaseValuesId) {
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
        builder.setPredicates(new Predicate[]{PredicateFactory.equal((String)"responsibilities.delegationRules.delegateRuleId", (Object)ruleBaseValuesId), PredicateFactory.equal((String)"currentInd", (Object)Boolean.TRUE)});
        List rules = this.getDataObjectService().findMatching(RuleBaseValues.class, builder.build()).getResults();
        RuleBaseValues rule = null;
        for (RuleBaseValues currentRule : rules) {
            if (rule != null && currentRule.getVersionNbr() <= rule.getVersionNbr()) continue;
            rule = currentRule;
        }
        return rule;
    }

    @Override
    public List findOldDelegations(RuleBaseValues oldRule, RuleBaseValues newRule) {
        Query q = this.entityManager.createNativeQuery(OLD_DELEGATIONS_SQL);
        q.setParameter(1, (Object)oldRule.getId());
        q.setParameter(2, (Object)newRule.getId());
        ArrayList<RuleBaseValues> oldDelegations = new ArrayList<RuleBaseValues>();
        for (Object l : q.getResultList()) {
            oldDelegations.add(this.findRuleBaseValuesById(String.valueOf(l)));
        }
        return oldDelegations;
    }

    @Override
    public String findResponsibilityIdForRule(String ruleName, String ruleResponsibilityName, String ruleResponsibilityType) {
        Iterator iter;
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
        builder.setPredicates(new Predicate[]{PredicateFactory.equal((String)"ruleResponsibilityName", (Object)ruleResponsibilityName), PredicateFactory.equal((String)"ruleResponsibilityType", (Object)ruleResponsibilityType), PredicateFactory.equal((String)"ruleBaseValues.currentInd", (Object)Boolean.TRUE), PredicateFactory.equal((String)"ruleBaseValues.name", (Object)ruleName)});
        List responsibilities = this.getDataObjectService().findMatching(RuleResponsibilityBo.class, builder.build()).getResults();
        if (responsibilities != null && (iter = responsibilities.iterator()).hasNext()) {
            RuleResponsibilityBo responsibility = (RuleResponsibilityBo)((Object)iter.next());
            return responsibility.getResponsibilityId();
        }
        return null;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    @Required
    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

